! In the following routine, 'X11_id' refers to the X11 window.
! To set/get properties in the new device, use 'print_id'.
!
! Caution: after the opening of the printing device (EPS or PDF),
!          pgid = print_id, but CURRENT_WIN_ID remains equal to X11_id.

!_______________________________________________________________________
!
   subroutine print_eps( filename )

      character(len=*), intent(in) :: filename
      !------ API end ------

      type(mf_win_info), pointer :: win
      integer :: X11_id, print_id, offset, ncol
      logical :: axis_on, inverted
      integer :: i, k, i1, i2, n1, n2, needs_colormap
      integer :: vec_tmp(1)
      real(kind=MF_DOUBLE) :: r, g, b

      integer :: ibuf(4), lchr
      character :: chr
      real(kind=MF_DOUBLE) :: rbuf(1)
      character(len=132) :: instr

   !------ end of declarations -- execution starts hereafter  ------

      FIG_NUMBER = CURRENT_WIN_ID
      EPS_NAME = filename

      win => mf_win_db(CURRENT_WIN_ID)

      if( win%colorbar == 0 ) then
         MF_COLBAR = 0
      else
         if( win%colorbar_pos == "ri" ) then
            MF_COLBAR = 1
         else ! colorbar_pos = "bi"
            MF_COLBAR = 2
         end if
      end if

      WIN_TITLE = win%win_title

      X11_id = win%mfplot_id

      ! Store some dimensions in the EPS driver memory
      ibuf(1:2) = [ grxmxa(grcide), grymxa(grcide) ]
      call grexec( EPS_DRIVER_NUM, GET_DEF_SIZE_VIRT, rbuf, ibuf, chr, lchr )

      ! Important: before opening the device, we have to forgot all settings
      ! of the Graphic State from previous device.
      LAST_COLOR_IS_VALID = .false.
      LAST_LINEWIDTH_IS_VALID = .false.
      LAST_LINESTYLE_IS_VALID = .false.
      LAST_FONT_ATTRIB_IS_VALID = .false.


      ! Store the mode of writing (black/white or white/black) in EPS driver
      ! memory
      ibuf(1) = BLACK_ON_WHITE
      call grexec( EPS_DRIVER_NUM, SELECT_BACK_FOREGROUND, rbuf, ibuf, chr, lchr )

      ! Setting a global variable
      call grgenv( "EPS_COMMENTS", instr, lchr ) ! grgenv add "MFPLOT_"
      if( lchr >= 1 ) then
         if( instr(1:1) == "1" ) then
            COMMENTS_IN_EPS = .true.
         else
            COMMENTS_IN_EPS = .false.
         end if
      else
         COMMENTS_IN_EPS = .false.
      end if

      ! Open the selected device
      i = pgopen( trim(adjustl(filename)) // "/EPS" )

      if( i <= 0 ) then
         call PrintMessage( "msPrint", "E",                             &
                            "cannot open the EPS device!" )
      end if

      print_id = i
      call pgslct( print_id )

      ! Keep the layout of the X11 window.
      pg_axe_fnt_siz_fct(print_id) = pg_axe_fnt_siz_fct(X11_id)
      pg_axis_lin_width(print_id)  = pg_axis_lin_width(X11_id)
      pg_lab_fnt_siz_fct(print_id) = pg_lab_fnt_siz_fct(X11_id)
      pg_tit_fnt_siz_fct(print_id) = pg_tit_fnt_siz_fct(X11_id)

      ! Ne pas inclure de test sur win%colormap_init car il n'est pas
      ! strictement nécessaire que la colormap soit défini: il en
      ! existe une par défaut. Il risque cependant d'y avoir des
      ! couleurs bizarres, notamment dans les EPS créés;
      ! un warning a donc été placé dans les routines 'Patch' et
      ! 'PColor'
      if( win%colormap_used ) then

         call pgscir_PS_ec( win%colormap_ci_low, win%colormap_ci_high )

         ! Before drawing, we must store again the colormap.
         if( win%predefined_colormap ) then
            inverted = win%colormap_inverted
            select case( win%colormap_name )
               case( "grey" )
                  call set_predefined_colormap( 0, inverted )
               case( "fusion" )
                  call set_predefined_colormap( 1, inverted )
               case( "bluered" )
                  call set_predefined_colormap( 2, inverted )
               case( "rainbow" )
                  call set_predefined_colormap( 3, inverted )
               case( "hot" )
                  call set_predefined_colormap( 4, inverted )
               case( "parula" )
                  call set_predefined_colormap( 5, inverted )
               case( "flag" )
                  call set_predefined_colormap( 6, inverted )
               case default ! as "rainbow"
                  call set_predefined_colormap( 3, inverted )
            end select
         else
            if( .not. allocated(win%user_colormap) ) then
               write(STDERR,*) "(MUESLI Print:) internal error:"
               write(STDERR,*) "                win%user_colormap not allocated!"
               write(STDERR,*) "                (subroutine print_eps)"
               call msMuesliTrace( pause="yes" )
               return
            end if
            offset = win%colormap_ci_low - 1
            ncol = size(win%user_colormap,1)
            do i = 1, ncol
               r = win%user_colormap(i,1)
               g = win%user_colormap(i,2)
               b = win%user_colormap(i,3)
               call grscr(i+offset, r, g, b)
            end do
         end if

         ! Send the range of colormap indices, and tell the EPS driver to write
         ! the colormap inside the image (whatever the status of colorbar is).
         if( win%shading == "flat" ) then
            needs_colormap = 0
         else
            needs_colormap = 1
         end if
         if( needs_colormap == 1 ) then
            if( COMMENTS_IN_EPS ) then
               ibuf(1) = 1
               call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- begin of Colormap", 0 )
            end if
         end if
         ibuf(1) = needs_colormap
         ibuf(2) = win%colormap_ci_low
         ibuf(3) = win%colormap_ci_high
         call grexec( grgtyp, WRITE_COLORMAP_IF, rbuf, ibuf, chr, lchr )
         if( needs_colormap == 1 ) then
            if( COMMENTS_IN_EPS ) then
               ibuf(1) = 1
               call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- end of Colormap", 0 )
            end if
         end if

      end if

      if( NB_USER_COL >= 1 ) then
         ! We must also store these colors !
         do k = 1, NB_USER_COL
            call pgslct( X11_id )
            call grqcr( CI_HIGH_MAX-k, r, g, b )
            call pgslct( print_id )
            call grscr( CI_HIGH_MAX-k, r, g, b )
         end do
      end if

      ! Read the AFM files (Adobe Font Metrics) of the eight fontes
      ! used for text (tables limited to 22:255 subrange).
      if( .not. MF_AFM_READ ) then
         ! Filling the tables of 'grpckg1.inc'.
         call gr_read_AFM_files()
         MF_AFM_READ = .true.
      end if
      ! Closing AFM files will be done in 'msExitFgl()'.

      ! These two variables are used in 'grparse_ps_font'
      PS_Std_Fonts_presence(:) = .false.
      EnglishBT_embedded = .false.

      if( win%transparency_used .and. .not. X11_DEVICE ) then
         call PrintMessage( "msPrint", "W",                             &
                            "when X11 Device is 'off'",                 &
                            "printing in EPS cannot use transparency!" )
      end if

      ! Keep, if applicable, the USER_TICKS_LABELS variables...
      if( USER_TICKS(X11_id) ) then
         USER_TICKS(print_id) = USER_TICKS(X11_id)
         USER_TICKS_ALL(print_id) = USER_TICKS_ALL(X11_id)
         vec_tmp = lbound(USER_TICKS_LABELS(X11_id)%labels) ; i1 = vec_tmp(1)
         vec_tmp = ubound(USER_TICKS_LABELS(X11_id)%labels) ; i2 = vec_tmp(1)
         if( allocated(USER_TICKS_LABELS(print_id)%labels) ) then
            vec_tmp = lbound(USER_TICKS_LABELS(print_id)%labels) ; n1 = vec_tmp(1)
            vec_tmp = ubound(USER_TICKS_LABELS(print_id)%labels) ; n2 = vec_tmp(1)
            if( n1 /= i1 .or. n2 /= i2  ) then
               deallocate( USER_TICKS_LABELS(print_id)%labels )
               allocate( USER_TICKS_LABELS(print_id)%labels(i1:i2) )
               deallocate( USER_TICKS_LABELS(print_id)%length )
               allocate( USER_TICKS_LABELS(print_id)%length(i1:i2) )
            end if
         else
            allocate( USER_TICKS_LABELS(print_id)%labels(i1:i2) )
            allocate( USER_TICKS_LABELS(print_id)%length(i1:i2) )
         end if
         USER_TICKS_LABELS(print_id)%labels(:) = USER_TICKS_LABELS(X11_id)%labels(:)
         USER_TICKS_LABELS(print_id)%length(:) = USER_TICKS_LABELS(X11_id)%length(:)
      end if

      if( win%transparency_used .and. X11_DEVICE ) then

         ! on va lire tous les pixels de la fenêtre X11 et on crée
         ! une image unique à insérer dans le PS.
         call mf_win_redraw_pre_PS( CURRENT_WIN_ID )

         ! removing axes and labels (we don't want pixel image of them)
         axis_on = win%axis_on
         if( axis_on ) then
            call pgslct( X11_id )
            PRINTING_EPS = .false.
! ici, on va redessiner, mais il faut un clipping élargi d'un pixel partout,
! pour éviter que l'EPS ne fasse apparaître une ligne blanche dans le cadre
! du viewport...
ibuf(1) = 0
call grexec( grgtyp, SET_1_PIX_CORR, rbuf, ibuf, chr, lchr )
            call msAxis( "off" )
! ici, on remets le clipping-narrow
ibuf(1) = 1
call grexec( grgtyp, SET_1_PIX_CORR, rbuf, ibuf, chr, lchr )
            PRINTING_EPS = .true.
            call pgslct( print_id )
         end if

         call X11_rect_dump_to_PS( X11_id, print_id, win%current_axes )

         ! if needed, restoring axes and labels
         if( axis_on ) then
            call pgslct( X11_id )
            PRINTING_EPS = .false.
            call msAxis( "on" )
            PRINTING_EPS = .true.
            call pgslct( print_id )
         end if

         ! draw the axis, because (due to the X11 dump) it is not yet drawn.
         if( win%axis_on ) then
            if( COMMENTS_IN_EPS ) then
               ibuf(1) = 0
               call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- begin of Box", 0 )
            end if
         end if
         call mf_win_draw_box( CURRENT_WIN_ID )
         if( win%axis_on ) then
            if( COMMENTS_IN_EPS ) then
               ibuf(1) = 0
               call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- end of Box", 0 )
            end if
         end if

      else ! sinon, on redessine tous les objets graphiques...

         ! These two variables are used in 'grparse_ps_font'
         PS_Std_Fonts_presence(:) = .false.
         EnglishBT_embedded = .false.

         call mf_win_redraw( CURRENT_WIN_ID, from_print_call=.true. )

      end if

      if( win%empty ) then
         ! For many Ubuntu versions (and perhaps other distros), fix a bug
         ! occuring only for empty EPS: viewers like 'okular' or 'evince'
         ! cannot show a white image, unless the 'showpage' operator is added
         ! at the end, which is by the way controversed!
         ibuf(1) = 1
         call eps_driver( GET_INFO_EMPTY_EPS, rbuf, ibuf, "", 0 )
      end if

      call pgclos( )

      ! The current X11 window is selected again
      ! (even if it is the NULL_DEVICE)
      call pgslct( X11_id )

   end subroutine print_eps
!_______________________________________________________________________
!
   subroutine print_pdf( filename )

      character(len=*), intent(in) :: filename
      !------ API end ------

      type(mf_win_info), pointer :: win
      integer :: X11_id, print_id, offset, ncol
      logical :: axis_on, inverted
      integer :: i, k, i1, i2, n1, n2
      integer :: vec_tmp(1)
      real(kind=MF_DOUBLE) :: r, g, b

      integer :: ibuf(4), lchr
      character :: chr
      real(kind=MF_DOUBLE) :: rbuf(1)
      character(len=132) :: instr

   !------ end of declarations -- execution starts hereafter  ------

      FIG_NUMBER = CURRENT_WIN_ID
      PDF_NAME = filename

      win => mf_win_db(CURRENT_WIN_ID)

      if( win%colorbar == 0 ) then
         MF_COLBAR = 0
      else
         if( win%colorbar_pos == "ri" ) then
            MF_COLBAR = 1
         else ! colorbar_pos = "bi"
            MF_COLBAR = 2
         end if
      end if

      WIN_TITLE = win%win_title

      X11_id = win%mfplot_id

      ! Store some dimensions in the PDF driver memory
      ibuf(1:2) = [ grxmxa(grcide), grymxa(grcide) ]
      call grexec( PDF_DRIVER_NUM, GET_DEF_SIZE_VIRT, rbuf, ibuf, chr, lchr )

      ! Must be done before opening the PDF driver (it is required to know
      ! the number of some types of object, and if the colormap must be
      ! inserted in the PDF).
      call count_PDF_objects( CURRENT_WIN_ID, MF_NB_BITMAPS,            &
                              MF_NB_TRI_GRAD, MF_NB_QUAD_GRAD,          &
                              MF_CMAP_USED, MF_MARKERS_USED )

      ! These two variables are used in 'grparse_ps_font'
      PS_Std_Fonts_presence(:) = .false.
      EnglishBT_embedded = .false.

      ! Important: before opening the device, we have to forgot all settings
      ! of the Graphic State from previous device.
      LAST_COLOR_IS_VALID = .false.
      LAST_LINEWIDTH_IS_VALID = .false.
      LAST_LINESTYLE_IS_VALID = .false.
      LAST_FONT_ATTRIB_IS_VALID = .false.

      ! Open the selected device
      i = pgopen( trim(adjustl(filename)) // "/PDF" )

      if( i <= 0 ) then
         call PrintMessage( "msPrint", "E",                             &
                            "cannot open the PDF device!" )
      end if

      ! Setting a global variable
      call grgenv( "PDF_COMMENTS", instr, lchr ) ! grgenv add "MFPLOT_"
      if( lchr >= 1 ) then
         if( instr(1:1) == "1" ) then
            COMMENTS_IN_PDF = .true.
         else
            COMMENTS_IN_PDF = .false.
         end if
      else
         COMMENTS_IN_PDF = .false.
      end if

      print_id = i
      call pgslct( print_id )

      ! Keep the layout of the X11 window.
      pg_axe_fnt_siz_fct(print_id) = pg_axe_fnt_siz_fct(X11_id)
      pg_axis_lin_width(print_id)  = pg_axis_lin_width(X11_id)
      pg_lab_fnt_siz_fct(print_id) = pg_lab_fnt_siz_fct(X11_id)
      pg_tit_fnt_siz_fct(print_id) = pg_tit_fnt_siz_fct(X11_id)

      ! Ne pas inclure de test sur win%colormap_init car il n'est pas
      ! strictement nécessaire que la colormap soit défini: il en
      ! existe une par défaut. Il risque cependant d'y avoir des
      ! couleurs bizarres, notamment dans les PDF créés;
      ! un warning a donc été placé dans les routines 'Patch' et
      ! 'PColor'
      if( win%colormap_used ) then

         call pgscir_PS_ec( win%colormap_ci_low, win%colormap_ci_high )

         ! Before drawing, we must store again the colormap.
         if( win%predefined_colormap ) then
            inverted = win%colormap_inverted
            select case( win%colormap_name )
               case( "grey" )
                  call set_predefined_colormap( 0, inverted )
               case( "fusion" )
                  call set_predefined_colormap( 1, inverted )
               case( "bluered" )
                  call set_predefined_colormap( 2, inverted )
               case( "rainbow" )
                  call set_predefined_colormap( 3, inverted )
               case( "hot" )
                  call set_predefined_colormap( 4, inverted )
               case( "parula" )
                  call set_predefined_colormap( 5, inverted )
               case( "flag" )
                  call set_predefined_colormap( 6, inverted )
               case default ! as "rainbow"
                  call set_predefined_colormap( 3, inverted )
            end select
         else
            if( .not. allocated(win%user_colormap) ) then
               write(STDERR,*) "(MUESLI Print:) internal error:"
               write(STDERR,*) "                win%user_colormap not allocated!"
               write(STDERR,*) "                (subroutine print_pdf)"
               call msMuesliTrace( pause="yes" )
               return
            end if
            offset = win%colormap_ci_low - 1
            ncol = size(win%user_colormap,1)
            do i = 1, ncol
               r = win%user_colormap(i,1)
               g = win%user_colormap(i,2)
               b = win%user_colormap(i,3)
               call grscr(i+offset, r, g, b)
            end do
         end if

         ! If needed, send the range of colormap indices, and tell the EPS
         ! and PDF drivers to write the colormap inside the image (whatever
         ! the status of colorbar is).
         if( MF_CMAP_USED ) then
            if( COMMENTS_IN_PDF ) then
               call pdf_driver( ADD_COMMENT_EPS_PDF, rbuf, 1, "%-- begin of Colormap", 0 )
            end if
         end if
         ! ibuf(1) not used for PDF (only for EPS)
         ibuf(2) = win%colormap_ci_low
         ibuf(3) = win%colormap_ci_high
         call grexec( grgtyp, WRITE_COLORMAP_IF, rbuf, ibuf, chr, lchr )
         if( MF_CMAP_USED ) then
            if( COMMENTS_IN_PDF ) then
               call pdf_driver( ADD_COMMENT_EPS_PDF, rbuf, 1, "%-- end of Colormap", 0 )
            end if
         end if

      end if

      if( NB_USER_COL >= 1 ) then
         ! We must also store these colors !
         do k = 1, NB_USER_COL
            call pgslct( X11_id )
            call grqcr( CI_HIGH_MAX-k, r, g, b )
            call pgslct( print_id )
            call grscr( CI_HIGH_MAX-k, r, g, b )
         end do
      end if

      ! Keep, if applicable, the USER_TICKS_LABELS variables...
      if( USER_TICKS(X11_id) ) then
         USER_TICKS(print_id) = USER_TICKS(X11_id)
         USER_TICKS_ALL(print_id) = USER_TICKS_ALL(X11_id)
         vec_tmp = lbound(USER_TICKS_LABELS(X11_id)%labels) ; i1 = vec_tmp(1)
         vec_tmp = ubound(USER_TICKS_LABELS(X11_id)%labels) ; i2 = vec_tmp(1)
         if( allocated(USER_TICKS_LABELS(print_id)%labels) ) then
            vec_tmp = lbound(USER_TICKS_LABELS(print_id)%labels) ; n1 = vec_tmp(1)
            vec_tmp = ubound(USER_TICKS_LABELS(print_id)%labels) ; n2 = vec_tmp(1)
            if( n1 /= i1 .or. n2 /= i2  ) then
               deallocate( USER_TICKS_LABELS(print_id)%labels )
               allocate( USER_TICKS_LABELS(print_id)%labels(i1:i2) )
               deallocate( USER_TICKS_LABELS(print_id)%length )
               allocate( USER_TICKS_LABELS(print_id)%length(i1:i2) )
            end if
         else
            allocate( USER_TICKS_LABELS(print_id)%labels(i1:i2) )
            allocate( USER_TICKS_LABELS(print_id)%length(i1:i2) )
         end if
         USER_TICKS_LABELS(print_id)%labels(:) = USER_TICKS_LABELS(X11_id)%labels(:)
         USER_TICKS_LABELS(print_id)%length(:) = USER_TICKS_LABELS(X11_id)%length(:)
      end if

      ! on redessine tous les objets graphiques...

      ! Read the AFM files (Adobe Font Metrics) of the eight fontes
      ! used for text (tables limited to 22:255 subrange).
      if( .not. MF_AFM_READ ) then
         ! Filling the tables of 'grpckg1.inc'.
         call gr_read_AFM_files()
         MF_AFM_READ = .true.
      end if
      ! Closing AFM files will be done in 'msExitFgl()'.

      call mf_win_redraw( CURRENT_WIN_ID, from_print_call=.true. )

      call pgclos( )

      ! The current X11 window is selected again
      ! (even if it is the NULL_DEVICE)
      call pgslct( X11_id )

   end subroutine print_pdf
