!_______________________________________________________________________
!
   subroutine msPrint( filename, file_format )

      character(len=*), intent(in) :: filename

      ! choix du format de fichier vectoriel : "EPS", "PDF"
      character(len=*), intent(in), optional :: file_format

      !------ API end ------

      type(mf_win_info), pointer :: win
      character(len=8) :: print_device
      character(len=3) :: extension_3_chars
      integer :: k, itmp
      character(len=3) :: answer
      logical :: device_has_cursor, epscomments

      character(len=*), parameter :: ROUTINE_NAME = "msPrint"

   !------ end of declarations -- execution starts hereafter  ------

      if( len_trim(filename) == 0 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "no filename!" )
         return
      end if

      if( CURRENT_WIN_ID == 0 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "no window selected!" )
         return
      end if

      win => mf_win_db(CURRENT_WIN_ID)

      ! inquiring if the device has a cursor
      call pgqinf( "CURSOR", answer, itmp )
      if( to_lower(answer) == "yes" ) then
         device_has_cursor = .true.
         itmp = gr_set_cursor_shape( MF_WATCH_CURSOR )
      else
         device_has_cursor = .false.
      end if

      if( present(file_format) ) then
         select case( to_lower(trim(file_format)) )
            case( "eps" )
               print_device = "/EPS"
            case( "pdf" )
               print_device = "/PDF"
               if( BLACK_ON_WHITE == 0 ) then
                  call PrintMessage( trim(ROUTINE_NAME), "W",           &
                                     "PDF are created in black_on_white!", &
                                     "(thus, black and white colors have been swapped)" )
               end if
            case default
               call PrintMessage( trim(ROUTINE_NAME), "E",              &
                                  "unknown required format!" )
               go to 99
         end select
      else
         k = len_trim(filename)
         if( k-2 < 1 ) then
            ! too short filename
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "too short, or malformed filename!" )
            go to 99
         end if
         extension_3_chars = to_lower( filename(k-2:k) )
         select case( extension_3_chars )
            case( "eps" )
               print_device = "/EPS"
            case( "pdf" )
               print_device = "/PDF"
               if( BLACK_ON_WHITE == 0 ) then
                  call PrintMessage( trim(ROUTINE_NAME), "W",           &
                                     "PDF are created in black_on_white!", &
                                     "(thus, black and white colors have been swapped)" )
               end if
            case( "png" )
               if( BLACK_ON_WHITE == 0 ) then
                  call PrintMessage( trim(ROUTINE_NAME), "E",           &
                                     "PNG format is no longer available since version 2.13!", &
                                     "(you can choose EPS or PDF, then convert your vector image", &
                                     " in a bitmap one)" )
               end if
               go to 99
            case default
               print_device = "/EPS"
         end select
      end if

      if( print_device == "/EPS" ) then

         PRINTING_EPS = .true.
         call print_eps( filename )
         PRINTING_EPS = .false.

      else if( print_device == "/PDF" ) then

         PRINTING_PDF = .true.
         call print_pdf( filename )
         PRINTING_PDF = .false.

      end if

 99   continue

      ! restore the cursor
      if( device_has_cursor ) then
         itmp = gr_set_cursor_shape( MF_LEFT_ARROW_CURSOR )
      end if

   end subroutine msPrint
