!_______________________________________________________________________
!
   subroutine mf_line_draw( grobj )

      type(grobj_elem), intent(in) :: grobj
      !------ API end ------

      ! grobj type = "line"

      type(mf_win_info), pointer :: win

      integer :: status

      real(kind=MF_DOUBLE) :: rbuf(1)
      integer :: ibuf(2), lchr
      character :: chr

   !------ end of declarations -- execution starts hereafter  ------

      call quick_detect_pt_inside_2( grobj%struct%npt,                  &
                                     grobj%struct%abs_tab,              &
                                     grobj%struct%ord_tab,              &
                                     status )
      if( status == 0 ) return

      if( PRINTING_EPS ) then
         if( COMMENTS_IN_EPS ) then
            ibuf(1) = 0
            call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- begin of Line", 0 )
         end if
      end if
      if( PRINTING_PDF ) then
         if( COMMENTS_IN_PDF ) then
            call pdf_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- begin of Line", 0 )
         end if
         gr_pdf_color_intent = 1 ! Stroke
      end if

      win => mf_win_db(CURRENT_WIN_ID)

      call grsci(grobj%struct%color)   ! set color index
      call grslw(grobj%struct%linewidth) ! set line width
      call grsls(grobj%struct%linestyle)

      if( grobj%struct%cap_style == -1 ) then
         ibuf(1) = MF_DEFAULT_CAP_STYLE
      else
         ibuf(1) = grobj%struct%cap_style
      end if
      if( grobj%struct%join_style == -1 ) then
         ibuf(2) = MF_DEFAULT_JOIN_STYLE
      else
         ibuf(2) = grobj%struct%join_style
      end if
      call grexec( grgtyp, SET_LINE_CAP_JOIN_STYLE, rbuf, ibuf, chr, lchr )

      if( win%axis_scale_x == 1 .and. win%axis_scale_y == 1 ) then
         call pgline( grobj%struct%npt,                                 &
                      grobj%struct%abs_tab, grobj%struct%ord_tab )
      else if( win%axis_scale_x == 2 .and. win%axis_scale_y == 1 ) then
         call pgline( grobj%struct%npt,                                 &
                      log10(grobj%struct%abs_tab), grobj%struct%ord_tab )
      else if( win%axis_scale_x == 1 .and. win%axis_scale_y == 2 ) then
         call pgline( grobj%struct%npt,                                 &
                      grobj%struct%abs_tab, log10(grobj%struct%ord_tab) )
      else if( win%axis_scale_x == 2 .and. win%axis_scale_y == 2 ) then
         call pgline( grobj%struct%npt,                                 &
                      log10(grobj%struct%abs_tab), log10(grobj%struct%ord_tab) )
      else
         print *, "mf_line_draw: internal error."
         print *, "              bad value for axis_scale(s)!"
         pause "only for debugging purpose"
         stop
      end if

      ibuf(1) = MF_DEFAULT_CAP_STYLE
      ibuf(2) = MF_DEFAULT_JOIN_STYLE
      call grexec( grgtyp, SET_LINE_CAP_JOIN_STYLE, rbuf, ibuf, chr, lchr )

      if( PRINTING_EPS ) then
         LAST_COLOR_IS_VALID = .false.
         LAST_LINEWIDTH_IS_VALID = .false.
         LAST_LINESTYLE_IS_VALID = .false.
         LAST_FONT_ATTRIB_IS_VALID = .false.
         if( COMMENTS_IN_EPS ) then
            ibuf(1) = 0
            call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- end of Line", 0 )
         end if
      end if
      if( PRINTING_PDF ) then
         LAST_LINEWIDTH_IS_VALID = .false.
         LAST_LINESTYLE_IS_VALID = .false.
         LAST_FONT_ATTRIB_IS_VALID = .false.
         if( COMMENTS_IN_PDF ) then
            call pdf_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- end of Line", 0 )
         end if
      end if

   end subroutine mf_line_draw
!_______________________________________________________________________
!
   subroutine mf_point_draw( grobj )

      type(grobj_elem), intent(in) :: grobj
      !------ API end ------

      ! grobj type = "point"

      type(mf_win_info), pointer :: win

      integer :: marker, status

      real(kind=MF_DOUBLE) :: rbuf(1)
      integer :: ibuf(2), lchr
      character :: chr

   !------ end of declarations -- execution starts hereafter  ------

      call quick_detect_pt_inside_1( grobj%struct%npt,                  &
                                     grobj%struct%abs_tab,              &
                                     grobj%struct%ord_tab,              &
                                     status )
      if( status == 0 ) return

      if( PRINTING_EPS ) then
         if( COMMENTS_IN_EPS ) then
            ibuf(1) = 0
            call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- begin of Point (or marker)", 0 )
         end if
      end if
      if( PRINTING_PDF ) then
         if( COMMENTS_IN_PDF ) then
            call pdf_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- begin of Point (or marker)", 0 )
         end if
         gr_pdf_color_intent = 3 ! Stroke & Fill
      end if

      win => mf_win_db(CURRENT_WIN_ID)

      call grsci(grobj%struct%color)   ! set color index
      marker = grobj%struct%marker
      call grsms(grobj%struct%markersize) ! set marker size

      if( grobj%struct%cap_style == -1 ) then
         ibuf(1) = MF_DEFAULT_CAP_STYLE
      else
         ibuf(1) = grobj%struct%cap_style
      end if
      if( grobj%struct%join_style == -1 ) then
         ibuf(2) = MF_DEFAULT_JOIN_STYLE
      else
         ibuf(2) = grobj%struct%join_style
      end if
      call grexec( grgtyp, SET_LINE_CAP_JOIN_STYLE, rbuf, ibuf, chr, lchr )

      if( win%axis_scale_x == 1 .and. win%axis_scale_y == 1 ) then
         call pgpt( grobj%struct%npt,                                   &
                    grobj%struct%abs_tab, grobj%struct%ord_tab,         &
                    marker )
      else if( win%axis_scale_x == 2 .and. win%axis_scale_y == 1 ) then
         call pgpt( grobj%struct%npt,                                   &
                    log10(grobj%struct%abs_tab), grobj%struct%ord_tab,  &
                    marker )
      else if( win%axis_scale_x == 1 .and. win%axis_scale_y == 2 ) then
         call pgpt( grobj%struct%npt,                                   &
                    grobj%struct%abs_tab, log10(grobj%struct%ord_tab),  &
                    marker )
      else if( win%axis_scale_x == 2 .and. win%axis_scale_y == 2 ) then
         call pgpt( grobj%struct%npt,                                   &
                    log10(grobj%struct%abs_tab), log10(grobj%struct%ord_tab), &
                    marker )
      else
         print *, "mf_point_draw: internal error."
         print *, "               bad value for axis_scale(s)!"
         pause "only for debugging purpose"
         stop
      end if

      ibuf(1) = MF_DEFAULT_CAP_STYLE
      ibuf(2) = MF_DEFAULT_JOIN_STYLE
      call grexec( grgtyp, SET_LINE_CAP_JOIN_STYLE, rbuf, ibuf, chr, lchr )

      if( PRINTING_EPS ) then
         if( COMMENTS_IN_EPS ) then
            ibuf(1) = 0
            call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- end of Point (or marker)", 0 )
         end if
      end if
      if( PRINTING_PDF ) then
         if( COMMENTS_IN_PDF ) then
            call pdf_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- end of Point (or marker)", 0 )
         end if
      end if

   end subroutine mf_point_draw
!_______________________________________________________________________
!
   subroutine mf_line_point_draw( grobj )

      type(grobj_elem), intent(in) :: grobj
      !------ API end ------

      ! grobj type = "line+point"

      type(mf_win_info), pointer :: win

      integer :: marker, status

      real(kind=MF_DOUBLE) :: rbuf(1)
      integer :: ibuf(2), lchr
      character :: chr

   !------ end of declarations -- execution starts hereafter  ------

      call quick_detect_pt_inside_2( grobj%struct%npt,                  &
                                     grobj%struct%abs_tab,              &
                                     grobj%struct%ord_tab,              &
                                     status )
      if( status == 0 ) return

      if( PRINTING_EPS ) then
         if( COMMENTS_IN_EPS ) then
            ibuf(1) = 0
            call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- begin of Line+Point", 0 )
         end if
      end if
      if( PRINTING_PDF ) then
         if( COMMENTS_IN_PDF ) then
            call pdf_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- begin of Line+Point", 0 )
         end if
         gr_pdf_color_intent = 3 ! Stroke & Fill
      end if

      win => mf_win_db(CURRENT_WIN_ID)

      call grsci(grobj%struct%color) ! set color index
      call grslw(grobj%struct%linewidth) ! set line width
      call grsls(grobj%struct%linestyle)

      if( grobj%struct%cap_style == -1 ) then
         ibuf(1) = MF_DEFAULT_CAP_STYLE
      else
         ibuf(1) = grobj%struct%cap_style
      end if
      if( grobj%struct%join_style == -1 ) then
         ibuf(2) = MF_DEFAULT_JOIN_STYLE
      else
         ibuf(2) = grobj%struct%join_style
      end if
      call grexec( grgtyp, SET_LINE_CAP_JOIN_STYLE, rbuf, ibuf, chr, lchr )

      if( win%axis_scale_x == 1 .and. win%axis_scale_y == 1 ) then
         call pgline( grobj%struct%npt,                                 &
                      grobj%struct%abs_tab, grobj%struct%ord_tab )
      else if( win%axis_scale_x == 2 .and. win%axis_scale_y == 1 ) then
         call pgline( grobj%struct%npt,                                 &
                      log10(grobj%struct%abs_tab), grobj%struct%ord_tab )
      else if( win%axis_scale_x == 1 .and. win%axis_scale_y == 2 ) then
         call pgline( grobj%struct%npt,                                 &
                      grobj%struct%abs_tab, log10(grobj%struct%ord_tab) )
      else if( win%axis_scale_x == 2 .and. win%axis_scale_y == 2 ) then
         call pgline( grobj%struct%npt,                                 &
                      log10(grobj%struct%abs_tab), log10(grobj%struct%ord_tab) )
      else
         print *, "mf_line_point_draw: internal error."
         print *, "                    bad value for axis_scale(s)!"
         pause "only for debugging purpose"
         stop
      end if

      ibuf(1) = MF_DEFAULT_CAP_STYLE
      ibuf(2) = MF_DEFAULT_JOIN_STYLE
      call grexec( grgtyp, SET_LINE_CAP_JOIN_STYLE, rbuf, ibuf, chr, lchr )

      if( PRINTING_EPS ) then
         LAST_COLOR_IS_VALID = .false.
         LAST_LINEWIDTH_IS_VALID = .false.
         LAST_LINESTYLE_IS_VALID = .false.
         LAST_FONT_ATTRIB_IS_VALID = .false.
      end if
      if( PRINTING_PDF ) then
         LAST_LINEWIDTH_IS_VALID = .false.
         LAST_LINESTYLE_IS_VALID = .false.
         LAST_FONT_ATTRIB_IS_VALID = .false.
      end if

      marker = grobj%struct%marker
      call grsms(grobj%struct%markersize) ! set marker size

      if( win%axis_scale_x == 1 .and. win%axis_scale_y == 1 ) then
         call pgpt( grobj%struct%npt,                                   &
                    grobj%struct%abs_tab,                               &
                    grobj%struct%ord_tab,                               &
                    marker )
      else if( win%axis_scale_x == 2 .and. win%axis_scale_y == 1 ) then
         call pgpt( grobj%struct%npt,                                   &
                    log10(grobj%struct%abs_tab),                        &
                    grobj%struct%ord_tab,                               &
                    marker )
      else if( win%axis_scale_x == 1 .and. win%axis_scale_y == 2 ) then
         call pgpt( grobj%struct%npt,                                   &
                    grobj%struct%abs_tab,                               &
                    log10(grobj%struct%ord_tab),                        &
                    marker )
      else if( win%axis_scale_x == 2 .and. win%axis_scale_y == 2 ) then
         call pgpt( grobj%struct%npt,                                   &
                    log10(grobj%struct%abs_tab),                        &
                    log10(grobj%struct%ord_tab),                        &
                    marker )
      end if

      if( PRINTING_EPS ) then
         if( COMMENTS_IN_EPS ) then
            ibuf(1) = 0
            call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- end of Line+Point", 0 )
         end if
      end if
      if( PRINTING_PDF ) then
         if( COMMENTS_IN_PDF ) then
            call pdf_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- end of Line+Point", 0 )
         end if
      end if

   end subroutine mf_line_point_draw
!_______________________________________________________________________
!
   subroutine quick_detect_pt_inside_1( n, x, y, status )

      integer,              intent(in) :: n
      real(kind=MF_DOUBLE), intent(in) :: x(:), y(:)
      integer                          :: status
      !------ API end ------

      ! Return status=1 if something may be drawn inside the axes,
      ! else return status=0.
      !
      ! Case: Polypoints.

      type(mf_win_info), pointer :: win

      integer :: i
      logical :: x_inverted, y_inverted, bool_1, bool_2, bool_3, bool_4

   !------ end of declarations -- execution starts hereafter  ------

      win => mf_win_db(CURRENT_WIN_ID)

      status = 0

      if( win%current_axes(1) < win%current_axes(2) ) then
         x_inverted = .false.
      else
         x_inverted = .true.
      end if

      if( win%current_axes(3) < win%current_axes(4) ) then
         y_inverted = .false.
      else
         y_inverted = .true.
      end if

      ! Set status to 1 as soon as we detect that a point is inside
      ! the axes.
      !
      ! This quick test doesn't depend on line attributes, nor on the axes
      ! scaling.
      do i = 1, n
         if( x_inverted ) then
            bool_1 = x(i) >= win%current_axes(2)
            bool_2 = x(i) <= win%current_axes(1)
         else
            bool_1 = x(i) >= win%current_axes(1)
            bool_2 = x(i) <= win%current_axes(2)
         end if
         if( y_inverted ) then
            bool_3 = y(i) >= win%current_axes(4)
            bool_4 = y(i) <= win%current_axes(3)
         else
            bool_3 = y(i) >= win%current_axes(3)
            bool_4 = y(i) <= win%current_axes(4)
         end if
         if( bool_1 ) then
            if( bool_2 ) then
               if( bool_3 ) then
                  if( bool_4 ) then
                     status = 1
                     return
                  end if
               end if
            end if
         end if
      end do

   end subroutine quick_detect_pt_inside_1
!_______________________________________________________________________
!
   subroutine quick_detect_pt_inside_2( n, x, y, status )

      integer,              intent(in) :: n
      real(kind=MF_DOUBLE), intent(in) :: x(:), y(:)
      integer                          :: status
      !------ API end ------

      ! Return status=1 if something may be drawn inside the axes,
      ! else return status=0.
      !
      ! Case: Polylines.

      type(mf_win_info), pointer :: win

      real(kind=MF_DOUBLE) :: x_min, x_max, y_min, y_max
      integer :: i
      logical :: x_inverted, y_inverted, bool_1, bool_2, bool_3, bool_4

   !------ end of declarations -- execution starts hereafter  ------

      win => mf_win_db(CURRENT_WIN_ID)

      status = 0

      if( MF_QR_in_aux_pixmap ) then
         ! x_*_QR and y_*_QR already defined in Pan or PanAndZoom
      else
         x_left_QR   = win%current_axes(1)
         x_right_QR  = win%current_axes(2)
         y_bottom_QR = win%current_axes(3)
         y_top_QR    = win%current_axes(4)
      end if
      if( x_left_QR < x_right_QR ) then
         x_inverted = .false.
      else
         x_inverted = .true.
      end if

      if( y_bottom_QR < y_top_QR ) then
         y_inverted = .false.
      else
         y_inverted = .true.
      end if

      ! Set status to 1 as soon as we detect that the BBox of a line
      ! segment has an intersection with the axes which is not empty.
      ! (special case for a single point is also taken into account)
      !
      ! This quick test doesn't depend on line attributes, nor on the axes
      ! scaling.
      if( n == 1 ) then
         if( x_inverted ) then
            bool_1 = x(1) >= x_right_QR
            bool_2 = x(1) <= x_left_QR
         else
            bool_1 = x(1) >= x_left_QR
            bool_2 = x(1) <= x_right_QR
         end if
         if( y_inverted ) then
            bool_3 = y(1) >= y_top_QR
            bool_4 = y(1) <= y_bottom_QR
         else
            bool_3 = y(1) >= y_bottom_QR
            bool_4 = y(1) <= y_top_QR
         end if
         if( bool_1 ) then
            if( bool_2 ) then
               if( bool_3 ) then
                  if( bool_4 ) then
                     status = 1
                     return
                  end if
               end if
            end if
         end if
      else
         do i = 1, n-1
            x_min = min( x(i), x(i+1) )
            x_max = max( x(i), x(i+1) )
            y_min = min( y(i), y(i+1) )
            y_max = max( y(i), y(i+1) )
            if( x_inverted ) then
               bool_1 = x_max >= x_right_QR
               bool_2 = x_min <= x_left_QR
            else
               bool_1 = x_max >= x_left_QR
               bool_2 = x_min <= x_right_QR
            end if
            if( y_inverted ) then
               bool_3 = y_max >= y_top_QR
               bool_4 = y_min <= y_bottom_QR
            else
               bool_3 = y_max >= y_bottom_QR
               bool_4 = y_min <= y_top_QR
            end if
            if( bool_1 ) then
               if( bool_2 ) then
                  if( bool_3 ) then
                     if( bool_4 ) then
                        status = 1
                        return
                     end if
                  end if
               end if
            end if
         end do
      end if

   end subroutine quick_detect_pt_inside_2
