!_______________________________________________________________________
!
   function PlotCore( x_pg, y_pg, linecolor, linestyle, linewidth,      &
                      markersize, marker )                              &
   result( handle )

      real(kind=MF_DOUBLE), pointer    :: x_pg(:), y_pg(:)
      integer                          :: linecolor
      integer,              intent(in) :: linestyle, marker
      real(kind=MF_DOUBLE), intent(in) :: linewidth, markersize

      integer :: handle
      !------ API end ------

      type(mf_win_info), pointer :: win
      type(grobj_elem), pointer :: grobj

      integer :: i, n_pg, old_n_pg, hdle
      real(kind=MF_DOUBLE) :: range(4)

      real(kind=MF_DOUBLE), pointer :: anim_x(:) => null(), anim_y(:) => null()

      logical :: xoptl, yoptl

   !------ end of declarations -- execution starts hereafter  ------

      n_pg = size(x_pg)

      win => mf_win_db(CURRENT_WIN_ID)

      call mf_save_and_disable_fpe( )

      if( win%axis_manual_x==1 .and. win%axis_manual_y==1 .and.         &
          .not. win%mf_win_db_active ) then
         ! special case for animation

         ! select the first color, regardless the color scheme
         if( linecolor == -127 ) then
            select case( win%color_scheme )
               case( 1 )
                  linecolor = COL_CYCLE_TAB_1(1)
               case( 2 )
                  linecolor = COL_CYCLE_TAB_2(1)
               case( 3 )
                  linecolor = COL_CYCLE_TAB_3(1)
               case( 4 )
                  linecolor = COL_CYCLE_TAB_4(1)
               case default
                  write(STDERR,*) "(FGL PlotCore:) line 49: Internal error."
                  write(STDERR,*) "     Bad value for color_scheme."
                  pause "only for debugging purpose"
                  stop
            end select
         end if

      else ! standard case without animation (win_db active)

         range(1) = minval( x_pg )
         range(2) = maxval( x_pg )
         range(3) = minval( y_pg )
         range(4) = maxval( y_pg )
         call mf_prepare_axes( CURRENT_WIN_ID, range )

         ! cycling color table
         if( linecolor == -127 ) then
            select case( win%color_scheme )
               case( 1 )
                  linecolor = COL_CYCLE_TAB_1(win%ind_next_color)
                  if( win%ind_next_color == 6 ) then
                     win%ind_next_color = 1
                  else
                     win%ind_next_color = win%ind_next_color + 1
                  end if
               case( 2 )
                  linecolor = COL_CYCLE_TAB_2(win%ind_next_color)
                  if( win%ind_next_color == 7 ) then
                     win%ind_next_color = 1
                  else
                     win%ind_next_color = win%ind_next_color + 1
                  end if
               case( 3 )
                  linecolor = COL_CYCLE_TAB_3(win%ind_next_color)
                  if( win%ind_next_color == 7 ) then
                     win%ind_next_color = 1
                  else
                     win%ind_next_color = win%ind_next_color + 1
                  end if
               case( 4 )
                  linecolor = COL_CYCLE_TAB_4(win%ind_next_color)
                  if( win%ind_next_color == 12 ) then
                     win%ind_next_color = 1
                  else
                     win%ind_next_color = win%ind_next_color + 1
                  end if
               case default
                  write(STDERR,*) "(FGL PlotCore:) line 96: Internal error."
                  write(STDERR,*) "     Bad value for color_scheme."
                  pause "only for debugging purpose"
                  stop
            end select
         end if

      end if

      ! plotting something is always clipped at viewport
      if( X11_DEVICE ) then
         ! caution: axes must have been defined before
         call X11_clip_on_viewport()
      end if

      win%blank = .false.
      win%empty = .false.

      handle = 0

!++++++++++++++++++ Storage in DB ++++++++++++++++++

      ! new grobj
      if( win%mf_win_db_active ) then
         ! create a new grobj and insert it in the linked list
         call create_grobj( win, grobj )
      else
         ! just allocate the grobj
         allocate( grobj )
      end if

      grobj%struct%color = linecolor
      grobj%struct%linewidth = linewidth
      grobj%struct%marker = marker
      grobj%struct%npt = n_pg

      ! ATTENTION : on stocke dans la mémoire graphique les tableaux
      !             d'origine (même si on est en échelles log.).
      ! cela permet de basculer facilement de linéaire à log10 et
      ! inversement, sans perte de précision.
      grobj%struct%abs_tab => x_pg

      grobj%struct%ord_tab => y_pg

      if( linestyle /= -127 .and. marker == -127 ) then
         ! draw only line
         grobj%struct%linestyle = linestyle
         grobj%struct%cmd = "line"
      else if( linestyle == -127 .and. marker /= -127 ) then
         ! draw only markers
         grobj%struct%linestyle = 1
         grobj%struct%markersize = markersize
         grobj%struct%cmd = "point"
      else
         ! draw both
         grobj%struct%linestyle = linestyle
         grobj%struct%markersize = markersize
         grobj%struct%cmd = "line+point"
      end if

      if( win%mf_win_db_active ) then

         hdle = mf_win_get_free_handle(CURRENT_WIN_ID)
         win%handles(hdle)%ptr => grobj
         grobj%struct%hdle = hdle
         handle = encode_handle( CURRENT_WIN_ID, hdle )

      end if

!+++++++++++++++++++++++++++++++++++++++++++++++++++

!------------------ Drawing GrObj ------------------

      if( grobj%struct%cmd == "line" ) then
         call mf_line_draw( grobj )
      else if( grobj%struct%cmd == "point" ) then
         call mf_point_draw( grobj )
      else ! grobj%struct%cmd = "line+point"
         call mf_line_point_draw( grobj )
      end if

!---------------------------------------------------

      if( .not. win%mf_win_db_active ) then
         call delete_grobj_inside( grobj )
         deallocate( grobj )
         ! x_pg and y_pg already deallocated by 'delete_grobj_inside'
      end if

      call mf_restore_fpe( )

   end function PlotCore
!_______________________________________________________________________
!
   subroutine copy_data_for_plotting( tab_in, log_axis, tab_out, status )

      ! Inappropriate real values (Infinite or too large numerical values)
      ! are changed in NaN.
      !
      ! log_axis = 1 : linear axis
      !          = 2 : log axis

      real(kind=MF_DOUBLE), intent(in) :: tab_in(:)
      integer,              intent(in) :: log_axis

      real(kind=MF_DOUBLE), intent(out) :: tab_out(:)
      integer,              intent(out) :: status
      !------ API end ------

      ! to avoid overflow in computing ticks in pgbox...
      ! to avoid overflow in computing the whole range for each axis.
      real(kind=MF_DOUBLE), parameter :: MF_REALMAX_DOUBLE = 0.8d308

      integer :: i, n

      type(mf_win_info), pointer :: win

   !------ end of declarations -- execution starts hereafter  ------

      if( log_axis /= 1 .and. log_axis /= 2 ) then
         print *, "[Muesli/FGL] Plot: internal error in copy_data_for_plotting!"
         print *, "             Bad value for log_axis."
         pause "for debugging purpose only!"
         stop
      end if

      call mf_save_and_disable_fpe( )

      win => mf_win_db(CURRENT_WIN_ID)

      status = 0

      n = size(tab_in)

      if( log_axis == 1 ) then
         ! linear axis
         do i = 1, n
            if( tab_in(i) > MF_REALMAX_DOUBLE ) then
               tab_out(i) = MF_NAN
               status = 1
            else if( tab_in(i) < -MF_REALMAX_DOUBLE ) then
               tab_out(i) = MF_NAN
               status = 1
            else
               tab_out(i) = tab_in(i)
            end if
         end do
      else
         ! log axis
         do i = 1, n
            if( tab_in(i) > MF_REALMAX_DOUBLE ) then
               tab_out(i) = MF_NAN
               status = 1
            else if( tab_in(i) <= 0.0d0 ) then
               tab_out(i) = MF_NAN
               status = 1
            else
               tab_out(i) = tab_in(i)
            end if
         end do
      end if

      call mf_restore_fpe( )

   end subroutine copy_data_for_plotting
