!_______________________________________________________________________
!
   subroutine mf_plot_voronoi( grobj )

      type(grobj_elem), intent(in)   :: grobj
      !------ API end ------

      ! grobj type = "voronoi"

      type(mf_win_info), pointer :: win

      integer :: i, nn, nv, n, k, kk, icol_txt, tb, nstr, marker
      character(len=10) :: str
      real(kind=MF_DOUBLE) :: xc, yc

      real(kind=MF_DOUBLE), allocatable :: x_pg(:), y_pg(:)

      real(kind=MF_DOUBLE) :: rbuf(1)
      integer :: ibuf(1)

   !------ end of declarations -- execution starts hereafter  ------

      if( PRINTING_EPS ) then
         if( COMMENTS_IN_EPS ) then
            ibuf(1) = 0
            call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- begin of Voronoi", 0 )
         end if
         call gresc( "q" ) ! = gsave
      end if
      if( PRINTING_PDF ) then
         if( COMMENTS_IN_PDF ) then
            call pdf_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- begin of Voronoi", 0 )
         end if
         call gresc( "q" ) ! = gsave
         gr_pdf_color_intent = 3 ! Stroke & Fill
      end if

      ! first, draw the polygonal cells of the Voronoi diagram...
      call grsci(grobj%struct%color) ! set color index
      call grslw(grobj%struct%linewidth) ! set line width
      call grsls(1) ! line style: continuous
      nn = grobj%struct%npt
      do i = 1, nn
         n = size( grobj%struct%int_lst(i)%list )
         if( allocated(x_pg) ) then
            if( size(x_pg) < n+1 ) then
               deallocate( x_pg, y_pg )
               allocate( x_pg(n+1), y_pg(n+1) )
            end if
         else
            allocate( x_pg(n+1), y_pg(n+1) )
         end if
         do k = 1, n
            kk = grobj%struct%int_lst(i)%list(k)
            x_pg(k) = grobj%struct%val_mat(kk,1)
            y_pg(k) = grobj%struct%val_mat(kk,2)
         end do
         x_pg(n+1) = x_pg(1)
         y_pg(n+1) = y_pg(1)
         call pgline( n+1, x_pg, y_pg )
      end do

      ! second, draw the points (center of the Voronoi cells)...
      call grsci(1) ! set color index to 'foreground'
      call grsms(grobj%struct%markersize) ! set marker size
      call pgpt( nn, grobj%struct%abs_mat(:,1),                         &
                     grobj%struct%abs_mat(:,2), grobj%struct%marker )

      if( grobj%struct%bool1 ) then
         ! Write the nodes' number
         gr_pdf_color_intent = 3 ! Stroke & Fill
         icol_txt = grobj%struct%linestyle
         call grsci(icol_txt)
!### TODO ?:
! setting default value (not adapted if enlarging window),
! moreover, doesn't match the current symbol size ...
         call pgsch( grobj%struct%height_text ) ! char. height
         do i = 1, nn
            ! Find center of the label
            xc = grobj%struct%abs_mat(i,1) ! + shift ? ###
            yc = grobj%struct%abs_mat(i,2) ! + shift ? ###
            ! Write the label in a string
            write(str,"(I0)") i
            call pgptxt( xc, yc, angle=0.0d0,                           &
                         hjust=0.5d0, vjust=0.5d0, text=trim(str),      &
                         clipping=.true. )
         end do
      end if

      if( grobj%struct%bool2 ) then
         ! Write the vertices' number
         gr_pdf_color_intent = 3 ! Stroke & Fill
         icol_txt = grobj%struct%marker
         call grsci(icol_txt)
!### TODO ?:
! setting default value (not adapted if enlarging window),
! moreover, doesn't match the current symbol size ...
         call pgsch( grobj%struct%height_text ) ! char. height
         nv = grobj%struct%npt2
         do i = 1, nv
            ! Find center of the label
            xc = grobj%struct%val_mat(i,1)
            yc = grobj%struct%val_mat(i,2)
            ! Save current text background and set to erase
            ! anything under the textbox.
            call pgqtbg(tb)
            call pgstbg(0)
            ! Write the label in a string
            write(str,"(I0)") i
            str = " " // str
            nstr = len_trim(str) + 1
            call pgptxt( xc, yc, angle=0.0d0,                           &
                         hjust=0.5d0, vjust=0.5d0, text=str(1:nstr),    &
                         to_be_trimmed=.false., clipping=.true. )
            ! Restore text background
            call pgstbg(tb)
         end do
      end if

      if( PRINTING_EPS ) then
         call gresc( "Q" ) ! = grestore
         LAST_COLOR_IS_VALID = .false.
         LAST_LINEWIDTH_IS_VALID = .false.
         LAST_LINESTYLE_IS_VALID = .false.
         LAST_FONT_ATTRIB_IS_VALID = .false.
         if( COMMENTS_IN_EPS ) then
            ibuf(1) = 0
            call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- end of Voronoi", 0 )
         end if
      end if
      if( PRINTING_PDF ) then
         call gresc( "Q" ) ! = grestore
         LAST_LINEWIDTH_IS_VALID = .false.
         LAST_LINESTYLE_IS_VALID = .false.
         LAST_FONT_ATTRIB_IS_VALID = .false.
         if( COMMENTS_IN_PDF ) then
            call pdf_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- end of Voronoi", 0 )
         end if
      end if

   end subroutine mf_plot_voronoi
