!_______________________________________________________________________
!
   function PlotVoronoi( voronoi,                                       &
                         icol, linewidth, height,                       &
                         nod_num, vert_num )                            &
   result( handle )

      type(mfVoronoiStruct), intent(in) :: voronoi
      integer,               intent(in) :: icol
      real(kind=MF_DOUBLE),  intent(in) :: linewidth, height
      logical,               intent(in) :: nod_num, vert_num

      integer :: handle
      !------ API end ------

      integer :: nn, nv

      real(kind=MF_DOUBLE), pointer :: xy_pg(:,:), vert_xy_pg(:,:)
      type(mf_Int_List), pointer :: vert_list(:)

      type(mf_win_info), pointer :: win
      type(grobj_elem), pointer :: grobj

      real(kind=MF_DOUBLE) :: range(4)
      integer :: hdle, icol_txt

      integer :: itmp
      character(len=3) :: answer
      logical :: device_has_cursor

      character(len=*), parameter :: ROUTINE_NAME = "mf/msPlotVoronoi"

   !------ end of declarations -- execution starts hereafter  ------

      handle = 0

      if( voronoi%init == 0 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'voronoi' doesn't seem to be a valid Voronoi diagram!", &
                            "-> did you initialize it using mfVoronoi?" )
         return
      end if

      if( voronoi%init == 2 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'voronoi' is perhaps a valid Voronoi diagram, but it doesn't", &
                            "contain appropriate information about the cells' vertices!" )
         return
      end if

      nn = size( voronoi%n_xy, 1 )

      allocate( xy_pg(nn,2) )
      xy_pg = voronoi%n_xy

      nv = size( voronoi%v_xy, 1 )
      allocate( vert_xy_pg(nv,2) )
      vert_xy_pg = voronoi%v_xy

      allocate( vert_list(nn) )
      vert_list = voronoi%vertices

      ! les [nouveaux] axes doivent être prêts
      range(1) = minval( xy_pg(:,1) )
      range(2) = maxval( xy_pg(:,1) )
      range(3) = minval( xy_pg(:,2) )
      range(4) = maxval( xy_pg(:,2) )
      call mf_prepare_axes( CURRENT_WIN_ID, range )

      ! plotting something is always clipped at viewport
      if( X11_DEVICE ) then
         ! caution: axes must have been defined before
         call X11_clip_on_viewport()
      end if

      call pgbbuf()

      win => mf_win_db(CURRENT_WIN_ID)

!++++++++++++++++++ Storage in DB ++++++++++++++++++

      ! new grobj
      if( win%mf_win_db_active ) then
         ! create a new grobj and insert it in the linked list
         call create_grobj( win, grobj )
      else
         ! just allocate the grobj
         allocate( grobj )
      end if

      grobj%struct%cmd = "voronoi"
      grobj%struct%range = range
      grobj%struct%abs_mat => xy_pg
      grobj%struct%val_mat => vert_xy_pg
      grobj%struct%int_lst => vert_list
      grobj%struct%npt = nn
      grobj%struct%npt2 = nv
      grobj%struct%color = icol
      grobj%struct%linewidth = linewidth
      grobj%struct%height_text = height
      grobj%struct%bool1 = nod_num
      grobj%struct%bool2 = vert_num
      grobj%struct%marker = 6 ! circle

      if( nod_num ) then
         ! dark blue
         call decode_col_rgb( [0.0d0,0.0d0,0.6d0], icol_txt )
         grobj%struct%linestyle = icol_txt
      end if

      if( vert_num ) then
         ! dark magenta
         call decode_col_rgb( [0.0d0,0.6d0,0.0d0], icol_txt )
         grobj%struct%alpha_transp = icol_txt
      end if

      if( win%mf_win_db_active ) then
         hdle = mf_win_get_free_handle(CURRENT_WIN_ID)
         win%handles(hdle)%ptr => grobj
         grobj%struct%hdle = hdle
         handle = encode_handle( CURRENT_WIN_ID, hdle )
      end if

!+++++++++++++++++++++++++++++++++++++++++++++++++++

      win%blank = .false.
      win%empty = .false.

!------------------ Drawing GrObj ------------------

      ! inquiring if the device has a cursor
      call pgqinf( "CURSOR", answer, itmp )
      if( to_lower(answer) == "yes" ) then
         device_has_cursor = .true.
         itmp = gr_set_cursor_shape( MF_WATCH_CURSOR )
      else
         device_has_cursor = .false.
      end if

      call mf_plot_voronoi( grobj )

      call pgebuf()

      if( device_has_cursor ) then
         itmp = gr_set_cursor_shape( MF_LEFT_ARROW_CURSOR )
      end if

!---------------------------------------------------

      if( .not. win%mf_win_db_active ) then
         call delete_grobj_inside( grobj )
         deallocate( grobj )
      end if

   end function PlotVoronoi
