!_______________________________________________________________________
!
#ifdef _MF_FUNC
   function mfPlotVoronoi_color_str( voronoi,                           &
                                     color, linewidth, height,          &
                                     nod_num, vert_num )                &
   result( handle )
#endif
#ifdef _MF_SUBR
   subroutine msPlotVoronoi_color_str( voronoi,                         &
                                       color, linewidth, height,        &
                                       nod_num, vert_num )
#endif

      type(mfVoronoiStruct), intent(in)           :: voronoi
      character(len=*),      intent(in)           :: color
      real(kind=MF_DOUBLE),  intent(in), optional :: linewidth, height
      logical,               intent(in), optional :: nod_num, vert_num

      integer :: handle
      !------ API end ------

      integer :: icol, ier
      real(kind=MF_DOUBLE) :: linewidth_0, height_0
      logical :: nod_num_0, vert_num_0

#ifdef _MF_FUNC
      character(len=*), parameter :: ROUTINE_NAME = "mfPlotVoronoi"
#endif
#ifdef _MF_SUBR
      character(len=*), parameter :: ROUTINE_NAME = "msPlotVoronoi"
#endif

   !------ end of declarations -- execution starts hereafter  ------

      if( BLACK_ON_WHITE == -1 ) then
         if( CURRENT_WIN_ID == 0 ) then
            call msFigure()
            if( CURRENT_WIN_ID == 0 ) then
               call PrintMessage( trim(ROUTINE_NAME), "E",              &
                                 "cannot plot: no window created!" )
               handle = 0
               return
            end if
         end if
      end if

      ! default values
      if( BLACK_ON_WHITE == 1 ) then
         icol = 1
      else
         icol = 0
      end if

      if( len_trim(color) == 1 .or. color(1:1) == "\" ) then
         call decode_linespec( color, icol, ier=ier )
         if( ier /= 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "bad 'color' argument!",                 &
                               "(line color will be set to light grey)" )
            icol = -127
         end if
      else
         call decode_col_name( color, icol )
      end if

      if( icol == -127 ) then
         icol = MFPLOT_LIGHT_GREY
      end if

      if( present(linewidth) ) then
         linewidth_0 = linewidth
      else
         linewidth_0 = 1.0
      end if

      if( present(height) ) then
         height_0 = height
      else
         height_0 = 1.0
      end if

      if( present(nod_num) ) then
         nod_num_0 = nod_num
      else
         nod_num_0 = .false.
      end if

      if( present(vert_num) ) then
         vert_num_0 = vert_num
      else
         vert_num_0 = .false.
      end if

      handle = PlotVoronoi( voronoi, icol,                              &
                            linewidth_0, height_0,                      &
                            nod_num_0, vert_num_0 )

#ifdef _MF_FUNC
   end function mfPlotVoronoi_color_str
#endif
#ifdef _MF_SUBR
   end subroutine msPlotVoronoi_color_str
#endif
!_______________________________________________________________________
!
#ifdef _MF_FUNC
   function mfPlotVoronoi_color_rgb( voronoi,                           &
                                     color, linewidth, height,          &
                                     nod_num, vert_num )                &
   result( handle )
#endif
#ifdef _MF_SUBR
   subroutine msPlotVoronoi_color_rgb( voronoi,                         &
                                       color, linewidth, height,        &
                                       nod_num, vert_num )
#endif

      type(mfVoronoiStruct), intent(in)           :: voronoi
      real(kind=MF_DOUBLE),  intent(in), optional :: color(3)
      real(kind=MF_DOUBLE),  intent(in), optional :: linewidth, height
      logical,               intent(in), optional :: nod_num, vert_num

      integer :: handle
      !------ API end ------

      integer :: icol
      real(kind=MF_DOUBLE) :: linewidth_0, height_0
      logical :: nod_num_0, vert_num_0

#ifdef _MF_FUNC
      character(len=*), parameter :: ROUTINE_NAME = "mfPlotVoronoi"
#endif
#ifdef _MF_SUBR
      character(len=*), parameter :: ROUTINE_NAME = "msPlotVoronoi"
#endif

   !------ end of declarations -- execution starts hereafter  ------

      if( BLACK_ON_WHITE == -1 ) then
         if( CURRENT_WIN_ID == 0 ) then
            call msFigure()
            if( CURRENT_WIN_ID == 0 ) then
               call PrintMessage( trim(ROUTINE_NAME), "E",              &
                                 "cannot plot: no window created!" )
               handle = 0
               return
            end if
         end if
      end if

      ! default values
      if( BLACK_ON_WHITE == 1 ) then
         icol = 1
      else
         icol = 0
      end if

      if( present(color) ) then
         call decode_col_rgb( color, icol )
      end if

      if( icol == -127 ) then
         icol = MFPLOT_LIGHT_GREY
      end if

      if( present(linewidth) ) then
         linewidth_0 = linewidth
      else
         linewidth_0 = 1.0
      end if

      if( present(height) ) then
         height_0 = height
      else
         height_0 = 1.0
      end if

      if( present(nod_num) ) then
         nod_num_0 = nod_num
      else
         nod_num_0 = .false.
      end if

      if( present(vert_num) ) then
         vert_num_0 = vert_num
      else
         vert_num_0 = .false.
      end if

      handle = PlotVoronoi( voronoi, icol,                              &
                            linewidth_0, height_0,                      &
                            nod_num_0, vert_num_0 )

#ifdef _MF_FUNC
   end function mfPlotVoronoi_color_rgb
#endif
#ifdef _MF_SUBR
   end subroutine msPlotVoronoi_color_rgb
#endif
