!_______________________________________________________________________
!
#ifdef _MF_FUNC
   function mfPlotQuadrBezier_color_str( x, y, linespec,                &
                                         color, linewidth,              &
                                         dashes_inverted )              &
   result( handle )
#endif
#ifdef _MF_SUBR
   subroutine msPlotQuadrBezier_color_str( x, y, linespec,              &
                                           color, linewidth,            &
                                           dashes_inverted )
#endif

      type(mfArray)                              :: x, y
      character(len=*),     intent(in), optional :: linespec
      character(len=*),     intent(in)           :: color
      real(kind=MF_DOUBLE), intent(in), optional :: linewidth
      logical,              intent(in), optional :: dashes_inverted
      integer :: handle
      !------ API end ------

      ! This Quadratic Bézier curve is continuous (but doesn't have
      ! necessarily continuous derivatives); therefore, the total number
      ! of points in the 'x' and 'y' arrays must be of the form: 2*k+1,
      ! where k is the number of segments.

      type(mf_win_info), pointer :: win
      real(kind=MF_DOUBLE) :: linewidth_d
      integer :: linecolor, linestyle, marker, ier

      ! pointers for manipulating mfArray out of fml module
      real(kind=MF_DOUBLE), pointer :: x_ptr(:,:), y_ptr(:,:)

      real(kind=MF_DOUBLE), pointer :: x_sto_pg(:), y_sto_pg(:)
      integer :: p_dim, n_dim, n_pg
      integer :: status, status_alloc_x, status_alloc_y
      character(len=4) :: str1

#ifdef _MF_FUNC
      character(len=*), parameter :: ROUTINE_NAME = "mfPlotQuadrBezier"
#endif
#ifdef _MF_SUBR
      character(len=*), parameter :: ROUTINE_NAME = "msPlotQuadrBezier"
#endif

   !------ end of declarations -- execution starts hereafter  ------

#ifdef _MF_FUNC
      handle = 0
#endif

      if( CURRENT_WIN_ID == 0 ) then
         call msFigure()
         if( CURRENT_WIN_ID == 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "cannot plot : no window created!" )
            return
         end if
      end if

      win => mf_win_db(CURRENT_WIN_ID)

      if( win%axis_scale_x == 0 .and. win%axis_scale_y == 0 ) then
         win%axis_scale_x = 1
         win%axis_scale_y = 1
      end if

      call msInitArgs( x, y )

      ! checking that 'x' is allocated
      if( mfIsEqual(x,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' not allocated!" )
         go to 99
      end if

      ! 'x' must be Real
      if( .not. mfIsReal(x) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' must be real!" )
         go to 99
      end if

      ! 'x' cannot be sparse
      if( mfIsSparse(x) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' cannot be sparse!" )
         go to 99
      end if

      call msPointer_real_only( x, x_ptr, status_alloc_x )

      if( size(x_ptr,1)==0 .or. size(x_ptr,2)==0 ) then
         call PrintMessage( trim(ROUTINE_NAME), "W",                    &
                            "nothing to plot" )
         go to 99
      end if

      ! checking that 'x' is a 1-D array
      if( size(x_ptr,1)/=1 .and. size(x_ptr,2)/=1 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "cannot yet plot a matrix" )
         go to 99
      else
         if( size(x_ptr,1) == 1 ) then
            p_dim = 2
         else
            p_dim = 1
         end if
         n_dim = size(x_ptr,p_dim)
         n_pg = n_dim
         allocate( x_sto_pg(n_pg) )

         allocate( y_sto_pg(n_pg) )

      end if

      ! checking for nb of control points;
      ! it must be of the form: 2*k+1
      if( mod(n_pg-1,2) /= 0 ) then
         write(str1,"(I0)") n_pg
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "bad nb of control points!",                &
                            "it must be of the form : 2*k+1, but got n = " // trim(str1) )
         go to 99
      end if

      ! checking that 'y' is allocated
      if( mfIsEqual(y,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' not allocated!" )
         go to 99
      end if

      ! 'y' must be Real
      if( .not. mfIsReal(y) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' must be real!" )
         go to 99
      end if

      ! 'y' cannot be sparse
      if( mfIsSparse(y) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' cannot be sparse!" )
         go to 99
      end if

      call msPointer_real_only( y, y_ptr, status_alloc_y )

      ! checking that 'y' have the same size than 'x'
      if( size(y_ptr,1) /= size(x_ptr,1) .or.                           &
          size(y_ptr,2) /= size(x_ptr,2)      ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' and 'y' array must have the same size" )
         go to 99
      end if

      ! comme la récursivité pour construire les segments de droite
      ! élémentaires risque d'entraîner un MEMORY FAULT, alors, on doit
      ! systématiquement éliminer les Inf, puis, dans un second temps,
      ! traiter correctement les NaN produits dans la routine CORE.
      if( p_dim == 1 ) then

         call copy_data_for_plotting( x_ptr(:,1), win%axis_scale_x, x_sto_pg(:), status )
         if( status /= 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "some values for 'x' are inappropriate for MFPLOT;", &
                               "they will be ignored!" )
         end if

         call copy_data_for_plotting( y_ptr(:,1), win%axis_scale_y, y_sto_pg(:), status )
         if( status /= 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "some values for 'y' are inappropriate for MFPLOT;", &
                               "they will be ignored!" )
         end if

      else

         call copy_data_for_plotting( x_ptr(1,:), win%axis_scale_x, x_sto_pg(:), status )
         if( status /= 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "some values for 'x' are inappropriate for MFPLOT;", &
                               "they will be ignored!" )
         end if

         call copy_data_for_plotting( y_ptr(1,:), win%axis_scale_y, y_sto_pg(:), status )
         if( status /= 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "some values for 'y' are inappropriate for MFPLOT;", &
                               "they will be ignored!" )
         end if

      end if

      if( present(linespec) ) then
         call decode_linespec( linespec, linecolor, linestyle, marker )
         ! only linestyle must have a valid value
         if( linestyle == -127 .and. marker == -127 ) then
            linestyle = 1
         end if
         if( marker /= -127 ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "marker selection is discarded in this routine.",                              &
                               "(hint: add a msPlot call with the Hold property)" )
         end if
      else
         linecolor = -127 ! means: not found
         linestyle = 1
         marker    = -127 ! means: not found
      end if

      if( present(dashes_inverted) ) then
         if( linestyle == 2 ) then
            if( dashes_inverted ) then
               linestyle = 5 ! inverted dashed line
            end if
         else
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "argument 'dashes_inverted' may be used only for a dashed curve.", &
                               "it will be ignored!" )
         end if
      end if

      if( len_trim(color) == 1 .or. color(1:1) == "\" ) then
         call decode_linespec( color, linecolor, ier=ier )
         if( ier /= 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                              "bad 'color' argument!",                  &
                              "(line color will be set to foreground color)" )
            linecolor = 1
         end if
      else
         call decode_col_name( color, linecolor )
      end if

      if( present(linewidth) ) then
         linewidth_d = linewidth
      else
         linewidth_d = 1.
      end if

      ! marker is ignored
      handle = PlotQuadrBezierCore( x_sto_pg, y_sto_pg, linecolor,      &
                                    linestyle, linewidth_d )

      if( mfIsComplex(x) ) then
         call PrintMessage( trim(ROUTINE_NAME), "W",                    &
                            "Imaginary parts of complex argument 'x' ignored." )
      end if

      if( mfIsComplex(y) ) then
         call PrintMessage( trim(ROUTINE_NAME), "W",                    &
                            "Imaginary parts of complex argument 'y' ignored." )
      end if

 99   continue

      if( status_alloc_x == 1 ) then
         deallocate( x_ptr )
      else
         call msFreePointer( x, x_ptr )
      end if

      if( status_alloc_y == 1 ) then
         deallocate( y_ptr )
      else
         call msFreePointer( y, y_ptr )
      end if

      call msFreeArgs( x, y )
      call msAutoRelease( x, y )

#ifdef _MF_FUNC
   end function mfPlotQuadrBezier_color_str
#endif
#ifdef _MF_SUBR
   end subroutine msPlotQuadrBezier_color_str
#endif
!_______________________________________________________________________
!
#ifdef _MF_FUNC
   function mfPlotQuadrBezier_color_rgb( x, y, linespec,                &
                                         color, linewidth,              &
                                         dashes_inverted )              &
   result( handle )
#endif
#ifdef _MF_SUBR
   subroutine msPlotQuadrBezier_color_rgb( x, y, linespec,              &
                                           color, linewidth,            &
                                           dashes_inverted )
#endif

      type(mfArray)                              :: x, y
      character(len=*),     intent(in), optional :: linespec
      real(kind=MF_DOUBLE), intent(in), optional :: color(3)
      real(kind=MF_DOUBLE), intent(in), optional :: linewidth
      logical,              intent(in), optional :: dashes_inverted
      integer :: handle
      !------ API end ------

      ! This Quadratic Bézier curve is continuous (but doesn't have
      ! necessarily continuous derivatives); therefore, the total number
      ! of points in the 'x' and 'y' arrays must be of the form: 2*k+1,
      ! where k is the number of segments.

      type(mf_win_info), pointer :: win
      real(kind=MF_DOUBLE) :: linewidth_d
      integer :: linecolor, linestyle, marker

      ! pointers for manipulating mfArray out of fml module
      real(kind=MF_DOUBLE), pointer :: x_ptr(:,:), y_ptr(:,:)

      real(kind=MF_DOUBLE), pointer :: x_sto_pg(:), y_sto_pg(:)
      integer :: p_dim, n_dim, n_pg
      integer :: status, status_alloc_x, status_alloc_y
      character(len=4) :: str1

#ifdef _MF_FUNC
      character(len=*), parameter :: ROUTINE_NAME = "mfPlotQuadrBezier"
#endif
#ifdef _MF_SUBR
      character(len=*), parameter :: ROUTINE_NAME = "msPlotQuadrBezier"
#endif

   !------ end of declarations -- execution starts hereafter  ------

#ifdef _MF_FUNC
      handle = 0
#endif

      if( CURRENT_WIN_ID == 0 ) then
         call msFigure()
         if( CURRENT_WIN_ID == 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "cannot plot : no window created!" )
            return
         end if
      end if

      win => mf_win_db(CURRENT_WIN_ID)

      if( win%axis_scale_x == 0 .and. win%axis_scale_y == 0 ) then
         win%axis_scale_x = 1
         win%axis_scale_y = 1
      end if

      call msInitArgs( x, y )

      ! checking that 'x' is allocated
      if( mfIsEqual(x,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' not allocated!" )
         go to 99
      end if

      ! 'x' must be Real
      if( .not. mfIsReal(x) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' must be real!" )
         go to 99
      end if

      ! 'x' cannot be sparse
      if( mfIsSparse(x) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' cannot be sparse!" )
         go to 99
      end if

      call msPointer_real_only( x, x_ptr, status_alloc_x )

      if( size(x_ptr,1)==0 .or. size(x_ptr,2)==0 ) then
         call PrintMessage( trim(ROUTINE_NAME), "W",                    &
                            "nothing to plot" )
         go to 99
      end if

      ! checking that 'x' is a 1-D array
      if( size(x_ptr,1)/=1 .and. size(x_ptr,2)/=1 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "cannot yet plot a matrix" )
         go to 99
      else
         if( size(x_ptr,1) == 1 ) then
            p_dim = 2
         else
            p_dim = 1
         end if
         n_dim = size(x_ptr,p_dim)
         n_pg = n_dim
         allocate( x_sto_pg(n_pg) )

         allocate( y_sto_pg(n_pg) )

      end if

      ! checking for nb of control points;
      ! it must be of the form: 2*k+1
      if( mod(n_pg-1,2) /= 0 ) then
         write(str1,"(I0)") n_pg
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "bad nb of control points!",                &
                            "it must be of the form : 2*k+1, but got n = " // trim(str1) )
         go to 99
      end if

      ! checking that 'y' is allocated
      if( mfIsEqual(y,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' not allocated!" )
         go to 99
      end if

      ! 'y' must be Real
      if( .not. mfIsReal(y) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' must be real!" )
         go to 99
      end if

      ! 'y' cannot be sparse
      if( mfIsSparse(y) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' cannot be sparse!" )
         go to 99
      end if

      call msPointer_real_only( y, y_ptr, status_alloc_y )

      ! checking that 'y' have the same size than 'x'
      if( size(y_ptr,1) /= size(x_ptr,1) .or.                           &
          size(y_ptr,2) /= size(x_ptr,2)      ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' and 'y' array must have the same size" )
         go to 99
      end if

      ! comme la récursivité pour construire les segments de droite
      ! élémentaires risque d'entraîner un MEMORY FAULT, alors, on doit
      ! systématiquement éliminer les Inf, puis, dans un second temps,
      ! traiter correctement les NaN produits dans la routine CORE.
      if( p_dim == 1 ) then

         call copy_data_for_plotting( x_ptr(:,1), win%axis_scale_x, x_sto_pg(:), status )
         if( status /= 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "some values for 'x' are inappropriate for MFPLOT;", &
                               "they will be ignored!" )
         end if

         call copy_data_for_plotting( y_ptr(:,1), win%axis_scale_y, y_sto_pg(:), status )
         if( status /= 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "some values for 'y' are inappropriate for MFPLOT;", &
                               "they will be ignored!" )
         end if

      else

         call copy_data_for_plotting( x_ptr(1,:), win%axis_scale_x, x_sto_pg(:), status )
         if( status /= 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "some values for 'x' are inappropriate for MFPLOT;", &
                               "they will be ignored!" )
         end if

         call copy_data_for_plotting( y_ptr(1,:), win%axis_scale_y, y_sto_pg(:), status )
         if( status /= 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "some values for 'y' are inappropriate for MFPLOT;", &
                               "they will be ignored!" )
         end if

      end if

      if( present(linespec) ) then
         call decode_linespec( linespec, linecolor, linestyle, marker )
         ! only linestyle must have a valid value
         if( linestyle == -127 .and. marker == -127 ) then
            linestyle = 1
         end if
         if( marker /= -127 ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "marker selection is discarded in this routine.",                              &
                               "(hint: add a msPlot call with the Hold property)" )
         end if
      else
         linecolor = -127 ! means: not found
         linestyle = 1
         marker    = -127 ! means: not found
      end if

      if( present(dashes_inverted) ) then
         if( linestyle == 2 ) then
            if( dashes_inverted ) then
               linestyle = 5 ! inverted dashed line
            end if
         else
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "argument 'dashes_inverted' may be used only for a dashed curve.", &
                               "it will be ignored!" )
         end if
      end if

      if( present(color) ) then
         call decode_col_rgb( color, linecolor )
      end if

      if( present(linewidth) ) then
         linewidth_d = linewidth
      else
         linewidth_d = 1.
      end if

      ! marker is ignored
      handle = PlotQuadrBezierCore( x_sto_pg, y_sto_pg, linecolor,      &
                                    linestyle, linewidth_d )

      if( mfIsComplex(x) ) then
         call PrintMessage( trim(ROUTINE_NAME), "W",                    &
                            "Imaginary parts of complex argument 'x' ignored." )
      end if

      if( mfIsComplex(y) ) then
         call PrintMessage( trim(ROUTINE_NAME), "W",                    &
                            "Imaginary parts of complex argument 'y' ignored." )
      end if

 99   continue

      if( status_alloc_x == 1 ) then
         deallocate( x_ptr )
      else
         call msFreePointer( x, x_ptr )
      end if

      if( status_alloc_y == 1 ) then
         deallocate( y_ptr )
      else
         call msFreePointer( y, y_ptr )
      end if

      call msFreeArgs( x, y )
      call msAutoRelease( x, y )

#ifdef _MF_FUNC
   end function mfPlotQuadrBezier_color_rgb
#endif
#ifdef _MF_SUBR
   end subroutine msPlotQuadrBezier_color_rgb
#endif
