!_______________________________________________________________________
!
   subroutine mf_PlotPLdomain_draw( grobj )

      type(grobj_elem), intent(in)   :: grobj
      !------ API end ------

      ! grobj type = "PLdomain"

      type(mf_win_info), pointer :: win

      integer :: i, nn, ne, nh, k1, k2, icol_txt, tb, nstr
      character(len=10) :: str
      real(kind=MF_DOUBLE) :: xc, yc, delta

      real(kind=MF_DOUBLE) :: x_pg_2(2), y_pg_2(2)
      real(kind=MF_DOUBLE) :: xbox(4), ybox(4)

      real(kind=MF_DOUBLE) :: rbuf(1)
      integer :: ibuf(1)

   !------ end of declarations -- execution starts hereafter  ------

      if( PRINTING_EPS ) then
         if( COMMENTS_IN_EPS ) then
            ibuf(1) = 0
            call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- begin of PLdomain", 0 )
         end if
         call gresc( "q" ) ! = gsave
      end if
      if( PRINTING_PDF ) then
         if( COMMENTS_IN_PDF ) then
            call pdf_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- begin of PLdomain", 0 )
         end if
         call gresc( "q" ) ! = gsave
      end if

      ! draw segments
      gr_pdf_color_intent = 1 ! Stroke
      call grsci(grobj%struct%color) ! set color index
      call grslw(grobj%struct%linewidth) ! set line width
      call grsls(1) ! line style: continuous
      if( .not. associated(grobj%struct%tab_2d_1) ) then
         ne = -1
      else
         ne = size(grobj%struct%tab_2d_1,1)
      end if
      do i = 1, ne
         k1 = grobj%struct%tab_2d_1(i,1)
         k2 = grobj%struct%tab_2d_1(i,2)
         x_pg_2(:) = [ grobj%struct%abs_mat(k1,1),                      &
                       grobj%struct%abs_mat(k2,1) ]
         y_pg_2(:) = [ grobj%struct%abs_mat(k1,2),                      &
                       grobj%struct%abs_mat(k2,2) ]
         call pgline( 2, x_pg_2, y_pg_2 )
      end do

!### Warning: ci-dessous, codage en dur des codes de markers 14 et 23
!             (qui doivent être reportés 'as well' dans la routine
!              'count_PDF_objects' de mf_win_aux.F90)

      ! draw only nodes implied in segments
      gr_pdf_color_intent = 3 ! Stroke & Fill
      call grsci(1) ! set color index
      call grsms(1.0d0) ! set marker size
      do i = 1, ne
         k1 = grobj%struct%tab_2d_1(i,1)
         call pgpt( 1, [grobj%struct%abs_mat(k1,1)],                    &
                       [grobj%struct%abs_mat(k1,2)], 14 )
      end do

      ! draw holes (as points)
      if( .not. associated(grobj%struct%ord_mat) ) then
         nh = -1
      else
         nh = size(grobj%struct%ord_mat,1)
      end if
      call grsci(2) ! set color index
      do i = 1, nh
         call pgpt( 1, [grobj%struct%ord_mat(i,1)],                     &
                       [grobj%struct%ord_mat(i,2)], 23 )
      end do

      if( grobj%struct%bool1 ) then
         ! Write the nodes' number (only the first node of each segment)
         gr_pdf_color_intent = 3 ! Stroke & Fill
         icol_txt = grobj%struct%npt
         call grsci(icol_txt)
!### TODO ?:
! setting default value (not adapted if enlarging window),
! moreover, doesn't match the current symbol size ...
         call pgsch( 1.0d0 ) ! default char. height
         do i = 1, ne
            k1 = grobj%struct%tab_2d_1(i,1)
            ! Find center of the label
            xc = grobj%struct%abs_mat(k1,1)
            yc = grobj%struct%abs_mat(k1,2)
            ! Save current text background and set to erase
            ! anything under the textbox.
            call pgqtbg(tb)
            call pgstbg(0)
            ! Write the label in a string
            write(str,"(I0)") i
            str = " " // str
            nstr = len_trim(str) + 1
            call pgptxt( xc, yc, angle=0.0d0,                           &
                         hjust=0.5d0, vjust=0.5d0, text=str(1:nstr),    &
                         to_be_trimmed=.false., clipping=.true. )
            ! Restore text background
            call pgstbg(tb)
         end do
      end if

      if( grobj%struct%bool2 ) then
         ! Write the edges' number
         gr_pdf_color_intent = 3 ! Stroke & Fill
         icol_txt = grobj%struct%npt2
         call grsci(icol_txt)
!### TODO ?:
! setting default value (not adapted if enlarging window),
! moreover, doesn't match the current symbol size ...
         call pgsch( 1.0d0 ) ! default char. height
         do i = 1, ne
            k1 = grobj%struct%tab_2d_1(i,1)
            k2 = grobj%struct%tab_2d_1(i,2)
            ! Find center of the label
            xc = ( sum(grobj%struct%abs_mat([k1,k2],1)) ) / 2.0d0
            yc = ( sum(grobj%struct%abs_mat([k1,k2],2)) ) / 2.0d0
            ! Save current text background and set to erase
            ! anything under the textbox.
            call pgqtbg(tb)
            call pgstbg(0)
            ! Write the label in a string
            write(str,"(I0)") i
            str = " " // str
            nstr = len_trim(str) + 1
            call pgptxt( xc, yc, angle=0.0d0,                           &
                         hjust=0.5d0, vjust=0.5d0, text=str(1:nstr),    &
                         to_be_trimmed=.false., clipping=.true. )
         end do
      end if

      if( grobj%struct%bool3 ) then
         ! Write the holes' number
         gr_pdf_color_intent = 3 ! Stroke & Fill
         icol_txt = grobj%struct%npt3
         call grsci(icol_txt)
!### TODO ?:
! setting default value (not adapted if enlarging window),
! moreover, doesn't match the current symbol size ...
         call pgsch( 1.0d0 ) ! default char. height
         do i = 1, nh
            ! Find center of the label
            xc = grobj%struct%ord_mat(i,1)
            yc = grobj%struct%ord_mat(i,2)
            ! Write the label in a string
            write(str,"(I0)") i
            ! Find bounding box of character "8"
            call pgqtxt( xc, yc, 0.0d0, 0.5d0, "8", xbox, ybox )
            delta = 0.5d0*(ybox(3) - ybox(1))
            call pgptxt( xc+delta, yc+delta, angle=0.0d0,               &
                         hjust=0.5d0, vjust=0.5d0, text=trim(str),      &
                         to_be_trimmed=.false., clipping=.true. )
         end do
      end if

      if( PRINTING_EPS ) then
         call gresc( "Q" ) ! = grestore
         LAST_COLOR_IS_VALID = .false.
         LAST_LINEWIDTH_IS_VALID = .false.
         LAST_LINESTYLE_IS_VALID = .false.
         LAST_FONT_ATTRIB_IS_VALID = .false.
         if( COMMENTS_IN_EPS ) then
            ibuf(1) = 0
            call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- end of PLdomain", 0 )
         end if
      end if
      if( PRINTING_PDF ) then
         call gresc( "Q" ) ! = grestore
         LAST_LINEWIDTH_IS_VALID = .false.
         LAST_LINESTYLE_IS_VALID = .false.
         LAST_FONT_ATTRIB_IS_VALID = .false.
         if( COMMENTS_IN_PDF ) then
            call pdf_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- end of PLdomain", 0 )
         end if
      end if

   end subroutine mf_PlotPLdomain_draw
