!_______________________________________________________________________
!
   function PlotPLdomain_aux( PL_domain, nn, ne, nh,                      &
                          icol, linewidth,                              &
                          nod_num, edg_num, hol_num )                             &
   result( handle )

      type(mfPLdomain),     intent(in) :: PL_domain
      integer,              intent(in) :: nn, ne, nh, icol
      real(kind=MF_DOUBLE), intent(in) :: linewidth
      logical,              intent(in) :: nod_num, edg_num, hol_num

      integer :: handle
      !------ API end ------

      type(mf_win_info), pointer :: win
      type(grobj_elem), pointer :: grobj

      real(kind=MF_DOUBLE) :: range(4)

      integer :: hdle, icol_txt

      integer :: itmp
      character(len=3) :: answer
      logical :: device_has_cursor

   !------ end of declarations -- execution starts hereafter  ------

      ! les [nouveaux] axes doivent être prêts
      range(1) = minval( PL_domain%n_xy(:,1) )
      range(2) = maxval( PL_domain%n_xy(:,1) )
      range(3) = minval( PL_domain%n_xy(:,2) )
      range(4) = maxval( PL_domain%n_xy(:,2) )
      call mf_prepare_axes( CURRENT_WIN_ID, range )

      ! plotting something is always clipped at viewport
      if( X11_DEVICE ) then
         ! caution: axes must have been defined before
         call X11_clip_on_viewport()
      end if

      win => mf_win_db(CURRENT_WIN_ID)

!++++++++++++++++++ Storage in DB ++++++++++++++++++

      ! new grobj
      if( win%mf_win_db_active ) then
         ! create a new grobj and insert it in the linked list
         call create_grobj( win, grobj )
      else
         ! just allocate the grobj
         allocate( grobj )
      end if

      grobj%struct%cmd = "PLdomain"
      grobj%struct%range = range
      if( nn > 0 ) then
         allocate( grobj%struct%abs_mat(nn,2) )
         grobj%struct%abs_mat = PL_domain%n_xy
      end if
      if( ne > 0 ) then
         allocate( grobj%struct%tab_2d_1(ne,2) )
         grobj%struct%tab_2d_1 = PL_domain%edge_n
      end if
      if( nh > 0 ) then
         allocate( grobj%struct%ord_mat(nh,2) )
         grobj%struct%ord_mat = PL_domain%holes_xy
      end if
      grobj%struct%color = icol
      grobj%struct%linewidth = linewidth

      grobj%struct%bool1 = nod_num
      if( nod_num ) then
         ! Write the node number
         call decode_col_rgb( [0.0d0,0.0d0,0.6d0], icol_txt )
         grobj%struct%npt = icol_txt
      end if

      grobj%struct%bool2 = edg_num
      if( edg_num ) then
         ! Write the edge number
         call decode_col_rgb( [0.0d0,0.6d0,0.0d0], icol_txt )
         grobj%struct%npt2 = icol_txt
      end if

      if( nh > 0 ) then
         grobj%struct%bool3 = hol_num
         if( hol_num ) then
            ! Write the hole number
            call decode_col_rgb( [0.6d0,0.0d0,0.0d0], icol_txt )
            grobj%struct%npt3 = icol_txt
         end if
      end if

      if( win%mf_win_db_active ) then
         hdle = mf_win_get_free_handle(CURRENT_WIN_ID)
         win%handles(hdle)%ptr => grobj
         grobj%struct%hdle = hdle
         handle = encode_handle( CURRENT_WIN_ID, hdle )
      end if

!+++++++++++++++++++++++++++++++++++++++++++++++++++

      win%blank = .false.
      win%empty = .false.

!------------------ Drawing GrObj ------------------

      ! inquiring if the device has a cursor
      call pgqinf( "CURSOR", answer, itmp )
      if( to_lower(answer) == "yes" ) then
         device_has_cursor = .true.
         itmp = gr_set_cursor_shape( MF_WATCH_CURSOR )
      else
         device_has_cursor = .false.
      end if

      call pgbbuf()

      call mf_PlotPLdomain_draw( grobj )

      call pgebuf()

      if( device_has_cursor ) then
         itmp = gr_set_cursor_shape( MF_LEFT_ARROW_CURSOR )
      end if

!---------------------------------------------------

      if( .not. win%mf_win_db_active ) then
         call delete_grobj_inside( grobj )
         deallocate( grobj )
      end if

   end function PlotPLdomain_aux
