!_______________________________________________________________________
!
#ifdef _MF_FUNC
   function mfPlotPLdomain_color_str( PL_domain,                        &
                                      color, linewidth,                 &
                                      nod_num, edg_num, hol_num )       &
   result( handle )
#endif
#ifdef _MF_SUBR
   subroutine msPlotPLdomain_color_str( PL_domain,                      &
                                        color, linewidth,               &
                                        nod_num, edg_num, hol_num )
#endif

      type(mfPLdomain)                           :: PL_domain
      character(len=*),     intent(in)           :: color
      real(kind=MF_DOUBLE), intent(in), optional :: linewidth
      logical,              intent(in), optional :: nod_num, edg_num, hol_num

      integer :: handle
      !------ API end ------

      integer :: mf_message_level_save
      integer :: p_dim, index_min, index_max, nn, ne, nh
      real(kind=MF_DOUBLE), pointer :: xy_sto_pg(:,:)
      integer, pointer :: tri_sto_pg(:,:)
      integer :: icol, ier
      real(kind=MF_DOUBLE) :: linewidth_0
      logical :: nod_num_0, edg_num_0, hol_num_0

#ifdef _MF_FUNC
      character(len=*), parameter :: ROUTINE_NAME = "mfPlotPLdomain"
#endif
#ifdef _MF_SUBR
      character(len=*), parameter :: ROUTINE_NAME = "msPlotPLdomain"
#endif

   !------ end of declarations -- execution starts hereafter  ------

#ifdef _MF_FUNC
      handle = 0
#endif

      if( CURRENT_WIN_ID == 0 ) then
         call msFigure()
         if( CURRENT_WIN_ID == 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "cannot plot: no window created!" )
            go to 99
         end if
      end if

      if( .not. allocated(PL_domain%n_xy) ) then
         call PrintMessage( trim(ROUTINE_NAME), "W",                    &
                            "no nodes: empty or corrupted PLdomain!" )
         go to 99
      else
         nn = size(PL_domain%n_xy,1)
      end if

      if( .not. allocated(PL_domain%edge_n) ) then
         ne = -1
      else
         ne = size(PL_domain%edge_n,1)
      end if

      if( .not. allocated(PL_domain%holes_xy) ) then
         nh = -1
      else
         nh = size(PL_domain%holes_xy,1)
      end if

      ! default values
      if( BLACK_ON_WHITE == 1 ) then
         icol = 1
      else
         icol = 0
      end if

      if( len_trim(color) == 1 .or. color(1:1) == "\" ) then
         call decode_linespec( color, icol, ier=ier )
         if( ier /= 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                              "bad 'color' argument!",                  &
                              "(line color will be set to light grey)" )
            icol = -127
         end if
      else
         call decode_col_name( color, icol )
      end if

      if( icol == -127 ) then
         icol = MFPLOT_LIGHT_GREY
      end if

      if( present(linewidth) ) then
         linewidth_0 = linewidth
      else
         linewidth_0 = 1.0
      end if

      if( present(nod_num) ) then
         nod_num_0 = nod_num
      else
         nod_num_0 = .false.
      end if

      if( present(edg_num) ) then
         edg_num_0 = edg_num
      else
         edg_num_0 = .false.
      end if

      if( present(hol_num) ) then
         hol_num_0 = hol_num
      else
         hol_num_0 = .false.
      end if

      handle = PlotPLdomain_aux( PL_domain, nn, ne, nh, icol,           &
                                 linewidth_0,                           &
                                 nod_num_0, edg_num_0, hol_num_0 )

 99   continue

#ifdef _MF_FUNC
   end function mfPlotPLdomain_color_str
#endif
#ifdef _MF_SUBR
   end subroutine msPlotPLdomain_color_str
#endif
!_______________________________________________________________________
!
#ifdef _MF_FUNC
   function mfPlotPLdomain_color_rgb( PL_domain,                        &
                                      color, linewidth,                 &
                                      nod_num, edg_num, hol_num )       &
   result( handle )
#endif
#ifdef _MF_SUBR
   subroutine msPlotPLdomain_color_rgb( PL_domain,                      &
                                        color, linewidth,               &
                                        nod_num, edg_num, hol_num )
#endif

      type(mfPLdomain)                           :: PL_domain
      real(kind=MF_DOUBLE), intent(in), optional :: color(3)
      real(kind=MF_DOUBLE), intent(in), optional :: linewidth
      logical,              intent(in), optional :: nod_num, edg_num, hol_num

      integer :: handle
      !------ API end ------

      integer :: mf_message_level_save
      integer :: p_dim, index_min, index_max, nn, ne, nh
      real(kind=MF_DOUBLE), pointer :: xy_sto_pg(:,:)
      integer, pointer :: tri_sto_pg(:,:)
      integer :: icol
      real(kind=MF_DOUBLE) :: linewidth_0
      logical :: nod_num_0, edg_num_0, hol_num_0

#ifdef _MF_FUNC
      character(len=*), parameter :: ROUTINE_NAME = "mfPlotPLdomain"
#endif
#ifdef _MF_SUBR
      character(len=*), parameter :: ROUTINE_NAME = "msPlotPLdomain"
#endif

   !------ end of declarations -- execution starts hereafter  ------

#ifdef _MF_FUNC
      handle = 0
#endif

      if( CURRENT_WIN_ID == 0 ) then
         call msFigure()
         if( CURRENT_WIN_ID == 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "cannot plot: no window created!" )
            go to 99
         end if
      end if

      if( .not. allocated(PL_domain%n_xy) ) then
         call PrintMessage( trim(ROUTINE_NAME), "W",                    &
                            "no nodes: empty or corrupted PLdomain!" )
         go to 99
      else
         nn = size(PL_domain%n_xy,1)
      end if

      if( .not. allocated(PL_domain%edge_n) ) then
         ne = -1
      else
         ne = size(PL_domain%edge_n,1)
      end if

      if( .not. allocated(PL_domain%holes_xy) ) then
         nh = -1
      else
         nh = size(PL_domain%holes_xy,1)
      end if

      ! default values
      if( BLACK_ON_WHITE == 1 ) then
         icol = 1
      else
         icol = 0
      end if

      if( present(color) ) then
         call decode_col_rgb( color, icol )
      end if

      if( icol == -127 ) then
         icol = MFPLOT_LIGHT_GREY
      end if

      if( present(linewidth) ) then
         linewidth_0 = linewidth
      else
         linewidth_0 = 1.0
      end if

      if( present(nod_num) ) then
         nod_num_0 = nod_num
      else
         nod_num_0 = .false.
      end if

      if( present(edg_num) ) then
         edg_num_0 = edg_num
      else
         edg_num_0 = .false.
      end if

      if( present(hol_num) ) then
         hol_num_0 = hol_num
      else
         hol_num_0 = .false.
      end if

      handle = PlotPLdomain_aux( PL_domain, nn, ne, nh, icol,           &
                                 linewidth_0,                           &
                                 nod_num_0, edg_num_0, hol_num_0 )

 99   continue

#ifdef _MF_FUNC
   end function mfPlotPLdomain_color_rgb
#endif
#ifdef _MF_SUBR
   end subroutine msPlotPLdomain_color_rgb
#endif
