!_______________________________________________________________________
!
   subroutine mf_histogram_draw( grobj )

      type(grobj_elem) :: grobj ! Caution: intent(in out)
      !------ API end ------

      ! grobj type = "histogram"

      type(mf_win_info), pointer :: win

      integer :: linecolor, n_pg, axis_scale_x, i, n_bin, pgflag
      real(kind=MF_DOUBLE) :: x_min_s, x_max_s, baseline
      real(kind=MF_DOUBLE) :: binsiz, nummax
      real(kind=MF_DOUBLE), pointer :: num(:)
      real(kind=MF_DOUBLE), allocatable :: x_pg_tmp(:)

      real(kind=MF_DOUBLE) :: rbuf(1)
      integer :: ibuf(1)

   !------ end of declarations -- execution starts hereafter  ------

      pgflag = grobj%struct%npt2

      if( PRINTING_EPS ) then
         if( COMMENTS_IN_EPS ) then
            ibuf(1) = 0
            call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- begin of Histogram", 0 )
         end if
      end if
      if( PRINTING_PDF ) then
         if( COMMENTS_IN_PDF ) then
            call pdf_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- begin of Histogram", 0 )
         end if
         if( pgflag == 1 ) then
            gr_pdf_color_intent = 1 ! Stroke
         else ! pgflag == 3
            gr_pdf_color_intent = 2 ! Fill
         end if
      end if

      win => mf_win_db(CURRENT_WIN_ID)

      linecolor = grobj%struct%color
      call grsci(linecolor) ! set color index
      n_pg = grobj%struct%npt
      x_min_s = grobj%struct%abs_tab(1)
      x_max_s = grobj%struct%abs_tab(2)
      n_bin = grobj%struct%abs_tab(3)
      binsiz = grobj%struct%x_text
      axis_scale_x = grobj%struct%npt3

      if( win%axis_scale_x == axis_scale_x ) then
         ! The kind of scaling is the same as that used during the
         ! histogram computation: all is good.
         num => grobj%struct%tm1_tab
         if( win%axis_scale_x == 2 ) then
            x_min_s = log10( x_min_s )
            x_max_s = log10( x_max_s )
         end if
      else
         ! The kind of scaling has changed: the histogram must be recomputed...
         allocate( x_pg_tmp(n_pg) )
         if( win%axis_scale_x == 1 ) then
            ! lin
            x_pg_tmp(:) = grobj%struct%ord_tab(:)
         else if( win%axis_scale_x == 2 ) then
            ! log
            x_min_s = log10( x_min_s )
            x_max_s = log10( x_max_s )
            x_pg_tmp(:) = log10( grobj%struct%ord_tab(:) )
         else
            print *, "mf_histogram_draw: internal error."
            print *, "                   bad value for axis_scale(s)!"
            pause "only for debugging purpose"
            stop
         end if
         allocate( num(n_bin) )

         call pghist_ec_pre( n_pg, x_pg_tmp, x_min_s, x_max_s,          &
                             n_bin, nummax, binsiz, num )
         ! store 'num', replacing old values.
         deallocate( grobj%struct%tm1_tab )
         grobj%struct%tm1_tab => num
      end if

      if( win%axis_scale_y == 1 ) then
         baseline = 0.
         call pghist_ec( x_min_s, n_bin, pgflag, binsiz,                &
                         num, baseline )
      else
         baseline = log10(0.1)
         do i = 1, n_bin
            if( num(i) == 0. ) then
               ! avoid -INF, shift to baseline
               num(i) = 0.1
            end if
         end do
         call pghist_ec( x_min_s, n_bin, pgflag, binsiz,                &
                         log10(num), baseline )
      end if

      if( PRINTING_EPS ) then
         if( COMMENTS_IN_EPS ) then
            ibuf(1) = 0
            call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- end of Histogram", 0 )
         end if
      end if
      if( PRINTING_PDF ) then
         if( COMMENTS_IN_PDF ) then
            call pdf_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- end of Histogram", 0 )
         end if
      end if

   end subroutine mf_histogram_draw
