!_______________________________________________________________________
!
#ifdef _MF_FUNC
   function mfPlotHist_color_str( x, x_min, x_max, n_bin,               &
                                  color, filled, icol_mfplot )          &
   result( handle )
#endif
#ifdef _MF_SUBR
   subroutine msPlotHist_color_str( out, x, x_min, x_max, n_bin,        &
                                    color, filled, icol_mfplot )
      type(mf_Out) :: out
      type(mfArray), pointer :: out1, out2
#endif

      type(mfArray),        intent(in)           :: x
      real(kind=MF_DOUBLE), intent(in)           :: x_min, x_max
      integer,              intent(in)           :: n_bin
      character(len=*),     intent(in)           :: color
      logical,              intent(in), optional :: filled
      ! not documented argument, used only for call from msCumulHist
      integer,              intent(in), optional :: icol_mfplot ! predefined MFPLOT colors

      integer :: handle
      !------ API end ------

      ! pointers for manipulating mfArray out of fml module
      real(kind=MF_DOUBLE), pointer :: x_ptr(:,:)

      type(mf_win_info), pointer :: win
      type(grobj_elem), pointer :: grobj

      real(kind=MF_DOUBLE), pointer :: x_sto_pg(:)
      real(kind=MF_DOUBLE), allocatable :: x_pg_tmp(:)
      real(kind=MF_DOUBLE) :: x_min_s, x_max_s
      integer :: p_dim, n_dim, n_pg, ier
      integer :: i, status, hdle
      integer :: i_dummy
      real(kind=MF_DOUBLE) :: binsiz, nummax
      real(kind=MF_DOUBLE), pointer :: num(:)
      real(kind=MF_DOUBLE) :: x_min_s_tmp, x_max_s_tmp

      logical :: filled_0, color_undefined
      integer :: pgflag
      integer :: icol

      real(kind=MF_DOUBLE) :: range(4)
      integer :: mf_message_level_save
      integer :: axis_manual_save_x, axis_manual_save_y

      integer :: itmp
      character(len=3) :: answer
      logical :: device_has_cursor

#ifdef _MF_FUNC
      character(len=*), parameter :: ROUTINE_NAME = "mfPlotHist"
#endif
#ifdef _MF_SUBR
      character(len=*), parameter :: ROUTINE_NAME = "msPlotHist"
#endif

   !------ end of declarations -- execution starts hereafter  ------

#ifdef _MF_FUNC
      handle = 0
#endif

      if( CURRENT_WIN_ID == 0 ) then
         call msFigure()
         if( CURRENT_WIN_ID == 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "cannot plot: no window created!" )
            go to 99
         end if
      end if

      win => mf_win_db(CURRENT_WIN_ID)

      if( win%axis_scale_x == 0 .and. win%axis_scale_y == 0 ) then
         win%axis_scale_x = 1
         win%axis_scale_y = 1
      end if

      call msInitArgs( x )

      ! checking that 'x' is allocated
      if( mfIsEqual(x,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' not allocated!" )
         go to 99
      end if

      ! 'x' must be Real
      if( .not. mfIsReal(x) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' must be real!" )
         go to 99
      end if

      ! 'x' cannot be sparse
      if( mfIsSparse(x) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' cannot be sparse!" )
         go to 99
      end if

      call msPointer( x, x_ptr, no_crc=.true. )

      if( size(x_ptr,1)==0 .or. size(x_ptr,2)==0 ) then
         call PrintMessage( trim(ROUTINE_NAME), "W",                    &
                            "nothing to plot" )
         go to 99
      end if

      ! checking that 'x' is a 1-D array
      if( size(x_ptr,1)/=1 .and. size(x_ptr,2)/=1 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "cannot yet build an histogram for a matrix",&
                            "(see also the routine 'msCumulHist' which accepts matrices)" )
         go to 99
      else
         if( size(x_ptr,1) == 1 ) then
            p_dim = 2
         else
            p_dim = 1
         end if
         n_dim = size(x_ptr,p_dim)
         n_pg = n_dim
         allocate( x_sto_pg(n_pg) )

      end if

      ! some tests
      if( n_pg<1 .or. x_max<=x_min .or. n_bin<1 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "invalid arguments!" )
         go to 99
      end if

      if( CURRENT_WIN_ID == 0 ) then
         call msFigure()
         if( CURRENT_WIN_ID == 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "cannot plot : no window created!" )
            go to 99
         end if
      end if

      if( all( win%current_axes(:) == 0.0d0 ) ) then
         ! set the whole graphic env, keeping the 'manual' status
         axis_manual_save_x = win%axis_manual_x
         axis_manual_save_y = win%axis_manual_y
         call msAxis( [ 0.0d0, 1.0d0, 0.0d0, 1.0d0 ] )
         win%axis_manual_x = axis_manual_save_x
         win%axis_manual_y = axis_manual_save_y
      end if

      ! plotting something is always clipped at viewport
      if( X11_DEVICE ) then
         ! caution: axes must have been defined before
         call X11_clip_on_viewport()
      end if

      if( p_dim == 1 ) then
         call copy_data_for_plotting( x_ptr(:,1), win%axis_scale_x, x_sto_pg(:), status )
         if( status /= 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "some values for 'x' are inappropriate for MFPLOT;", &
                               "they will be ignored!" )
         end if
      else
         call copy_data_for_plotting( x_ptr(1,:), win%axis_scale_x, x_sto_pg(:), status )
         if( status /= 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "some values for 'x' are inappropriate for MFPLOT;", &
                               "they will be ignored!" )
         end if
      end if

      call msFreePointer( x, x_ptr )

      ! prepare histogram
      x_min_s = x_min
      x_max_s = x_max

      allocate( x_pg_tmp(n_pg) )

      if( win%axis_scale_x == 1 ) then
         ! lin
         x_min_s_tmp = x_min_s
         x_max_s_tmp = x_max_s
         x_pg_tmp(:) = x_sto_pg(:)
      else
         ! log
         x_min_s_tmp = log10( x_min_s )
         x_max_s_tmp = log10( x_max_s )
         x_pg_tmp(:) = log10( x_sto_pg(:) )
      end if

      allocate( num(n_bin) )

      call pghist_ec_pre( n_pg, x_pg_tmp, x_min_s_tmp, x_max_s_tmp,     &
                          n_bin, nummax, binsiz, num )

#ifdef _MF_SUBR
      ! il faut deux arguments de sortie au plus
      if( out%n < 0 .or. out%n > 2 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "two output args max required!" )
         go to 99
      end if

      ! check args of mfOut
      if( .not. args_mfout_ok( out, x ) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "output arguments cannot be tempo, or cannot share",&
                            "same memory as another input argument." )
         go to 99
      end if

      if( out%n >= 1 ) then
         out1 => out%ptr1

         out1 = num
      end if

      if( out%n == 2 ) then
         out2 => out%ptr2

         if( win%axis_scale_x == 1 ) then
            ! lin
            out2 = mfLinSpace( dble(x_min_s_tmp), dble(x_max_s_tmp),    &
                               n_bin+1 )
         else
            ! log
            out2 = mfLogSpace( dble(x_min_s_tmp), dble(x_max_s_tmp),    &
                               n_bin+1 )
         end if
      end if
#endif

      ! les [nouveaux] axes doivent être prêts
      range(1) = x_min_s
      range(2) = x_max_s
      range(3) = 0.1d0
      range(4) = nummax
      call mf_prepare_axes( CURRENT_WIN_ID, range )

      if( present(filled) ) then
         filled_0 = filled
      else
         filled_0 = .false.
      end if

      if( len_trim(color) == 1 .or. color(1:1) == "\" ) then
         call decode_linespec( color, icol, ier=ier )
         if( ier /= 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                              "bad 'color' argument!",                  &
                              "(line color will be set to foreground color)" )
            icol = 1
         end if
      else
         call decode_col_name( color, icol )
      end if

      if( filled_0 ) then
         pgflag = 3
      else
         pgflag = 1
      end if

      handle = 0

!++++++++++++++++++ Storage in DB ++++++++++++++++++

      ! new grobj
      if( win%mf_win_db_active ) then
         ! create a new grobj and insert it in the linked list
         call create_grobj( win, grobj )
      else
         ! just allocate the grobj
         allocate( grobj )
      end if

      grobj%struct%cmd = "histogram"
      grobj%struct%range = range
      grobj%struct%color = icol
      grobj%struct%npt2 = pgflag
      ! Original raw data is stored because we must recomputed the histogram
      ! in the case where scale is changed (lin->log, for ex.)
      grobj%struct%npt = n_pg

      ! Computed histogram is also stored to avoid a second computation
      ! before the drawing.
      grobj%struct%tm1_tab => num
      grobj%struct%x_text = binsiz
      grobj%struct%npt3 = win%axis_scale_x ! kind of scaling used during
                                           ! the histogram computation

      allocate( grobj%struct%abs_tab(3) )
      grobj%struct%abs_tab(1) = x_min_s
      grobj%struct%abs_tab(2) = x_max_s
      grobj%struct%abs_tab(3) = n_bin

      grobj%struct%ord_tab => x_sto_pg

      if( win%mf_win_db_active ) then
         hdle = mf_win_get_free_handle(CURRENT_WIN_ID)
         win%handles(hdle)%ptr => grobj
         grobj%struct%hdle = hdle
         handle = encode_handle( CURRENT_WIN_ID, hdle )
      end if

!+++++++++++++++++++++++++++++++++++++++++++++++++++

      win%blank = .false.
      win%empty = .false.

!------------------ Drawing GrObj ------------------

      ! inquiring if the device has a cursor
      call pgqinf( "CURSOR", answer, itmp )
      if( to_lower(answer) == "yes" ) then
         device_has_cursor = .true.
         itmp = gr_set_cursor_shape( MF_WATCH_CURSOR )
      else
         device_has_cursor = .false.
      end if

      call mf_histogram_draw( grobj )

      call pgebuf()

      if( device_has_cursor ) then
         itmp = gr_set_cursor_shape( MF_LEFT_ARROW_CURSOR )
      end if

!---------------------------------------------------

      if( .not. win%mf_win_db_active ) then
         call delete_grobj_inside( grobj )
         deallocate( grobj )
      end if

 99   continue

      call msFreeArgs( x )
      call msAutoRelease( x )

#ifdef _MF_FUNC
   end function mfPlotHist_color_str
#endif
#ifdef _MF_SUBR
   end subroutine msPlotHist_color_str
#endif
!_______________________________________________________________________
!
#ifdef _MF_FUNC
   function mfPlotHist_color_rgb( x, x_min, x_max, n_bin,               &
                                  color, filled, icol_mfplot )          &
   result( handle )
#endif
#ifdef _MF_SUBR
   subroutine msPlotHist_color_rgb( out, x, x_min, x_max, n_bin,        &
                                    color, filled, icol_mfplot )
      type(mf_Out) :: out
      type(mfArray), pointer :: out1, out2
#endif

      type(mfArray),        intent(in)           :: x
      real(kind=MF_DOUBLE), intent(in)           :: x_min, x_max
      integer,              intent(in)           :: n_bin
      real(kind=MF_DOUBLE), intent(in), optional :: color(3)
      logical,              intent(in), optional :: filled
      ! not documented argument, used only for call from msCumulHist
      integer,              intent(in), optional :: icol_mfplot ! predefined MFPLOT colors

      integer :: handle
      !------ API end ------

      ! pointers for manipulating mfArray out of fml module
      real(kind=MF_DOUBLE), pointer :: x_ptr(:,:)

      type(mf_win_info), pointer :: win
      type(grobj_elem), pointer :: grobj

      real(kind=MF_DOUBLE), pointer :: x_sto_pg(:)
      real(kind=MF_DOUBLE), allocatable :: x_pg_tmp(:)
      real(kind=MF_DOUBLE) :: x_min_s, x_max_s
      integer :: p_dim, n_dim, n_pg
      integer :: i, status, hdle
      integer :: i_dummy
      real(kind=MF_DOUBLE) :: binsiz, nummax
      real(kind=MF_DOUBLE), pointer :: num(:)
      real(kind=MF_DOUBLE) :: x_min_s_tmp, x_max_s_tmp

      logical :: filled_0, color_undefined
      integer :: pgflag
      integer :: icol

      real(kind=MF_DOUBLE) :: range(4)
      integer :: mf_message_level_save
      integer :: axis_manual_save_x, axis_manual_save_y

      integer :: itmp
      character(len=3) :: answer
      logical :: device_has_cursor

#ifdef _MF_FUNC
      character(len=*), parameter :: ROUTINE_NAME = "mfPlotHist"
#endif
#ifdef _MF_SUBR
      character(len=*), parameter :: ROUTINE_NAME = "msPlotHist"
#endif

   !------ end of declarations -- execution starts hereafter  ------

#ifdef _MF_FUNC
      handle = 0
#endif

      if( CURRENT_WIN_ID == 0 ) then
         call msFigure()
         if( CURRENT_WIN_ID == 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "cannot plot: no window created!" )
            go to 99
         end if
      end if

      win => mf_win_db(CURRENT_WIN_ID)

      if( win%axis_scale_x == 0 .and. win%axis_scale_y == 0 ) then
         win%axis_scale_x = 1
         win%axis_scale_y = 1
      end if

      call msInitArgs( x )

      ! checking that 'x' is allocated
      if( mfIsEqual(x,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' not allocated!" )
         go to 99
      end if

      ! 'x' must be Real
      if( .not. mfIsReal(x) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' must be real!" )
         go to 99
      end if

      ! 'x' cannot be sparse
      if( mfIsSparse(x) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' cannot be sparse!" )
         go to 99
      end if

      call msPointer( x, x_ptr, no_crc=.true. )

      if( size(x_ptr,1)==0 .or. size(x_ptr,2)==0 ) then
         call PrintMessage( trim(ROUTINE_NAME), "W",                    &
                            "nothing to plot" )
         go to 99
      end if

      ! checking that 'x' is a 1-D array
      if( size(x_ptr,1)/=1 .and. size(x_ptr,2)/=1 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "cannot yet build an histogram for a matrix",&
                            "(see also the routine 'msCumulHist' which accepts matrices)" )
         go to 99
      else
         if( size(x_ptr,1) == 1 ) then
            p_dim = 2
         else
            p_dim = 1
         end if
         n_dim = size(x_ptr,p_dim)
         n_pg = n_dim
         allocate( x_sto_pg(n_pg) )

      end if

      ! some tests
      if( n_pg<1 .or. x_max<=x_min .or. n_bin<1 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "invalid arguments!" )
         go to 99
      end if

      if( CURRENT_WIN_ID == 0 ) then
         call msFigure()
         if( CURRENT_WIN_ID == 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "cannot plot : no window created!" )
            go to 99
         end if
      end if

      if( all( win%current_axes(:) == 0.0d0 ) ) then
         ! set the whole graphic env, keeping the 'manual' status
         axis_manual_save_x = win%axis_manual_x
         axis_manual_save_y = win%axis_manual_y
         call msAxis( [ 0.0d0, 1.0d0, 0.0d0, 1.0d0 ] )
         win%axis_manual_x = axis_manual_save_x
         win%axis_manual_y = axis_manual_save_y
      end if

      ! plotting something is always clipped at viewport
      if( X11_DEVICE ) then
         ! caution: axes must have been defined before
         call X11_clip_on_viewport()
      end if

      if( p_dim == 1 ) then
         call copy_data_for_plotting( x_ptr(:,1), win%axis_scale_x, x_sto_pg(:), status )
         if( status /= 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "some values for 'x' are inappropriate for MFPLOT;", &
                               "they will be ignored!" )
         end if
      else
         call copy_data_for_plotting( x_ptr(1,:), win%axis_scale_x, x_sto_pg(:), status )
         if( status /= 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "some values for 'x' are inappropriate for MFPLOT;", &
                               "they will be ignored!" )
         end if
      end if

      call msFreePointer( x, x_ptr )

      ! prepare histogram
      x_min_s = x_min
      x_max_s = x_max

      allocate( x_pg_tmp(n_pg) )

      if( win%axis_scale_x == 1 ) then
         ! lin
         x_min_s_tmp = x_min_s
         x_max_s_tmp = x_max_s
         x_pg_tmp(:) = x_sto_pg(:)
      else
         ! log
         x_min_s_tmp = log10( x_min_s )
         x_max_s_tmp = log10( x_max_s )
         x_pg_tmp(:) = log10( x_sto_pg(:) )
      end if

      allocate( num(n_bin) )

      call pghist_ec_pre( n_pg, x_pg_tmp, x_min_s_tmp, x_max_s_tmp, n_bin, &
                          nummax, binsiz, num )

#ifdef _MF_SUBR
      ! il faut deux arguments de sortie au plus
      if( out%n < 0 .or. out%n > 2 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "two output args max required!" )
         go to 99
      end if

      ! check args of mfOut
      if( .not. args_mfout_ok( out, x ) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "output arguments cannot be tempo, or cannot share",&
                            "same memory as another input argument." )
         go to 99
      end if

      if( out%n >= 1 ) then
         out1 => out%ptr1

         out1 = num
      end if

      if( out%n == 2 ) then
         out2 => out%ptr2

         if( win%axis_scale_x == 1 ) then
            ! lin
            out2 = mfLinSpace( dble(x_min_s_tmp), dble(x_max_s_tmp),    &
                               n_bin+1 )
         else
            ! log
            out2 = mfLogSpace( dble(x_min_s_tmp), dble(x_max_s_tmp),    &
                               n_bin+1 )
         end if
      end if
#endif

      ! les [nouveaux] axes doivent être prêts
      range(1) = x_min_s
      range(2) = x_max_s
      range(3) = 0.1d0
      range(4) = nummax
      call mf_prepare_axes( CURRENT_WIN_ID, range )

      if( present(filled) ) then
         filled_0 = filled
      else
         filled_0 = .false.
      end if

      color_undefined = .true.
      if( present(color) ) then
         call decode_col_rgb( color, icol )
         color_undefined = .false.
      end if
      if( present(icol_mfplot) ) then
         icol = icol_mfplot
         color_undefined = .false.
      end if
      if( color_undefined ) then
         select case( win%color_scheme )
            case( 1 )
               icol = COL_CYCLE_TAB_1(win%ind_next_color)
               if( win%ind_next_color == 6 ) then
                  win%ind_next_color = 1
               else
                  win%ind_next_color = win%ind_next_color + 1
               end if
            case( 2 )
               icol = COL_CYCLE_TAB_2(win%ind_next_color)
               if( win%ind_next_color == 7 ) then
                  win%ind_next_color = 1
               else
                  win%ind_next_color = win%ind_next_color + 1
               end if
            case( 3 )
               icol = COL_CYCLE_TAB_3(win%ind_next_color)
               if( win%ind_next_color == 7 ) then
                  win%ind_next_color = 1
               else
                  win%ind_next_color = win%ind_next_color + 1
               end if
            case( 4 )
               icol = COL_CYCLE_TAB_4(win%ind_next_color)
               if( win%ind_next_color == 12 ) then
                  win%ind_next_color = 1
               else
                  win%ind_next_color = win%ind_next_color + 1
               end if
            case default
               write(STDERR,*) "(FGL PlotHist:) Internal error."
               write(STDERR,*) "     Bad value for color_scheme."
               pause "only for debugging purpose"
               stop
         end select
      end if

      if( filled_0 ) then
         pgflag = 3
      else
         pgflag = 1
      end if

      handle = 0

!++++++++++++++++++ Storage in DB ++++++++++++++++++

      ! new grobj
      if( win%mf_win_db_active ) then
         ! create a new grobj and insert it in the linked list
         call create_grobj( win, grobj )
      else
         ! just allocate the grobj
         allocate( grobj )
      end if

      grobj%struct%cmd = "histogram"
      grobj%struct%range = range
      grobj%struct%color = icol
      grobj%struct%npt2 = pgflag
      ! Original raw data is stored because we must recomputed the histogram
      ! in the case where scale is changed (lin->log, for ex.)
      grobj%struct%npt = n_pg

      ! Computed histogram is also stored to avoid a second computation
      ! before the drawing.
      grobj%struct%tm1_tab => num
      grobj%struct%x_text = binsiz
      grobj%struct%npt3 = win%axis_scale_x ! kind of scaling used during
                                           ! the histogram computation

      allocate( grobj%struct%abs_tab(3) )
      grobj%struct%abs_tab(1) = x_min_s
      grobj%struct%abs_tab(2) = x_max_s
      grobj%struct%abs_tab(3) = n_bin

      grobj%struct%ord_tab => x_sto_pg

      if( win%mf_win_db_active ) then
         hdle = mf_win_get_free_handle(CURRENT_WIN_ID)
         win%handles(hdle)%ptr => grobj
         grobj%struct%hdle = hdle
         handle = encode_handle( CURRENT_WIN_ID, hdle )
      end if

!+++++++++++++++++++++++++++++++++++++++++++++++++++

      win%blank = .false.
      win%empty = .false.

!------------------ Drawing GrObj ------------------

      ! inquiring if the device has a cursor
      call pgqinf( "CURSOR", answer, itmp )
      if( to_lower(answer) == "yes" ) then
         device_has_cursor = .true.
         itmp = gr_set_cursor_shape( MF_WATCH_CURSOR )
      else
         device_has_cursor = .false.
      end if

      call mf_histogram_draw( grobj )

      call pgebuf()

      if( device_has_cursor ) then
         itmp = gr_set_cursor_shape( MF_LEFT_ARROW_CURSOR )
      end if

!---------------------------------------------------

      if( .not. win%mf_win_db_active ) then
         call delete_grobj_inside( grobj )
         deallocate( grobj )
      end if

 99   continue

      call msFreeArgs( x )
      call msAutoRelease( x )

#ifdef _MF_FUNC
   end function mfPlotHist_color_rgb
#endif
#ifdef _MF_SUBR
   end subroutine msPlotHist_color_rgb
#endif
