!_______________________________________________________________________
!
   function PlotCubicSplineCore( abs_curv_pg,                           &
                                 x_pg, y_pg, wx_pg, wy_pg,              &
                                 linecolor, linestyle, linewidth )      &
   result( handle )

      real(kind=MF_DOUBLE), intent(in) :: abs_curv_pg(:),               &
                                          x_pg(:), y_pg(:), wx_pg(:), wy_pg(:)
      integer                          :: linecolor
      integer,              intent(in) :: linestyle
      real(kind=MF_DOUBLE), intent(in) :: linewidth
      integer :: handle
      !------ API end ------

      integer :: nctrl
      ! on rajoute le suffixe "_sto_pg" pour faire un mem_debug
      ! avec l'utilitaire 'replace_alloc_dealloc'.
      real(kind=MF_DOUBLE), pointer :: xctrl_sto_pg(:), yctrl_sto_pg(:)


      type(mf_win_info), pointer :: win
      type(grobj_elem), pointer :: grobj

      integer :: i, n_pg, hdle
      real(kind=MF_DOUBLE) :: range(4)

      integer :: itmp
      character(len=3) :: answer
      logical :: device_has_cursor

      character(len=*), parameter :: ROUTINE_NAME = "mfPlotCubicSpline"

   !------ end of declarations -- execution starts hereafter  ------

      call pgbbuf()

      win => mf_win_db(CURRENT_WIN_ID)

      if( win%axis_scale_x == 0 .or. win%axis_scale_y == 0 ) then
         ! it seems that axis_scale has not yet been initialised
         win%axis_scale_x = 1
         win%axis_scale_y = 1
      else if( win%axis_scale_x == 2 .or. win%axis_scale_y == 2 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "cannot use log axis for Cubic Spline curves!" )
         handle = 0
         return
      end if

      n_pg = size(abs_curv_pg)
      nctrl = 3*(n_pg-1) + 1
      allocate( xctrl_sto_pg(nctrl) )

      allocate( yctrl_sto_pg(nctrl) )

      call pg_spline_to_bezier( n_pg, abs_curv_pg,                      &
                                x_pg, y_pg, wx_pg, wy_pg,               &
                                nctrl, xctrl_sto_pg, yctrl_sto_pg )

      ! A Spline curve is not always localized inside the convex polygon
      ! of its nodes. However, as we can get the Bézier control points,
      ! we can easily define a correct BBOX.
      range(1) = minval( xctrl_sto_pg )
      range(2) = maxval( xctrl_sto_pg )
      range(3) = minval( yctrl_sto_pg )
      range(4) = maxval( yctrl_sto_pg )
      call mf_prepare_axes( CURRENT_WIN_ID, range )

      if( linecolor == -127 ) then
         select case( win%color_scheme )
            case( 1 )
               linecolor = COL_CYCLE_TAB_1(win%ind_next_color)
               if( win%ind_next_color == 6 ) then
                  win%ind_next_color = 1
               else
                  win%ind_next_color = win%ind_next_color + 1
               end if
            case( 2 )
               linecolor = COL_CYCLE_TAB_2(win%ind_next_color)
               if( win%ind_next_color == 7 ) then
                  win%ind_next_color = 1
               else
                  win%ind_next_color = win%ind_next_color + 1
               end if
            case( 3 )
               linecolor = COL_CYCLE_TAB_3(win%ind_next_color)
               if( win%ind_next_color == 7 ) then
                  win%ind_next_color = 1
               else
                  win%ind_next_color = win%ind_next_color + 1
               end if
            case( 4 )
               linecolor = COL_CYCLE_TAB_4(win%ind_next_color)
               if( win%ind_next_color == 12 ) then
                  win%ind_next_color = 1
               else
                  win%ind_next_color = win%ind_next_color + 1
               end if
            case default
               write(STDERR,*) "(FGL PlotCubicSplineCore:) Internal error."
               write(STDERR,*) "     Bad value for color_scheme."
               pause "only for debugging purpose"
               stop
         end select
      end if

      ! plotting something is always clipped at viewport
      if( X11_DEVICE ) then
         ! caution: axes must have been defined before
         call X11_clip_on_viewport()
      end if

!++++++++++++++++++ Storage in DB ++++++++++++++++++

      ! new grobj
      if( win%mf_win_db_active ) then
         ! create a new grobj and insert it in the linked list
         call create_grobj( win, grobj )
      else
         ! just allocate the grobj
         allocate( grobj )
      end if

      grobj%struct%color = linecolor
      grobj%struct%linestyle = linestyle
      grobj%struct%linewidth = linewidth
      grobj%struct%cmd = "cubic_bezier"
      grobj%struct%npt = nctrl
      grobj%struct%abs_tab => xctrl_sto_pg
      grobj%struct%ord_tab => yctrl_sto_pg

      if( win%mf_win_db_active ) then
         hdle = mf_win_get_free_handle(CURRENT_WIN_ID)
         win%handles(hdle)%ptr => grobj
         grobj%struct%hdle = hdle
         handle = encode_handle( CURRENT_WIN_ID, hdle )
      end if

!+++++++++++++++++++++++++++++++++++++++++++++++++++
      win%blank = .false.
      win%empty = .false.

!------------------ Drawing GrObj ------------------

      ! inquiring if the device has a cursor
      call pgqinf( "CURSOR", answer, itmp )
      if( to_lower(answer) == "yes" ) then
         device_has_cursor = .true.
         itmp = gr_set_cursor_shape( MF_WATCH_CURSOR )
      else
         device_has_cursor = .false.
      end if

      call mf_cubic_bezier_draw( grobj )

      call pgebuf()

      if( device_has_cursor ) then
         itmp = gr_set_cursor_shape( MF_LEFT_ARROW_CURSOR )
      end if

!---------------------------------------------------

      if( .not. win%mf_win_db_active ) then
         call delete_grobj_inside( grobj )
         deallocate( grobj )
      end if

   end function PlotCubicSplineCore
