!_______________________________________________________________________
!
#ifdef _MF_FUNC
   function mfPlotCubicSpline_color_str( abs_curv, x, y, wx, wy,        &
                                         linespec, color, linewidth,    &
                                         dashes_inverted )              &
   result( handle )
#endif
#ifdef _MF_SUBR
   subroutine msPlotCubicSpline_color_str( abs_curv, x, y, wx, wy,      &
                                           linespec, color, linewidth,  &
                                           dashes_inverted )
#endif

      type(mfArray)                              :: abs_curv, x, y, wx, wy
      character(len=*),     intent(in), optional :: linespec
      character(len=*),     intent(in)           :: color
      real(kind=MF_DOUBLE), intent(in), optional :: linewidth
      logical,              intent(in), optional :: dashes_inverted
      integer :: handle
      !------ API end ------

      type(mf_win_info), pointer :: win
      real(kind=MF_DOUBLE) :: linewidth_d
      integer :: linecolor, linestyle, marker, ier

      ! pointers for manipulating mfArray out of fml module
      real(kind=MF_DOUBLE), pointer :: abs_curv_ptr(:,:),               &
                                       x_ptr(:,:), y_ptr(:,:),          &
                                       wx_ptr(:,:), wy_ptr(:,:)

      real(kind=MF_DOUBLE), allocatable :: abs_curv_pg(:),              &
                                           x_pg(:), y_pg(:),            &
                                           wx_pg(:), wy_pg(:)
      integer :: p_dim, n_pg
      integer :: status
      integer :: status_alloc_abs_curv,                                 &
                 status_alloc_x, status_alloc_y,                        &
                 status_alloc_wx, status_alloc_wy

#ifdef _MF_FUNC
      character(len=*), parameter :: ROUTINE_NAME = "mfPlotCubicSpline"
#endif
#ifdef _MF_SUBR
      character(len=*), parameter :: ROUTINE_NAME = "msPlotCubicSpline"
#endif

   !------ end of declarations -- execution starts hereafter  ------

#ifdef _MF_FUNC
      handle = 0
#endif

      if( CURRENT_WIN_ID == 0 ) then
         call msFigure()
         if( CURRENT_WIN_ID == 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "cannot plot : no window created!" )
            return
         end if
      end if

      win => mf_win_db(CURRENT_WIN_ID)

      if( win%axis_scale_x == 0 .and. win%axis_scale_y == 0 ) then
         win%axis_scale_x = 1
         win%axis_scale_y = 1
      end if

      call msInitArgs( abs_curv, x, y, wx, wy )

      ! checking that 'abs_curv' is allocated
      if( mfIsEqual(abs_curv,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'abs_curv' not allocated!" )
         go to 99
      end if

      ! 'abs_curv' must be Real
      if( .not. mfIsReal(abs_curv) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'abs_curv' must be real!" )
         go to 99
      end if

      ! 'abs_curv' cannot be sparse
      if( mfIsSparse(abs_curv) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'abs_curv' cannot be sparse!" )
         go to 99
      end if

      ! checking that 'x' is allocated
      if( mfIsEqual(x,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' not allocated!" )
         go to 99
      end if

      ! 'x' must be Real
      if( .not. mfIsReal(x) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' must be real!" )
         go to 99
      end if

      ! 'x' cannot be sparse
      if( mfIsSparse(x) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' cannot be sparse!" )
         go to 99
      end if

      ! checking that 'y' is allocated
      if( mfIsEqual(y,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' not allocated!" )
         go to 99
      end if

      ! 'y' must be Real
      if( .not. mfIsReal(y) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' must be real!" )
         go to 99
      end if

      ! 'y' cannot be sparse
      if( mfIsSparse(y) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' cannot be sparse!" )
         go to 99
      end if

      ! checking that 'wx' is allocated
      if( mfIsEqual(wx,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'wx' not allocated!" )
         go to 99
      end if

      ! 'wx' must be Real
      if( .not. mfIsReal(wx) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'wx' must be real!" )
         go to 99
      end if

      ! 'wx' cannot be sparse
      if( mfIsSparse(wx) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'wx' cannot be sparse!" )
         go to 99
      end if

      ! checking that 'wy' is allocated
      if( mfIsEqual(wy,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'wy' not allocated!" )
         go to 99
      end if

      ! 'wy' must be Real
      if( .not. mfIsReal(wy) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'wy' must be real!" )
         go to 99
      end if

      ! 'wy' cannot be sparse
      if( mfIsSparse(wy) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'wy' cannot be sparse!" )
         go to 99
      end if

      ! checking for 'abs_curv'
      call msPointer_real_only( abs_curv, abs_curv_ptr, status_alloc_abs_curv )
      if( .not. associated( abs_curv_ptr ) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'abs_curv' not initialized!" )
         go to 99
      end if
      if( size(abs_curv_ptr,1)==0 .or. size(abs_curv_ptr,2)==0 ) then
         call PrintMessage( trim(ROUTINE_NAME), "W",                    &
                            "nothing to plot" )
         go to 99
      end if
      ! checking that 'abs_curv' is a 1-D array
      if( size(abs_curv_ptr,1)/=1 .and. size(abs_curv_ptr,2)/=1 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "cannot yet plot a matrix" )
         go to 99
      else
         if( size(abs_curv_ptr,1) == 1 ) then
            p_dim = 2
         else
            p_dim = 1
         end if
         n_pg = size(abs_curv_ptr,p_dim)
      end if

      call msPointer_real_only( x, x_ptr, status_alloc_x )

      ! checking that 'x' have the same size than 'abs_curv'
      if( size(x_ptr,1) /= size(abs_curv_ptr,1) .or.                    &
          size(x_ptr,2) /= size(abs_curv_ptr,2)      ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' and 'abs_curv' array must have the same size" )
         go to 99
      end if

      call msPointer_real_only( y, y_ptr, status_alloc_y )

      ! checking that 'y' have the same size than 'abs_curv'
      if( size(y_ptr,1) /= size(abs_curv_ptr,1) .or.                    &
          size(y_ptr,2) /= size(abs_curv_ptr,2)      ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' and 'abs_curv' array must have the same size" )
         go to 99
      end if

      call msPointer_real_only( wx, wx_ptr, status_alloc_wx )

      ! checking that 'wx' have the same size than 'abs_curv'
      if( size(wx_ptr,1) /= size(abs_curv_ptr,1) .or.                           &
          size(wx_ptr,2) /= size(abs_curv_ptr,2)      ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'wx' and 'abs_curv' array must have the same size" )
         go to 99
      end if

      call msPointer_real_only( wy, wy_ptr, status_alloc_wy )

      ! checking that 'wy' have the same size than 'abs_curv'
      if( size(wy_ptr,1) /= size(abs_curv_ptr,1) .or.                           &
          size(wy_ptr,2) /= size(abs_curv_ptr,2)      ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'wy' and 'abs_curv' array must have the same size" )
         go to 99
      end if

      allocate( abs_curv_pg(n_pg) )

      allocate( x_pg(n_pg) )

      allocate( y_pg(n_pg) )

      allocate( wx_pg(n_pg) )

      allocate( wy_pg(n_pg) )

      if( p_dim == 1 ) then

         call copy_data_for_plotting( abs_curv_ptr(:,1), 1, abs_curv_pg(:), status )
         if( status /= 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "some values for 'abs_curv' are inappropriate for MFPLOT;", &
                               "they will be ignored!" )
         end if

         call copy_data_for_plotting( x_ptr(:,1), win%axis_scale_x, x_pg(:), status )
         if( status /= 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "some values for 'x' are inappropriate for MFPLOT;", &
                               "they will be ignored!" )
         end if

         call copy_data_for_plotting( y_ptr(:,1), win%axis_scale_y, y_pg(:), status )
         if( status /= 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "some values for 'y' are inappropriate for MFPLOT;", &
                               "they will be ignored!" )
         end if

         call copy_data_for_plotting( wx_ptr(:,1), 1, wx_pg(:), status )
         if( status /= 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "some values for 'wx' are inappropriate for MFPLOT;", &
                               "they will be ignored!" )
         end if

         call copy_data_for_plotting( wy_ptr(:,1), 1, wy_pg(:), status )
         if( status /= 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "some values for 'wy' are inappropriate for MFPLOT;", &
                               "they will be ignored!" )
         end if

      else

         call copy_data_for_plotting( abs_curv_ptr(1,:), 1, abs_curv_pg(:), status )
         if( status /= 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "some values for 'abs_curv' are inappropriate for MFPLOT;", &
                               "they will be ignored!" )
         end if

         call copy_data_for_plotting( x_ptr(1,:), win%axis_scale_x, x_pg(:), status )
         if( status /= 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "some values for 'x' are inappropriate for MFPLOT;", &
                               "they will be ignored!" )
         end if

         call copy_data_for_plotting( y_ptr(1,:), win%axis_scale_y, y_pg(:), status )
         if( status /= 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "some values for 'y' are inappropriate for MFPLOT;", &
                               "they will be ignored!" )
         end if

         call copy_data_for_plotting( wx_ptr(1,:), 1, wx_pg(:), status )
         if( status /= 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "some values for 'wx' are inappropriate for MFPLOT;", &
                               "they will be ignored!" )
         end if

         call copy_data_for_plotting( wy_ptr(1,:), 1, wy_pg(:), status )
         if( status /= 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "some values for 'wy' are inappropriate for MFPLOT;", &
                               "they will be ignored!" )
         end if

      end if

      if( present(linespec) ) then
         call decode_linespec( linespec, linecolor, linestyle, marker )
         ! only linestyle must have a valid value
         if( linestyle == -127 .and. marker == -127 ) then
            linestyle = 1
         end if
         if( marker /= -127 ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "marker selection is discarded in this routine.",                              &
                               "(hint: add a msPlot call with the Hold property)" )
         end if
      else
         linecolor = -127 ! means: not found
         linestyle = 1
         marker    = -127 ! means: not found
      end if

      if( present(dashes_inverted) ) then
         if( linestyle == 2 ) then
            if( dashes_inverted ) then
               linestyle = 5 ! inverted dashed line
            end if
         else
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "argument 'dashes_inverted' may be used only for a dashed curve.", &
                               "it will be ignored!" )
         end if
      end if

      if( len_trim(color) == 1 .or. color(1:1) == "\" ) then
         call decode_linespec( color, linecolor, ier=ier )
         if( ier /= 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                              "bad 'color' argument!",                  &
                              "(line color will be set to foreground color)" )
            linecolor = 1
         end if
      else
         call decode_col_name( color, linecolor )
      end if

      if( present(linewidth) ) then
         linewidth_d = linewidth
      else
         linewidth_d = 1.
      end if

      ! marker is ignored
      handle = PlotCubicSplineCore( abs_curv_pg,                        &
                                    x_pg, y_pg, wx_pg, wy_pg,           &
                                    linecolor, linestyle, linewidth_d )

      if( mfIsComplex(x) ) then
         call PrintMessage( trim(ROUTINE_NAME), "W",                    &
                            "Imaginary parts of complex argument 'x' ignored." )
      end if

      if( mfIsComplex(y) ) then
         call PrintMessage( trim(ROUTINE_NAME), "W",                    &
                            "Imaginary parts of complex argument 'y' ignored." )
      end if

 99   continue

      if( status_alloc_abs_curv == 1 ) then
         deallocate( abs_curv_ptr )
      else
         ! unlock the internal mfArray properties
         call msFreePointer( abs_curv, abs_curv_ptr )
      end if

      if( status_alloc_x == 1 ) then
         deallocate( x_ptr )
      else
         ! unlock the internal mfArray properties
         call msFreePointer( x, x_ptr )
      end if

      if( status_alloc_y == 1 ) then
         deallocate( y_ptr )
      else
         ! unlock the internal mfArray properties
         call msFreePointer( y, y_ptr )
      end if

      if( status_alloc_wx == 1 ) then
         deallocate( wx_ptr )
      else
         ! unlock the internal mfArray properties
         call msFreePointer( wx, wx_ptr )
      end if

      if( status_alloc_wy == 1 ) then
         deallocate( wy_ptr )
      else
         ! unlock the internal mfArray properties
         call msFreePointer( wy, wy_ptr )
      end if

      call msFreeArgs( abs_curv, x, y, wx, wy )
      call msAutoRelease( abs_curv, x, y, wx, wy )

#ifdef _MF_FUNC
   end function mfPlotCubicSpline_color_str
#endif
#ifdef _MF_SUBR
   end subroutine msPlotCubicSpline_color_str
#endif
!_______________________________________________________________________
!
#ifdef _MF_FUNC
   function mfPlotCubicSpline_color_rgb( abs_curv, x, y, wx, wy,        &
                                         linespec, color, linewidth,    &
                                         dashes_inverted )              &
   result( handle )
#endif
#ifdef _MF_SUBR
   subroutine msPlotCubicSpline_color_rgb( abs_curv, x, y, wx, wy,      &
                                           linespec, color, linewidth,  &
                                           dashes_inverted )
#endif

      type(mfArray)                              :: abs_curv, x, y, wx, wy
      character(len=*),     intent(in), optional :: linespec
      real(kind=MF_DOUBLE), intent(in), optional :: color(3)
      real(kind=MF_DOUBLE), intent(in), optional :: linewidth
      logical,              intent(in), optional :: dashes_inverted
      integer :: handle
      !------ API end ------

      type(mf_win_info), pointer :: win
      real(kind=MF_DOUBLE) :: linewidth_d
      integer :: linecolor, linestyle, marker

      ! pointers for manipulating mfArray out of fml module
      real(kind=MF_DOUBLE), pointer :: abs_curv_ptr(:,:),               &
                                       x_ptr(:,:), y_ptr(:,:),          &
                                       wx_ptr(:,:), wy_ptr(:,:)

      real(kind=MF_DOUBLE), allocatable :: abs_curv_pg(:),              &
                                           x_pg(:), y_pg(:),            &
                                           wx_pg(:), wy_pg(:)
      integer :: p_dim, n_pg
      integer :: status
      integer :: status_alloc_abs_curv,                                 &
                 status_alloc_x, status_alloc_y,                        &
                 status_alloc_wx, status_alloc_wy

#ifdef _MF_FUNC
      character(len=*), parameter :: ROUTINE_NAME = "mfPlotCubicSpline"
#endif
#ifdef _MF_SUBR
      character(len=*), parameter :: ROUTINE_NAME = "msPlotCubicSpline"
#endif

   !------ end of declarations -- execution starts hereafter  ------

#ifdef _MF_FUNC
      handle = 0
#endif

      if( CURRENT_WIN_ID == 0 ) then
         call msFigure()
         if( CURRENT_WIN_ID == 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "cannot plot : no window created!" )
            return
         end if
      end if

      win => mf_win_db(CURRENT_WIN_ID)

      if( win%axis_scale_x == 0 .and. win%axis_scale_y == 0 ) then
         win%axis_scale_x = 1
         win%axis_scale_y = 1
      end if

      call msInitArgs( abs_curv, x, y, wx, wy )

      ! checking that 'abs_curv' is allocated
      if( mfIsEqual(abs_curv,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'abs_curv' not allocated!" )
         go to 99
      end if

      ! 'abs_curv' must be Real
      if( .not. mfIsReal(abs_curv) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'abs_curv' must be real!" )
         go to 99
      end if

      ! 'abs_curv' cannot be sparse
      if( mfIsSparse(abs_curv) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'abs_curv' cannot be sparse!" )
         go to 99
      end if

      ! checking that 'x' is allocated
      if( mfIsEqual(x,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' not allocated!" )
         go to 99
      end if

      ! 'x' must be Real
      if( .not. mfIsReal(x) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' must be real!" )
         go to 99
      end if

      ! 'x' cannot be sparse
      if( mfIsSparse(x) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' cannot be sparse!" )
         go to 99
      end if

      ! checking that 'y' is allocated
      if( mfIsEqual(y,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' not allocated!" )
         go to 99
      end if

      ! 'y' must be Real
      if( .not. mfIsReal(y) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' must be real!" )
         go to 99
      end if

      ! 'y' cannot be sparse
      if( mfIsSparse(y) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' cannot be sparse!" )
         go to 99
      end if

      ! checking that 'wx' is allocated
      if( mfIsEqual(wx,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'wx' not allocated!" )
         go to 99
      end if

      ! 'wx' must be Real
      if( .not. mfIsReal(wx) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'wx' must be real!" )
         go to 99
      end if

      ! 'wx' cannot be sparse
      if( mfIsSparse(wx) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'wx' cannot be sparse!" )
         go to 99
      end if

      ! checking that 'wy' is allocated
      if( mfIsEqual(wy,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'wy' not allocated!" )
         go to 99
      end if

      ! 'wy' must be Real
      if( .not. mfIsReal(wy) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'wy' must be real!" )
         go to 99
      end if

      ! 'wy' cannot be sparse
      if( mfIsSparse(wy) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'wy' cannot be sparse!" )
         go to 99
      end if

      ! checking for 'abs_curv'
      call msPointer_real_only( abs_curv, abs_curv_ptr, status_alloc_abs_curv )
      if( .not. associated( abs_curv_ptr ) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'abs_curv' not initialized!" )
         go to 99
      end if
      if( size(abs_curv_ptr,1)==0 .or. size(abs_curv_ptr,2)==0 ) then
         call PrintMessage( trim(ROUTINE_NAME), "W",                    &
                            "nothing to plot" )
         go to 99
      end if
      ! checking that 'abs_curv' is a 1-D array
      if( size(abs_curv_ptr,1)/=1 .and. size(abs_curv_ptr,2)/=1 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "cannot yet plot a matrix" )
         go to 99
      else
         if( size(abs_curv_ptr,1) == 1 ) then
            p_dim = 2
         else
            p_dim = 1
         end if
         n_pg = size(abs_curv_ptr,p_dim)
      end if

      call msPointer_real_only( x, x_ptr, status_alloc_x )

      ! checking that 'x' have the same size than 'abs_curv'
      if( size(x_ptr,1) /= size(abs_curv_ptr,1) .or.                    &
          size(x_ptr,2) /= size(abs_curv_ptr,2)      ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' and 'abs_curv' array must have the same size" )
         go to 99
      end if

      call msPointer_real_only( y, y_ptr, status_alloc_y )

      ! checking that 'y' have the same size than 'abs_curv'
      if( size(y_ptr,1) /= size(abs_curv_ptr,1) .or.                    &
          size(y_ptr,2) /= size(abs_curv_ptr,2)      ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' and 'abs_curv' array must have the same size" )
         go to 99
      end if

      call msPointer_real_only( wx, wx_ptr, status_alloc_wx )

      ! checking that 'wx' have the same size than 'abs_curv'
      if( size(wx_ptr,1) /= size(abs_curv_ptr,1) .or.                           &
          size(wx_ptr,2) /= size(abs_curv_ptr,2)      ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'wx' and 'abs_curv' array must have the same size" )
         go to 99
      end if

      call msPointer_real_only( wy, wy_ptr, status_alloc_wy )

      ! checking that 'wy' have the same size than 'abs_curv'
      if( size(wy_ptr,1) /= size(abs_curv_ptr,1) .or.                           &
          size(wy_ptr,2) /= size(abs_curv_ptr,2)      ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'wy' and 'abs_curv' array must have the same size" )
         go to 99
      end if

      allocate( abs_curv_pg(n_pg) )

      allocate( x_pg(n_pg) )

      allocate( y_pg(n_pg) )

      allocate( wx_pg(n_pg) )

      allocate( wy_pg(n_pg) )

      if( p_dim == 1 ) then

         call copy_data_for_plotting( abs_curv_ptr(:,1), 1, abs_curv_pg(:), status )
         if( status /= 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "some values for 'abs_curv' are inappropriate for MFPLOT;", &
                               "they will be ignored!" )
         end if

         call copy_data_for_plotting( x_ptr(:,1), win%axis_scale_x, x_pg(:), status )
         if( status /= 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "some values for 'x' are inappropriate for MFPLOT;", &
                               "they will be ignored!" )
         end if

         call copy_data_for_plotting( y_ptr(:,1), win%axis_scale_y, y_pg(:), status )
         if( status /= 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "some values for 'y' are inappropriate for MFPLOT;", &
                               "they will be ignored!" )
         end if

         call copy_data_for_plotting( wx_ptr(:,1), 1, wx_pg(:), status )
         if( status /= 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "some values for 'wx' are inappropriate for MFPLOT;", &
                               "they will be ignored!" )
         end if

         call copy_data_for_plotting( wy_ptr(:,1), 1, wy_pg(:), status )
         if( status /= 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "some values for 'wy' are inappropriate for MFPLOT;", &
                               "they will be ignored!" )
         end if

      else

         call copy_data_for_plotting( abs_curv_ptr(1,:), 1, abs_curv_pg(:), status )
         if( status /= 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "some values for 'abs_curv' are inappropriate for MFPLOT;", &
                               "they will be ignored!" )
         end if

         call copy_data_for_plotting( x_ptr(1,:), win%axis_scale_x, x_pg(:), status )
         if( status /= 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "some values for 'x' are inappropriate for MFPLOT;", &
                               "they will be ignored!" )
         end if

         call copy_data_for_plotting( y_ptr(1,:), win%axis_scale_y, y_pg(:), status )
         if( status /= 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "some values for 'y' are inappropriate for MFPLOT;", &
                               "they will be ignored!" )
         end if

         call copy_data_for_plotting( wx_ptr(1,:), 1, wx_pg(:), status )
         if( status /= 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "some values for 'wx' are inappropriate for MFPLOT;", &
                               "they will be ignored!" )
         end if

         call copy_data_for_plotting( wy_ptr(1,:), 1, wy_pg(:), status )
         if( status /= 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "some values for 'wy' are inappropriate for MFPLOT;", &
                               "they will be ignored!" )
         end if

      end if

      if( present(linespec) ) then
         call decode_linespec( linespec, linecolor, linestyle, marker )
         ! only linestyle must have a valid value
         if( linestyle == -127 .and. marker == -127 ) then
            linestyle = 1
         end if
         if( marker /= -127 ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "marker selection is discarded in this routine.",                              &
                               "(hint: add a msPlot call with the Hold property)" )
         end if
      else
         linecolor = -127 ! means: not found
         linestyle = 1
         marker    = -127 ! means: not found
      end if

      if( present(dashes_inverted) ) then
         if( linestyle == 2 ) then
            if( dashes_inverted ) then
               linestyle = 5 ! inverted dashed line
            end if
         else
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "argument 'dashes_inverted' may be used only for a dashed curve.", &
                               "it will be ignored!" )
         end if
      end if

      if( present(color) ) then
         call decode_col_rgb( color, linecolor )
      end if

      if( present(linewidth) ) then
         linewidth_d = linewidth
      else
         linewidth_d = 1.
      end if

      ! marker is ignored
      handle = PlotCubicSplineCore( abs_curv_pg,                        &
                                    x_pg, y_pg, wx_pg, wy_pg,           &
                                    linecolor, linestyle, linewidth_d )

      if( mfIsComplex(x) ) then
         call PrintMessage( trim(ROUTINE_NAME), "W",                    &
                            "Imaginary parts of complex argument 'x' ignored." )
      end if

      if( mfIsComplex(y) ) then
         call PrintMessage( trim(ROUTINE_NAME), "W",                    &
                            "Imaginary parts of complex argument 'y' ignored." )
      end if

 99   continue

      if( status_alloc_abs_curv == 1 ) then
         deallocate( abs_curv_ptr )
      else
         ! unlock the internal mfArray properties
         call msFreePointer( abs_curv, abs_curv_ptr )
      end if

      if( status_alloc_x == 1 ) then
         deallocate( x_ptr )
      else
         ! unlock the internal mfArray properties
         call msFreePointer( x, x_ptr )
      end if

      if( status_alloc_y == 1 ) then
         deallocate( y_ptr )
      else
         ! unlock the internal mfArray properties
         call msFreePointer( y, y_ptr )
      end if

      if( status_alloc_wx == 1 ) then
         deallocate( wx_ptr )
      else
         ! unlock the internal mfArray properties
         call msFreePointer( wx, wx_ptr )
      end if

      if( status_alloc_wy == 1 ) then
         deallocate( wy_ptr )
      else
         ! unlock the internal mfArray properties
         call msFreePointer( wy, wy_ptr )
      end if

      call msFreeArgs( abs_curv, x, y, wx, wy )
      call msAutoRelease( abs_curv, x, y, wx, wy )

#ifdef _MF_FUNC
   end function mfPlotCubicSpline_color_rgb
#endif
#ifdef _MF_SUBR
   end subroutine msPlotCubicSpline_color_rgb
#endif
