!_______________________________________________________________________
!
   subroutine mf_cubic_bezier_draw( grobj )

      type(grobj_elem), intent(in) :: grobj
      !------ API end ------

      ! grobj type = "cubic_bezier"

      type(mf_win_info), pointer :: win
      integer :: status

      real(kind=MF_DOUBLE) :: rbuf(1)
      integer :: ibuf(1)

   !------ end of declarations -- execution starts hereafter  ------

      if( PRINTING_EPS .or. PRINTING_PDF ) then
         ! Quick return only for printing
         call quick_detect_pt_inside_4( grobj%struct%npt,               &
                                        grobj%struct%abs_tab,           &
                                        grobj%struct%ord_tab,           &
                                        status )
         if( status == 0 ) return
      end if

      if( PRINTING_EPS ) then
         if( COMMENTS_IN_EPS ) then
            ibuf(1) = 0
            call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- begin of Cubic_Bezier", 0 )
         end if
      end if
      if( PRINTING_PDF ) then
         if( COMMENTS_IN_PDF ) then
            call pdf_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- begin of Cubic_Bezier", 0 )
         end if
         gr_pdf_color_intent = 1 ! Stroke
      end if

      call grsci(grobj%struct%color) ! set color index
      call grslw(grobj%struct%linewidth) ! set line width

      ! assumption : axis are always lin-lin
      call pg_cubic_bezier( grobj%struct%npt,                           &
                            grobj%struct%abs_tab,                       &
                            grobj%struct%ord_tab,                       &
                            grobj%struct%linestyle )

      if( PRINTING_EPS ) then
         if( COMMENTS_IN_EPS ) then
            ibuf(1) = 0
            call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- end of Cubic_Bezier", 0 )
         end if
      end if
      if( PRINTING_PDF ) then
         if( COMMENTS_IN_PDF ) then
            call pdf_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- end of Cubic_Bezier", 0 )
         end if
      end if

   end subroutine mf_cubic_bezier_draw
!_______________________________________________________________________
!
   subroutine quick_detect_pt_inside_4( n, x, y, status )

      integer,              intent(in) :: n
      real(kind=MF_DOUBLE), intent(in) :: x(:), y(:)
      integer                          :: status
      !------ API end ------

      ! Return status=1 if something may be drawn inside the axes,
      ! else return status=0.
      !
      ! Case: Quadratic Bézier.

      type(mf_win_info), pointer :: win

      real(kind=MF_DOUBLE) :: x_min, x_max, y_min, y_max
      integer :: i, n_seg, offset
      logical :: x_inverted, y_inverted, bool_1, bool_2, bool_3, bool_4

   !------ end of declarations -- execution starts hereafter  ------

      ! Check the total number of control points
      n_seg = n - 1
      if( mod(n_seg,3) /= 0 ) then
         write(0,*) "*** ERROR (quick_detect_pt_inside_4:) bad dim. for args!"
         write(0,*) "    -> they should be of the form : 3*k+1."
         return
      end if
      ! Number of segments
      n_seg = n_seg / 3

      win => mf_win_db(CURRENT_WIN_ID)

      status = 0

      if( win%current_axes(1) < win%current_axes(2) ) then
         x_inverted = .false.
      else
         x_inverted = .true.
      end if

      if( win%current_axes(3) < win%current_axes(4) ) then
         y_inverted = .false.
      else
         y_inverted = .true.
      end if

      ! Set status to 1 as soon as we detect that the BBox of a line
      ! segment has an intersection with the axes which is not empty.
      !
      ! This quick test doesn't depend on line attributes, nor on the axes
      ! scaling.
      do i = 1, n_seg
         offset = 3*(i-1)
         x_min = min( x(offset+1), x(offset+2), x(offset+3), x(offset+4) )
         x_max = max( x(offset+1), x(offset+2), x(offset+3), x(offset+4) )
         y_min = min( y(offset+1), y(offset+2), y(offset+3), y(offset+4) )
         y_max = max( y(offset+1), y(offset+2), y(offset+3), y(offset+4) )
         if( x_inverted ) then
            bool_1 = x_max >= win%current_axes(2)
            bool_2 = x_min <= win%current_axes(1)
         else
            bool_1 = x_max >= win%current_axes(1)
            bool_2 = x_min <= win%current_axes(2)
         end if
         if( y_inverted ) then
            bool_3 = y_max >= win%current_axes(4)
            bool_4 = y_min <= win%current_axes(3)
         else
            bool_3 = y_max >= win%current_axes(3)
            bool_4 = y_min <= win%current_axes(4)
         end if
         if( bool_1 ) then
            if( bool_2 ) then
               if( bool_3 ) then
                  if( bool_4 ) then
                     status = 1
                     return
                  end if
               end if
            end if
         end if
      end do

   end subroutine quick_detect_pt_inside_4
