! Volontairement, les entêtes et fin d'objet de type Shading 6 ont été
! rapatriés ici uniquement pour les PDF. Il s'agit d'éviter de créer un
! PDF invalide quand les 'Quick Return' conduisent à un tracé vide.
! Pour les EPS, c'est préférable de laisser les entêtes et fin dans la
! routine PatchQuadMesh_PS_PDF_shad, ainsi, on fait une "petite économie"
! supplémentaire en ne les écrivant pas.

! Par défaut, les coordonnées (entières) sont écrites au format Z4.4, c'est
! à dire en 16 bits, ou 2 octets. Cela peut paraître faible, mais cela
! suffit souvent amplement, grâce au clipping manuel effectué désormais ici.
! Le seul cas qui pourrait réellement poser problème est un zoom très
! important dans un maillage quadrangulaire extrêmement déformé (le clipping
! n'est pas effecté par cellule, mais par bande).
!
!### TODO: On pourrait éventuellement faire le choix de limiter l'écriture
! des entiers en 16 bits aux cas courant des grilles rectangulaires, et de
! prendre 32 bits pour toutes les grilles non rectangulaires.

!_______________________________________________________________________
!
   subroutine mf_pcolor_draw( grobj )

      type(grobj_elem), intent(in) :: grobj
      !------ API end ------

      ! grobj type = "pcolor"

      type(mf_win_info), pointer :: win

      integer :: nx, ny, ni, nj, grid_icol, grid_step(2)
      integer :: i, j, i_max, j_max, i_step, j_step, icol, tp
      integer :: ideb, ifin, jdeb, jfin
      logical :: draw_grid, x_inverted, y_inverted
      logical :: y_pg_4_depends_only_on_i
      real(kind=MF_DOUBLE) :: scaling_xyz(3), fact, mat_mean
      real(kind=MF_DOUBLE) :: x_pg_4(4), y_pg_4(4)
      integer :: icol_pg_4(4)
      character(len=80) :: inline
      logical :: empty_drawing, band_inside, cell_outside,              &
                 first_obj_found, band_inside_x, band_inside_y
      integer :: status
      character(len=3) :: file_format
      real(kind=MF_DOUBLE) :: xx_min, xx_max, yy_min, yy_max

      real(kind=MF_DOUBLE), allocatable :: xx2(:,:), yy2(:,:)
      integer, allocatable :: cc2(:,:)

      real(kind=MF_DOUBLE) :: rbuf(1)
      integer :: ibuf(1)

   !------ end of declarations -- execution starts hereafter  ------

      win => mf_win_db(CURRENT_WIN_ID)

      if( PRINTING_EPS ) then
         if( COMMENTS_IN_EPS ) then
            ibuf(1) = 0
            call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- begin of Pcolor", 0 )
         end if
         call EPS_clip_on_viewport_beg()
      end if

      if( PRINTING_PDF ) then
         call PDF_clip_on_viewport_beg()

         if( win%shading /= "flat" ) then
            MF_PDF_CURR_SHT6 = MF_PDF_CURR_SHT6 + 1
            ! close current content
            write(inline,"(A,I0,A)") "/Sht6_", MF_PDF_CURR_SHT6, " sh"
            call gresc( trim(inline) )
            call gresc("endstream")
            call gresc("endobj")
            call gresc("")
         end if

         if( COMMENTS_IN_PDF ) then
            call pdf_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- begin of Pcolor", 0 )
         end if

         if( win%shading /= "flat" ) then
            write(inline,"(I0,A)") MF_PDF_OFF_SHT6 + MF_PDF_CURR_SHT6, " 0 obj <<"
            call gresc( trim(inline) )
            call gresc("  /ShadingType 6")
            call gresc("  /ColorSpace /DeviceRGB")
            call gresc("  /BitsPerFlag 8")
            call gresc("  /BitsPerCoordinate 16")
            call gresc("  /BitsPerComponent 8")
            call gresc("  /Decode [ -32767 32768 -32767 32768 0 1 ]")
            write(inline,"(A,I0,A)") "  /Function ",                    &
                                     MF_PDF_OFF_CMAP + MF_PDF_CURR_CMAP, " 0 R"
            call gresc( trim(inline) )
            if( MF_DEFLATE_TO_A85 ) then
               call gresc("  /Filter [ /ASCII85Decode /FlateDecode /ASCIIHexDecode ]")
            else
               call gresc("  /Filter [ /ASCIIHexDecode /FlateDecode /ASCIIHexDecode ]")
            end if
            call gresc("  /Length 0         ")
            call gresc(">>")
            call gresc("stream")
         end if

      end if

      ni = size(grobj%struct%val_mat,1) ! rows    = ny
      nj = size(grobj%struct%val_mat,2) ! columns = nx

      fact = (win%colormap_ci_high-win%colormap_ci_low) /                       &
             (win%color_axes(2)-win%color_axes(1))

      if( grobj%struct%npt3 == -2 ) then
         i_max = ni
         j_max = nj
      else
         i_max = ni - 1
         j_max = nj - 1
      end if

      y_pg_4_depends_only_on_i = .false.
      if( grobj%struct%npt == -1 ) then
         if( associated(grobj%struct%abs_tab) ) then
            y_pg_4_depends_only_on_i = .true.
         end if
      else
         y_pg_4_depends_only_on_i = .true.
      end if

      if( win%current_axes(1) < win%current_axes(2) ) then
         x_inverted = .false.
      else
         x_inverted = .true.
      end if

      if( win%current_axes(3) < win%current_axes(4) ) then
         y_inverted = .false.
      else
         y_inverted = .true.
      end if

      empty_drawing = .false.

      if( (PRINTING_EPS .or. PRINTING_PDF) .and. win%shading /= "flat" ) then

!### TODO: le Quick-Return ne devrait pas se baser sur les valeurs strictes
!          des axes, mais sur des valeurs élargies lors du 'Pan'...
!          (voir, par ex. comment j'ai fait dans 'PatchTriMesh_shad.inc')
         x_left_QR  = win%current_axes(1)
         x_right_QR = win%current_axes(2)
         y_bottom_QR = win%current_axes(3)
         y_top_QR    = win%current_axes(4)

         ! les coordonnées (x,y) peuvent être dans une matrice ou un vecteur
         ! (on ne traite pas le cas 'cell-centered') Warning: i=row, j=col
         ! On fournit une ligne de quadrilatère à 'PatchQuadMesh_PS_PDF_shad'
         allocate( xx2(2,nj), yy2(2,nj), cc2(2,nj) )
         if( grobj%struct%npt == -1 ) then
            if( associated(grobj%struct%abs_tab) ) then
               ! (x,y) in vectors
               xx2(1,:) = grobj%struct%abs_tab(:)
               xx2(2,:) = xx2(1,:)
               if( win%axis_scale_x == 2 ) then
                  xx2 = log10( xx2 )
               end if
               ! Manual clipping to avoid Integer Overflow in 'Shading 6'
               ! EPS and PDF writing (because BitsPerCoordinate=16).
               if( y_inverted ) then
!### TODO: si le maillage est déformé (par ex. en forme de lune ou
!          hémisphérique, alors la valeur max. de y n'est pas localisée
!          en i_max, il faut la calculer avec la fonction maxval(), non ?
                  if( grobj%struct%ord_tab(i_max) < y_top_QR .or.       &
                      grobj%struct%ord_tab(1)     > y_bottom_QR ) then
                     empty_drawing = .true.
                  else
                     do ideb = 1, i_max
                        if( grobj%struct%ord_tab(ideb) < y_top_QR ) exit
                     end do
                     do ifin = i_max, 1, -1
                        if( grobj%struct%ord_tab(ifin) > y_bottom_QR ) exit
                     end do
                     ideb = max(1, ideb-1)
                  end if
               else
                  if( grobj%struct%ord_tab(i_max) < y_bottom_QR .or.    &
                      grobj%struct%ord_tab(1)     > y_top_QR ) then
                     empty_drawing = .true.
                  else
                     do ideb = 1, i_max
                        if( grobj%struct%ord_tab(ideb) > y_bottom_QR ) exit
                     end do
                     do ifin = i_max, 1, -1
                        if( grobj%struct%ord_tab(ifin) < y_top_QR ) exit
                     end do
                     ideb = max(1, ideb-1)
                  end if
               end if
               if( x_inverted ) then
                  if( grobj%struct%abs_tab(nj) < x_right_QR .or.        &
                      grobj%struct%abs_tab(1)  > x_left_QR ) then
                     empty_drawing = .true.
                  else
                     do jdeb = 1, nj
                        if( grobj%struct%abs_tab(jdeb) > x_right_QR ) exit
                     end do
                     do jfin = nj, 1, -1
                        if( grobj%struct%abs_tab(jfin) < x_left_QR ) exit
                     end do
                     jdeb = max(1, jdeb-1)
                     jfin = min(nj,jfin+1)
                  end if
               else
                  if( grobj%struct%abs_tab(nj) < x_left_QR .or.         &
                      grobj%struct%abs_tab(1)  > x_right_QR ) then
                     empty_drawing = .true.
                  else
                     do jdeb = 1, nj
                        if( grobj%struct%abs_tab(jdeb) > x_left_QR ) exit
                     end do
                     do jfin = nj, 1, -1
                        if( grobj%struct%abs_tab(jfin) < x_right_QR ) exit
                     end do
                     jdeb = max(1, jdeb-1)
                     jfin = min(nj,jfin+1)
                  end if
               end if
               if( .not. empty_drawing ) then
                  do i = ideb, ifin
                     ! type_of_patch: uniquement pour EPS & PDF Shading
                     tp = 0
                     if( i == ideb ) then
                        tp = tp + 1
                     end if
                     if( i == ifin ) then
                        tp = tp + 2
                     end if
                     yy2(1,:) = grobj%struct%ord_tab(i)
                     yy2(2,:) = grobj%struct%ord_tab(i+1)
                     if( win%axis_scale_y == 2 ) then
                        yy2 = log10( yy2 )
                     end if
                     cc2(1,:) = nint( win%colormap_ci_low +             &
                                fact*(grobj%struct%val_mat(i,:)-win%color_axes(1)) )
                     cc2(2,:) = nint( win%colormap_ci_low +             &
                                fact*(grobj%struct%val_mat(i+1,:)-win%color_axes(1)) )
                     call PatchQuadMesh_PS_PDF_shad( xx2(:,jdeb:jfin),  &
                                                     yy2(:,jdeb:jfin),  &
                                                     cc2(:,jdeb:jfin),  &
                                                     type_of_patch=tp,  &
                                                     status=status )
                  end do
               end if
            else
               ! (x,y) in matrices
               xx_min = minval( grobj%struct%abs_mat )
               xx_max = maxval( grobj%struct%abs_mat )
               yy_min = minval( grobj%struct%ord_mat )
               yy_max = maxval( grobj%struct%ord_mat )
               if( x_inverted ) then
                  if( xx_max < x_right_QR .or. x_left_QR < xx_min ) then
                     empty_drawing = .true.
                  end if
               else
                  if( xx_max < x_left_QR .or. x_right_QR < xx_min ) then
                     empty_drawing = .true.
                  end if
               end if
               if( y_inverted ) then
                  if( yy_max < y_top_QR .or. y_bottom_QR < yy_min ) then
                     empty_drawing = .true.
                  end if
               else
                  if( yy_max < y_bottom_QR .or. y_top_QR < yy_min ) then
                     empty_drawing = .true.
                  end if
               end if
               if( .not. empty_drawing ) then
                  first_obj_found = .false.
                  do i = 1, i_max
                     ! type_of_patch: uniquement pour EPS & PDF Shading

                     ! on examine les bandes une par une
                     xx2(1,:) = grobj%struct%abs_mat(i,:)
                     xx2(2,:) = grobj%struct%abs_mat(i+1,:)
                     if( win%axis_scale_x == 2 ) then
                        xx2 = log10( xx2 )
                     end if
                     yy2(1,:) = grobj%struct%ord_mat(i,:)
                     yy2(2,:) = grobj%struct%ord_mat(i+1,:)
                     if( win%axis_scale_y == 2 ) then
                        yy2 = log10( yy2 )
                     end if
                     cc2(1,:) = nint( win%colormap_ci_low +             &
                              fact*(grobj%struct%val_mat(i,:)-win%color_axes(1)) )
                     cc2(2,:) = nint( win%colormap_ci_low +             &
                              fact*(grobj%struct%val_mat(i+1,:)-win%color_axes(1)) )

                     band_inside_x = .false.
                     band_inside_y = .false.
                     xx_min = minval( xx2 )
                     xx_max = maxval( xx2 )
                     yy_min = minval( yy2 )
                     yy_max = maxval( yy2 )
                     if( x_inverted ) then
                        if( x_right_QR <= xx_min .and. xx_max <= x_left_QR ) then
                           band_inside_x = .true.
                        end if
                     else
                        if( x_left_QR <= xx_min .and. xx_max <= x_right_QR ) then
                           band_inside_x = .true.
                        end if
                     end if
                     if( y_inverted ) then
                        if( y_top_QR <= yy_min .and. yy_max <= y_bottom_QR ) then
                           band_inside_y = .true.
                        end if
                     else
                        if( y_bottom_QR <= yy_min .and. yy_max <= y_top_QR ) then
                           band_inside_y = .true.
                        end if
                     end if
                     band_inside = band_inside_x .and. band_inside_y

                     if( band_inside ) then
                        tp = 0
                        if( .not. first_obj_found ) then
                           tp = tp + 1
                           first_obj_found = .true.
                        end if
                        call PatchQuadMesh_PS_PDF_shad( xx2, yy2, cc2,  &
                                                        type_of_patch=tp, &
                                                        status=status )
                     else
                        do j = 1, nj-1
                           ! on examine les cellules une par une
                           cell_outside = .false.
                           xx_min = minval( xx2(:,j:j+1) )
                           xx_max = maxval( xx2(:,j:j+1) )
                           yy_min = minval( yy2(:,j:j+1) )
                           yy_max = maxval( yy2(:,j:j+1) )
                           if( x_inverted ) then
                              if( xx_max < x_right_QR .or. x_left_QR < xx_min ) then
                                 cell_outside = .true.
                              end if
                           else
                              if( xx_max < x_left_QR .or. x_right_QR < xx_min ) then
                                 cell_outside = .true.
                              end if
                           end if
                           if( y_inverted ) then
                              if( yy_max < y_top_QR .or. y_bottom_QR < yy_min ) then
                                 cell_outside = .true.
                              end if
                           else
                              if( yy_max < y_bottom_QR .or. y_top_QR < yy_min ) then
                                 cell_outside = .true.
                              end if
                           end if
                           if( cell_outside ) cycle
                           tp = 0
                           if( .not. first_obj_found ) then
                              tp = tp + 1
                              first_obj_found = .true.
                           end if
                           call PatchQuadMesh_PS_PDF_shad( xx2(:,j:j+1), &
                                                           yy2(:,j:j+1), &
                                                           cc2(:,j:j+1), &
                                                           type_of_patch=tp, &
                                                           status=status )
                        end do
                     end if

                  end do
                  ! pseudo call, just to finalize the compression
                  call PatchQuadMesh_PS_PDF_shad( xx2(1:2,1:2),         &
                                                  yy2(1:2,1:2),         &
                                                  cc2(1:2,1:2),         &
                                                  type_of_patch=2,      &
                                                  status=status,        &
                                                  finalize=.true. )
               end if
            end if
         else
            ! (x,y) not given
            if( grobj%struct%npt3 == -2 ) then
!### TODO: à revoir ? si, ça doit bien exister puisque je le traite
!                     dans le cas X11, ci-dessous...
               print *, "mf_pcolor_draw: internal error."
               print *, "print: this line should never be reached in 'interp' mode (?)"
               pause "only for debugging purpose"
               stop
               x_pg_4(:) = [ j-0.5, j+0.5, j+0.5, j-0.5 ]
               y_pg_4(:) = [ i-0.5, i-0.5, i+0.5, i+0.5 ]
            else
               xx2(1,:) = [ ( i, i = 1, nj ) ]
               xx2(2,:) = xx2(1,:)
               if( win%axis_scale_x == 2 ) then
                  xx2 = log10( xx2 )
               end if
               ! Manual clipping to avoid Integer Overflow in 'Shading 6'
               ! EPS and PDF writing (because BitsPerCoordinate=16).
               if( y_inverted ) then
                  ideb = max(1,floor(y_top_QR))
                  ifin = min(i_max,ceiling(y_bottom_QR)-1)
               else
                  ideb = max(1,floor(y_bottom_QR))
                  ifin = min(i_max,ceiling(y_top_QR)-1)
               end if
               if( ideb > ifin ) then
                  empty_drawing = .true.
               end if
               if( x_inverted ) then
                  jdeb = max(1,floor(x_right_QR))
                  jfin = min(nj,ceiling(x_left_QR))
               else
                  jdeb = max(1,floor(x_left_QR))
                  jfin = min(nj,ceiling(x_right_QR))
               end if
               if( jdeb > jfin ) then
                  empty_drawing = .true.
               end if
               if( .not. empty_drawing ) then
                  do i = ideb, ifin
                     ! type_of_patch: uniquement pour EPS & PDF Shading
                     tp = 0
                     if( i == ideb ) then
                        tp = tp + 1
                     end if
                     if( i == ifin ) then
                        tp = tp + 2
                     end if
                     yy2(1,:) = i
                     yy2(2,:) = i+1
                     cc2(1,:) = nint( win%colormap_ci_low +             &
                              fact*(grobj%struct%val_mat(i,:)-win%color_axes(1)) )
                     cc2(2,:) = nint( win%colormap_ci_low +             &
                              fact*(grobj%struct%val_mat(i+1,:)-win%color_axes(1)) )
                     if( win%axis_scale_y == 2 ) then
                        yy2 = log10( yy2 )
                     end if
                     call PatchQuadMesh_PS_PDF_shad( xx2(:,jdeb:jfin),  &
                                                     yy2(:,jdeb:jfin),  &
                                                     cc2(:,jdeb:jfin),  &
                                                     type_of_patch=tp,  &
                                                     status=status )
                  end do
               end if
            end if
         end if
         deallocate( xx2, yy2, cc2 )

         if( status /= 0 ) then
            if( PRINTING_EPS ) then
               file_format = "EPS"
            else ! PRINTING_PDF
               file_format = "PDF"
            end if
            call PrintMessage( "msPrint", "W",                          &
                               "Writing a Pcolor object in " // trim(file_format) // " format leads", &
                               "to integer overflow and, therefore, a non valid", &
                               trim(file_format) // " file (Too much zoom inside the image?)." )
            call PrintMessage( "msPrint", "I",                          &
                               "(Current writing in " // trim(file_format) // " use 16-bit integers)" )
            if( status == -2 ) then
               call PrintMessage( "msPrint", "W",                       &
                                  "Even using 32-bit integers doesn't suppress", &
                                  "the integer overflow for these data." )
            end if
         end if

      else ! X11 or NULL --- (or flat printing)

!### TODO: Ci-dessous, les 146 lignes correspondent à l'implémentation de
!          'Quick returns' (ou plutôt 'Quick cycle') assez sophistiqués...
!    Si on prend en compte la numérotation des quatre sommets pour chaque
!    polygone, on pourrait même éviter les appels de minval/maxval...
!
!    De plus, si on prenait en compte l'ordre de parcours des carrés dans
!    la matrice, alors on peut faire des 'Quick cycle', voire des 'exit'
!    permettant de sortir des deux boucles (mais il faudrait nommer les
!    deux boucles, par ex. loop_i_001 et loop_j_001).

         do i = 1, i_max

            if( grobj%struct%npt == -1 ) then
               if( associated(grobj%struct%abs_tab) ) then
                  y_pg_4(:) = [ grobj%struct%ord_tab(i),                &
                                grobj%struct%ord_tab(i+1),              &
                                grobj%struct%ord_tab(i+1),              &
                                grobj%struct%ord_tab(i) ]
                  if( win%axis_scale_y == 2 ) then
                     y_pg_4(:) = log10( y_pg_4(:) )
                  end if
               end if
            else
               if( grobj%struct%npt3 == -2 ) then
                  y_pg_4(:) = [ i-0.5, i+0.5, i+0.5, i-0.5 ]
               else
                  y_pg_4(:) = [ i, i+1, i+1, i ]
               end if
            end if

            if( y_pg_4_depends_only_on_i ) then
               ! Quick return (test only on 'y')
               if( MF_QR_in_aux_pixmap ) then
                  ! y_..._QR defined in Pan or PanAndZoom
               else
                  y_bottom_QR = win%current_axes(3)
                  y_top_QR    = win%current_axes(4)
               end if
               if( y_inverted ) then
                  if( maxval(y_pg_4) < y_top_QR ) cycle
                  if( minval(y_pg_4) > y_bottom_QR ) cycle
               else
                  if( maxval(y_pg_4) < y_bottom_QR ) cycle
                  if( minval(y_pg_4) > y_top_QR ) cycle
               end if
            end if

            do j = 1, j_max

               if( grobj%struct%npt == -1 ) then
                  if( associated(grobj%struct%abs_tab) ) then
                     x_pg_4(:) = [ grobj%struct%abs_tab(j),             &
                                 grobj%struct%abs_tab(j),               &
                                 grobj%struct%abs_tab(j+1),             &
                                 grobj%struct%abs_tab(j+1) ]
                     if( win%axis_scale_x == 2 ) then
                        x_pg_4(:) = log10( x_pg_4(:) )
                     end if
                  else
                     x_pg_4(:) = [ grobj%struct%abs_mat(i,j),           &
                                 grobj%struct%abs_mat(i+1,j),           &
                                 grobj%struct%abs_mat(i+1,j+1),         &
                                 grobj%struct%abs_mat(i,j+1) ]
                  end if
               else
                  if( grobj%struct%npt3 == -2 ) then
                     x_pg_4(:) = [ j-0.5, j-0.5, j+0.5, j+0.5 ]
                  else
                     x_pg_4(:) = [ j, j, j+1, j+1 ]
                  end if
               end if

               ! Quick return
               if( MF_QR_in_aux_pixmap ) then
                  ! x_..._QR defined in Pan or PanAndZoom
               else
                  x_left_QR  = win%current_axes(1)
                  x_right_QR = win%current_axes(2)
               end if
               if( x_inverted ) then
                  if( maxval(x_pg_4) < x_right_QR ) cycle
                  if( minval(x_pg_4) > x_left_QR ) cycle
               else
                  if( maxval(x_pg_4) < x_left_QR ) cycle
                  if( minval(x_pg_4) > x_right_QR ) cycle
               end if

               if( grobj%struct%npt == -1 ) then
                  if( associated(grobj%struct%ord_mat) ) then
                     y_pg_4(:) = [ grobj%struct%ord_mat(i,j),           &
                                 grobj%struct%ord_mat(i+1,j),           &
                                 grobj%struct%ord_mat(i+1,j+1),         &
                                 grobj%struct%ord_mat(i,j+1) ]
                  end if
               end if

               if( .not. y_pg_4_depends_only_on_i ) then
                  ! Quick return
                  if( MF_QR_in_aux_pixmap ) then
                     ! y_..._QR defined in Pan or PanAndZoom
                  else
                     y_bottom_QR = win%current_axes(3)
                     y_top_QR    = win%current_axes(4)
                  end if
                  if( y_inverted ) then
                     if( maxval(y_pg_4) < y_top_QR ) cycle
                     if( minval(y_pg_4) > y_bottom_QR ) cycle
                  else
                     if( maxval(y_pg_4) < y_bottom_QR ) cycle
                     if( minval(y_pg_4) > y_top_QR ) cycle
                  end if
               end if

               if( grobj%struct%npt3 == -2 ) then
                  icol_pg_4(:) = nint( win%colormap_ci_low +            &
                                       fact*(grobj%struct%val_mat(i,j)-win%color_axes(1)) )
               else
                  if( win%shading == "flat" ) then
                     mat_mean = 0.25d0*( grobj%struct%val_mat(i,j) +    &
                                       grobj%struct%val_mat(i+1,j) +    &
                                       grobj%struct%val_mat(i+1,j+1) +  &
                                       grobj%struct%val_mat(i,j+1) )
                     icol_pg_4(:) = nint( win%colormap_ci_low +         &
                                          fact*(mat_mean-win%color_axes(1)) )
                  else
                     icol_pg_4(1) = win%colormap_ci_low +               &
                                    fact*(grobj%struct%val_mat(i,j)-win%color_axes(1))
                     icol_pg_4(2) = win%colormap_ci_low +               &
                                    fact*(grobj%struct%val_mat(i+1,j)-win%color_axes(1))
                     icol_pg_4(3) = win%colormap_ci_low +               &
                                    fact*(grobj%struct%val_mat(i+1,j+1)-win%color_axes(1))
                     icol_pg_4(4) = win%colormap_ci_low +               &
                                    fact*(grobj%struct%val_mat(i,j+1)-win%color_axes(1))
                  end if
               end if

               ! detecting color-overflow
               if( COLOR_OVERFLOW_LOW_POLICY == 0 ) then
                  if( BLACK_ON_WHITE == 1 ) then
                     where( icol_pg_4 < win%colormap_ci_low )
                        icol_pg_4 = 1
                     end where
                  else
                     where( icol_pg_4 < win%colormap_ci_low )
                        icol_pg_4 = MFPLOT_QUASI_BLACK
                     end where
                  end if
               else
                  where( icol_pg_4 < win%colormap_ci_low )
                     icol_pg_4 = win%colormap_ci_low
                  end where
               end if
               if( COLOR_OVERFLOW_HIGH_POLICY == 0 ) then
                  if( BLACK_ON_WHITE == 1 ) then
                     where( icol_pg_4 > win%colormap_ci_high )
                        icol_pg_4 = MFPLOT_QUASI_WHITE
                     end where
                  else
                     where( icol_pg_4 > win%colormap_ci_high )
                        icol_pg_4 = 1
                     end where
                  end if
               else
                  where( icol_pg_4 > win%colormap_ci_high )
                     icol_pg_4 = win%colormap_ci_high
                  end where
               end if

               if( quad_is_tri(x_pg_4,y_pg_4,icol_pg_4) ) then
                  if( win%shading == "flat" ) then
                     call PatchTriCore( x_pg_4(1:3), y_pg_4(1:3), icol_pg_4(1:3), &
                                        opacity=1.0d0, flat=.true. )
                  else
                     call PatchTriCore( x_pg_4(1:3), y_pg_4(1:3), icol_pg_4(1:3), &
                                        opacity=1.0d0 )
                  end if
               else
                  if( quad_is_rect(x_pg_4,y_pg_4) ) then
                     if( win%shading == "flat" ) then
                        call PatchRectCore( x_pg_4, y_pg_4, icol_pg_4,  &
                                            opacity=1.0d0, flat=.true. )
                     else
                        call PatchRectCore( x_pg_4, y_pg_4, icol_pg_4,  &
                                            opacity=1.0d0 )
                     end if
                  else
                     if( win%shading == "flat" ) then
                        ! flat polygon
                        icol = icol_pg_4(1)
                        gr_pdf_color_intent = 2 ! Fill
                        call grsci(icol) ! set color index
                        call pgsfs(1) ! set fill-area style : solid (default)
                        call pgpoly( 4, x_pg_4, y_pg_4 )
                     else
                        call PatchQuadCore( x_pg_4, y_pg_4, icol_pg_4,  &
                                            opacity=1.0d0 )
                     end if
                  end if
               end if

            end do
         end do

      end if ! Vector drawing vs Pixel drawing

      if( PRINTING_PDF ) then
         if( win%shading /= "flat" ) then
            if( empty_drawing ) then
               ! fill the minimum of data, just to avoid mupdf warns about
               ! empty stream ;-)
               ! [The two data stream below have been obtained by using the
               !  initialization and finalization of 'deflate_stream_to_a85'
               !  and 'deflate_stream_to_hex', but without any data between
               !  the two calls.]
               if( MF_DEFLATE_TO_A85 ) then
                  call gresc("GhQ'r!!""/B+T") ! Note the double " inside
                  call gresc("~>")
               else
                  call gresc("78DA53000000210021")
                  call gresc(">")
               end if
            end if
            call gresc("endstream")
            call gresc("endobj")

            ! open a new content
            MF_PDF_CURR_CONT = MF_PDF_CURR_CONT + 1
            write(inline,"(I0,A)") MF_PDF_OFF_CONT + MF_PDF_CURR_CONT,  &
                                   " 0 obj <<"
            call gresc( trim(inline) )
            call gresc("  /Length 0         ")
            call gresc(">>")
            call gresc("stream")
         end if

         call PDF_clip_on_viewport_end()
      end if

      draw_grid = grobj%struct%bool1

      if( draw_grid ) then
         gr_pdf_color_intent = 1 ! Stroke
         call grsci(grobj%struct%color) ! set color index
         call grsls(1) ! line style: continuous
         if( grobj%struct%npt2 == -1 ) then
            ! (x,y) mat
            nx = size(grobj%struct%val_mat,1)
            ny = size(grobj%struct%val_mat,2)
            call draw_grid_pcolor_mat( grobj%struct%abs_mat,            &
                                       grobj%struct%ord_mat,            &
                                       nx, ny,                          &
                                       grobj%struct%ir )
         else ! -2
            ! (x,y) vec
            i_step = grobj%struct%ir(1)
            j_step = grobj%struct%ir(2)
            call draw_grid_pcolor_vec( i_max+1, i_step,                 &
                                       j_max+1, j_step,                 &
                                       win%axis_scale_x,                &
                                       win%axis_scale_y,                &
                                       grobj%struct%npt3==-2,           &
                                       grobj%struct%abs_tab,            &
                                       grobj%struct%ord_tab )
         end if
      end if

      if( PRINTING_EPS ) then
         call EPS_clip_on_viewport_end()
         if( COMMENTS_IN_EPS ) then
            ibuf(1) = 0
            call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- end of Pcolor", 0 )
         end if
      end if
      if( PRINTING_PDF ) then
         if( COMMENTS_IN_PDF ) then
            call pdf_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- end of Pcolor", 0 )
         end if
         call gresc("")
      end if

   end subroutine mf_pcolor_draw
!_______________________________________________________________________
!
   subroutine mf_pcolor_proj_draw( grobj )

      type(grobj_elem), intent(in) :: grobj
      !------ API end ------

      ! grobj type = "pcolor_proj"

      type(mf_win_info), pointer :: win

      integer :: ni, nj, grid_icol, grid_step(2)
      logical :: flat, draw_grid, lighting
      real(kind=MF_DOUBLE) :: scaling_xyz(3)

      real(kind=MF_DOUBLE) :: rbuf(1)
      integer :: ibuf(1)

   !------ end of declarations -- execution starts hereafter  ------

      if( PRINTING_EPS ) then
         if( COMMENTS_IN_EPS ) then
            ibuf(1) = 0
            call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- begin of Pcolor (proj.)", 0 )
         end if
      end if
      if( PRINTING_PDF ) then
         if( COMMENTS_IN_PDF ) then
            call pdf_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- begin of Pcolor (proj.)", 0 )
         end if
      end if

      win => mf_win_db(CURRENT_WIN_ID)

      ni = size(grobj%struct%val_mat,1) ! rows    = ny
      nj = size(grobj%struct%val_mat,2) ! columns = nx
      if( win%shading == "flat" ) then
         flat = .true.
      else
         flat = .false.
      end if
      draw_grid = grobj%struct%bool1
      grid_icol = grobj%struct%color
      grid_step = grobj%struct%ir
      lighting = grobj%struct%bool3
      if( lighting ) then
         scaling_xyz = grobj%struct%jc
      end if
      if( grobj%struct%marker == 1 ) then
         ! "XZ"-like projection
         if( grobj%struct%npt == -1 ) then
            ! absc present
            if( grobj%struct%bool2 ) then
               ! forward view
               call pg2dproj_x( grobj%struct%val_mat, ni, nj,           &
                                .true., flat,                           &
                                draw_grid, grid_icol, grid_step,        &
                                xx=grobj%struct%abs_tab,                &
                                yy=grobj%struct%ord_tab,                &
                                lighting=lighting,                      &
                                scaling_xyz=scaling_xyz )
            else ! backward view
               call pg2dproj_x( grobj%struct%val_mat, ni, nj,           &
                                .false., flat,                          &
                                draw_grid, grid_icol, grid_step,        &
                                xx=grobj%struct%abs_tab,                &
                                yy=grobj%struct%ord_tab,                &
                                lighting=lighting,                      &
                                scaling_xyz=scaling_xyz )
            end if
         else ! absc not present
            if( grobj%struct%bool2 ) then
               ! forward view
               call pg2dproj_x( grobj%struct%val_mat, ni, nj,           &
                                .true., flat,                           &
                                draw_grid, grid_icol, grid_step )
            else ! backward view
               call pg2dproj_x( grobj%struct%val_mat, ni, nj,           &
                                .false., flat,                          &
                                draw_grid, grid_icol, grid_step )
            end if
         end if
      else
         ! "YZ"-like projection
         if( grobj%struct%npt == -1 ) then
            ! absc present
            if( grobj%struct%bool2 ) then
               ! forward view
               call pg2dproj_y( grobj%struct%val_mat, ni, nj,           &
                                .true., flat,                           &
                                draw_grid, grid_icol, grid_step,        &
                                xx=grobj%struct%abs_tab,                &
                                yy=grobj%struct%ord_tab,                &
                                lighting=lighting,                      &
                                scaling_xyz=scaling_xyz )
            else ! backward view
               call pg2dproj_y( grobj%struct%val_mat, ni, nj,           &
                                .false., flat,                          &
                                draw_grid, grid_icol, grid_step,        &
                                xx=grobj%struct%abs_tab,                &
                                yy=grobj%struct%ord_tab,                &
                                lighting=lighting,                      &
                                scaling_xyz=scaling_xyz )
            end if
         else ! absc not present
            if( grobj%struct%bool2 ) then
               ! forward view
               call pg2dproj_y( grobj%struct%val_mat, ni, nj,           &
                                .true., flat,                           &
                                draw_grid, grid_icol, grid_step )
            else ! backward view
               call pg2dproj_y( grobj%struct%val_mat, ni, nj,           &
                                .false., flat,                          &
                                draw_grid, grid_icol, grid_step )
            end if
         end if
      end if

      if( PRINTING_EPS ) then
         if( COMMENTS_IN_EPS ) then
            ibuf(1) = 0
            call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- end of Pcolor (proj.)", 0 )
         end if
      end if
      if( PRINTING_PDF ) then
         if( COMMENTS_IN_PDF ) then
            call pdf_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- end of Pcolor (proj.)", 0 )
         end if
      end if

   end subroutine mf_pcolor_proj_draw
!_______________________________________________________________________
!
   subroutine mf_pcolor_mat_proj_draw( grobj )

      type(grobj_elem), intent(in) :: grobj
      !------ API end ------

      ! grobj type = "pcolor_mat_proj"

      type(mf_win_info), pointer :: win

      logical :: flat, lighting, draw_grid
      integer :: ni, nj, grid_icol, grid_step(2)
      real(kind=MF_DOUBLE) :: scaling_xyz(3), ref_l_gd

      real(kind=MF_DOUBLE) :: rbuf(1)
      integer :: ibuf(1)

   !------ end of declarations -- execution starts hereafter  ------

      if( PRINTING_EPS ) then
         if( COMMENTS_IN_EPS ) then
            ibuf(1) = 0
            call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- begin of Pcolor (mat. proj.)", 0 )
         end if
      end if
      if( PRINTING_PDF ) then
         if( COMMENTS_IN_PDF ) then
            call pdf_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- begin of Pcolor (mat. proj.)", 0 )
         end if
      end if

      win => mf_win_db(CURRENT_WIN_ID)

      ni = size(grobj%struct%val_mat,1)
      nj = size(grobj%struct%val_mat,2)
      if( win%shading == "flat" ) then
         flat = .true.
      else
         flat = .false.
      end if
      draw_grid = grobj%struct%bool1
      grid_icol = grobj%struct%color
      grid_step = grobj%struct%ir
      lighting = grobj%struct%bool3
      if( lighting ) then
         scaling_xyz = grobj%struct%jc
      end if
      if( draw_grid ) then
         ref_l_gd = grobj%struct%markersize
      end if
      if( grobj%struct%marker == 1 ) then
         ! "XZ"-like projection
         call pg2dproj_matx( grobj%struct%val_mat,                      &
                             grobj%struct%abs_mat,                      &
                             grobj%struct%ord_mat, ni, nj,              &
                             grobj%struct%bool2, flat,                  &
                             draw_grid, grid_icol, grid_step,           &
                             ref_l_gd, lighting=lighting,               &
                             scaling_xyz=scaling_xyz )
      else
         ! "YZ"-like projection
         call pg2dproj_maty( grobj%struct%val_mat,                      &
                             grobj%struct%abs_mat,                      &
                             grobj%struct%ord_mat, ni, nj,              &
                             grobj%struct%bool2, flat,                  &
                             draw_grid, grid_icol, grid_step,           &
                             ref_l_gd, lighting=lighting,               &
                             scaling_xyz=scaling_xyz )
      end if

      if( PRINTING_EPS ) then
         if( COMMENTS_IN_EPS ) then
            ibuf(1) = 0
            call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- end of Pcolor (mat. proj.)", 0 )
         end if
      end if
      if( PRINTING_PDF ) then
         if( COMMENTS_IN_PDF ) then
            call pdf_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- end of Pcolor (mat. proj.)", 0 )
         end if
      end if

   end subroutine mf_pcolor_mat_proj_draw
