!
! codes for mf_pcolor_draw and get_true_min_max:
!
!   grobj%struct%npt  = -1 : (x,y) present
!                       -2 : (x,y) not present
!
!   grobj%struct%npt2 = -1 : (x,y) mat
!                       -2 : (x,y) vec
!
!   grobj%struct%npt3 = -1 : vertex centered [default]
!                       -2 :   cell centered
!

!_______________________________________________________________________
!
   function PcolorCoreMat( mat, cell_centered, x, y,                    &
                           view_type, draw_grid, grid_icol, grid_step ) &
   result( handle )

      real(kind=MF_DOUBLE), pointer            :: mat(:,:)
      logical,                      intent(in) :: cell_centered
      real(kind=MF_DOUBLE), pointer            :: x(:,:), y(:,:)
      logical,                      intent(in) :: draw_grid
      integer,                      intent(in) :: view_type, grid_icol
      integer,                      intent(in) :: grid_step(2)

      integer :: handle
      !------ API end ------

      type(mf_win_info), pointer :: win
      type(grobj_elem), pointer :: grobj

      real(kind=MF_DOUBLE) :: range(4)

      integer :: hdle
      integer :: itmp
      character(len=3) :: answer
      logical :: device_has_cursor

   !------ end of declarations -- execution starts hereafter  ------

      call pgbbuf()

      ! les [nouveaux] axes doivent être prêts
      range(1) = minval( x(:,:) ) ! x_min
      range(2) = maxval( x(:,:) ) ! x_max
      range(3) = minval( y(:,:) ) ! y_min
      range(4) = maxval( y(:,:) ) ! y_max

      call mf_prepare_axes( CURRENT_WIN_ID, range )

      win => mf_win_db(CURRENT_WIN_ID)

      ! plotting something is always clipped at viewport
      if( X11_DEVICE ) then
         ! caution: axes must have been defined before
         call X11_clip_on_viewport()
      end if

      handle = 0

!++++++++++++++++++ Storage in DB ++++++++++++++++++

      ! new grobj
      if( win%mf_win_db_active ) then
         ! create a new grobj and insert it in the linked list
         call create_grobj( win, grobj )
      else
         ! just allocate the grobj
         allocate( grobj )
      end if

      grobj%struct%cmd = "pcolor"
      grobj%struct%range = range
      grobj%struct%npt = -1
      grobj%struct%npt2 = -1
      if( cell_centered ) then
         grobj%struct%npt3 = -2
      else ! vertex centered
         grobj%struct%npt3 = -1
      end if
      grobj%struct%val_mat => mat
      grobj%struct%abs_mat => x
      grobj%struct%ord_mat => y
      grobj%struct%bool1 = draw_grid
      grobj%struct%color = grid_icol
      allocate( grobj%struct%ir(2) )
      grobj%struct%ir = grid_step

      if( win%mf_win_db_active ) then

         hdle = mf_win_get_free_handle(CURRENT_WIN_ID)
         win%handles(hdle)%ptr => grobj
         grobj%struct%hdle = hdle
         handle = encode_handle( CURRENT_WIN_ID, hdle )

      end if

!+++++++++++++++++++++++++++++++++++++++++++++++++++

!------------------ Drawing GrObj ------------------

      ! inquiring if the device has a cursor
      call pgqinf( "CURSOR", answer, itmp )
      if( to_lower(answer) == "yes" ) then
         device_has_cursor = .true.
         itmp = gr_set_cursor_shape( MF_WATCH_CURSOR )
      else
         device_has_cursor = .false.
      end if

      call mf_pcolor_draw( grobj )

      call pgebuf()

      if( device_has_cursor ) then
         itmp = gr_set_cursor_shape( MF_LEFT_ARROW_CURSOR )
      end if

!---------------------------------------------------

      if( .not. win%mf_win_db_active ) then
         call delete_grobj_inside( grobj )
         deallocate( grobj )
         ! x, y and mat already deallocated by 'delete_grobj_inside'
      end if

      win%blank = .false.
      win%empty = .false.

   end function PcolorCoreMat
!_______________________________________________________________________
!
   function PcolorCoreMat_XZ( mat, x, y,                                &
                              view_type, draw_grid, grid_icol, grid_step, &
                              lighting )                                &
   result( handle )

      real(kind=MF_DOUBLE), pointer            :: mat(:,:), x(:,:), y(:,:)
      logical,                      intent(in) :: draw_grid
      integer,                      intent(in) :: view_type, grid_icol
      integer,                      intent(in) :: grid_step(2)
      logical,                      intent(in) :: lighting

      integer :: handle
      !------ API end ------

      ! Case only for view_type=+4 ("XZf")
      !                         -4 ("XZb")

      type(mf_win_info), pointer :: win
      type(grobj_elem), pointer :: grobj

      real(kind=MF_DOUBLE) :: range(4)

      integer :: i, j, ni, nj, hdle
      real(kind=MF_DOUBLE) :: x_min, x_max, y_min, y_max, z_min, z_max
      real(kind=MF_DOUBLE) :: scaling_xyz(3), ref_l_grid
      logical :: flat, forward
      integer :: itmp
      character(len=3) :: answer
      logical :: device_has_cursor

   !------ end of declarations -- execution starts hereafter  ------

      handle = 0

      if( abs(view_type) /= 4 ) then
         print *, "PcolorCoreMat_XZ: internal error. Bad value for side_view."
         pause "only for debugging purpose"
         stop
      end if

      call pgbbuf()

      ni = size(mat,1) ! rows    = ny
      nj = size(mat,2) ! columns = nx

      ! Take care that, hereafter, due to projection, there is a change
      ! for the name of axis:
      !        new X-axis takes its values in x(:,:)
      !        new Y-axis   "    "    "    in mat(:,:)
      !

      x_min = minval( x )
      x_max = maxval( x )

      y_min = minval( y )
      y_max = maxval( y )

      z_min = minval( mat )
      z_max = maxval( mat )

      ! les [nouveaux] axes doivent être prêts
      ! backward view
      range(1) = x_min ! 'x' min
      range(2) = x_max ! 'x' max
      range(3) = z_min ! 'y' min
      range(4) = z_max ! 'y' max

      if( view_type < 0 ) then
         ! backward view
         range(1:2) = [ range(2), range(1) ]
      end if

      win => mf_win_db(CURRENT_WIN_ID)

      call mf_prepare_axes( CURRENT_WIN_ID, range )

!### TODO: je ne vois pas pourquoi... laissons l'utilisateur décider !
      ! dans PColor, on force les axes à être 'auto'
      ! sinon, pb après msClf() ou après msSpy()...
!!      win%axis_manual = 0

      if( lighting ) then
         scaling_xyz(1) = x_max - x_min
         scaling_xyz(2) = y_max - y_min
         scaling_xyz(3) = z_max - z_min
      end if

      ! plotting something is always clipped at viewport
      if( X11_DEVICE ) then
         ! caution: axes must have been defined before
         call X11_clip_on_viewport()
      end if

      if( draw_grid ) then
         ref_l_grid = max( x_max-x_min, z_max-z_min )
      end if

!++++++++++++++++++ Storage in DB ++++++++++++++++++

      ! new grobj
      if( win%mf_win_db_active ) then
         ! create a new grobj and insert it in the linked list
         call create_grobj( win, grobj )
      else
         ! just allocate the grobj
         allocate( grobj )
      end if

      grobj%struct%cmd = "pcolor_mat_proj"
      grobj%struct%range = range
      grobj%struct%val_mat => mat
      grobj%struct%abs_mat => x
      grobj%struct%ord_mat => y

      grobj%struct%bool1 = draw_grid
      grobj%struct%color = grid_icol
      allocate( grobj%struct%ir(2) )
      grobj%struct%ir = grid_step
      grobj%struct%bool3 = lighting
      allocate( grobj%struct%jc(3) )
      grobj%struct%jc = scaling_xyz
      grobj%struct%markersize = ref_l_grid

      if( view_type > 0 ) then
         ! forward view
         grobj%struct%bool2 = .true.
      else
         ! backward view
         grobj%struct%bool2 = .false.
      end if
      grobj%struct%marker = 1 ! "XZ"

      if( win%mf_win_db_active ) then

         hdle = mf_win_get_free_handle(CURRENT_WIN_ID)
         win%handles(hdle)%ptr => grobj
         grobj%struct%hdle = hdle
         handle = encode_handle( CURRENT_WIN_ID, hdle )

      end if

!+++++++++++++++++++++++++++++++++++++++++++++++++++

!------------------ Drawing GrObj ------------------

      ! inquiring if the device has a cursor
      call pgqinf( "CURSOR", answer, itmp )
      if( to_lower(answer) == "yes" ) then
         device_has_cursor = .true.
         itmp = gr_set_cursor_shape( MF_WATCH_CURSOR )
      else
         device_has_cursor = .false.
      end if

      call mf_pcolor_mat_proj_draw( grobj )

      call pgebuf()

      if( device_has_cursor ) then
         itmp = gr_set_cursor_shape( MF_LEFT_ARROW_CURSOR )
      end if

!---------------------------------------------------

      if( .not. win%mf_win_db_active ) then
         call delete_grobj_inside( grobj )
         deallocate( grobj )
         ! icol_sto_pg already deallocated by 'delete_grobj_inside'
      end if

      win%blank = .false.
      win%empty = .false.

   end function PcolorCoreMat_XZ
!_______________________________________________________________________
!
   function PcolorCoreMat_YZ( mat, x, y,                                &
                              view_type, draw_grid, grid_icol, grid_step, &
                              lighting )                                &
   result( handle )

      real(kind=MF_DOUBLE), pointer            :: mat(:,:), x(:,:), y(:,:)
      logical,                      intent(in) :: draw_grid
      integer,                      intent(in) :: view_type, grid_icol
      integer,                      intent(in) :: grid_step(2)
      logical,                      intent(in) :: lighting

      integer :: handle
      !------ API end ------

      ! Case only for view_type=+3 ("YZf")
      !                         -3 ("YZb")

      type(mf_win_info), pointer :: win
      type(grobj_elem), pointer :: grobj

      real(kind=MF_DOUBLE) :: range(4)

      integer :: i, j, ni, nj, hdle
      real(kind=MF_DOUBLE) :: x_min, x_max, y_min, y_max, z_min, z_max
      real(kind=MF_DOUBLE) :: scaling_xyz(3), ref_l_grid
      logical :: flat, forward
      integer :: itmp
      character(len=3) :: answer
      logical :: device_has_cursor

   !------ end of declarations -- execution starts hereafter  ------

      handle = 0

      if( abs(view_type) /= 3 ) then
         print *, "PcolorCoreMat_YZ: internal error. Bad value for side_view."
         pause "only for debugging purpose"
         stop
      end if

      call pgbbuf()

      ni = size(mat,1) ! rows    = ny
      nj = size(mat,2) ! columns = nx

      ! Take care that, hereafter, due to projection, there is a change
      ! for the name of axis:
      !        new X-axis takes its values in y(:,:)
      !        new Y-axis   "    "    "    in mat(:,:)
      !

      x_min = minval( x )
      x_max = maxval( x )

      y_min = minval( y )
      y_max = maxval( y )

      z_min = minval( mat )
      z_max = maxval( mat )

      ! les [nouveaux] axes doivent être prêts
      ! backward view
      range(1) = y_min ! 'x' min
      range(2) = y_max ! 'x' max
      range(3) = z_min ! 'y' min
      range(4) = z_max ! 'y' max

      if( view_type > 0 ) then
         ! forward view
         range(1:2) = [ range(2), range(1) ]
      end if

      win => mf_win_db(CURRENT_WIN_ID)

      call mf_prepare_axes( CURRENT_WIN_ID, range )

!### TODO: je ne vois pas pourquoi... laissons l'utilisateur décider !
      ! dans PColor, on force les axes à être 'auto'
      ! sinon, pb après msClf() ou après msSpy()...
!!      win%axis_manual = 0

      if( lighting ) then
         scaling_xyz(1) = x_max - x_min
         scaling_xyz(2) = y_max - y_min
         scaling_xyz(3) = z_max - z_min
      end if

      ! plotting something is always clipped at viewport
      if( X11_DEVICE ) then
         ! caution: axes must have been defined before
         call X11_clip_on_viewport()
      end if

      if( draw_grid ) then
         ref_l_grid = max( y_max-y_min, z_max-z_min )
      end if

!++++++++++++++++++ Storage in DB ++++++++++++++++++

      ! new grobj
      if( win%mf_win_db_active ) then
         ! create a new grobj and insert it in the linked list
         call create_grobj( win, grobj )
      else
         ! just allocate the grobj
         allocate( grobj )
      end if

      grobj%struct%cmd = "pcolor_mat_proj"
      grobj%struct%range = range
      grobj%struct%val_mat => mat
      grobj%struct%abs_mat => x
      grobj%struct%ord_mat => y

      grobj%struct%bool1 = draw_grid
      grobj%struct%color = grid_icol
      allocate( grobj%struct%ir(2) )
      grobj%struct%ir = grid_step
      grobj%struct%bool3 = lighting
      allocate( grobj%struct%jc(3) )
      grobj%struct%jc = scaling_xyz
      grobj%struct%markersize = ref_l_grid

      if( view_type > 0 ) then
         ! forward view
         grobj%struct%bool2 = .true.
      else
         ! backward view
         grobj%struct%bool2 = .false.
      end if
      grobj%struct%marker = 2 ! "YZ"

      if( win%mf_win_db_active ) then

         hdle = mf_win_get_free_handle(CURRENT_WIN_ID)
         win%handles(hdle)%ptr => grobj
         grobj%struct%hdle = hdle
         handle = encode_handle( CURRENT_WIN_ID, hdle )

      end if

!+++++++++++++++++++++++++++++++++++++++++++++++++++

!------------------ Drawing GrObj ------------------

      ! inquiring if the device has a cursor
      call pgqinf( "CURSOR", answer, itmp )
      if( to_lower(answer) == "yes" ) then
         device_has_cursor = .true.
         itmp = gr_set_cursor_shape( MF_WATCH_CURSOR )
      else
         device_has_cursor = .false.
      end if

      call mf_pcolor_mat_proj_draw( grobj )

      call pgebuf()

      if( device_has_cursor ) then
         itmp = gr_set_cursor_shape( MF_LEFT_ARROW_CURSOR )
      end if

!---------------------------------------------------

      if( .not. win%mf_win_db_active ) then
         call delete_grobj_inside( grobj )
         deallocate( grobj )
         ! icol_sto_pg already deallocated by 'delete_grobj_inside'
      end if

      win%blank = .false.
      win%empty = .false.

   end function PcolorCoreMat_YZ
!_______________________________________________________________________
!
   function PcolorCoreVec( mat, cell_centered, x, y,                    &
                           view_type, draw_grid, grid_icol, grid_step )                                  &
   result( handle )

      real(kind=MF_DOUBLE), pointer            :: mat(:,:)
      logical,                      intent(in) :: cell_centered
      real(kind=MF_DOUBLE), pointer,  optional :: x(:), y(:)
      logical,                      intent(in) :: draw_grid
      integer,                      intent(in) :: view_type, grid_icol
      integer,                      intent(in) :: grid_step(2)

      integer :: handle
      !------ API end ------

      ! Case only for view_type=0 ("ji") or ("XY")

      ! Caution : different convention as Matlab
      ! i -> y (inversed)
      ! j -> x                       (idem Spy)

      ! Here, cells' shape is always rectangular.

      type(mf_win_info), pointer :: win
      type(grobj_elem), pointer :: grobj

      real(kind=MF_DOUBLE) :: range(4)

      integer :: i, ni, nj, hdle
      logical :: x_and_y_present
      real(kind=MF_DOUBLE) :: dir_x, dir_y
      integer :: itmp
      character(len=3) :: answer
      logical :: device_has_cursor

   !------ end of declarations -- execution starts hereafter  ------

      call pgbbuf()

      if( view_type /= 0 ) then
         print *, "PcolorCoreVec: internal error. Bad value for side_view."
         pause "only for debugging purpose"
         stop
      end if

      ni = size(mat,1) ! rows    = ny
      nj = size(mat,2) ! columns = nx

      x_and_y_present = present(x) .and. present(y)

      handle = 0

      ! last check on values in 'x' and 'y' (difficult to do in the
      ! calling routine!): these vectors must be strictly monotonous
      ! (i.e. two consecutive values cannot be equal)
      if( x_and_y_present ) then
         ! Detect ordering in 'x'
         dir_x = x(2) - x(1)
         if( dir_x == 0.0d0 ) then
            call PrintMessage( "PColor", "E",                           &
                               "'x' must contain strictly monotonous values!" )
            return
         end if
         do i = 3, size(x)
            if( (x(i) - x(i-1))*dir_x <= 0.0d0 ) then
               call PrintMessage( "PColor", "E",                        &
                                  "'x' must contain strictly monotonous values!" )
               return
            end if
         end do
         ! Detect ordering in 'y'
         dir_y = y(2) - y(1)
         if( dir_y == 0.0d0 ) then
            call PrintMessage( "PColor", "E",                           &
                               "'y' must contain strictly monotonous values!" )
            return
         end if
         do i = 3, size(y)
            if( (y(i) - y(i-1))*dir_y <= 0.0d0 ) then
               call PrintMessage( "PColor", "E",                        &
                                  "'y' must contain strictly monotonous values!" )
               return
            end if
         end do
      end if

      ! les [nouveaux] axes doivent être prêts
      if( x_and_y_present ) then
         range(1) = min( x(1), x(nj) ) ! x_min
         range(2) = max( x(1), x(nj) ) ! x_max
         range(3) = min( y(1), y(ni) ) ! y_min
         range(4) = max( y(1), y(ni) ) ! y_max
      else
         if( cell_centered ) then
            range(:) = [ 0.5, nj+0.5, ni+0.5, 0.5 ]
         else ! vertex centered
            range(:) = [ 1, nj, ni, 1 ]
         end if
      end if

      win => mf_win_db(CURRENT_WIN_ID)

      call mf_prepare_axes( CURRENT_WIN_ID, range )

!### TODO: je ne vois pas pourquoi... laissons l'utilisateur décider !
      ! dans PColor, on force les axes à être 'auto'
      ! sinon, pb après msClf() ou après msSpy()...
!!      win%axis_manual = 0

      ! plotting something is always clipped at viewport
      if( X11_DEVICE ) then
         ! caution: axes must have been defined before
         call X11_clip_on_viewport()
      end if

!++++++++++++++++++ Storage in DB ++++++++++++++++++

      ! new grobj
      if( win%mf_win_db_active ) then
         ! create a new grobj and insert it in the linked list
         call create_grobj( win, grobj )
      else
         ! just allocate the grobj
         allocate( grobj )
      end if

      grobj%struct%cmd = "pcolor"
      grobj%struct%range = range
      grobj%struct%val_mat => mat
      if( x_and_y_present ) then
         grobj%struct%npt = -1
         grobj%struct%npt2 = -2
         grobj%struct%abs_tab => x
         grobj%struct%ord_tab => y
      else
         grobj%struct%npt = -2
      end if
      if( cell_centered ) then
         grobj%struct%npt3 = -2
      else
         grobj%struct%npt3 = -1
      end if
      grobj%struct%bool1 = draw_grid
!### TODO: à revoir ?
grobj%struct%bool2 = .true. ! Integer X labelling
grobj%struct%bool3 = .true. ! Integer Y labelling
      grobj%struct%color = grid_icol
      allocate( grobj%struct%ir(2) )
      grobj%struct%ir = grid_step

      if( win%mf_win_db_active ) then

         hdle = mf_win_get_free_handle(CURRENT_WIN_ID)
         win%handles(hdle)%ptr => grobj
         grobj%struct%hdle = hdle
         handle = encode_handle( CURRENT_WIN_ID, hdle )

      end if

!+++++++++++++++++++++++++++++++++++++++++++++++++++

!------------------ Drawing GrObj ------------------

      ! inquiring if the device has a cursor
      call pgqinf( "CURSOR", answer, itmp )
      if( to_lower(answer) == "yes" ) then
         device_has_cursor = .true.
         itmp = gr_set_cursor_shape( MF_WATCH_CURSOR )
      else
         device_has_cursor = .false.
      end if

      call mf_pcolor_draw( grobj )

      call pgebuf()

      if( device_has_cursor ) then
         itmp = gr_set_cursor_shape( MF_LEFT_ARROW_CURSOR )
      end if

!---------------------------------------------------

      if( .not. win%mf_win_db_active ) then
         call delete_grobj_inside( grobj )
         deallocate( grobj )
         ! x, y and mat already deallocated (if needed) by 'delete_grobj_inside'
      end if

      win%blank = .false.
      win%empty = .false.

   end function PcolorCoreVec
!_______________________________________________________________________
!
   function PcolorCoreVec_XZ( mat, cell_centered, x, y,                 &
                              view_type, draw_grid, grid_icol, grid_step, &
                              lighting )                                &
   result( handle )

      real(kind=MF_DOUBLE), pointer            :: mat(:,:)
      logical,                      intent(in) :: cell_centered
      real(kind=MF_DOUBLE), pointer,  optional :: x(:), y(:)
      logical,                      intent(in) :: draw_grid
      integer,                      intent(in) :: view_type, grid_icol
      integer,                      intent(in) :: grid_step(2)
      logical,                      intent(in) :: lighting

      integer :: handle
      !------ API end ------

      ! case only for view_type=+2 ("jZf") or +4 ("XZf")
      !                         -2 ("jZb") or -4 ("XZb")

      ! Attention : convention différente de Matlab
      ! i -> y (inversed)
      ! j -> x                       (idem Spy)

      type(mf_win_info), pointer :: win
      type(grobj_elem), pointer :: grobj

      real(kind=MF_DOUBLE) :: range(4)

      integer :: i, j, ni, nj, hdle
      real(kind=MF_DOUBLE) :: x_min, x_max, y_min, y_max, z_min, z_max
      real(kind=MF_DOUBLE) :: scaling_xyz(3)
      integer :: itmp
      character(len=3) :: answer
      logical :: device_has_cursor

   !------ end of declarations -- execution starts hereafter  ------

      handle = 0

      if( abs(view_type) /= 2 .and. abs(view_type) /= 4 ) then
         print *, "PcolorCoreVec_XZ: internal error. Bad value for side_view."
         pause "only for debugging purpose"
         stop
      end if

      ni = size(mat,1) ! rows    = ny
      nj = size(mat,2) ! columns = nx

      ! last check on values in 'y' (difficult to do in the calling routine!):
      ! these vectors must be strictly monotonous
      ! (i.e. two consecutive values cannot be equal)
      if( present(x) ) then
         do i = 2, size(x)
            if( x(i) == x(i-1) ) then
               call PrintMessage( "PColor", "E",                        &
                                  "'x' must contain strictly monotonous values!" )
               return
            end if
         end do
      end if

      call pgbbuf()

      ! Take care that, hereafter, due to projection, there is a change
      ! for the name of axis:
      !        new X-axis takes its values in x(:)
      !        new Y-axis   "    "    "    in mat(:,:)

      z_min = minval( mat )
      z_max = maxval( mat )

      ! les [nouveaux] axes doivent être prêts
      ! forward view
      if( present(x) ) then
         x_min = min( x(1), x(size(x)) )
         x_max = max( x(1), x(size(x)) )
         y_min = min( y(1), y(size(y)) )
         y_max = max( y(1), y(size(y)) )
         range(1) = x_min
         range(2) = x_max
         range(3) = z_min                   ! y_min
         range(4) = z_max                   ! y_max
      else
         if( cell_centered ) then
            call PrintMessage( "PColor", "E",                           &
                               "'data_centering' equal to 'cell' cannot be used", &
                               "when using projection onto the XY or YZ axes." )
            return
         else ! vertex centered
            range(:) = [ 1.0d0, dble(nj), z_min, z_max ]
         end if
      end if

      if( view_type < 0 ) then
         ! backward view
         range(1:2) = [ range(2), range(1) ]
      end if

      win => mf_win_db(CURRENT_WIN_ID)

      call mf_prepare_axes( CURRENT_WIN_ID, range )

!### TODO: je ne vois pas pourquoi... laissons l'utilisateur décider !
      ! dans PColor, on force les axes à être 'auto'
      ! sinon, pb après msClf() ou après msSpy()...
!!      win%axis_manual = 0

      if( lighting ) then
         scaling_xyz(1) = x_max - x_min
         scaling_xyz(2) = y_max - y_min
         scaling_xyz(3) = z_max - z_min
      end if

      ! plotting something is always clipped at viewport
      if( X11_DEVICE ) then
         ! caution: axes must have been defined before
         call X11_clip_on_viewport()
      end if

!++++++++++++++++++ Storage in DB ++++++++++++++++++

      ! new grobj
      if( win%mf_win_db_active ) then
         ! create a new grobj and insert it in the linked list
         call create_grobj( win, grobj )
      else
         ! just allocate the grobj
         allocate( grobj )
      end if

      grobj%struct%cmd = "pcolor_proj"
      grobj%struct%range = range
      grobj%struct%val_mat => mat

      if( present(x) ) then
         grobj%struct%npt = -1
         grobj%struct%npt2 = -2
         grobj%struct%abs_tab => x
         grobj%struct%ord_tab => y
      else
         grobj%struct%npt = -2
      end if

      if( cell_centered ) then
         grobj%struct%npt3 = -2
      else
         grobj%struct%npt3 = -1
      end if

      grobj%struct%bool1 = draw_grid
!### TODO: prendre deux autres variables booléeennes ! J'ai codé un peu vite,
!          sans voir qu'elles étaient prises !
!          => ajouter 'bool4' et 'bool5' à grobj%struct
!!grobj%struct%bool2 = .true. ! Integer X labelling
!!grobj%struct%bool3 = .false. ! Integer Y labelling
      grobj%struct%color = grid_icol
      allocate( grobj%struct%ir(2) )
      grobj%struct%ir = grid_step
      grobj%struct%bool3 = lighting
      if( lighting ) then
         allocate( grobj%struct%jc(3) )
         grobj%struct%jc = scaling_xyz
      end if

      if( view_type > 0 ) then
         ! forward view
         grobj%struct%bool2 = .true.
      else
         ! backward view
         grobj%struct%bool2 = .false.
      end if
      grobj%struct%marker = 1 ! "XZ"

      if( win%mf_win_db_active ) then
         hdle = mf_win_get_free_handle(CURRENT_WIN_ID)
         win%handles(hdle)%ptr => grobj
         grobj%struct%hdle = hdle
         handle = encode_handle( CURRENT_WIN_ID, hdle )
      end if

!+++++++++++++++++++++++++++++++++++++++++++++++++++

      win%blank = .false.
      win%empty = .false.

!------------------ Drawing GrObj ------------------

      ! inquiring if the device has a cursor
      call pgqinf( "CURSOR", answer, itmp )
      if( to_lower(answer) == "yes" ) then
         device_has_cursor = .true.
         itmp = gr_set_cursor_shape( MF_WATCH_CURSOR )
      else
         device_has_cursor = .false.
      end if

      call mf_pcolor_proj_draw( grobj )

      call pgebuf()

      if( device_has_cursor ) then
         itmp = gr_set_cursor_shape( MF_LEFT_ARROW_CURSOR )
      end if

!---------------------------------------------------

      if( .not. win%mf_win_db_active ) then
         call delete_grobj_inside( grobj )
         deallocate( grobj )
      end if

   end function PcolorCoreVec_XZ
!_______________________________________________________________________
!
   function PcolorCoreVec_YZ( mat, cell_centered, x, y,                 &
                              view_type, draw_grid, grid_icol, grid_step, &
                              lighting )                                &
   result( handle )

      real(kind=MF_DOUBLE), pointer            :: mat(:,:)
      logical,                      intent(in) :: cell_centered
      real(kind=MF_DOUBLE), pointer,  optional :: x(:), y(:)
      logical,                      intent(in) :: draw_grid
      integer,                      intent(in) :: view_type, grid_icol
      integer,                      intent(in) :: grid_step(2)
      logical,                      intent(in) :: lighting

      integer :: handle
      !------ API end ------

      ! case only for view_type=+1 ("iZf") or +3 ("YZf")
      !                         -1 ("iZb") or -3 ("YZb")

      ! Attention : convention différente de Matlab
      ! i -> y (inversed)
      ! j -> x                       (idem Spy)

      type(mf_win_info), pointer :: win
      type(grobj_elem), pointer :: grobj

      real(kind=MF_DOUBLE) :: range(4)

      integer :: i, j, ni, nj, hdle
      real(kind=MF_DOUBLE) :: x_min, x_max, y_min, y_max, z_min, z_max
      real(kind=MF_DOUBLE) :: scaling_xyz(3)
      integer :: itmp
      character(len=3) :: answer
      logical :: device_has_cursor

   !------ end of declarations -- execution starts hereafter  ------

      handle = 0

      if( abs(view_type) /= 1 .and. abs(view_type) /= 3 ) then
         print *, "PcolorCoreVec_YZ: internal error. Bad value for side_view."
         pause "only for debugging purpose"
         stop
      end if

      ni = size(mat,1) ! rows    = ny
      nj = size(mat,2) ! columns = nx

      ! last check on values in 'y' (difficult to do in the calling routine!):
      ! these vectors must be strictly monotonous
      ! (i.e. two consecutive values cannot be equal)
      if( present(y) ) then
         do i = 2, size(y)
            if( y(i) == y(i-1) ) then
               call PrintMessage( "PColor", "E",                        &
                                  "'y' must contain strictly monotonous values!" )
               return
            end if
         end do
      end if

      call pgbbuf()

      ! Take care that, hereafter, due to projection, there is a change
      ! for the name of axis:
      !        new X-axis takes its values in y(:)
      !        new Y-axis   "    "    "    in mat(:,:)

      z_min = minval( mat )
      z_max = maxval( mat )

      ! les [nouveaux] axes doivent être prêts
      ! forward view
      if( present(y) ) then
         x_min = min( x(1), x(size(x)) )
         x_max = max( x(1), x(size(x)) )
         y_min = min( y(1), y(size(y)) )
         y_max = max( y(1), y(size(y)) )
         range(1) = y_min                   ! x_min
         range(2) = y_max                   ! x_max
         range(3) = z_min                   ! y_min
         range(4) = z_max                   ! y_max
      else
         if( cell_centered ) then
            call PrintMessage( "PColor", "E",                           &
                               "'data_centering' equal to 'cell' cannot be used", &
                               "when using projection onto the XY or YZ axes." )
            return
         else ! vertex centered
            range(:) = [ 1.0d0, dble(ni), z_min, z_max ]
         end if
      end if

      if( view_type < 0 ) then
         ! backward view
         range(1:2) = [ range(2), range(1) ]
      end if

      win => mf_win_db(CURRENT_WIN_ID)

      call mf_prepare_axes( CURRENT_WIN_ID, range )

!### TODO: je ne vois pas pourquoi... laissons l'utilisateur décider !
      ! dans PColor, on force les axes à être 'auto'
      ! sinon, pb après msClf() ou après msSpy()...
!!      win%axis_manual = 0

      if( lighting ) then
         scaling_xyz(1) = x_max - x_min
         scaling_xyz(2) = y_max - y_min
         scaling_xyz(3) = z_max - z_min
      end if

      ! plotting something is always clipped at viewport
      if( X11_DEVICE ) then
         ! caution: axes must have been defined before
         call X11_clip_on_viewport()
      end if

!++++++++++++++++++ Storage in DB ++++++++++++++++++

      ! new grobj
      if( win%mf_win_db_active ) then
         ! create a new grobj and insert it in the linked list
         call create_grobj( win, grobj )
      else
         ! just allocate the grobj
         allocate( grobj )
      end if

      grobj%struct%cmd = "pcolor_proj"
      grobj%struct%range = range
      grobj%struct%val_mat => mat

      if( present(y) ) then
         grobj%struct%npt = -1
         grobj%struct%npt2 = -2
         grobj%struct%abs_tab => x
         grobj%struct%ord_tab => y
      else
         grobj%struct%npt = -2
      end if

      if( cell_centered ) then
         grobj%struct%npt3 = -2
      else
         grobj%struct%npt3 = -1
      end if

      grobj%struct%bool1 = draw_grid
!### TODO: prendre deux autres variables booléeennes ! J'ai codé un peu vite,
!          sans voir qu'elles étaient prises !
!          => ajouter 'bool4' et 'bool5' à grobj%struct
!!grobj%struct%bool2 = .true. ! Integer X labelling
!!grobj%struct%bool3 = .false. ! Integer Y labelling
      grobj%struct%color = grid_icol
      allocate( grobj%struct%ir(2) )
      grobj%struct%ir = grid_step
      grobj%struct%bool3 = lighting
      if( lighting ) then
         allocate( grobj%struct%jc(3) )
         grobj%struct%jc = scaling_xyz
      end if

      if( view_type > 0 ) then
         ! forward view
         grobj%struct%bool2 = .true.
      else
         ! backward view
         grobj%struct%bool2 = .false.
      end if
      grobj%struct%marker = 2 ! "YZ"

      if( win%mf_win_db_active ) then
         hdle = mf_win_get_free_handle(CURRENT_WIN_ID)
         win%handles(hdle)%ptr => grobj
         grobj%struct%hdle = hdle
         handle = encode_handle( CURRENT_WIN_ID, hdle )
      end if

!+++++++++++++++++++++++++++++++++++++++++++++++++++

      win%blank = .false.
      win%empty = .false.

!------------------ Drawing GrObj ------------------

      ! inquiring if the device has a cursor
      call pgqinf( "CURSOR", answer, itmp )
      if( to_lower(answer) == "yes" ) then
         device_has_cursor = .true.
         itmp = gr_set_cursor_shape( MF_WATCH_CURSOR )
      else
         device_has_cursor = .false.
      end if

      call mf_pcolor_proj_draw( grobj )

      call pgebuf()

      if( device_has_cursor ) then
         itmp = gr_set_cursor_shape( MF_LEFT_ARROW_CURSOR )
      end if

!---------------------------------------------------

      if( .not. win%mf_win_db_active ) then
         call delete_grobj_inside( grobj )
         deallocate( grobj )
      end if

   end function PcolorCoreVec_YZ
