!_______________________________________________________________________
!
#ifdef _MF_FUNC
   function mfPcolor_z_str( z, data_centering, view,                    &
                            grid, grid_color, grid_step )               &
   result( handle )
#endif
#ifdef _MF_SUBR
   subroutine msPcolor_z_str( z, data_centering, view,                  &
                              grid, grid_color, grid_step )
#endif

      type(mfArray)                              :: z
      character(len=*),     intent(in), optional :: data_centering
      character(len=*),     intent(in), optional :: view
      logical,              intent(in), optional :: grid
      character(len=*),     intent(in)           :: grid_color
      integer,              intent(in), optional :: grid_step(2)

      integer :: handle
      !------ API end ------

      ! pointers for manipulating mfArray out of fml module
      real(kind=MF_DOUBLE), pointer :: z_ptr(:,:)
      real(kind=MF_DOUBLE), pointer :: mat_sto_pg(:,:)
      real(kind=MF_DOUBLE) :: z_min, z_max
      logical :: z_min_max_exist
      integer :: ni, nj, ier
      logical :: cell_centered, draw_grid
      integer :: grid_icol, view_type, grid_step_0(2)

      type(mf_win_info), pointer :: win
      integer :: mf_message_level_save

#ifdef _MF_FUNC
      character(len=*), parameter :: ROUTINE_NAME = "mfPcolor"
#endif
#ifdef _MF_SUBR
      character(len=*), parameter :: ROUTINE_NAME = "msPcolor"
#endif

   !------ end of declarations -- execution starts hereafter  ------

#ifdef _MF_FUNC
      handle = 0
#endif

      if( CURRENT_WIN_ID == 0 ) then
         call msFigure()
         if( CURRENT_WIN_ID == 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "cannot plot: no window created!" )
            go to 99
         end if
      end if

      call msInitArgs( z )

      ! checking that 'z' is allocated
      if( mfIsEqual(z,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'z' not allocated!" )
         go to 99
      end if

      ! 'z' must be Real
      if( .not. mfIsReal(z) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'z' must be real!" )
         go to 99
      end if

      ! 'z' cannot be sparse
      if( mfIsSparse(z) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'z' cannot be sparse!" )
         go to 99
      end if

      ! 'z' cannot contain NaN values
      if( Any(mfIsNaN(z)) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'z' cannot contain NaN values!" )
         go to 99
      end if

      ! optional data centering
      if( present(data_centering) ) then
         if( data_centering == "cell" ) then
            cell_centered = .true.
         else if( data_centering == "vertex" ) then
            cell_centered = .false.
         else
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "'data_centering' must be equal to 'vertex' or 'cell'!" )
            go to 99
         end if
      else
         cell_centered = .false.
      end if

      win => mf_win_db(CURRENT_WIN_ID)

      if( .not. win%colormap_init ) then
         call PrintMessage( trim(ROUTINE_NAME), "I",                    &
                            "Colormap has not yet been defined!",       &
                            "(default colormap is selected)" )
         call msColormap( "rainbow" )
      end if

      ! for printing in EPS and PDF...
      win%colormap_used = .true.

      ! 'ij' axis mode is selected
      win%axis_mode_xy = .false.
      ! If axis are in the 'manual' mode, keep them as is.
      if( win%axis_manual_x == 0 ) then
         win%axis_manual_x = 2 ! 'tight'
      end if
      if( win%axis_manual_y == 0 ) then
         win%axis_manual_y = 2 ! 'tight'
      end if
      call unset_smart_ticks_x()
      call unset_smart_ticks_y()

      if( cell_centered .and. win%shading /= "flat" ) then
         call PrintMessage( trim(ROUTINE_NAME), "W",                    &
                            "shading can be only flat for the cell-centered case!" )
      end if

      call msPointer( z, z_ptr, no_crc=.true. )

      ni = size(z_ptr,1)
      nj = size(z_ptr,2)

      if( .not. cell_centered ) then
         if( ni < 2 ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "number of rows is too small!",          &
                               '(hint: use data_centering="cell")' )
            go to 99
         end if
         if( nj < 2 ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "number of columns is too small!",       &
                               '(hint: use data_centering="cell")' )
            go to 99
         end if
      end if

      allocate( mat_sto_pg(ni,nj) )

      mat_sto_pg(:,:) = z_ptr(:,:)

      z_min_max_exist = .false.
      if( .not. win%color_axis_set ) then
         z_min = minval(mat_sto_pg(:,:))
         z_max = maxval(mat_sto_pg(:,:))
         z_min_max_exist = .true.
         call set_color_axis( win, [ z_min, z_max ] )
      end if

      ! warning if some data lead to color overflow (only for the
      ! shading="interp" case, because when shading is flat, this will
      ! be processed elsewhere)
      if( win%shading == "interp" ) then
         if( .not. z_min_max_exist ) then
            z_min = minval(mat_sto_pg(:,:))
            z_max = maxval(mat_sto_pg(:,:))
         end if
         if( z_min < win%color_axes(1) ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "data is out of Color Axis: (-)",        &
                               "-> this will lead to strange colors!" )
         end if
         if( z_max > win%color_axes(2) ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "data is out of Color Axis: (+)",        &
                               "-> this will lead to strange colors!" )
         end if
      end if

      call msFreePointer( z, z_ptr )

      if( present(grid) ) then
         draw_grid = grid
      else
         draw_grid = .false.
      end if

      if( len_trim(grid_color) == 1 .or. grid_color(1:1) == "\" ) then
         call decode_linespec( grid_color, grid_icol, ier=ier )
         if( ier /= 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                              "bad 'grid_color' argument!",             &
                              "(grid color will be set to light grey)" )
            grid_icol = -127
         end if
      else
         call decode_col_name( grid_color, grid_icol )
      end if

      if( grid_icol == -127 ) then
         grid_icol = MFPLOT_LIGHT_GREY
      end if

      if( present(grid_step) ) then
         grid_step_0(:) = grid_step(:)
         if( any( grid_step < 1 ) ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "'grid_step' must have all its components greater", &
                               "or equal than 1!",                      &
                               "(discarding provided values, and set grid_step to [1,1])" )
            grid_step_0(:) = [ 1, 1 ]
         end if
      else
         grid_step_0(:) = [ 1, 1 ]
      end if

      if( present(view) ) then
         select case( view )
            case( "ji" )
               view_type =  0
            case( "iZ", "iZf" )
               view_type =  1
            case( "iZb" )
               view_type = -1
            case( "jZ", "jZf" )
               view_type =  2
            case( "jZb" )
               view_type = -2
            case default
               call PrintMessage( trim(ROUTINE_NAME), "E",              &
                                  "when (x,y) are not present 'view' must be equal to", &
                                  "one of the following strings:",      &
                                  '"ji", "iZ", "iZb", "jZ", "jZb"' )
               go to 99
         end select
      else
         view_type = 0
      end if

      select case( view_type )

         case( 0 )
INTEGER_XLABEL( CURRENT_WIN_ID ) = .true.
INTEGER_YLABEL( CURRENT_WIN_ID ) = .true.
            handle = PcolorCoreVec( mat_sto_pg, cell_centered,          &
                                    view_type=view_type,                &
                                    draw_grid=draw_grid, grid_icol=grid_icol, &
                                    grid_step=grid_step_0 )

         case( 1, -1 )
INTEGER_XLABEL( CURRENT_WIN_ID ) = .false.
INTEGER_YLABEL( CURRENT_WIN_ID ) = .true.
            handle = PcolorCoreVec_YZ( mat_sto_pg, cell_centered,       &
                                       view_type=view_type,             &
                                       draw_grid=draw_grid, grid_icol=grid_icol, &
                                       grid_step=grid_step_0,           &
                                       lighting=.false. )

         case( 2, -2 )
INTEGER_XLABEL( CURRENT_WIN_ID ) = .true.
INTEGER_YLABEL( CURRENT_WIN_ID ) = .false.
            handle = PcolorCoreVec_XZ( mat_sto_pg, cell_centered,       &
                                       view_type=view_type,             &
                                       draw_grid=draw_grid, grid_icol=grid_icol, &
                                       grid_step=grid_step_0,           &
                                       lighting=.false. )

      end select

INTEGER_XLABEL( CURRENT_WIN_ID ) = .false.
INTEGER_YLABEL( CURRENT_WIN_ID ) = .false.

 99   continue

      call msFreeArgs( z )
      call msAutoRelease( z )

#ifdef _MF_FUNC
   end function mfPcolor_z_str
#endif
#ifdef _MF_SUBR
   end subroutine msPcolor_z_str
#endif
!_______________________________________________________________________
!
#ifdef _MF_FUNC
   function mfPcolor_z_rgb( z, data_centering, view,                    &
                            grid, grid_color, grid_step )               &
   result( handle )
#endif
#ifdef _MF_SUBR
   subroutine msPcolor_z_rgb( z, data_centering, view,                  &
                              grid, grid_color, grid_step )
#endif

      type(mfArray)                              :: z
      character(len=*),     intent(in), optional :: data_centering
      character(len=*),     intent(in), optional :: view
      logical,              intent(in), optional :: grid
      real(kind=MF_DOUBLE), intent(in), optional :: grid_color(3)
      integer,              intent(in), optional :: grid_step(2)

      integer :: handle
      !------ API end ------

      ! pointers for manipulating mfArray out of fml module
      real(kind=MF_DOUBLE), pointer :: z_ptr(:,:)
      real(kind=MF_DOUBLE), pointer :: mat_sto_pg(:,:)
      real(kind=MF_DOUBLE) :: z_min, z_max
      logical :: z_min_max_exist
      integer :: ni, nj
      logical :: cell_centered, draw_grid
      integer :: grid_icol, view_type, grid_step_0(2)

      type(mf_win_info), pointer :: win
      integer :: mf_message_level_save

#ifdef _MF_FUNC
      character(len=*), parameter :: ROUTINE_NAME = "mfPcolor"
#endif
#ifdef _MF_SUBR
      character(len=*), parameter :: ROUTINE_NAME = "msPcolor"
#endif

   !------ end of declarations -- execution starts hereafter  ------

#ifdef _MF_FUNC
      handle = 0
#endif

      if( CURRENT_WIN_ID == 0 ) then
         call msFigure()
         if( CURRENT_WIN_ID == 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "cannot plot: no window created!" )
            go to 99
         end if
      end if

      call msInitArgs( z )

      ! checking that 'z' is allocated
      if( mfIsEqual(z,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'z' not allocated!" )
         go to 99
      end if

      ! 'z' must be Real
      if( .not. mfIsReal(z) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'z' must be real!" )
         go to 99
      end if

      ! 'z' cannot be sparse
      if( mfIsSparse(z) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'z' cannot be sparse!" )
         go to 99
      end if

      ! 'z' cannot contain NaN values
      if( Any(mfIsNaN(z)) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'z' cannot contain NaN values!" )
         go to 99
      end if

      ! optional data centering
      if( present(data_centering) ) then
         if( data_centering == "cell" ) then
            cell_centered = .true.
         else if( data_centering == "vertex" ) then
            cell_centered = .false.
         else
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "'data_centering' must be equal to 'vertex' or 'cell'!" )
            go to 99
         end if
      else
         cell_centered = .false.
      end if

      win => mf_win_db(CURRENT_WIN_ID)

      if( .not. win%colormap_init ) then
         call PrintMessage( trim(ROUTINE_NAME), "I",                    &
                            "Colormap has not yet been defined!",       &
                            "(default colormap is selected)" )
         call msColormap( "rainbow" )
      end if

      win%colormap_used = .true.

      ! 'ij' axis mode is selected
      win%axis_mode_xy = .false.
      ! If axis are in the 'manual' mode, keep them as is.
      if( win%axis_manual_x == 0 ) then
         win%axis_manual_x = 2 ! 'tight'
      end if
      if( win%axis_manual_y == 0 ) then
         win%axis_manual_y = 2 ! 'tight'
      end if
      call unset_smart_ticks_x()
      call unset_smart_ticks_y()

      if( cell_centered .and. win%shading /= "flat" ) then
         call PrintMessage( trim(ROUTINE_NAME), "W",                    &
                            "shading can be only flat for the cell-centered case!" )
      end if

      call msPointer( z, z_ptr, no_crc=.true. )

      ni = size(z_ptr,1)
      nj = size(z_ptr,2)

      if( .not. cell_centered ) then
         if( ni < 2 ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "number of rows is too small!",          &
                               '(hint: use data_centering="cell")' )
            go to 99
         end if
         if( nj < 2 ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "number of columns is too small!",       &
                               '(hint: use data_centering="cell")' )
            go to 99
         end if
      end if

      allocate( mat_sto_pg(ni,nj) )

      mat_sto_pg(:,:) = z_ptr(:,:)

      z_min_max_exist = .false.
      if( .not. win%color_axis_set ) then
         z_min = minval(mat_sto_pg(:,:))
         z_max = maxval(mat_sto_pg(:,:))
         z_min_max_exist = .true.
         call set_color_axis( win, [ z_min, z_max ] )
      end if

      ! warning if some data lead to color overflow (only for the
      ! shading="interp" case, because when shading is flat, this will
      ! be processed elsewhere)
      if( win%shading == "interp" ) then
         if( .not. z_min_max_exist ) then
            z_min = minval(mat_sto_pg(:,:))
            z_max = maxval(mat_sto_pg(:,:))
         end if
         if( z_min < win%color_axes(1) ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "data is out of Color Axis: (-)",        &
                               "-> this will lead to strange colors!" )
         end if
         if( z_max > win%color_axes(2) ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "data is out of Color Axis: (+)",        &
                               "-> this will lead to strange colors!" )
         end if
      end if

      call msFreePointer( z, z_ptr )

      if( present(grid) ) then
         draw_grid = grid
      else
         draw_grid = .false.
      end if

      if( present(grid_color) ) then
         call decode_col_rgb( grid_color, grid_icol )
      else
         grid_icol = 1 ! foreground color
      end if

      if( present(grid_step) ) then
         grid_step_0(:) = grid_step(:)
         if( any( grid_step < 1 ) ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "'grid_step' must have all its components greater", &
                               "or equal than 1!",                      &
                               "(discarding provided values, and set grid_step to [1,1])" )
            grid_step_0(:) = [ 1, 1 ]
         end if
      else
         grid_step_0(:) = [ 1, 1 ]
      end if

      if( present(view) ) then
         select case( view )
            case( "ji" )
               view_type =  0
            case( "iZ", "iZf" )
               view_type =  1
            case( "iZb" )
               view_type = -1
            case( "jZ", "jZf" )
               view_type =  2
            case( "jZb" )
               view_type = -2
            case default
               call PrintMessage( trim(ROUTINE_NAME), "E",              &
                                  "when (x,y) are not present 'view' must be equal to", &
                                  "one of the following strings:",      &
                                  '"ji", "iZ", "iZb", "jZ", "jZb"' )
               go to 99
         end select
      else
         view_type = 0
      end if

      select case( view_type )

         case( 0 )
INTEGER_XLABEL( CURRENT_WIN_ID ) = .true.
INTEGER_YLABEL( CURRENT_WIN_ID ) = .true.
            handle = PcolorCoreVec( mat_sto_pg, cell_centered,          &
                                    view_type=view_type,                &
                                    draw_grid=draw_grid, grid_icol=grid_icol, &
                                    grid_step=grid_step_0 )

         case( 1, -1 )
INTEGER_XLABEL( CURRENT_WIN_ID ) = .false.
INTEGER_YLABEL( CURRENT_WIN_ID ) = .true.
            handle = PcolorCoreVec_YZ( mat_sto_pg, cell_centered,       &
                                       view_type=view_type,             &
                                       draw_grid=draw_grid, grid_icol=grid_icol, &
                                       grid_step=grid_step_0,           &
                                       lighting=.false. )

         case( 2, -2 )
INTEGER_XLABEL( CURRENT_WIN_ID ) = .true.
INTEGER_YLABEL( CURRENT_WIN_ID ) = .false.
            handle = PcolorCoreVec_XZ( mat_sto_pg, cell_centered,       &
                                       view_type=view_type,             &
                                       draw_grid=draw_grid, grid_icol=grid_icol, &
                                       grid_step=grid_step_0,           &
                                       lighting=.false. )

      end select

INTEGER_XLABEL( CURRENT_WIN_ID ) = .false.
INTEGER_YLABEL( CURRENT_WIN_ID ) = .false.

 99   continue

      call msFreeArgs( z )
      call msAutoRelease( z )

#ifdef _MF_FUNC
   end function mfPcolor_z_rgb
#endif
#ifdef _MF_SUBR
   end subroutine msPcolor_z_rgb
#endif
!_______________________________________________________________________
!
#ifdef _MF_FUNC
   function mfPcolor_xyz_str( x, y, z, data_centering, view,            &
                              grid, grid_color, grid_step, lighting )   &
   result( handle )
#endif
#ifdef _MF_SUBR
   subroutine msPcolor_xyz_str( x, y, z, data_centering, view,          &
                                grid, grid_color, grid_step, lighting )
#endif

      type(mfArray)                              :: x, y, z
      character(len=*),     intent(in), optional :: data_centering
      character(len=*),     intent(in), optional :: view
      logical,              intent(in), optional :: grid
      character(len=*),     intent(in)           :: grid_color
      integer,              intent(in), optional :: grid_step(2)
      logical,              intent(in), optional :: lighting

      integer :: handle
      !------ API end ------

      ! pointers for manipulating mfArray out of fml module
      real(kind=MF_DOUBLE), pointer :: x_ptr(:,:), y_ptr(:,:), z_ptr(:,:)
      real(kind=MF_DOUBLE), pointer :: x_sto_pg(:), y_sto_pg(:), mat_sto_pg(:,:)
      real(kind=MF_DOUBLE), pointer :: mat_abs_sto_pg(:,:), mat_ord_sto_pg(:,:)
      real(kind=MF_DOUBLE) :: z_min, z_max
      logical :: full_matrix, z_min_max_exist
      integer :: ni, nj, nx_pg, ny_pg, dim_x, dim_y
      integer :: nx_abs, ny_abs, nx_ord, ny_ord, ier
      logical :: cell_centered, draw_grid, lighting_0
      integer :: grid_icol, view_type, grid_step_0(2)

      type(mf_win_info), pointer :: win
      integer :: mf_message_level_save

#ifdef _MF_FUNC
      character(len=*), parameter :: ROUTINE_NAME = "mfPcolor"
#endif
#ifdef _MF_SUBR
      character(len=*), parameter :: ROUTINE_NAME = "msPcolor"
#endif

   !------ end of declarations -- execution starts hereafter  ------

#ifdef _MF_FUNC
      handle = 0
#endif

      if( CURRENT_WIN_ID == 0 ) then
         call msFigure()
         if( CURRENT_WIN_ID == 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "cannot plot: no window created!" )
            go to 99
         end if
      end if

      call msInitArgs( x, y, z )

      ! All checks on 'x', 'y' and 'z' must be done first!

      ! checking that 'x' is allocated
      if( mfIsEqual(x,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' not allocated!" )
         go to 99
      end if

      ! 'x' must be real
      if( .not. mfIsReal(x) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' must be real!" )
         go to 99
      end if

      ! 'x' cannot be sparse
      if( mfIsSparse(x) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' cannot be sparse!" )
         go to 99
      end if

      ! 'x' cannot contain NaN values
      if( Any(mfIsNaN(x)) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' cannot contain NaN values!" )
         go to 99
      end if

      ! When 'x' is a vector, the 'strictly monotonous values' check
      ! is reported to the called routine.

      ! checking that 'y' is allocated
      if( mfIsEqual(y,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' not allocated!" )
         go to 99
      end if

      ! 'y' must be real
      if( .not. mfIsReal(y) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' must be real!" )
         go to 99
      end if

      ! 'y' cannot be sparse
      if( mfIsSparse(y) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' cannot be sparse!" )
         go to 99
      end if

      ! 'y' cannot contain NaN values
      if( Any(mfIsNaN(y)) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' cannot contain NaN values!" )
         go to 99
      end if

      ! When 'y' is a vector, the 'strictly monotonous values' check
      ! is reported to the called routine.

      ! checking that 'z' is allocated
      if( mfIsEqual(z,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'z' not allocated!" )
         go to 99
      end if

      ! 'z' must be real
      if( .not. mfIsReal(z) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'z' must be real!" )
         go to 99
      end if

      ! 'z' cannot be sparse
      if( mfIsSparse(z) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'z' cannot be sparse!" )
         go to 99
      end if

      ! 'z' cannot contain NaN values
      if( Any(mfIsNaN(z)) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'z' cannot contain NaN values!" )
         go to 99
      end if

      ! End of checks -----------------------------------!

      ! optional data centering
      if( present(data_centering) ) then
         if( data_centering == "cell" ) then
            cell_centered = .true.
         else if( data_centering == "vertex" ) then
            cell_centered = .false.
         else
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "'data_centering' must be equal to 'vertex' or 'cell'!" )
            go to 99
         end if
      else
         cell_centered = .false.
      end if

      win => mf_win_db(CURRENT_WIN_ID)

      if( .not. win%colormap_init ) then
         call PrintMessage( trim(ROUTINE_NAME), "I",                    &
                            "Colormap has not yet been defined!",       &
                            "(default colormap is selected)" )
         call msColormap( "rainbow" )
      end if

      win%colormap_used = .true.

      ! 'xy' axis mode is selected
      win%axis_mode_xy = .true.
      ! If axis are in the 'manual' mode, keep them as is.
      if( win%axis_manual_x == 0 ) then
         win%axis_manual_x = 2 ! 'tight'
      end if
      if( win%axis_manual_y == 0 ) then
         win%axis_manual_y = 2 ! 'tight'
      end if
      call unset_smart_ticks_x()
      call unset_smart_ticks_y()

      if( cell_centered .and. win%shading /= "flat" ) then
         call PrintMessage( trim(ROUTINE_NAME), "W",                    &
                            "shading can be only flat for the cell-centered case!" )
      end if

      call msPointer( x, x_ptr, no_crc=.true., intern_call=.true. )

      call msPointer( y, y_ptr, no_crc=.true., intern_call=.true. )

      ni = size(z,1)
      nj = size(z,2)

      if( .not. cell_centered ) then
         if( ni < 2 ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "number of rows is too small!",          &
                               '(hint: use data_centering="cell")' )
            go to 99
         end if
         if( nj < 2 ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "number of columns is too small!",       &
                               '(hint: use data_centering="cell")' )
            go to 99
         end if
      end if

      if( size(x_ptr,1)/=1 .and. size(x_ptr,2)/=1 ) then ! coord. matrices
         full_matrix = .true.
         ny_abs = size(x_ptr,1)
         nx_abs = size(x_ptr,2)
         if( cell_centered ) then
            if( ni /= ny_abs-1 .or. nj /= nx_abs-1 ) then
               call PrintMessage( trim(ROUTINE_NAME), "E",              &
                                  "in the 'cell_centered' option, shape of 'x'", &
                                  "must be consistent with those of 'z'!" )
               go to 99
            end if
         else
            if( ni /= ny_abs .or. nj /= nx_abs ) then
               call PrintMessage( trim(ROUTINE_NAME), "E",              &
                                  "shape of 'x' and 'z' don't match!" )
               go to 99
            end if
         end if
         allocate( mat_abs_sto_pg(ny_abs,nx_abs) )
         mat_abs_sto_pg(:,:) = x_ptr(:,:)
      else                                               ! generator vectors
         full_matrix = .false.
         if( size(x_ptr,1) == 1 ) then
            dim_x = 2
         else
            dim_x = 1
         end if
         nx_pg = size(x_ptr,dim_x)
         if( cell_centered ) then
            if( nj /= nx_pg-1 ) then
               call PrintMessage( trim(ROUTINE_NAME), "E",              &
                                  "in the 'cell_centered' option, size of 'x'", &
                                  "must be consistent with those of 'z'!" )
               go to 99
            end if
         else
            if( nj /= nx_pg ) then
               call PrintMessage( trim(ROUTINE_NAME), "E",              &
                                  "shape of 'x' and 'z' don't match!" )
               go to 99
            end if
         end if
         allocate( x_sto_pg(nx_pg) )
         if( dim_x == 1 ) then
            x_sto_pg(:) = x_ptr(:,1)
         else
            x_sto_pg(:) = x_ptr(1,:)
         end if
      end if

      call msFreePointer( x, x_ptr )

      if( size(y_ptr,1)/=1 .and. size(y_ptr,2)/=1 ) then ! matrix
         if( .not. full_matrix ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "'y' should be a full matrix, as 'x'!" )
            go to 99
         end if
         ny_ord = size(y_ptr,1)
         nx_ord = size(y_ptr,2)
         if( cell_centered ) then
            if( ni /= ny_ord-1 .or. nj /= nx_ord-1 ) then
               call PrintMessage( trim(ROUTINE_NAME), "E",              &
                                  "in the 'cell_centered' option, shape of 'y'", &
                                  "must be consistent with those of 'z'!" )
               go to 99
            end if
         else
            if( ni /= ny_ord .or. nj /= nx_ord ) then
               call PrintMessage( trim(ROUTINE_NAME), "E",              &
                                  "shape of 'y' and 'z' don't match!" )
               go to 99
            end if
         end if
         allocate( mat_ord_sto_pg(ny_ord,nx_ord) )
         mat_ord_sto_pg(:,:) = y_ptr(:,:)
      else                                               ! vector
         if( size(y_ptr,1) == 1 ) then
            dim_y = 2
         else
            dim_y = 1
         end if
         if( dim_x == dim_y ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "bad args shape for 'x' and 'y': you must provide", &
                               "one row vector and one column vector!" )
            go to 99
         end if
         ny_pg = size(y_ptr,dim_y)
         if( cell_centered ) then
            if( ni /= ny_pg-1 ) then
               call PrintMessage( trim(ROUTINE_NAME), "E",              &
                                  "in the 'cell_centered' option, size of 'y'", &
                                  "must be consistent with those of 'z'!" )
               go to 99
            end if
         else
            if( ni /= ny_pg ) then
               call PrintMessage( trim(ROUTINE_NAME), "E",              &
                                  "size of 'y' and 'z' don't match!" )
               go to 99
            end if
         end if
         allocate( y_sto_pg(ny_pg) )
         if( dim_y == 1 ) then
            y_sto_pg(:) = y_ptr(:,1)
         else
            y_sto_pg(:) = y_ptr(1,:)
         end if
      end if

      call msFreePointer( y, y_ptr )

      call msPointer( z, z_ptr, no_crc=.true. )

      allocate( mat_sto_pg(ni,nj) )
      mat_sto_pg(:,:) = z_ptr(:,:)

      if( present(lighting) ) then
         lighting_0 = lighting
      else
         lighting_0 = .false.
      end if

      z_min_max_exist = .false.
      if( .not. win%color_axis_set ) then
if( lighting_0 ) then
         z_min = 0.0d0
         z_max = 1.0d0
else
         z_min = minval(mat_sto_pg(:,:))
         z_max = maxval(mat_sto_pg(:,:))
end if
         z_min_max_exist = .true.
         call set_color_axis( win, [ z_min, z_max ] )
      end if

      if( .not. z_min_max_exist ) then
         if( lighting_0 ) then
            z_min = 0.0d0
            z_max = 1.0d0
         else
            z_min = minval(mat_sto_pg(:,:))
            z_max = maxval(mat_sto_pg(:,:))
         end if
      end if

      ! warning if some data lead to color overflow (only for the
      ! shading="interp" case, because when shading is flat, this will
      ! be processed elsewhere)
      if( win%shading == "interp" ) then
         if( z_min < win%color_axes(1) ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "data is out of Color Axis: (-)",        &
                               "-> this will lead to strange colors!" )
         end if
         if( z_max > win%color_axes(2) ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "data is out of Color Axis: (+)",        &
                               "-> this will lead to strange colors!" )
         end if
      end if

      if( present(grid) ) then
         draw_grid = grid
      else
         draw_grid = .false.
      end if

      if( len_trim(grid_color) == 1 .or. grid_color(1:1) == "\" ) then
         call decode_linespec( grid_color, grid_icol, ier=ier )
         if( ier /= 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                              "bad 'grid_color' argument!",             &
                              "(grid color will be set to light grey)" )
            grid_icol = -127
         end if
      else
         call decode_col_name( grid_color, grid_icol )
      end if

      if( grid_icol == -127 ) then
         grid_icol = MFPLOT_LIGHT_GREY
      end if

      if( present(grid_step) ) then
         grid_step_0(:) = grid_step(:)
         if( any( grid_step < 1 ) ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "'grid_step' must have all its components greater", &
                               "or equal than 1!",                      &
                               "(discarding provided values, and set grid_step to [1,1])" )
            grid_step_0(:) = [ 1, 1 ]
         end if
      else
         grid_step_0(:) = [ 1, 1 ]
      end if

      if( present(view) ) then
         select case( view )
            case( "XY" )
               view_type =  0
            case( "YZ", "YZf" )
               view_type =  3
            case( "YZb" )
               view_type = -3
            case( "XZ", "XZf" )
               view_type =  4
            case( "XZb" )
               view_type = -4
            case default
               call PrintMessage( trim(ROUTINE_NAME), "E",              &
                                 "when (x,y) are present 'view' must be equal to one", &
                                 "of the following strings:",           &
                                 '"XY", "YZ", "YZb", "XZ", "XZb"' )
               go to 99
         end select
      else
         view_type = 0
      end if

      select case( view_type )

         case( 0 )
            if( full_matrix ) then
               handle = PcolorCoreMat( mat_sto_pg, cell_centered,       &
                                       mat_abs_sto_pg, mat_ord_sto_pg,  &
                                       view_type=view_type,             &
                                       draw_grid=draw_grid,             &
                                       grid_icol=grid_icol,             &
                                       grid_step=grid_step_0 )
            else
               ! vector case
               handle = PcolorCoreVec( mat_sto_pg, cell_centered,       &
                                       x_sto_pg, y_sto_pg,              &
                                       view_type=view_type,             &
                                       draw_grid=draw_grid,             &
                                       grid_icol=grid_icol,             &
                                       grid_step=grid_step_0 )
            end if

         case( 3, -3 )
            if( full_matrix ) then
               handle = PcolorCoreMat_YZ( mat_sto_pg,                   &
                                          mat_abs_sto_pg, mat_ord_sto_pg, &
                                          view_type=view_type,          &
                                          draw_grid=draw_grid,          &
                                          grid_icol=grid_icol,          &
                                          grid_step=grid_step_0,        &
                                          lighting=lighting_0 )
            else
               ! vector case
               handle = PcolorCoreVec_YZ( mat_sto_pg, cell_centered,    &
                                          x=x_sto_pg, y=y_sto_pg,       &
                                          view_type=view_type,          &
                                          draw_grid=draw_grid,          &
                                          grid_icol=grid_icol,          &
                                          grid_step=grid_step_0,        &
                                          lighting=lighting_0 )
            end if

         case( 4, -4 )
            if( full_matrix ) then
               handle = PcolorCoreMat_XZ( mat_sto_pg,                   &
                                          mat_abs_sto_pg, mat_ord_sto_pg, &
                                          view_type=view_type,          &
                                          draw_grid=draw_grid,          &
                                          grid_icol=grid_icol,          &
                                          grid_step=grid_step_0,        &
                                          lighting=lighting_0 )
            else
               ! vector case
               handle = PcolorCoreVec_XZ( mat_sto_pg, cell_centered,    &
                                          x=x_sto_pg, y=y_sto_pg,       &
                                          view_type=view_type,          &
                                          draw_grid=draw_grid,          &
                                          grid_icol=grid_icol,          &
                                          grid_step=grid_step_0,        &
                                          lighting=lighting_0 )
            end if

      end select

      call msFreePointer( z, z_ptr )

 99   continue

      call msFreeArgs( x, y, z )
      call msAutoRelease( x, y, z )

#ifdef _MF_FUNC
   end function mfPcolor_xyz_str
#endif
#ifdef _MF_SUBR
   end subroutine msPcolor_xyz_str
#endif
!_______________________________________________________________________
!
#ifdef _MF_FUNC
   function mfPcolor_xyz_rgb( x, y, z, data_centering, view,            &
                              grid, grid_color, grid_step, lighting )   &
   result( handle )
#endif
#ifdef _MF_SUBR
   subroutine msPcolor_xyz_rgb( x, y, z, data_centering, view,          &
                                grid, grid_color, grid_step, lighting )
#endif

      type(mfArray)                              :: x, y, z
      character(len=*),     intent(in), optional :: data_centering
      character(len=*),     intent(in), optional :: view
      logical,              intent(in), optional :: grid
      real(kind=MF_DOUBLE), intent(in), optional :: grid_color(3)
      integer,              intent(in), optional :: grid_step(2)
      logical,              intent(in), optional :: lighting

      integer :: handle
      !------ API end ------

      ! pointers for manipulating mfArray out of fml module
      real(kind=MF_DOUBLE), pointer :: x_ptr(:,:), y_ptr(:,:), z_ptr(:,:)
      real(kind=MF_DOUBLE), pointer :: x_sto_pg(:), y_sto_pg(:), mat_sto_pg(:,:)
      real(kind=MF_DOUBLE), pointer :: mat_abs_sto_pg(:,:), mat_ord_sto_pg(:,:)
      real(kind=MF_DOUBLE) :: z_min, z_max
      logical :: full_matrix, z_min_max_exist
      integer :: ni, nj, nx_pg, ny_pg, dim_x, dim_y
      integer :: nx_abs, ny_abs, nx_ord, ny_ord
      logical :: cell_centered, draw_grid, lighting_0
      integer :: grid_icol, view_type, grid_step_0(2)

      type(mf_win_info), pointer :: win
      integer :: mf_message_level_save

#ifdef _MF_FUNC
      character(len=*), parameter :: ROUTINE_NAME = "mfPcolor"
#endif
#ifdef _MF_SUBR
      character(len=*), parameter :: ROUTINE_NAME = "msPcolor"
#endif

   !------ end of declarations -- execution starts hereafter  ------

#ifdef _MF_FUNC
      handle = 0
#endif

      if( CURRENT_WIN_ID == 0 ) then
         call msFigure()
         if( CURRENT_WIN_ID == 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "cannot plot: no window created!" )
            go to 99
         end if
      end if

      call msInitArgs( x, y, z )

      ! All checks on 'x', 'y' and 'z' must be done first!

      ! checking that 'x' is allocated
      if( mfIsEqual(x,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' not allocated!" )
         go to 99
      end if

      ! 'x' must be real
      if( .not. mfIsReal(x) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' must be real!" )
         go to 99
      end if

      ! 'x' cannot be sparse
      if( mfIsSparse(x) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' cannot be sparse!" )
         go to 99
      end if

      ! 'x' cannot contain NaN values
      if( Any(mfIsNaN(x)) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' cannot contain NaN values!" )
         go to 99
      end if

      ! When 'x' is a vector, the 'strictly monotonous values' check
      ! is reported to the called routine.

      ! checking that 'y' is allocated
      if( mfIsEqual(y,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' not allocated!" )
         go to 99
      end if

      ! 'y' must be real
      if( .not. mfIsReal(y) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' must be real!" )
         go to 99
      end if

      ! 'y' cannot be sparse
      if( mfIsSparse(y) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' cannot be sparse!" )
         go to 99
      end if

      ! 'y' cannot contain NaN values
      if( Any(mfIsNaN(y)) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' cannot contain NaN values!" )
         go to 99
      end if

      ! When 'y' is a vector, the 'strictly monotonous values' check
      ! is reported to the called routine.

      ! checking that 'z' is allocated
      if( mfIsEqual(z,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'z' not allocated!" )
         go to 99
      end if

      ! 'z' must be real
      if( .not. mfIsReal(z) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'z' must be real!" )
         go to 99
      end if

      ! 'z' cannot be sparse
      if( mfIsSparse(z) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'z' cannot be sparse!" )
         go to 99
      end if

      ! 'z' cannot contain NaN values
      if( Any(mfIsNaN(z)) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'z' cannot contain NaN values!" )
         go to 99
      end if

      ! End of checks -----------------------------------!

      ! optional data centering
      if( present(data_centering) ) then
         if( data_centering == "cell" ) then
            cell_centered = .true.
         else if( data_centering == "vertex" ) then
            cell_centered = .false.
         else
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "'data_centering' must be equal to 'vertex' or 'cell'!" )
            go to 99
         end if
      else
         cell_centered = .false.
      end if

      win => mf_win_db(CURRENT_WIN_ID)

      if( .not. win%colormap_init ) then
         call PrintMessage( trim(ROUTINE_NAME), "I",                    &
                            "Colormap has not yet been defined!",       &
                            "(default colormap is selected)" )
         call msColormap( "rainbow" )
      end if

      win%colormap_used = .true.

      ! 'xy' axis mode is selected
      win%axis_mode_xy = .true.
      ! If axis are in the 'manual' mode, keep them as is.
      if( win%axis_manual_x == 0 ) then
         win%axis_manual_x = 2 ! 'tight'
      end if
      if( win%axis_manual_y == 0 ) then
         win%axis_manual_y = 2 ! 'tight'
      end if
      call unset_smart_ticks_x()
      call unset_smart_ticks_y()

      if( cell_centered .and. win%shading /= "flat" ) then
         call PrintMessage( trim(ROUTINE_NAME), "W",                    &
                            "shading can be only flat for the cell-centered case!" )
      end if

      call msPointer( x, x_ptr, no_crc=.true., intern_call=.true. )

      call msPointer( y, y_ptr, no_crc=.true., intern_call=.true. )

      ni = size(z,1)
      nj = size(z,2)

      if( .not. cell_centered ) then
         if( ni < 2 ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "number of rows is too small!",          &
                               '(hint: use data_centering="cell")' )
            go to 99
         end if
         if( nj < 2 ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "number of columns is too small!",       &
                               '(hint: use data_centering="cell")' )
            go to 99
         end if
      end if

      if( size(x_ptr,1)/=1 .and. size(x_ptr,2)/=1 ) then ! coord. matrices
         full_matrix = .true.
         ny_abs = size(x_ptr,1)
         nx_abs = size(x_ptr,2)
         if( cell_centered ) then
            if( ni /= ny_abs-1 .or. nj /= nx_abs-1 ) then
               call PrintMessage( trim(ROUTINE_NAME), "E",              &
                                  "in the 'cell_centered' option, shape of 'x'", &
                                  "must be consistent with those of 'z'!" )
               go to 99
            end if
         else
            if( ni /= ny_abs .or. nj /= nx_abs ) then
               call PrintMessage( trim(ROUTINE_NAME), "E",              &
                                  "shape of 'x' and 'z' don't match!" )
               go to 99
            end if
         end if
         allocate( mat_abs_sto_pg(ny_abs,nx_abs) )
         mat_abs_sto_pg(:,:) = x_ptr(:,:)
      else                                               ! generator vectors
         full_matrix = .false.
         if( size(x_ptr,1) == 1 ) then
            dim_x = 2
         else
            dim_x = 1
         end if
         nx_pg = size(x_ptr,dim_x)
         if( cell_centered ) then
            if( nj /= nx_pg-1 ) then
               call PrintMessage( trim(ROUTINE_NAME), "E",              &
                                  "in the 'cell_centered' option, size of 'x'", &
                                  "must be consistent with those of 'z'!" )
               go to 99
            end if
         else
            if( nj /= nx_pg ) then
               call PrintMessage( trim(ROUTINE_NAME), "E",              &
                                  "shape of 'x' and 'z' don't match!" )
               go to 99
            end if
         end if
         allocate( x_sto_pg(nx_pg) )
         if( dim_x == 1 ) then
            x_sto_pg(:) = x_ptr(:,1)
         else
            x_sto_pg(:) = x_ptr(1,:)
         end if
      end if

      call msFreePointer( x, x_ptr )

      if( size(y_ptr,1)/=1 .and. size(y_ptr,2)/=1 ) then ! matrix
         if( .not. full_matrix ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "'y' should be a full matrix, as 'x'!" )
            go to 99
         end if
         ny_ord = size(y_ptr,1)
         nx_ord = size(y_ptr,2)
         if( cell_centered ) then
            if( ni /= ny_ord-1 .or. nj /= nx_ord-1 ) then
               call PrintMessage( trim(ROUTINE_NAME), "E",              &
                                  "in the 'cell_centered' option, shape of 'y'", &
                                  "must be consistent with those of 'z'!" )
               go to 99
            end if
         else
            if( ni /= ny_ord .or. nj /= nx_ord ) then
               call PrintMessage( trim(ROUTINE_NAME), "E",              &
                                  "shape of 'y' and 'z' don't match!" )
               go to 99
            end if
         end if
         allocate( mat_ord_sto_pg(ny_ord,nx_ord) )
         mat_ord_sto_pg(:,:) = y_ptr(:,:)
      else                                               ! vector
         if( size(y_ptr,1) == 1 ) then
            dim_y = 2
         else
            dim_y = 1
         end if
         if( dim_x == dim_y ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "bad args shape for 'x' and 'y': you must provide", &
                               "one row vector and one column vector!" )
            go to 99
         end if
         ny_pg = size(y_ptr,dim_y)
         if( cell_centered ) then
            if( ni /= ny_pg-1 ) then
               call PrintMessage( trim(ROUTINE_NAME), "E",              &
                                  "in the 'cell_centered' option, size of 'y'", &
                                  "must be consistent with those of 'z'!" )
               go to 99
            end if
         else
            if( ni /= ny_pg ) then
               call PrintMessage( trim(ROUTINE_NAME), "E",              &
                                  "size of 'y' and 'z' don't match!" )
               go to 99
            end if
         end if
         allocate( y_sto_pg(ny_pg) )
         if( dim_y == 1 ) then
            y_sto_pg(:) = y_ptr(:,1)
         else
            y_sto_pg(:) = y_ptr(1,:)
         end if
      end if

      call msFreePointer( y, y_ptr )

      call msPointer( z, z_ptr, no_crc=.true. )

      allocate( mat_sto_pg(ni,nj) )
      mat_sto_pg(:,:) = z_ptr(:,:)

      if( present(lighting) ) then
         lighting_0 = lighting
      else
         lighting_0 = .false.
      end if

      z_min_max_exist = .false.
      if( .not. win%color_axis_set ) then
if( lighting_0 ) then
         z_min = 0.0d0
         z_max = 1.0d0
else
         z_min = minval(mat_sto_pg(:,:))
         z_max = maxval(mat_sto_pg(:,:))
end if
         z_min_max_exist = .true.
         call set_color_axis( win, [ z_min, z_max ] )
      end if

      if( .not. z_min_max_exist ) then
         if( lighting_0 ) then
            z_min = 0.0d0
            z_max = 1.0d0
         else
            z_min = minval(mat_sto_pg(:,:))
            z_max = maxval(mat_sto_pg(:,:))
         end if
      end if

      ! warning if some data lead to color overflow (only for the
      ! shading="interp" case, because when shading is flat, this will
      ! be processed elsewhere)
      if( win%shading == "interp" ) then
         if( z_min < win%color_axes(1) ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "data is out of Color Axis: (-)",        &
                               "-> this will lead to strange colors!" )
         end if
         if( z_max > win%color_axes(2) ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "data is out of Color Axis: (+)",        &
                               "-> this will lead to strange colors!" )
         end if
      end if

      if( present(grid) ) then
         draw_grid = grid
      else
         draw_grid = .false.
      end if

      if( present(grid_color) ) then
         call decode_col_rgb( grid_color, grid_icol )
      else
         grid_icol = 1 ! foreground color
      end if

      if( present(grid_step) ) then
         grid_step_0(:) = grid_step(:)
         if( any( grid_step < 1 ) ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "'grid_step' must have all its components greater", &
                               "or equal than 1!",                      &
                               "(discarding provided values, and set grid_step to [1,1])" )
            grid_step_0(:) = [ 1, 1 ]
         end if
      else
         grid_step_0(:) = [ 1, 1 ]
      end if

      if( present(view) ) then
         select case( view )
            case( "XY" )
               view_type =  0
            case( "YZ", "YZf" )
               view_type =  3
            case( "YZb" )
               view_type = -3
            case( "XZ", "XZf" )
               view_type =  4
            case( "XZb" )
               view_type = -4
            case default
               call PrintMessage( trim(ROUTINE_NAME), "E",              &
                                 "when (x,y) are present 'view' must be equal to one", &
                                 "of the following strings:",           &
                                 '"XY", "YZ", "YZb", "XZ", "XZb"' )
               go to 99
         end select
      else
         view_type = 0
      end if

      select case( view_type )

         case( 0 )
            if( full_matrix ) then
               handle = PcolorCoreMat( mat_sto_pg, cell_centered,       &
                                       mat_abs_sto_pg, mat_ord_sto_pg,  &
                                       view_type=view_type,             &
                                       draw_grid=draw_grid,             &
                                       grid_icol=grid_icol,             &
                                       grid_step=grid_step_0 )
            else
               ! vector case
               handle = PcolorCoreVec( mat_sto_pg, cell_centered,       &
                                       x_sto_pg, y_sto_pg,              &
                                       view_type=view_type,             &
                                       draw_grid=draw_grid,             &
                                       grid_icol=grid_icol,             &
                                       grid_step=grid_step_0 )
            end if

         case( 3, -3 )
            if( full_matrix ) then
               handle = PcolorCoreMat_YZ( mat_sto_pg,                   &
                                          mat_abs_sto_pg, mat_ord_sto_pg, &
                                          view_type=view_type,          &
                                          draw_grid=draw_grid,          &
                                          grid_icol=grid_icol,          &
                                          grid_step=grid_step_0,        &
                                          lighting=lighting_0 )
            else
               ! vector case
               handle = PcolorCoreVec_YZ( mat_sto_pg, cell_centered,    &
                                          x=x_sto_pg, y=y_sto_pg,       &
                                          view_type=view_type,          &
                                          draw_grid=draw_grid,          &
                                          grid_icol=grid_icol,          &
                                          grid_step=grid_step_0,        &
                                          lighting=lighting_0 )
            end if

         case( 4, -4 )
            if( full_matrix ) then
               handle = PcolorCoreMat_XZ( mat_sto_pg,                   &
                                          mat_abs_sto_pg, mat_ord_sto_pg, &
                                          view_type=view_type,          &
                                          draw_grid=draw_grid,          &
                                          grid_icol=grid_icol,          &
                                          grid_step=grid_step_0,        &
                                          lighting=lighting_0 )
            else
               ! vector case
               handle = PcolorCoreVec_XZ( mat_sto_pg, cell_centered,    &
                                          x=x_sto_pg, y=y_sto_pg,       &
                                          view_type=view_type,          &
                                          draw_grid=draw_grid,          &
                                          grid_icol=grid_icol,          &
                                          grid_step=grid_step_0,        &
                                          lighting=lighting_0 )
            end if

      end select

      call msFreePointer( z, z_ptr )

 99   continue

      call msFreeArgs( x, y, z )
      call msAutoRelease( x, y, z )

#ifdef _MF_FUNC
   end function mfPcolor_xyz_rgb
#endif
#ifdef _MF_SUBR
   end subroutine msPcolor_xyz_rgb
#endif
