!_______________________________________________________________________
!
   subroutine mf_polygon_draw( grobj )

      type(grobj_elem), intent(in) :: grobj
      !------ API end ------

      ! grobj type = "polygon"

      type(mf_win_info), pointer :: win

      logical :: clipped, draw_grid

      real(kind=MF_DOUBLE) :: rbuf(1)
      integer :: ibuf(1)

   !------ end of declarations -- execution starts hereafter  ------

      clipped = grobj%struct%bool1

      if( PRINTING_EPS ) then
         if( COMMENTS_IN_EPS ) then
            ibuf(1) = 0
            call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- begin of Polygon", 0 )
         end if
         if( .not. clipped ) then
            call EPS_no_clip_beg()
         end if
!### dangereux dans certains cas (le grestore va annuler le clipping)
!    (voir ci-dessous)
!!         call gresc( "gsave" )
      end if
      if( PRINTING_PDF ) then
         if( COMMENTS_IN_PDF ) then
            call pdf_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- begin of Polygon", 0 )
         end if
         if( .not. clipped ) then
            call PDF_no_clip_beg()
         end if
!### dangereux dans certains cas (le grestore va annuler le clipping)
!    (voir ci-dessous)
!!         call gresc( "q" ) ! = gsave
         gr_pdf_color_intent = 2 ! Fill
      end if

      call grsci(grobj%struct%color) ! set color index
      call pgsfs(1) ! set fill-area style : solid (default)

      win => mf_win_db(CURRENT_WIN_ID)

      if( win%axis_scale_x == 1 .and. win%axis_scale_y == 1 ) then
         call pgpoly( grobj%struct%npt,                                 &
                      grobj%struct%abs_tab,                             &
                      grobj%struct%ord_tab, clipped )
      else if( win%axis_scale_x == 2 .and. win%axis_scale_y == 1 ) then
         call pgpoly( grobj%struct%npt,                                 &
                      log10(grobj%struct%abs_tab),                      &
                      grobj%struct%ord_tab, clipped )
      else if( win%axis_scale_x == 1 .and. win%axis_scale_y == 2 ) then
         call pgpoly( grobj%struct%npt,                                 &
                      grobj%struct%abs_tab,                             &
                      log10(grobj%struct%ord_tab), clipped )
      else if( win%axis_scale_x == 2 .and. win%axis_scale_y == 2 ) then
         call pgpoly( grobj%struct%npt,                                 &
                      log10(grobj%struct%abs_tab),                      &
                      log10(grobj%struct%ord_tab), clipped )
      else
         print *, "mf_polygon_draw: internal error."
         print *, "                 bad value for axis_scale(s)!"
         pause "only for debugging purpose"
         stop
      end if

      draw_grid = grobj%struct%bool2
      if( draw_grid ) then
         gr_pdf_color_intent = 1 ! Stroke
         call grsci(grobj%struct%npt2) ! set color index
         call grsls(1) ! line style : continuous
         ! draw the first (n_pg-1) sides of the polygon
         call pgline( grobj%struct%npt,                                 &
                      grobj%struct%abs_tab, grobj%struct%ord_tab )
         ! draw the last side
         call grlina( grobj%struct%abs_tab(1), grobj%struct%ord_tab(1) )
      end if

      if( PRINTING_EPS ) then
         if( .not. clipped ) then
            call EPS_no_clip_end()
         end if
!### dangereux dans certains cas (le grestore va annuler le clipping)
!!         call gresc( "grestore" )
         LAST_COLOR_IS_VALID = .false.
         LAST_LINEWIDTH_IS_VALID = .false.
         LAST_LINESTYLE_IS_VALID = .false.
         LAST_FONT_ATTRIB_IS_VALID = .false.
         if( COMMENTS_IN_EPS ) then
            ibuf(1) = 0
            call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- end of Polygon", 0 )
         end if
      end if
      if( PRINTING_PDF ) then
         if( .not. clipped ) then
            call PDF_no_clip_end()
         end if
!### dangereux dans certains cas (le grestore va annuler le clipping)
!!         call gresc( "Q" ) ! = grestore
         LAST_LINEWIDTH_IS_VALID = .false.
         LAST_LINESTYLE_IS_VALID = .false.
         LAST_FONT_ATTRIB_IS_VALID = .false.
         if( COMMENTS_IN_PDF ) then
            call pdf_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- end of Polygon", 0 )
         end if
      end if

   end subroutine mf_polygon_draw
!_______________________________________________________________________
!
   subroutine mf_patch_draw( grobj )

      type(grobj_elem), intent(in out) :: grobj
      !------ API end ------

      ! grobj type = "patch"

      logical :: flat, draw_grid
      real(kind=MF_DOUBLE) :: x_pg_3(3), y_pg_3(3)
      integer :: i, c_pg_3(3)

      real(kind=MF_DOUBLE) :: rbuf(1)
      integer :: ibuf(1)

   !------ end of declarations -- execution starts hereafter  ------

      ! for X11, "patch" is always not flat (else "polygon" type)
      flat = .false.
      if( PRINTING_EPS ) then
         if( COMMENTS_IN_EPS ) then
            ibuf(1) = 0
            call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- begin of Patch", 0 )
         end if
         call EPS_clip_on_viewport_beg()
         ! flat checking... because the 'flat' property may be lost due to use
         !                  of transparency (see 'Patch_basic' routine)
         flat = all( grobj%struct%col_tab == grobj%struct%col_tab(1) )
      end if
      if( PRINTING_PDF ) then
         if( COMMENTS_IN_PDF ) then
            call pdf_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- begin of Patch", 0 )
         end if
         call PDF_clip_on_viewport_beg()
         ! flat checking... because the 'flat' property may be lost due to use
         !                  of transparency (see 'Patch_basic' routine)
         flat = all( grobj%struct%col_tab == grobj%struct%col_tab(1) )
      end if

      if( grobj%struct%npt == 3 ) then
         ! draw with a linear interpolating scheme for colors
         call PatchTriCore( grobj%struct%abs_tab,                       &
                            grobj%struct%ord_tab,                       &
                            grobj%struct%col_tab,                       &
                            opacity=grobj%struct%alpha_transp,          &
                            flat=flat )
      else if( grobj%struct%npt == 4 ) then
         ! draw with a bilinear interpolating scheme for colors
         if( quad_is_rect(grobj%struct%abs_tab,grobj%struct%ord_tab) ) then
            call PatchRectCore( grobj%struct%abs_tab,                   &
                                grobj%struct%ord_tab,                   &
                                grobj%struct%col_tab,                   &
                                opacity=grobj%struct%alpha_transp,      &
                                flat=flat )
         else
            call PatchQuadCore( grobj%struct%abs_tab,                   &
                                grobj%struct%ord_tab,                   &
                                grobj%struct%col_tab,                   &
                                opacity=grobj%struct%alpha_transp,      &
                                flat=flat )
         end if
      else ! npt > 4
         ! assuming a convex polygon: split in triangles
         x_pg_3(1) = grobj%struct%abs_tab(1)
         y_pg_3(1) = grobj%struct%ord_tab(1)
         c_pg_3(1) = grobj%struct%col_tab(1)
         do i = 2, grobj%struct%npt-1
            x_pg_3(2) = grobj%struct%abs_tab(i)
            y_pg_3(2) = grobj%struct%ord_tab(i)
            c_pg_3(2) = grobj%struct%col_tab(i)
            x_pg_3(3) = grobj%struct%abs_tab(i+1)
            y_pg_3(3) = grobj%struct%ord_tab(i+1)
            c_pg_3(3) = grobj%struct%col_tab(i+1)
            call PatchTriCore( x_pg_3, y_pg_3, c_pg_3,                  &
                               opacity=grobj%struct%alpha_transp,       &
                               flat=flat )
         end do
      end if

      draw_grid = grobj%struct%bool2
      if( draw_grid ) then
         gr_pdf_color_intent = 1 ! Stroke
         call grsci(grobj%struct%npt2) ! set color index
         call grsls(1) ! line style : continuous
         ! draw the first (n_pg-1) sides of the polygon
         call pgline( grobj%struct%npt,                                 &
                      grobj%struct%abs_tab, grobj%struct%ord_tab )
         ! draw the last side
         call grlina( grobj%struct%abs_tab(1), grobj%struct%ord_tab(1) )
      end if

      if( PRINTING_EPS ) then
         call EPS_clip_on_viewport_end()
         if( COMMENTS_IN_EPS ) then
            ibuf(1) = 0
            call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- end of Patch", 0 )
         end if
      else if( PRINTING_PDF ) then
         call PDF_clip_on_viewport_end()
         if( COMMENTS_IN_PDF ) then
            call pdf_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- end of Patch", 0 )
         end if
      end if

   end subroutine mf_patch_draw
