!_______________________________________________________________________
!
   function PolyFillCore( x_pg, y_pg, icol, draw_grid, grid_icol,       &
                          clipping )                                    &
   result( handle )

      real(kind=MF_DOUBLE), pointer :: x_pg(:), y_pg(:)
      integer, intent(in)           :: icol
      logical                       :: draw_grid
      integer, intent(in)           :: grid_icol
      logical, intent(in), optional :: clipping

      integer             :: handle
      !------ API end ------

      ! no transparency, always flat color

      type(mf_win_info), pointer :: win
      type(grobj_elem), pointer :: grobj

      integer :: i, n_pg, hdle
      real(kind=MF_DOUBLE) :: range(4)
      logical :: clipped

   !------ end of declarations -- execution starts hereafter  ------

      n_pg = size(x_pg)

      ! les [nouveaux] axes doivent être prêts
      range(1) = minval( x_pg )
      range(2) = maxval( x_pg )
      range(3) = minval( y_pg )
      range(4) = maxval( y_pg )
      call mf_prepare_axes( CURRENT_WIN_ID, range )

      win => mf_win_db(CURRENT_WIN_ID)

      if( present(clipping) ) then
         clipped = clipping
      else
         clipped = .true.
      end if

      if( .not. clipped ) then
         win%at_least_one_grobj_not_clipped = .true.
      end if

      if( clipped ) then
         if( X11_DEVICE ) then
            ! caution: axes must have been defined before
            call X11_clip_on_viewport()
         end if
      end if

!++++++++++++++++++ Storage in DB ++++++++++++++++++

      ! new grobj
      if( win%mf_win_db_active ) then
         ! create a new grobj and insert it in the linked list
         call create_grobj( win, grobj )
      else
         ! just allocate the grobj
         allocate( grobj )
      end if

      grobj%struct%color = icol
      grobj%struct%linestyle = 1

      grobj%struct%cmd = "polygon"
      grobj%struct%npt = n_pg
      grobj%struct%abs_tab => x_pg
      grobj%struct%ord_tab => y_pg
      grobj%struct%bool1 = clipped
      grobj%struct%bool2 = draw_grid

      if( draw_grid ) then
         grobj%struct%npt2 = grid_icol
      end if

      if( win%mf_win_db_active ) then

         hdle = mf_win_get_free_handle(CURRENT_WIN_ID)
         win%handles(hdle)%ptr => grobj
         grobj%struct%hdle = hdle
         handle = encode_handle( CURRENT_WIN_ID, hdle )

      end if

!+++++++++++++++++++++++++++++++++++++++++++++++++++

!------------------ Drawing GrObj ------------------

      call mf_polygon_draw( grobj )

!---------------------------------------------------

      if( .not. win%mf_win_db_active ) then
         call delete_grobj_inside( grobj )
         deallocate( grobj )
         ! x_pg and y_pg already deallocated by 'delete_grobj_inside'
      end if

      win%blank = .false.
      win%empty = .false.

   end function PolyFillCore
!_______________________________________________________________________
!
   function PatchPolyCore( x_pg, y_pg, c_pg, transp,                    &
                           draw_grid, grid_icol )                       &
   result( handle )

      real(kind=MF_DOUBLE),    pointer            :: x_pg(:), y_pg(:)
      integer, pointer            :: c_pg(:)
      real(kind=MF_DOUBLE),            intent(in) :: transp
      logical                     :: draw_grid
      integer,         intent(in) :: grid_icol

      integer :: handle
      !------ API end ------

      type(mf_win_info), pointer :: win
      type(grobj_elem), pointer :: grobj

      real(kind=MF_DOUBLE) :: range(4)

      real(kind=MF_DOUBLE) :: x_pg_3(3), y_pg_3(3)
      integer :: c_pg_3(3)

      integer :: hdle

   !------ end of declarations -- execution starts hereafter  ------

      ! les [nouveaux] axes doivent être prêts
      range(1) = minval( x_pg )
      range(2) = maxval( x_pg )
      range(3) = minval( y_pg )
      range(4) = maxval( y_pg )
      call mf_prepare_axes( CURRENT_WIN_ID, range )

      win => mf_win_db(CURRENT_WIN_ID)

      if( X11_DEVICE ) then
         ! caution: axes must have been defined before
         call X11_clip_on_viewport()
      end if

      if( transp < 1.0 ) then
         win%transparency_used = .true.
      end if

!++++++++++++++++++ Storage in DB ++++++++++++++++++

      ! new grobj
      if( win%mf_win_db_active ) then
         ! create a new grobj and insert it in the linked list
         call create_grobj( win, grobj )
      else
         ! just allocate the grobj
         allocate( grobj )
      end if

      grobj%struct%cmd = "patch"
      grobj%struct%npt = size(x_pg)
      grobj%struct%alpha_transp = transp
      grobj%struct%abs_tab => x_pg
      grobj%struct%ord_tab => y_pg
      grobj%struct%col_tab => c_pg
      grobj%struct%bool2 = draw_grid

      if( win%mf_win_db_active ) then

         hdle = mf_win_get_free_handle(CURRENT_WIN_ID)
         win%handles(hdle)%ptr => grobj
         grobj%struct%hdle = hdle
         handle = encode_handle( CURRENT_WIN_ID, hdle )

      end if

!+++++++++++++++++++++++++++++++++++++++++++++++++++

!------------------ Drawing GrObj ------------------

      call mf_patch_draw( grobj )

!---------------------------------------------------

      if( .not. win%mf_win_db_active ) then
         call delete_grobj_inside( grobj )
         deallocate( grobj )
         ! x_pg, y_pg and c_pg already deallocated by 'delete_grobj_inside'
      end if

      win%blank = .false.
      win%empty = .false.

   end function PatchPolyCore
