
!_______________________________________________________________________
!
#ifdef _MF_FUNC
   function mfPatch_basic_1_str_2_str( x, y, color, opacity,            &
                                       grid, grid_color, clipping )     &
   result ( handle )
#endif
#ifdef _MF_SUBR
   subroutine msPatch_basic_1_str_2_str( x, y, color, opacity,          &
                                         grid, grid_color, clipping )
#endif

      type(mfArray)                              :: x, y
      character(len=*),     intent(in)           :: color
      real(kind=MF_DOUBLE), intent(in), optional :: opacity
      logical,              intent(in), optional :: grid, clipping
      character(len=*),     intent(in)           :: grid_color

      integer :: handle
      !------ API end ------

      ! Patch "flat" (à une couleur), éventuellement avec de la transparence
      ! par rapport au fond déjà tracé.
      ! Attention : transparence = opacité, en fait.

      ! pointers for manipulating mfArray out of fml module
      real(kind=MF_DOUBLE), pointer :: x_ptr(:,:), y_ptr(:,:)

      real(kind=MF_DOUBLE), pointer :: x_sto_pg(:), y_sto_pg(:)
      integer, pointer :: icol_sto_pg(:)

      integer :: p_dim, n_dim, n_pg, ier
      logical :: draw_grid, clipped
      integer :: grid_icol

      integer :: icol, color_request_nb
      integer :: mf_message_level_save

      real(kind=MF_DOUBLE) :: opacity_s

#ifdef _MF_FUNC
      character(len=*), parameter :: ROUTINE_NAME = "mfPatch"
#endif
#ifdef _MF_SUBR
      character(len=*), parameter :: ROUTINE_NAME = "msPatch"
#endif

   !------ end of declarations -- execution starts hereafter  ------

#ifdef _MF_FUNC
      handle = 0
#endif

      if( CURRENT_WIN_ID == 0 ) then
         call msFigure()
         if( CURRENT_WIN_ID == 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "cannot plot: no window created!" )
            go to 99
         end if
      end if

      call msInitArgs( x, y )

      ! checking that 'x' is allocated
      if( mfIsEqual(x,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' not allocated!" )
         go to 99
      end if

      ! 'x' must be Real
      if( .not. mfIsReal(x) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' must be real!" )
         go to 99
      end if

      ! 'x' cannot be sparse
      if( mfIsSparse(x) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' cannot be sparse!" )
         go to 99
      end if

      ! 'x' cannot contain NaN values
      if( Any(mfIsNaN(x)) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' cannot contain NaN values!" )
         go to 99
      end if

      call msPointer( x, x_ptr, no_crc=.true., intern_call=.true. )

      ! checking that 'y' is allocated
      if( mfIsEqual(y,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' not allocated!" )
         go to 99
      end if

      ! 'y' must be Real
      if( .not. mfIsReal(y) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' must be real!" )
         go to 99
      end if

      ! 'y' cannot be sparse
      if( mfIsSparse(y) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' cannot be sparse!" )
         go to 99
      end if

      ! 'y' cannot contain NaN values
      if( Any(mfIsNaN(y)) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' cannot contain NaN values!" )
         go to 99
      end if

      call msPointer( y, y_ptr, no_crc=.true., intern_call=.true. )

      if( size(x_ptr,1)==0 .or. size(x_ptr,2)==0 ) then
         call PrintMessage( trim(ROUTINE_NAME), "W",                    &
                            "nothing to plot" )
         go to 99
      end if

      ! checking that 'x' is a 1-D array
      if( size(x_ptr,1)/=1 .and. size(x_ptr,2)/=1 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "cannot yet plot a matrix" )
         go to 99
      else
         if( size(x_ptr,1) == 1 ) then
            p_dim = 2
         else
            p_dim = 1
         end if
         n_dim = size(x_ptr,p_dim)
         n_pg = n_dim
         allocate( x_sto_pg(n_pg) )

         allocate( y_sto_pg(n_pg) )

      end if

      ! checking that 'y' have the same shape than 'x'
      if( size(y_ptr,1) /= size(x_ptr,1) .or.                           &
          size(y_ptr,2) /= size(x_ptr,2)      ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' and 'y' array must have the same size" )
         go to 99
      end if

      if( p_dim == 1 ) then
         x_sto_pg(:) = x_ptr(:,1)
         y_sto_pg(:) = y_ptr(:,1)
      else
         x_sto_pg(:) = x_ptr(1,:)
         y_sto_pg(:) = y_ptr(1,:)
      end if

      call msFreePointer( x, x_ptr )
      call msFreePointer( y, y_ptr )

      if( len_trim(color) == 1 .or. color(1:1) == "\" ) then
         call decode_linespec( color, icol, ier=ier )
         if( ier /= 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                              "bad 'color' argument!",                  &
                              "(color will be set to light grey)" )
            icol = -127
         end if
      else
         icol = -127
      end if

      if( icol == -127 ) then
         icol = MFPLOT_LIGHT_GREY
      end if

      if( present(opacity) ) then
         opacity_s = opacity
         if( opacity_s < 0.0d0 .or. 1.0d0 < opacity_s ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "opacity must be in [0,1]" )
            opacity_s = max( min(0.0d0,opacity_s), 1.0d0 )
         end if
      else
         opacity_s = 1.0d0
      end if

      if( present(grid) ) then
         draw_grid = grid
      else
         draw_grid = .false.
      end if

      if( len_trim(grid_color) == 1 .or. grid_color(1:1) == "\" ) then
         call decode_linespec( grid_color, grid_icol, ier=ier )
         if( ier /= 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                              "bad 'grid_color' argument!",             &
                              "(grid color will be set to dark grey)" )
            grid_icol = -127
         end if
      else
         grid_icol = -127
      end if

      if( grid_icol == -127 ) then
         grid_icol = MFPLOT_DARK_GREY
      end if

      if( present(clipping) ) then
         clipped = clipping
      else
         clipped = .true.
      end if

      if( opacity_s == 1.0d0 ) then
         handle = PolyFillCore( x_sto_pg, y_sto_pg, icol,               &
                                draw_grid=draw_grid, grid_icol=grid_icol, &
                                clipping=clipped )
      else
         ! For X11, only patch can do transparency
         allocate( icol_sto_pg(n_pg) )
         icol_sto_pg(:) = icol
         handle = PatchPolyCore( x_sto_pg, y_sto_pg, icol_sto_pg,       &
                                 opacity_s, draw_grid=draw_grid,        &
                                 grid_icol=grid_icol )
      end if

 99   continue

      call msFreeArgs( x, y )
      call msAutoRelease( x, y )

#ifdef _MF_FUNC
   end function mfPatch_basic_1_str_2_str
#endif
#ifdef _MF_SUBR
   end subroutine msPatch_basic_1_str_2_str
#endif
!_______________________________________________________________________
!
#ifdef _MF_FUNC
   function mfPatch_basic_1_str_2_rgb( x, y, color, opacity,            &
                                       grid, grid_color, clipping )     &
   result ( handle )
#endif
#ifdef _MF_SUBR
   subroutine msPatch_basic_1_str_2_rgb( x, y, color, opacity,          &
                                         grid, grid_color, clipping )
#endif

      type(mfArray)                              :: x, y
      character(len=*),     intent(in)           :: color
      real(kind=MF_DOUBLE), intent(in), optional :: opacity
      logical,              intent(in), optional :: grid, clipping
      real(kind=MF_DOUBLE), intent(in), optional :: grid_color(3)

      integer :: handle
      !------ API end ------

      ! Patch "flat" (à une couleur), éventuellement avec de la transparence
      ! par rapport au fond déjà tracé.
      ! Attention : transparence = opacité, en fait.

      ! pointers for manipulating mfArray out of fml module
      real(kind=MF_DOUBLE), pointer :: x_ptr(:,:), y_ptr(:,:)

      real(kind=MF_DOUBLE), pointer :: x_sto_pg(:), y_sto_pg(:)
      integer, pointer :: icol_sto_pg(:)

      integer :: p_dim, n_dim, n_pg, ier
      logical :: draw_grid, clipped
      integer :: grid_icol

      integer :: icol, color_request_nb
      integer :: mf_message_level_save

      real(kind=MF_DOUBLE) :: opacity_s

#ifdef _MF_FUNC
      character(len=*), parameter :: ROUTINE_NAME = "mfPatch"
#endif
#ifdef _MF_SUBR
      character(len=*), parameter :: ROUTINE_NAME = "msPatch"
#endif

   !------ end of declarations -- execution starts hereafter  ------

#ifdef _MF_FUNC
      handle = 0
#endif

      if( CURRENT_WIN_ID == 0 ) then
         call msFigure()
         if( CURRENT_WIN_ID == 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "cannot plot: no window created!" )
            go to 99
         end if
      end if

      call msInitArgs( x, y )

      ! checking that 'x' is allocated
      if( mfIsEqual(x,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' not allocated!" )
         go to 99
      end if

      ! 'x' must be Real
      if( .not. mfIsReal(x) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' must be real!" )
         go to 99
      end if

      ! 'x' cannot be sparse
      if( mfIsSparse(x) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' cannot be sparse!" )
         go to 99
      end if

      ! 'x' cannot contain NaN values
      if( Any(mfIsNaN(x)) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' cannot contain NaN values!" )
         go to 99
      end if

      call msPointer( x, x_ptr, no_crc=.true., intern_call=.true. )

      ! checking that 'y' is allocated
      if( mfIsEqual(y,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' not allocated!" )
         go to 99
      end if

      ! 'y' must be Real
      if( .not. mfIsReal(y) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' must be real!" )
         go to 99
      end if

      ! 'y' cannot be sparse
      if( mfIsSparse(y) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' cannot be sparse!" )
         go to 99
      end if

      ! 'y' cannot contain NaN values
      if( Any(mfIsNaN(y)) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' cannot contain NaN values!" )
         go to 99
      end if

      call msPointer( y, y_ptr, no_crc=.true., intern_call=.true. )

      if( size(x_ptr,1)==0 .or. size(x_ptr,2)==0 ) then
         call PrintMessage( trim(ROUTINE_NAME), "W",                    &
                            "nothing to plot" )
         go to 99
      end if

      ! checking that 'x' is a 1-D array
      if( size(x_ptr,1)/=1 .and. size(x_ptr,2)/=1 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "cannot yet plot a matrix" )
         go to 99
      else
         if( size(x_ptr,1) == 1 ) then
            p_dim = 2
         else
            p_dim = 1
         end if
         n_dim = size(x_ptr,p_dim)
         n_pg = n_dim
         allocate( x_sto_pg(n_pg) )

         allocate( y_sto_pg(n_pg) )

      end if

      ! checking that 'y' have the same shape than 'x'
      if( size(y_ptr,1) /= size(x_ptr,1) .or.                           &
          size(y_ptr,2) /= size(x_ptr,2)      ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' and 'y' array must have the same size" )
         go to 99
      end if

      if( p_dim == 1 ) then
         x_sto_pg(:) = x_ptr(:,1)
         y_sto_pg(:) = y_ptr(:,1)
      else
         x_sto_pg(:) = x_ptr(1,:)
         y_sto_pg(:) = y_ptr(1,:)
      end if

      call msFreePointer( x, x_ptr )
      call msFreePointer( y, y_ptr )

      if( len_trim(color) == 1 .or. color(1:1) == "\" ) then
         call decode_linespec( color, icol, ier=ier )
         if( ier /= 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                              "bad 'color' argument!",                  &
                              "(color will be set to light grey)" )
            icol = -127
         end if
      else
         call decode_col_name( color, icol )
      end if

      if( icol == -127 ) then
         icol = MFPLOT_LIGHT_GREY
      end if

      if( present(opacity) ) then
         opacity_s = opacity
         if( opacity_s < 0.0d0 .or. 1.0d0 < opacity_s ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "opacity must be in [0,1]" )
            opacity_s = max( min(0.0d0,opacity_s), 1.0d0 )
         end if
      else
         opacity_s = 1.0d0
      end if

      if( present(grid) ) then
         draw_grid = grid
      else
         draw_grid = .false.
      end if

      if( present(grid_color) ) then
         call decode_col_rgb( grid_color, grid_icol )
      else
         grid_icol = MFPLOT_DARK_GREY
      end if

      if( present(clipping) ) then
         clipped = clipping
      else
         clipped = .true.
      end if

      if( opacity_s == 1.0d0 ) then
         handle = PolyFillCore( x_sto_pg, y_sto_pg, icol,               &
                                draw_grid=draw_grid, grid_icol=grid_icol, &
                                clipping=clipped )
      else
         ! For X11, only patch can do transparency
         allocate( icol_sto_pg(n_pg) )
         icol_sto_pg(:) = icol
         handle = PatchPolyCore( x_sto_pg, y_sto_pg, icol_sto_pg,       &
                                 opacity_s, draw_grid=draw_grid,        &
                                 grid_icol=grid_icol )
      end if

 99   continue

      call msFreeArgs( x, y )
      call msAutoRelease( x, y )

#ifdef _MF_FUNC
   end function mfPatch_basic_1_str_2_rgb
#endif
#ifdef _MF_SUBR
   end subroutine msPatch_basic_1_str_2_rgb
#endif
!_______________________________________________________________________
!
#ifdef _MF_FUNC
   function mfPatch_basic_1_rgb_2_str( x, y, color, opacity,            &
                                       grid, grid_color, clipping )     &
   result ( handle )
#endif
#ifdef _MF_SUBR
   subroutine msPatch_basic_1_rgb_2_str( x, y, color, opacity,          &
                                         grid, grid_color, clipping )
#endif

      type(mfArray)                              :: x, y
      real(kind=MF_DOUBLE), intent(in), optional :: color(3)
      real(kind=MF_DOUBLE), intent(in), optional :: opacity
      logical,              intent(in), optional :: grid, clipping
      character(len=*),     intent(in)           :: grid_color

      integer :: handle
      !------ API end ------

      ! Patch "flat" (à une couleur), éventuellement avec de la transparence
      ! par rapport au fond déjà tracé.
      ! Attention : transparence = opacité, en fait.

      ! pointers for manipulating mfArray out of fml module
      real(kind=MF_DOUBLE), pointer :: x_ptr(:,:), y_ptr(:,:)

      real(kind=MF_DOUBLE), pointer :: x_sto_pg(:), y_sto_pg(:)
      integer, pointer :: icol_sto_pg(:)

      integer :: p_dim, n_dim, n_pg, ier
      logical :: draw_grid, clipped
      integer :: grid_icol

      integer :: icol, color_request_nb
      integer :: mf_message_level_save

      real(kind=MF_DOUBLE) :: opacity_s

#ifdef _MF_FUNC
      character(len=*), parameter :: ROUTINE_NAME = "mfPatch"
#endif
#ifdef _MF_SUBR
      character(len=*), parameter :: ROUTINE_NAME = "msPatch"
#endif

   !------ end of declarations -- execution starts hereafter  ------

#ifdef _MF_FUNC
      handle = 0
#endif

      if( CURRENT_WIN_ID == 0 ) then
         call msFigure()
         if( CURRENT_WIN_ID == 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "cannot plot: no window created!" )
            go to 99
         end if
      end if

      call msInitArgs( x, y )

      ! checking that 'x' is allocated
      if( mfIsEqual(x,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' not allocated!" )
         go to 99
      end if

      ! 'x' must be Real
      if( .not. mfIsReal(x) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' must be real!" )
         go to 99
      end if

      ! 'x' cannot be sparse
      if( mfIsSparse(x) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' cannot be sparse!" )
         go to 99
      end if

      ! 'x' cannot contain NaN values
      if( Any(mfIsNaN(x)) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' cannot contain NaN values!" )
         go to 99
      end if

      call msPointer( x, x_ptr, no_crc=.true., intern_call=.true. )

      ! checking that 'y' is allocated
      if( mfIsEqual(y,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' not allocated!" )
         go to 99
      end if

      ! 'y' must be Real
      if( .not. mfIsReal(y) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' must be real!" )
         go to 99
      end if

      ! 'y' cannot be sparse
      if( mfIsSparse(y) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' cannot be sparse!" )
         go to 99
      end if

      ! 'y' cannot contain NaN values
      if( Any(mfIsNaN(y)) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' cannot contain NaN values!" )
         go to 99
      end if

      call msPointer( y, y_ptr, no_crc=.true., intern_call=.true. )

      if( size(x_ptr,1)==0 .or. size(x_ptr,2)==0 ) then
         call PrintMessage( trim(ROUTINE_NAME), "W",                    &
                            "nothing to plot" )
         go to 99
      end if

      ! checking that 'x' is a 1-D array
      if( size(x_ptr,1)/=1 .and. size(x_ptr,2)/=1 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "cannot yet plot a matrix" )
         go to 99
      else
         if( size(x_ptr,1) == 1 ) then
            p_dim = 2
         else
            p_dim = 1
         end if
         n_dim = size(x_ptr,p_dim)
         n_pg = n_dim
         allocate( x_sto_pg(n_pg) )

         allocate( y_sto_pg(n_pg) )

      end if

      ! checking that 'y' have the same shape than 'x'
      if( size(y_ptr,1) /= size(x_ptr,1) .or.                           &
          size(y_ptr,2) /= size(x_ptr,2)      ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' and 'y' array must have the same size" )
         go to 99
      end if

      if( p_dim == 1 ) then
         x_sto_pg(:) = x_ptr(:,1)
         y_sto_pg(:) = y_ptr(:,1)
      else
         x_sto_pg(:) = x_ptr(1,:)
         y_sto_pg(:) = y_ptr(1,:)
      end if

      call msFreePointer( x, x_ptr )
      call msFreePointer( y, y_ptr )

      if( present(color) ) then
         call decode_col_rgb( color, icol )
      else
         icol = MFPLOT_DARK_GREY
      end if

      if( present(opacity) ) then
         opacity_s = opacity
         if( opacity_s < 0.0d0 .or. 1.0d0 < opacity_s ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "opacity must be in [0,1]" )
            opacity_s = max( min(0.0d0,opacity_s), 1.0d0 )
         end if
      else
         opacity_s = 1.0d0
      end if

      if( present(grid) ) then
         draw_grid = grid
      else
         draw_grid = .false.
      end if

      if( len_trim(grid_color) == 1 .or. grid_color(1:1) == "\" ) then
         call decode_linespec( grid_color, grid_icol, ier=ier )
         if( ier /= 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                              "bad 'color' argument!",                  &
                              "(grid color will be set to dark grey)" )
            grid_icol = MFPLOT_DARK_GREY
         end if
      else
         call decode_col_name( grid_color, grid_icol )
      end if

      if( present(clipping) ) then
         clipped = clipping
      else
         clipped = .true.
      end if

      if( opacity_s == 1.0d0 ) then
         handle = PolyFillCore( x_sto_pg, y_sto_pg, icol,               &
                                draw_grid=draw_grid, grid_icol=grid_icol, &
                                clipping=clipped )
      else
         ! For X11, only patch can do transparency
         allocate( icol_sto_pg(n_pg) )
         icol_sto_pg(:) = icol
         handle = PatchPolyCore( x_sto_pg, y_sto_pg, icol_sto_pg,       &
                                 opacity_s, draw_grid=draw_grid,        &
                                 grid_icol=grid_icol )
      end if

 99   continue

      call msFreeArgs( x, y )
      call msAutoRelease( x, y )

#ifdef _MF_FUNC
   end function mfPatch_basic_1_rgb_2_str
#endif
#ifdef _MF_SUBR
   end subroutine msPatch_basic_1_rgb_2_str
#endif
!_______________________________________________________________________
!
#ifdef _MF_FUNC
   function mfPatch_basic_1_rgb_2_rgb( x, y, color, opacity,            &
                                       grid, grid_color, clipping )     &
   result ( handle )
#endif
#ifdef _MF_SUBR
   subroutine msPatch_basic_1_rgb_2_rgb( x, y, color, opacity,          &
                                         grid, grid_color, clipping )
#endif

      type(mfArray)                              :: x, y
      real(kind=MF_DOUBLE), intent(in), optional :: color(3)
      real(kind=MF_DOUBLE), intent(in), optional :: opacity
      logical,              intent(in), optional :: grid, clipping
      real(kind=MF_DOUBLE), intent(in), optional :: grid_color(3)

      integer :: handle
      !------ API end ------

      ! Patch "flat" (à une couleur), éventuellement avec de la transparence
      ! par rapport au fond déjà tracé.
      ! Attention : transparence = opacité, en fait.

      ! pointers for manipulating mfArray out of fml module
      real(kind=MF_DOUBLE), pointer :: x_ptr(:,:), y_ptr(:,:)

      real(kind=MF_DOUBLE), pointer :: x_sto_pg(:), y_sto_pg(:)
      integer, pointer :: icol_sto_pg(:)

      integer :: p_dim, n_dim, n_pg, ier
      logical :: draw_grid, clipped
      integer :: grid_icol

      integer :: icol, color_request_nb
      integer :: mf_message_level_save

      real(kind=MF_DOUBLE) :: opacity_s

#ifdef _MF_FUNC
      character(len=*), parameter :: ROUTINE_NAME = "mfPatch"
#endif
#ifdef _MF_SUBR
      character(len=*), parameter :: ROUTINE_NAME = "msPatch"
#endif

   !------ end of declarations -- execution starts hereafter  ------

#ifdef _MF_FUNC
      handle = 0
#endif

      if( CURRENT_WIN_ID == 0 ) then
         call msFigure()
         if( CURRENT_WIN_ID == 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "cannot plot: no window created!" )
            go to 99
         end if
      end if

      call msInitArgs( x, y )

      ! checking that 'x' is allocated
      if( mfIsEqual(x,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' not allocated!" )
         go to 99
      end if

      ! 'x' must be Real
      if( .not. mfIsReal(x) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' must be real!" )
         go to 99
      end if

      ! 'x' cannot be sparse
      if( mfIsSparse(x) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' cannot be sparse!" )
         go to 99
      end if

      ! 'x' cannot contain NaN values
      if( Any(mfIsNaN(x)) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' cannot contain NaN values!" )
         go to 99
      end if

      call msPointer( x, x_ptr, no_crc=.true., intern_call=.true. )

      ! checking that 'y' is allocated
      if( mfIsEqual(y,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' not allocated!" )
         go to 99
      end if

      ! 'y' must be Real
      if( .not. mfIsReal(y) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' must be real!" )
         go to 99
      end if

      ! 'y' cannot be sparse
      if( mfIsSparse(y) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' cannot be sparse!" )
         go to 99
      end if

      ! 'y' cannot contain NaN values
      if( Any(mfIsNaN(y)) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' cannot contain NaN values!" )
         go to 99
      end if

      call msPointer( y, y_ptr, no_crc=.true., intern_call=.true. )

      if( size(x_ptr,1)==0 .or. size(x_ptr,2)==0 ) then
         call PrintMessage( trim(ROUTINE_NAME), "W",                    &
                            "nothing to plot" )
         go to 99
      end if

      ! checking that 'x' is a 1-D array
      if( size(x_ptr,1)/=1 .and. size(x_ptr,2)/=1 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "cannot yet plot a matrix" )
         go to 99
      else
         if( size(x_ptr,1) == 1 ) then
            p_dim = 2
         else
            p_dim = 1
         end if
         n_dim = size(x_ptr,p_dim)
         n_pg = n_dim
         allocate( x_sto_pg(n_pg) )

         allocate( y_sto_pg(n_pg) )

      end if

      ! checking that 'y' have the same shape than 'x'
      if( size(y_ptr,1) /= size(x_ptr,1) .or.                           &
          size(y_ptr,2) /= size(x_ptr,2)      ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' and 'y' array must have the same size" )
         go to 99
      end if

      if( p_dim == 1 ) then
         x_sto_pg(:) = x_ptr(:,1)
         y_sto_pg(:) = y_ptr(:,1)
      else
         x_sto_pg(:) = x_ptr(1,:)
         y_sto_pg(:) = y_ptr(1,:)
      end if

      call msFreePointer( x, x_ptr )
      call msFreePointer( y, y_ptr )

      if( present(color) ) then
         call decode_col_rgb( color, icol )
      else
         icol = MFPLOT_DARK_GREY
      end if

      if( present(opacity) ) then
         opacity_s = opacity
         if( opacity_s < 0.0d0 .or. 1.0d0 < opacity_s ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "opacity must be in [0,1]" )
            opacity_s = max( min(0.0d0,opacity_s), 1.0d0 )
         end if
      else
         opacity_s = 1.0d0
      end if

      if( present(grid) ) then
         draw_grid = grid
      else
         draw_grid = .false.
      end if

      if( present(grid_color) ) then
         call decode_col_rgb( grid_color, grid_icol )
      else
         grid_icol = MFPLOT_DARK_GREY
      end if

      if( present(clipping) ) then
         clipped = clipping
      else
         clipped = .true.
      end if

      if( opacity_s == 1.0d0 ) then
         handle = PolyFillCore( x_sto_pg, y_sto_pg, icol,               &
                                draw_grid=draw_grid, grid_icol=grid_icol, &
                                clipping=clipped )
      else
         ! For X11, only patch can do transparency
         allocate( icol_sto_pg(n_pg) )
         icol_sto_pg(:) = icol
         handle = PatchPolyCore( x_sto_pg, y_sto_pg, icol_sto_pg,       &
                                 opacity_s, draw_grid=draw_grid,        &
                                 grid_icol=grid_icol )
      end if

 99   continue

      call msFreeArgs( x, y )
      call msAutoRelease( x, y )

#ifdef _MF_FUNC
   end function mfPatch_basic_1_rgb_2_rgb
#endif
#ifdef _MF_SUBR
   end subroutine msPatch_basic_1_rgb_2_rgb
#endif
!_______________________________________________________________________
!
#ifdef _MF_FUNC
   function mfPatch_grad_str( x, y, c, opacity, grid, grid_color )      &
   result ( handle )
#endif
#ifdef _MF_SUBR
   subroutine msPatch_grad_str( x, y, c, opacity, grid, grid_color )
#endif

      type(mfArray)                              :: x, y, c
      real(kind=MF_DOUBLE), intent(in), optional :: opacity
      logical,              intent(in), optional :: grid
      character(len=*),     intent(in)           :: grid_color

      integer :: handle
      !------ API end ------

      ! pointers for manipulating mfArray out of fml module
      real(kind=MF_DOUBLE), pointer :: x_ptr(:,:), y_ptr(:,:), c_ptr(:,:)

      real(kind=MF_DOUBLE), pointer :: x_sto_pg(:), y_sto_pg(:)
      real(kind=MF_DOUBLE), allocatable :: c_pg(:)
      integer, pointer :: icol_sto_pg(:)

      real(kind=MF_DOUBLE) :: opacity_s

      type(mf_win_info), pointer :: win
      integer :: p_dim, n_dim, n_pg
      logical :: draw_grid
      integer :: grid_icol, ier

      integer :: i, icol
      integer :: mf_message_level_save

#ifdef _MF_FUNC
      character(len=*), parameter :: ROUTINE_NAME = "mfPatch"
#endif
#ifdef _MF_SUBR
      character(len=*), parameter :: ROUTINE_NAME = "msPatch"
#endif

   !------ end of declarations -- execution starts hereafter  ------

#ifdef _MF_FUNC
      handle = 0
#endif

      if( CURRENT_WIN_ID == 0 ) then
         call msFigure()
         if( CURRENT_WIN_ID == 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "cannot plot: no window created!" )
            go to 99
         end if
      end if

      call msInitArgs( x, y, c )

      ! checking that 'c' is allocated
      if( mfIsEqual(c,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'c' not allocated!" )
         go to 99
      end if

      ! 'c' must be Real
      if( .not. mfIsReal(c) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'c' must be real!" )
         go to 99
      end if

      ! 'c' cannot be sparse
      if( mfIsSparse(c) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'c' cannot be sparse!" )
         go to 99
      end if

      ! 'c' cannot contain NaN values
      if( Any(mfIsNaN(c)) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'c' cannot contain NaN values!" )
         go to 99
      end if

      call msPointer( c, c_ptr, no_crc=.true. )

      if( any(mf_isnan(c_ptr)) ) then
         call msFreePointer( c, c_ptr )
         go to 99
      end if

      ! checking that 'x' is allocated
      if( mfIsEqual(x,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' not allocated!" )
         go to 99
      end if

      ! 'x' must be Real
      if( .not. mfIsReal(x) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' must be real!" )
         go to 99
      end if

      ! 'x' cannot be sparse
      if( mfIsSparse(x) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' cannot be sparse!" )
         go to 99
      end if

      ! 'x' cannot contain NaN values
      if( Any(mfIsNaN(x)) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' cannot contain NaN values!" )
         go to 99
      end if

      call msPointer( x, x_ptr, no_crc=.true., intern_call=.true. )

      ! checking that 'y' is allocated
      if( mfIsEqual(y,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' not allocated!" )
         go to 99
      end if

      ! 'y' must be Real
      if( .not. mfIsReal(y) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' must be real!" )
         go to 99
      end if

      ! 'y' cannot be sparse
      if( mfIsSparse(y) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' cannot be sparse!" )
         go to 99
      end if

      ! 'y' cannot contain NaN values
      if( Any(mfIsNaN(y)) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' cannot contain NaN values!" )
         go to 99
      end if

      call msPointer( y, y_ptr, no_crc=.true., intern_call=.true. )

      if( size(x_ptr,1)==0 .or. size(x_ptr,2)==0 ) then
         call PrintMessage( trim(ROUTINE_NAME), "W",                    &
                            "nothing to plot" )
         go to 99
      end if

      ! checking that 'x' is a 1-D array
      if( size(x_ptr,1)/=1 .and. size(x_ptr,2)/=1 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "cannot yet plot a matrix" )
         go to 99
      else
         if( size(x_ptr,1) == 1 ) then
            p_dim = 2
         else
            p_dim = 1
         end if
         n_dim = size(x_ptr,p_dim)
         n_pg = n_dim
         allocate( x_sto_pg(n_pg) )
         allocate( y_sto_pg(n_pg) )
         allocate( c_pg(n_pg) )
         allocate( icol_sto_pg(n_pg) )

      end if

      ! checking that 'y' have the same size than 'x'
      if( size(y_ptr,1) /= size(x_ptr,1) .or.                           &
          size(y_ptr,2) /= size(x_ptr,2)      ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' and 'y' array must have the same size" )
         go to 99
      end if

      ! checking that 'c' have the same size than 'x'
      if( size(c_ptr,1) /= size(x_ptr,1) .or.                           &
          size(c_ptr,2) /= size(x_ptr,2)      ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' and 'c' array must have the same size" )
         go to 99
      end if

      if( p_dim == 1 ) then
         x_sto_pg(:) = x_ptr(:,1)
         y_sto_pg(:) = y_ptr(:,1)
         c_pg(:) = c_ptr(:,1)
      else
         x_sto_pg(:) = x_ptr(1,:)
         y_sto_pg(:) = y_ptr(1,:)
         c_pg(:) = c_ptr(1,:)
      end if

      call msFreePointer( x, x_ptr )
      call msFreePointer( y, y_ptr )
      call msFreePointer( c, c_ptr )

      win => mf_win_db(CURRENT_WIN_ID)

      if( .not. win%colormap_init ) then
         call PrintMessage( trim(ROUTINE_NAME), "W",                    &
                            "Colormap has not yet been defined!",       &
                            "(you may obtain strange or unexpected results;", &
                            " in particular, colors may differ between X11", &
                            " screen and printed figure)" )
      end if

      win%colormap_used = .true.

      if( .not. win%color_axis_set ) then
         call PrintMessage( trim(ROUTINE_NAME), "W",                    &
                            "color axis not explicitly defined:",                  &
                            "-> by default the color axis is set to [0,1],", &
                            "   therefore this may lead to color overflow!", &
                            "   (see also 'msSetColorOverflowPolicy')" )
      end if

      ! échelle linéaire pour construire les indices de couleur
      ! dans MFPLOT
      do i = 1, n_pg
         if( c_pg(i) < win%color_axes(1) ) then
            ! out of prescribed real color range -- process only
            ! shading 'interp': the 'flat' case will be processed later on
            if( win%shading /= "flat" ) then
               call PrintMessage( trim(ROUTINE_NAME), "W",              &
                                  "requested color out of range:",      &
                                  "-> this will lead to strange colors!" )
               icol_sto_pg(i) = win%colormap_ci_low ! lower color in colormap
            end if
         else if( c_pg(i) > win%color_axes(2) ) then
            ! out of prescribed real color range -- process only
            ! shading 'interp': the 'flat' case will be processed later on
            if( win%shading /= "flat" ) then
               call PrintMessage( trim(ROUTINE_NAME), "W",              &
                                  "requested color out of range:",      &
                                  "-> this will lead to strange colors!" )
               icol_sto_pg(i) = win%colormap_ci_high ! higher color in colormap
            end if
         else
            icol_sto_pg(i) = win%colormap_ci_low +                      &
                         (win%colormap_ci_high-win%colormap_ci_low)*    &
                         (c_pg(i)-win%color_axes(1))/                   &
                         (win%color_axes(2)-win%color_axes(1))
         end if
      end do

      if( present(opacity) ) then
         opacity_s = opacity
         if( opacity_s < 0.0d0 .or. 1.0d0 < opacity_s ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "opacity must be in [0,1]" )
            opacity_s = max( min(0.0d0,opacity_s), 1.0d0 )
         end if
      else
         opacity_s = 1.0d0
      end if

      if( present(grid) ) then
         draw_grid = grid
      else
         draw_grid = .false.
      end if

      if( len_trim(grid_color) == 1 .or. grid_color(1:1) == "\" ) then
         call decode_linespec( grid_color, grid_icol, ier=ier )
         if( ier /= 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                              "bad 'grid_color' argument!",             &
                              "(grid color will be set to light grey)" )
            grid_icol = -127
         end if
      else
         grid_icol = -127
      end if

      if( grid_icol == -127 ) then
         grid_icol = MFPLOT_LIGHT_GREY
      end if

      if( win%shading == "flat" ) then
         ! uniform color inside the polygon
         icol = sum(icol_sto_pg(:))/n_pg
         if( any(c_pg(:) < win%color_axes(1)) ) then
            if( COLOR_OVERFLOW_LOW_POLICY == 0 ) then
               if( BLACK_ON_WHITE == 1 ) then
                  icol = 1 ! true black
               else
                  icol = MFPLOT_QUASI_BLACK
               end if
            else
               icol = win%colormap_ci_low ! lower color in colormap
            end if
         end if
         if( any(c_pg(:) > win%color_axes(2)) ) then
            if( COLOR_OVERFLOW_HIGH_POLICY == 0 ) then
               if( BLACK_ON_WHITE == 1 ) then
                  icol = MFPLOT_QUASI_WHITE
               else
                  icol = 1 ! true white
               end if
            else
               icol = win%colormap_ci_high ! higher color in colormap
            end if
         end if
         if( opacity_s == 1.0d0 ) then
            handle = PolyFillCore( x_sto_pg, y_sto_pg, icol,            &
                                   draw_grid=draw_grid, grid_icol=grid_icol )
            deallocate( icol_sto_pg )
         else
            ! only patch can do transparency
            icol_sto_pg(:) = icol
            handle = PatchPolyCore( x_sto_pg, y_sto_pg, icol_sto_pg,    &
                                    opacity_s, draw_grid=draw_grid,     &
                                    grid_icol=grid_icol )
         end if
      else if( all( icol_sto_pg(:) == icol_sto_pg(1) ) ) then
         ! uniform color inside the polygon
         if( opacity_s == 1.0d0 ) then
            handle = PolyFillCore( x_sto_pg, y_sto_pg, icol_sto_pg(1),  &
                                   draw_grid=draw_grid, grid_icol=grid_icol )
            deallocate( icol_sto_pg )
         else
            ! only patch can do transparency
            icol_sto_pg(:) = sum(icol_sto_pg(:))/n_pg
            handle = PatchPolyCore( x_sto_pg, y_sto_pg, icol_sto_pg,    &
                                    opacity_s, draw_grid=draw_grid,     &
                                    grid_icol=grid_icol )
         end if
      else
         if( n_pg < 3 ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "too few points in polygon!" )
            go to 99
         end if
         handle = PatchPolyCore( x_sto_pg, y_sto_pg, icol_sto_pg,       &
                                 opacity_s, draw_grid=draw_grid,        &
                                 grid_icol=grid_icol )
      end if

 99   continue

      call msFreeArgs( x, y, c )
      call msAutoRelease( x, y, c )

#ifdef _MF_FUNC
   end function mfPatch_grad_str
#endif
#ifdef _MF_SUBR
   end subroutine msPatch_grad_str
#endif
!_______________________________________________________________________
!
#ifdef _MF_FUNC
   function mfPatch_grad_rgb( x, y, c, opacity, grid, grid_color )      &
   result ( handle )
#endif
#ifdef _MF_SUBR
   subroutine msPatch_grad_rgb( x, y, c, opacity, grid, grid_color )
#endif

      type(mfArray)                              :: x, y, c
      real(kind=MF_DOUBLE), intent(in), optional :: opacity
      logical,              intent(in), optional :: grid
      real(kind=MF_DOUBLE), intent(in), optional :: grid_color(3)

      integer :: handle
      !------ API end ------

      ! pointers for manipulating mfArray out of fml module
      real(kind=MF_DOUBLE), pointer :: x_ptr(:,:), y_ptr(:,:), c_ptr(:,:)

      real(kind=MF_DOUBLE), pointer :: x_sto_pg(:), y_sto_pg(:)
      real(kind=MF_DOUBLE), allocatable :: c_pg(:)
      integer, pointer :: icol_sto_pg(:)

      real(kind=MF_DOUBLE) :: opacity_s

      type(mf_win_info), pointer :: win
      integer :: p_dim, n_dim, n_pg
      logical :: draw_grid
      integer :: grid_icol

      integer :: i, icol
      integer :: mf_message_level_save

#ifdef _MF_FUNC
      character(len=*), parameter :: ROUTINE_NAME = "mfPatch"
#endif
#ifdef _MF_SUBR
      character(len=*), parameter :: ROUTINE_NAME = "msPatch"
#endif

   !------ end of declarations -- execution starts hereafter  ------

#ifdef _MF_FUNC
      handle = 0
#endif

      if( CURRENT_WIN_ID == 0 ) then
         call msFigure()
         if( CURRENT_WIN_ID == 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "cannot plot: no window created!" )
            go to 99
         end if
      end if

      call msInitArgs( x, y, c )

      ! checking that 'c' is allocated
      if( mfIsEqual(c,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'c' not allocated!" )
         go to 99
      end if

      ! 'c' must be Real
      if( .not. mfIsReal(c) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'c' must be real!" )
         go to 99
      end if

      ! 'c' cannot be sparse
      if( mfIsSparse(c) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'c' cannot be sparse!" )
         go to 99
      end if

      ! 'c' cannot contain NaN values
      if( Any(mfIsNaN(c)) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'c' cannot contain NaN values!" )
         go to 99
      end if

      call msPointer( c, c_ptr, no_crc=.true. )

      if( any(mf_isnan(c_ptr)) ) then
         call msFreePointer( c, c_ptr )
         go to 99
      end if

      ! checking that 'x' is allocated
      if( mfIsEqual(x,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' not allocated!" )
         go to 99
      end if

      ! 'x' must be Real
      if( .not. mfIsReal(x) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' must be real!" )
         go to 99
      end if

      ! 'x' cannot be sparse
      if( mfIsSparse(x) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' cannot be sparse!" )
         go to 99
      end if

      ! 'x' cannot contain NaN values
      if( Any(mfIsNaN(x)) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' cannot contain NaN values!" )
         go to 99
      end if

      call msPointer( x, x_ptr, no_crc=.true., intern_call=.true. )

      ! checking that 'y' is allocated
      if( mfIsEqual(y,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' not allocated!" )
         go to 99
      end if

      ! 'y' must be Real
      if( .not. mfIsReal(y) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' must be real!" )
         go to 99
      end if

      ! 'y' cannot be sparse
      if( mfIsSparse(y) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' cannot be sparse!" )
         go to 99
      end if

      ! 'y' cannot contain NaN values
      if( Any(mfIsNaN(y)) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' cannot contain NaN values!" )
         go to 99
      end if

      call msPointer( y, y_ptr, no_crc=.true., intern_call=.true. )

      if( size(x_ptr,1)==0 .or. size(x_ptr,2)==0 ) then
         call PrintMessage( trim(ROUTINE_NAME), "W",                    &
                            "nothing to plot" )
         go to 99
      end if

      ! checking that 'x' is a 1-D array
      if( size(x_ptr,1)/=1 .and. size(x_ptr,2)/=1 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "cannot yet plot a matrix" )
         go to 99
      else
         if( size(x_ptr,1) == 1 ) then
            p_dim = 2
         else
            p_dim = 1
         end if
         n_dim = size(x_ptr,p_dim)
         n_pg = n_dim
         allocate( x_sto_pg(n_pg) )
         allocate( y_sto_pg(n_pg) )
         allocate( c_pg(n_pg) )
         allocate( icol_sto_pg(n_pg) )

      end if

      ! checking that 'y' have the same size than 'x'
      if( size(y_ptr,1) /= size(x_ptr,1) .or.                           &
          size(y_ptr,2) /= size(x_ptr,2)      ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' and 'y' array must have the same size" )
         go to 99
      end if

      ! checking that 'c' have the same size than 'x'
      if( size(c_ptr,1) /= size(x_ptr,1) .or.                           &
          size(c_ptr,2) /= size(x_ptr,2)      ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' and 'c' array must have the same size" )
         go to 99
      end if

      if( p_dim == 1 ) then
         x_sto_pg(:) = x_ptr(:,1)
         y_sto_pg(:) = y_ptr(:,1)
         c_pg(:) = c_ptr(:,1)
      else
         x_sto_pg(:) = x_ptr(1,:)
         y_sto_pg(:) = y_ptr(1,:)
         c_pg(:) = c_ptr(1,:)
      end if

      call msFreePointer( x, x_ptr )
      call msFreePointer( y, y_ptr )
      call msFreePointer( c, c_ptr )

      win => mf_win_db(CURRENT_WIN_ID)

      if( .not. win%colormap_init ) then
         call PrintMessage( trim(ROUTINE_NAME), "W",                    &
                            "Colormap has not yet been defined!",       &
                            "(you may obtain strange or unexpected results;", &
                            " in particular, colors may differ between X11", &
                            " screen and printed figure)" )
      end if

      win%colormap_used = .true.

      if( .not. win%color_axis_set ) then
         call PrintMessage( trim(ROUTINE_NAME), "W",                    &
                            "color axis not explicitly defined:",                  &
                            "-> by default the color axis is set to [0,1],", &
                            "   therefore this may lead to color overflow!", &
                            "   (see also 'msSetColorOverflowPolicy')" )
      end if

      ! échelle linéaire pour construire les indices de couleur
      ! dans MFPLOT
      do i = 1, n_pg
         if( c_pg(i) < win%color_axes(1) ) then
            ! out of prescribed real color range -- process only
            ! shading 'interp': the 'flat' case will be processed later on
            if( win%shading /= "flat" ) then
               call PrintMessage( trim(ROUTINE_NAME), "W",              &
                                  "requested color out of range:",      &
                                  "-> this will lead to strange colors!" )
               icol_sto_pg(i) = win%colormap_ci_low ! lower color in colormap
            end if
         else if( c_pg(i) > win%color_axes(2) ) then
            ! out of prescribed real color range -- process only
            ! shading 'interp': the 'flat' case will be processed later on
            if( win%shading /= "flat" ) then
               call PrintMessage( trim(ROUTINE_NAME), "W",              &
                                  "requested color out of range:",      &
                                  "-> this will lead to strange colors!" )
               icol_sto_pg(i) = win%colormap_ci_high ! higher color in colormap
            end if
         else
            icol_sto_pg(i) = win%colormap_ci_low +                      &
                         (win%colormap_ci_high-win%colormap_ci_low)*    &
                         (c_pg(i)-win%color_axes(1))/                   &
                         (win%color_axes(2)-win%color_axes(1))
         end if
      end do

      if( present(opacity) ) then
         opacity_s = opacity
         if( opacity_s < 0.0d0 .or. 1.0d0 < opacity_s ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "opacity must be in [0,1]" )
            opacity_s = max( min(0.0d0,opacity_s), 1.0d0 )
         end if
      else
         opacity_s = 1.0d0
      end if

      if( present(grid) ) then
         draw_grid = grid
      else
         draw_grid = .false.
      end if

      if( present(grid_color) ) then
         call decode_col_rgb( grid_color, grid_icol )
      else
         grid_icol = MFPLOT_DARK_GREY
      end if

      if( win%shading == "flat" ) then
         ! uniform color inside the polygon
         icol = sum(icol_sto_pg(:))/n_pg
         if( any(c_pg(:) < win%color_axes(1)) ) then
            if( COLOR_OVERFLOW_LOW_POLICY == 0 ) then
               if( BLACK_ON_WHITE == 1 ) then
                  icol = 1 ! true black
               else
                  icol = MFPLOT_QUASI_BLACK
               end if
            else
               icol = win%colormap_ci_low ! lower color in colormap
            end if
         end if
         if( any(c_pg(:) > win%color_axes(2)) ) then
            if( COLOR_OVERFLOW_HIGH_POLICY == 0 ) then
               if( BLACK_ON_WHITE == 1 ) then
                  icol = MFPLOT_QUASI_WHITE
               else
                  icol = 1 ! true white
               end if
            else
               icol = win%colormap_ci_high ! higher color in colormap
            end if
         end if
         if( opacity_s == 1.0d0 ) then
            handle = PolyFillCore( x_sto_pg, y_sto_pg, icol,            &
                                   draw_grid=draw_grid, grid_icol=grid_icol )
            deallocate( icol_sto_pg )
         else
            ! only patch can do transparency
            icol_sto_pg(:) = icol
            handle = PatchPolyCore( x_sto_pg, y_sto_pg, icol_sto_pg,    &
                                    opacity_s, draw_grid=draw_grid,     &
                                    grid_icol=grid_icol )
         end if
      else if( all( icol_sto_pg(:) == icol_sto_pg(1) ) ) then
         ! uniform color inside the polygon
         if( opacity_s == 1.0d0 ) then
            handle = PolyFillCore( x_sto_pg, y_sto_pg, icol_sto_pg(1),  &
                                   draw_grid=draw_grid, grid_icol=grid_icol )
            deallocate( icol_sto_pg )
         else
            ! only patch can do transparency
            icol_sto_pg(:) = sum(icol_sto_pg(:))/n_pg
            handle = PatchPolyCore( x_sto_pg, y_sto_pg, icol_sto_pg,    &
                                    opacity_s, draw_grid=draw_grid,     &
                                    grid_icol=grid_icol )
         end if
      else
         if( n_pg < 3 ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "too few points in polygon!" )
            go to 99
         end if
         handle = PatchPolyCore( x_sto_pg, y_sto_pg, icol_sto_pg,       &
                                 opacity_s, draw_grid=draw_grid,        &
                                 grid_icol=grid_icol )
      end if

 99   continue

      call msFreeArgs( x, y, c )
      call msAutoRelease( x, y, c )

#ifdef _MF_FUNC
   end function mfPatch_grad_rgb
#endif
#ifdef _MF_SUBR
   end subroutine msPatch_grad_rgb
#endif
