!_______________________________________________________________________
!
   subroutine msPan( )

      !------ API end ------

      integer :: itmp
      real(kind=MF_DOUBLE) :: mid_x, mid_y
      real(kind=MF_DOUBLE) :: x_left, x_right, y_bottom, y_top
      real(kind=MF_DOUBLE) :: x_left_z, x_right_z, y_bottom_z, y_top_z
      real(kind=MF_DOUBLE) :: x_left_init, x_right_init, y_bottom_init, y_top_init
      character :: ch
      character(len=4) :: win_id_char
      logical :: legend_exists, legend_grobj, clipping_disabled
      real(kind=MF_DOUBLE) :: range(4)
      real(kind=MF_DOUBLE) :: xscale, yscale
      real(kind=MF_DOUBLE) :: dx_axes, dy_axes
      real(kind=MF_DOUBLE) :: current_axes(4)

      integer :: leg_imin_dev, leg_imax_dev, leg_jmin_dev, leg_jmax_dev

      double precision :: rbuf(1)
      integer :: ibuf(11), lchr
      character(len=16) :: chr

      integer :: x11_legend_xmin, x11_legend_ymin,                      &
                 x11_legend_width, x11_legend_height

      type(mf_win_info), pointer :: win
      type(grobj_elem), pointer :: grobj
      character(len=20) :: cmd

      integer :: X11_WIDTH, X11_HEIGHT
      integer :: WM_left, WM_right, WM_bottom, WM_top
      integer :: VP_width, VP_height
      integer :: Dx, Dx_right, Dy_bottom, Dy, pos_x, pos_y
      double precision :: shift_x, shift_y, GRXORG_init, GRYORG_init
      double precision :: x_left_z_init, y_bottom_z_init
      double precision :: grxmin_QR_save, grxmax_QR_save,               &
                          grymin_QR_save, grymax_QR_save

      integer :: just, colbar
      integer :: i, j, imin, imax, jmin, jmax

      character(len=*), parameter :: ROUTINE_NAME = "msPan"

   !------ end of declarations -- execution starts hereafter  ------

      if( .not. X11_DEVICE ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "X11 device is ""off"".",                   &
                            "('" // trim(ROUTINE_NAME) // "' is an interactive routine which requires X11)" )
         return
      end if

      if( CURRENT_WIN_ID == 0 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "no X11 device selected." )
         return
      end if

      win => mf_win_db(CURRENT_WIN_ID)

      if( win%axis_scale_x == 0 .or. win%axis_scale_y == 0 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "X- and Y-axis not yet defined." )
         return
      end if

      call set_focus_mfplot_win( 1 )

      write(STDOUT,*)
      write(STDOUT,"(A,I0,A)") "  Entering interactive mode in Figure ", &
                               CURRENT_WIN_ID, " ... (ESC to quit)"
      write(STDOUT,*) " [Pan: click and drag to scroll in the axes]"
      write(STDOUT,*)

      ! Switch to 'manual' axis
      ! For printing, the selected subview must be the current view
      !  -> axis_manual must be TRUE.
      !  More generally, 'Pan' and 'Zoom' modes should activate it.
      win%axis_manual_x = 1
      win%axis_manual_y = 1

      ! Saving initial view before scrolling
      x_left_init = win%current_axes(1)
      x_right_init = win%current_axes(2)
      y_bottom_init = win%current_axes(3)
      y_top_init = win%current_axes(4)

      ! Copies required for location test
      x_left   = x_left_init
      x_right  = x_right_init
      y_bottom = y_bottom_init
      y_top    = y_top_init

      ! '_z' suffix concerns internal (always linear) coordinates
      call log_to_lin()

      current_axes(:) = win%current_axes(:)
      if( win%axis_scale_x == 2 ) then ! log scale
         current_axes(1:2) = log10( current_axes(1:2) )
      end if
      if( win%axis_scale_y == 2 ) then ! log scale
         current_axes(3:4) = log10( current_axes(3:4) )
      end if

      ! Here, these values are linear
      dx_axes = current_axes(2) - current_axes(1)
      dy_axes = current_axes(4) - current_axes(3)

      xscale = PGXSCL(PGID)
      yscale = PGYSCL(PGID)

      ! Retrieve Width and Height of viewport (dev. coord)
      VP_width  = GRXMAX(grcide) - GRXMIN(grcide)
      VP_height = GRYMAX(grcide) - GRYMIN(grcide)

      ! Get the X11 window dimension
      ibuf(1) = 0
      rbuf(1) = 0.0d0
      call grexec( grgtyp, GET_DEF_SIZE, rbuf, ibuf, chr, lchr )
      X11_WIDTH  = ibuf(2)
      X11_HEIGHT = ibuf(4)

      ! Get the width of the four white margins (WM_*) around the viewport.
      WM_left   = grxmin(grcide) + X11_XMARGIN
      WM_right  = X11_WIDTH - ( grxmax(grcide) + X11_XMARGIN )
      WM_bottom = grymin(grcide) + X11_YMARGIN
      WM_top    = X11_HEIGHT - ( grymax(grcide) + X11_YMARGIN )

      ! Compute the distances Dx_* and Dy_*, which are the maximum possible
      ! shift during the move using the pointer.
      Dx = WM_right  + VP_width  ! Dx is a shortcut for Dx_left
      Dy = WM_bottom + VP_height ! Dy is a shortcut for Dy_top
      Dx_right  = WM_left + VP_width
      Dy_bottom = WM_top  + VP_height

      ! Compute limit for active the cursor (actually, the viewport)
      imin = nint(pgxorg(pgid) + x_left_z*pgxscl(pgid)) + X11_XMARGIN
      imax = nint(pgxorg(pgid) + x_right_z*pgxscl(pgid)) + X11_XMARGIN
      jmax = X11_HEIGHT - ( nint(pgyorg(pgid)                           &
                            + y_bottom_z*pgyscl(pgid)) + X11_YMARGIN )
      jmin = X11_HEIGHT - ( nint(pgyorg(pgid)                           &
                            + y_top_z*pgyscl(pgid)) + X11_YMARGIN )

      ! Only one legend can be accounted for (if others exist, they will
      ! be drawn, anyway, during the full redrawing).
      legend_exists = .false.
      legend_grobj = .false.
      if( associated(win%legend) ) then
         legend_exists = .true.
      else
         grobj => win%grobj_head
         do
            if( .not. associated(grobj) ) exit
            if( .not. grobj%struct%visible ) then
               grobj => grobj%next
               cycle
            end if
            cmd = grobj%struct%cmd
            select case( cmd )
               case( "legend" )
                  legend_exists = .true.
                  legend_grobj = .true.
                  exit
            end select
            grobj => grobj%next
         end do
      end if
      if( legend_exists ) then
         ! Select the pixmap
         ibuf(1) = 2 ! Target is the 2nd aux pixmap
         call grexec( grgtyp, SELECT_AUX_PIXMAP, rbuf, ibuf, chr, lchr )

         ! Redraw legend only
         gr_text_in_legend = .true. ! (see mf_win_redraw)
         if( legend_grobj ) then
            call redraw_legend_X11( CURRENT_WIN_ID, grobj%struct )
         else
            call redraw_legend_X11( CURRENT_WIN_ID )
         end if
         gr_text_in_legend = .false.

         ! Reduction of the 2nd aux pixmap
         call grexec( grgtyp, REDUCE_2ND_AUX_PIXMAP, rbuf, ibuf, chr, lchr )
         ! Save legend position and size (X11 coords)
         x11_legend_xmin   = ibuf(1)
         x11_legend_ymin   = ibuf(2)
         x11_legend_width  = ibuf(3)
         x11_legend_height = ibuf(4)
         leg_imin_dev = ibuf(1)
         leg_jmin_dev = ibuf(2)
         leg_imax_dev = leg_imin_dev + ibuf(3)
         leg_jmax_dev = leg_jmin_dev + ibuf(4)

      end if

      if( win%colorbar == 0 ) then
         colbar = 0
      else
         if( win%colorbar_pos == "ri" ) then
            colbar = 1
         else ! colorbar_pos = "bi"
            colbar = 2
         end if
      end if
      if( win%axis_equal ) then
         ! scaled axis
         just = 1
      else
         ! automatic axis
         just = 0
      end if

      ! Select an auxiliary pixmap of dimension:
      !    VP_width+Dx_left+Dx_right  VP_height+Dy_bottom+Dy_top
      ibuf(1) = 1 ! Target is the auxiliary pixmap
      ibuf(2) = 1 ! Size is given
      ibuf(3) = VP_width  + Dx + Dx_right
      ibuf(4) = VP_height + Dy + Dy_bottom
      call grexec( grgtyp, SELECT_AUX_PIXMAP, rbuf, ibuf, chr, lchr )

      GRXORG_save = GRXORG(grcide)
      GRYORG_save = GRYORG(grcide)

      GRXORG_init = GRXORG_save
      GRYORG_init = GRYORG_save

      ! Shift the coordinates origin in GRPCKG: the viewport must be
      ! correctly located in the auxiliary pixmap.
      !### WARNING: The following definitions should match those
      !             at lines 497-498
      GRXORG(grcide) = GRXORG(grcide) + VP_width  - Dx_right  + Dx - 1
      GRYORG(grcide) = GRYORG(grcide) - VP_height + Dy_bottom - Dy + 1

      ! TLC of the plotting area (in the main pixmap !)
      pos_x = nint( grxmin(grcide) )
      pos_y = nint( grymax(grcide) )

      grxmin_save = grxmin(grcide)
      grxmax_save = grxmax(grcide)
      grymin_save = grymin(grcide)
      grymax_save = grymax(grcide)

      ! Define new limits for 'Quick Return' in many routine of GRPCKG
      grxmin(grcide) = grxmin(grcide) + VP_width  - Dx
      grxmax(grcide) = grxmax(grcide) + VP_width  + Dx_right
      grymin(grcide) = grymin(grcide) - VP_height - Dy_bottom
      grymax(grcide) = grymax(grcide) - VP_height + Dy

      grxmin_QR_save = grxmin(grcide)
      grxmax_QR_save = grxmax(grcide)
      grymin_QR_save = grymin(grcide)
      grymax_QR_save = grymax(grcide)

      ! New axes limits in World Coordinates (used for Quick Return)
      !   x_left_QR * GRXSCL(grcide) = grxmin(grcide) - GRXORG(grcide)
      !       = old_grxmin  + VP_width - Dx - old_GRXORG - VP_width
      x_left_QR  = win%current_axes(1) - Dx       / GRXSCL(grcide)
      x_right_QR = win%current_axes(2) + Dx_right / GRXSCL(grcide)

      !   y_min_QR * GRYSCL(grcide) = grymin(grcide) - GRYORG(grcide)
      !       = old_grymin - VP_height - Dy_bottom - old_GRYORG + VP_height
      y_bottom_QR = win%current_axes(3) - Dy_bottom / GRYSCL(grcide)
      y_top_QR    = win%current_axes(4) + Dy        / GRYSCL(grcide)

      MF_QR_in_aux_pixmap = .true.

!### TODO: why a double specification of "no clipping" ?
!          (once via grexec, then via the 'no_clipping' arg of 'mf_win_redraw')
!          (see the same remark in 'MoveGrObj_aux.f90')
      ! For X11 : no clipping (drawing will be automatically clipped at
      ! the pixmap boundaries)
      clipping_disabled = .false.
      if( CLIPPING_IN_AXES ) then
         ibuf(1) = 0 ! no clipping at viewport
         call grexec( grgtyp, SET_CLIPPING, rbuf, ibuf, chr, lchr ) ! set clipping
         CLIPPING_IN_AXES = .false.
         clipping_disabled = .true.
      end if

      ! Redraw all graphic objects (except the axes, their label and the
      ! legend) in the aux. pixmap.
      call mf_win_redraw( CURRENT_WIN_ID, usual_grobj_only=.true.,      &
                          no_clipping=.true. )

      MF_QR_in_aux_pixmap = .false.

      ibuf(1) = 0 ! Target is the main pixmap
      call grexec( grgtyp, SELECT_AUX_PIXMAP, rbuf, ibuf, chr, lchr )

      if( clipping_disabled ) then
         ! Restore the clipping at the viewport
         ibuf(1) = 1 ! clipping
         call grexec( grgtyp, SET_CLIPPING, rbuf, ibuf, chr, lchr ) ! set clipping
         CLIPPING_IN_AXES = .true.
      end if

      !=================================================================
      do

         ! Wait for a click (mouse down) or a key pressed
         if( legend_exists ) then
            itmp = grcurs_dyn_plus_exclude( MF_OPENED_HAND_CURSOR,      &
                                            imin, imax, jmin, jmax,     &
                     leg_imin_dev, leg_imax_dev, leg_jmin_dev, leg_jmax_dev, &
                     i, j, ch )
         else
            itmp = grcurs_dyn( MF_OPENED_HAND_CURSOR, imin, imax, jmin, jmax, &
                               i, j, ch )
         end if

         ch = to_upper(ch)

         if( ch == "R" ) then ! right button click (down)

            ! Wait for a click (mouse up)
            if( grcurs( MF_WATCH_CURSOR, i, j, 0, 0, 0, 0, ch, 0 ) == 0 ) then
               write(win_id_char,"(I0)") CURRENT_WIN_ID
               call PrintMessage( trim(ROUTINE_NAME), "E",              &
                                 "no cursor device for win ID: " // trim(adjustl(win_id_char)) )
               return
            end if

            ! Reset to initial view
!!print "(1X,2(A,ES10.3))", "x_left = ", x_left, ",   new val. = ", x_left_init
            x_left   = x_left_init
            x_right  = x_right_init
            y_bottom = y_bottom_init
            y_top    = y_top_init

            call log_to_lin()

!!print "(1X,2(A,ES10.3))", "pgxblc(pgid) = ", pgxblc(pgid), ",   new val. = ", x_left_z
            pgxblc(pgid) = x_left_z
            pgxtrc(pgid) = x_right_z
            pgyblc(pgid) = y_bottom_z
            pgytrc(pgid) = y_top_z

!!print "(1X,2(A,ES12.5))", "GRXORG(grcide) = ", GRXORG(grcide), ",   new val. = ", GRXORG_init
            GRXORG(grcide) = GRXORG_init
            GRYORG(grcide) = GRYORG_init

!!print *, "now: call redraw_in_aux_pixmap()"
            call redraw_in_aux_pixmap()

!!print "(1X,2(A,ES12.5))", "GRXORG(grcide) = ", GRXORG(grcide), ",   new val. = ", GRXORG_init
            GRXORG(grcide) = GRXORG_init
            GRYORG(grcide) = GRYORG_init

!!print *, "now: call redraw_axes()"
            call redraw_axes()

         else if( ch == "L" ) then ! left button click (down)

            itmp = gr_set_cursor_shape( MF_CLOSED_HAND_CURSOR )

            ! Scrolling in the large pixmap
            ibuf(1) = Dx
            ibuf(2) = Dy
            ibuf(3) = VP_width
            ibuf(4) = VP_height
            ibuf(5) = pos_x
            ibuf(6) = pos_y
            ibuf(7) = x11_legend_xmin
            ibuf(8) = x11_legend_ymin
            ibuf(9) = x11_legend_width
            ibuf(10) = x11_legend_height
            if( win%axis_on ) then
               ibuf(11) = 1
            else
               ibuf(11) = 0
            end if
            call grexec( grgtyp, SCROLL_IN_PIXMAP, rbuf, ibuf, chr, lchr )
            if( ibuf(5) == 0 .and. ibuf(6) == 0 ) cycle

            ! In case of exit, the new axis values must be known
            ! Shift obtained must be converted into world coordinates
            shift_x = ibuf(5)/xscale
            shift_y = ibuf(6)/yscale

            ! Shift PGBAND limits for next call
            x_left_z   = x_left_z   - shift_x
            x_right_z  = x_right_z  - shift_x
            y_bottom_z = y_bottom_z + shift_y
            y_top_z    = y_top_z    + shift_y

            call lin_to_log()

            call redraw_in_aux_pixmap()

         else if( ch == "6" ) then ! '6' key or ctrl-right click

            ! Wait for a click (mouse up)
            if( grcurs( MF_WATCH_CURSOR, i, j, 0, 0, 0, 0, ch, 0 ) == 0 ) then
               write(win_id_char,"(I0)") CURRENT_WIN_ID
               call PrintMessage( trim(ROUTINE_NAME), "E",              &
                                 "no cursor device for win ID: " // trim(adjustl(win_id_char)) )
               return
            end if

            ! Centers the view with respect to the bounding box of  all
            ! graphic obj.
            range(:) = get_true_min_max(CURRENT_WIN_ID)
            x_left   = range(1)
            x_right  = range(2)
            y_bottom = range(3)
            y_top    = range(4)

            call log_to_lin()

            mid_x = (x_left_z+x_right_z)/2.0d0
            mid_y = (y_bottom_z+y_top_z)/2.0d0

            ! dx_axes and dy_axes already take care of lin/log scales.
            x_left_z   = mid_x - dx_axes/2.0d0
            x_right_z  = mid_x + dx_axes/2.0d0
            y_bottom_z = mid_y - dy_axes/2.0d0
            y_top_z    = mid_y + dy_axes/2.0d0

            call lin_to_log()

            pgxblc(pgid) = x_left_z
            pgxtrc(pgid) = x_right_z
            pgyblc(pgid) = y_bottom_z
            pgytrc(pgid) = y_top_z

            ! Compute the shift with respect to the initial view
            if( win%axis_scale_x == 1 ) then ! lin scale
               x_left_z_init = x_left_init
            else                             ! log scale
               x_left_z_init = log10(x_left_init)
            end if
            if( win%axis_scale_y == 1 ) then ! lin scale
               y_bottom_z_init = y_bottom_init
            else                             ! log scale
               y_bottom_z_init = log10(y_bottom_init)
            end if
            shift_x = ( x_left_z   - x_left_z_init )   * GRXSCL(grcide)
            shift_y = ( y_bottom_z - y_bottom_z_init ) * GRYSCL(grcide)

            GRXORG(grcide) = GRXORG_init - shift_x
            GRYORG(grcide) = GRYORG_init - shift_y

            call redraw_in_aux_pixmap()

            GRXORG(grcide) = GRXORG_init - shift_x
            GRYORG(grcide) = GRYORG_init - shift_y

            call redraw_axes()

         else if( ichar(ch) == 27 ) then ! ESCAPE key pressed

            exit ! do loop

         end if

      end do

      grxmin(grcide) = grxmin_save
      grxmax(grcide) = grxmax_save
      grymin(grcide) = grymin_save
      grymax(grcide) = grymax_save

      GRXORG(grcide) = GRXORG_save
      GRYORG(grcide) = GRYORG_save
      pgxorg(pgid) = GRXORG_save
      pgyorg(pgid) = GRYORG_save

      win%current_axes(:) = [ x_left, x_right, y_bottom, y_top ]

      itmp = gr_set_cursor_shape( MF_LEFT_ARROW_CURSOR )

      call set_focus_mfplot_win( 0 )

   contains
      !_________________________________________________________________
      !
      subroutine redraw_in_aux_pixmap()

         ! Select an auxiliary pixmap
         ibuf(1) = 1 ! Target is the auxiliary pixmap
         ibuf(2) = 1 ! Size is given
         ibuf(3) = VP_width  + Dx + Dx_right
         ibuf(4) = VP_height + Dy + Dy_bottom
         call grexec( grgtyp, SELECT_AUX_PIXMAP, rbuf, ibuf, chr, lchr )

         ! Keep these saved values. They will be used by
         ! 'call_mf_pgtbox_from_x11_driver' and 'pgptxt'
         GRXORG_save = GRXORG(grcide)
         GRYORG_save = GRYORG(grcide)

         ! Locate the viewport in the auxiliary pixmap
         !### WARNING: The following definitions should match those
         !             at lines 234-235
         GRXORG(grcide) = GRXORG(grcide) + VP_width  - Dx_right  + Dx - 1
         GRYORG(grcide) = GRYORG(grcide) - VP_height + Dy_bottom - Dy + 1

         ! Define limits for 'Quick return' in GRPCKG
         grxmin(grcide) = grxmin_QR_save
         grxmax(grcide) = grxmax_QR_save
         grymin(grcide) = grymin_QR_save
         grymax(grcide) = grymax_QR_save

         ibuf(1) = 0 ! no clipping at viewport
         call grexec( grgtyp, SET_CLIPPING, rbuf, ibuf, chr, lchr ) ! set clipping

         ! New axes limits in World Coordinates (used for Quick Return)
         !   x_left_QR * GRXSCL(grcide) = grxmin(grcide) - GRXORG(grcide)
         !       = old_grxmin  + VP_width - Dx - old_GRXORG - VP_width
         x_left_QR  = x_left  - Dx       / GRXSCL(grcide)
         x_right_QR = x_right + Dx_right / GRXSCL(grcide)

         !   y_min_QR * GRYSCL(grcide) = grymin(grcide) - GRYORG(grcide)
         !       = old_grymin - VP_height - Dy_bottom - old_GRYORG + VP_height
         y_bottom_QR = y_bottom - Dy_bottom / GRYSCL(grcide)
         y_top_QR    = y_top    + Dy        / GRYSCL(grcide)

         MF_QR_in_aux_pixmap = .true.

         ! Redraw in the auxiliary pixmap
         call mf_win_redraw( CURRENT_WIN_ID, usual_grobj_only=.true.,   &
                             no_clipping=.true. )

         MF_QR_in_aux_pixmap = .false.

         ibuf(1) = 0 ! Target is the main pixmap
         call grexec( grgtyp, SELECT_AUX_PIXMAP, rbuf, ibuf, chr, lchr )

         ! Restore clipping at the viewport
         ibuf(1) = 1 ! clipping
         call grexec( grgtyp, SET_CLIPPING, rbuf, ibuf, chr, lchr ) ! set clipping

      end subroutine redraw_in_aux_pixmap
      !_________________________________________________________________
      !
      subroutine redraw_axes()

         if( win%axis_on ) then
            ! Erase the labelling area around the viewport
            call grexec( grgtyp, ERASE_LABEL_AREA_AROUND, rbuf, ibuf, chr, lchr )
         end if

         ! Update the main pixmap from the auxiliary one
         ibuf(1) = Dx
         ibuf(2) = Dy
         ibuf(3) = VP_width
         ibuf(4) = VP_height
         ibuf(5) = x11_legend_xmin
         ibuf(6) = x11_legend_ymin
         ibuf(7) = x11_legend_width
         ibuf(8) = x11_legend_height
         call grexec( grgtyp, UPDATE_MAIN_PIXMAP, rbuf, ibuf, chr, lchr )

         if( win%axis_on ) then
            ! Set the character height,
            call pgsch( pg_axe_fnt_siz_fct(pgid) * pg_char_height_factor(pgid) )

            call grslw( pg_axis_lin_width(pgid) )

            ! Redraw the ticks and numerical labelling
            call pgtbox( XOPT_SAVE, 0.0d0, 0, YOPT_SAVE, 0.0d0, 0 )
         end if

      end subroutine redraw_axes
      !_________________________________________________________________
      !
      subroutine lin_to_log()

         if( win%axis_scale_x == 1 ) then ! lin scale
            x_left = x_left_z
            x_right = x_right_z
         else                             ! log scale
            x_left = 10.0d0**x_left_z
            x_right = 10.0d0**x_right_z
         end if

         if( win%axis_scale_y == 1 ) then ! lin scale
            y_bottom = y_bottom_z
            y_top = y_top_z
         else                             ! log scale
            y_bottom = 10.0d0**y_bottom_z
            y_top = 10.0d0**y_top_z
         end if

      end subroutine lin_to_log
      !_________________________________________________________________
      !
      subroutine log_to_lin()

         if( win%axis_scale_x == 1 ) then ! lin scale
            x_left_z = x_left
            x_right_z = x_right
         else ! log scale
            x_left_z = log10(x_left)
            x_right_z = log10(x_right)
         end if

         if( win%axis_scale_y == 1 ) then ! lin scale
            y_bottom_z = y_bottom
            y_top_z = y_top
         else ! log scale
            y_bottom_z = log10(y_bottom)
            y_top_z = log10(y_top)
         end if

      end subroutine log_to_lin
      !_________________________________________________________________
      !
   end subroutine msPan
