!_______________________________________________________________________
!
   subroutine msMoveLegend( handle )

      integer, intent(in), optional :: handle
      !------ API end ------

      integer :: itmp
      real(kind=MF_DOUBLE) :: dx, dy, x0, y0, x0_dev, y0_dev
      real(kind=MF_DOUBLE) :: x_shift, y_shift
      real(kind=MF_DOUBLE) :: xscale, yscale
      character(len=4) :: win_id_char
      real(kind=MF_DOUBLE) :: dx_axes, dy_axes
      real(kind=MF_DOUBLE) :: current_axes(4)

      character(len=*), parameter :: ROUTINE_NAME = "msMoveLegend"

      type(mf_win_info), pointer :: win
      type(grobj_elem), pointer :: grobj
      integer :: X11_WIDTH, X11_HEIGHT

      type(legend_struct), pointer :: legend_ptr => null()
      integer :: win_id0, hdle
      logical :: clipping_disabled

      double precision :: rbuf(1)
      integer :: ibuf(4), lchr
      character(len=1) :: chr

   !------ end of declarations -- execution starts hereafter  ------

      if( .not. X11_DEVICE ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "X11 device is ""off"".",                   &
                            "('" // trim(ROUTINE_NAME) // "' is an interactive routine which requires X11)" )
         return
      end if

      if( CURRENT_WIN_ID == 0 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "no X11 device selected." )
         return
      end if

      win => mf_win_db(CURRENT_WIN_ID)

      if( present(handle) ) then
         call decode_handle( handle, win_id0, hdle )
         if( win_id0 /= CURRENT_WIN_ID ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                              "bad grobj handle!" )
            return
         end if
         ! legend is inside a grobj (it has a handle)
         grobj => win%handles(hdle)%ptr
         if( .not. associated( grobj ) ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "bad handle!" )
            return
         end if
         legend_ptr => grobj%struct%legend
      else
         ! legend has no handle (it is unique in the figure)
         legend_ptr => win%legend
      end if

      if( .not. associated(legend_ptr) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "current figure has no legend" )
         return
      end if

      if( legend_ptr%outside ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "A legend drawn 'outside' cannot be moved!" )
         return
      end if

      call set_focus_mfplot_win( 1 )

      write(STDOUT,*)
      write(STDOUT,"(A,I0,A)") "  Entering interactive mode in Figure ", &
                               CURRENT_WIN_ID, " ... (ESC to quit)"
      write(STDOUT,*) " [click the legend and drag to move it]"
      write(STDOUT,*)

      ! Preparation of move

      current_axes(:) = win%current_axes(:)
      if( win%axis_scale_x == 2 ) then ! log scale
         current_axes(1:2) = log10( current_axes(1:2) )
      end if
      if( win%axis_scale_y == 2 ) then ! log scale
         current_axes(3:4) = log10( current_axes(3:4) )
      end if

      dx_axes = current_axes(2) - current_axes(1)
      dy_axes = current_axes(4) - current_axes(3)

      xscale = PGXSCL(PGID) * dx_axes
      yscale = PGYSCL(PGID) * dy_axes

      ! Redraw all things, except the legend itself
      if( present(handle) ) then
         call mf_win_redraw( CURRENT_WIN_ID, stm_legend_hdl=hdle )
      else
         call mf_win_redraw( CURRENT_WIN_ID, stm_legend_ano=.true. )
      end if

      ! Get the X11 window dimension
      ibuf(1) = 0
      rbuf(1) = 0.0d0
      call grexec( grgtyp, GET_DEF_SIZE, rbuf, ibuf, chr, lchr )
      X11_WIDTH  = ibuf(2)
      X11_HEIGHT = ibuf(4)

      ! Select the pixmap: (enlarged auxiliary pixmap, because legend may be
      ! initially outside the window...)
      ibuf(1) = 1 ! Target is the auxiliary pixmap
      ibuf(2) = 1
      ibuf(3) = X11_WIDTH  + 500 ! enlarged width
      ibuf(4) = X11_HEIGHT + 500 ! enlarged height
      call grexec( grgtyp, SELECT_AUX_PIXMAP, rbuf, ibuf, chr, lchr )

      clipping_disabled = .false.
      if( CLIPPING_IN_AXES ) then
         ibuf(1) = 0 ! no clipping at viewport
         call grexec( grgtyp, SET_CLIPPING, rbuf, ibuf, chr, lchr ) ! set clipping
         CLIPPING_IN_AXES = .false.
         clipping_disabled = .true.
      end if

      gr_text_in_legend = .true. ! (see mf_win_redraw)

      ! first detect if legend frame has a TLC outside the X11 window
      ! (i.e. at least one negative X11 coords)
      x0 = legend_ptr%xmin ! this is relative coords
      y0 = legend_ptr%ymax
      ! convert first to world coords...
      x0 = current_axes(1) + x0*dx_axes
      y0 = current_axes(3) + y0*dy_axes
      ! convert to device coords...
      call gr_wld_to_dev( x0, y0, x0_dev, y0_dev )
      ! and then, convert to X11 pixels.
      x0 = x0_dev + X11_XMARGIN
      y0 = X11_HEIGHT - (y0_dev+X11_YMARGIN)

      if( x0 < 0.0d0 .or. y0 < 0.0d0 ) then
         ! move the pixmap in the center of the axes...
         x_shift = ( X11_WIDTH/2 - x0 ) / xscale
         y_shift = -( X11_HEIGHT/2 - y0 ) / xscale
         legend_ptr%x0 = legend_ptr%x0 + x_shift
         legend_ptr%y0 = legend_ptr%y0 + y_shift
         legend_ptr%xmin = legend_ptr%xmin + x_shift
         legend_ptr%xmax = legend_ptr%xmax + x_shift
         legend_ptr%ymin = legend_ptr%ymin + y_shift
         legend_ptr%ymax = legend_ptr%ymax + y_shift
      end if

      if( present(handle) ) then
         call redraw_legend_X11( CURRENT_WIN_ID, grobj%struct )
      else
         call redraw_legend_X11( CURRENT_WIN_ID )
      end if
      gr_text_in_legend = .false.

      ! Select the pixmap
      ibuf(1) = 0 ! Target is the main pixmap
      call grexec( grgtyp, SELECT_AUX_PIXMAP, rbuf, ibuf, chr, lchr )

      ! Move auxiliary pixmap
      ibuf(1) = 0 ! legend frame is not clipped at viewport
      call grexec( grgtyp, MOVE_GROBJ_PIXMAP, rbuf, ibuf, chr, lchr )
      dx = ibuf(1)
      dy = ibuf(2)

      if( clipping_disabled ) then
         ibuf(1) = 1 ! clipping at viewport
         call grexec( grgtyp, SET_CLIPPING, rbuf, ibuf, chr, lchr ) ! set clipping
         CLIPPING_IN_AXES = .true.
      end if

      ! change legend position only if there is a shift of at leat one pixel
      if( abs(dx) > 0 .or. abs(dy) > 0 ) then

         ! pixels converted in relative coords
         dx = dx/xscale
         dy = dy/yscale

         legend_ptr%x0 = legend_ptr%x0 + dx
         legend_ptr%y0 = legend_ptr%y0 + dy
         legend_ptr%xmin = legend_ptr%xmin + dx
         legend_ptr%xmax = legend_ptr%xmax + dx
         legend_ptr%ymin = legend_ptr%ymin + dy
         legend_ptr%ymax = legend_ptr%ymax + dy

      end if

      ! needed to eliminate the dashed contour around the moving grobj
      ! (indeed, the dashed line may remain over other grobjs having a
      !  lower level)
      call mf_win_redraw( CURRENT_WIN_ID )

      itmp = gr_set_cursor_shape( MF_LEFT_ARROW_CURSOR )

      call set_focus_mfplot_win( 0 )

   end subroutine msMoveLegend
