!_______________________________________________________________________
!
   subroutine msMoveGrObj_no_rot( win, grobj, prompt )

      type(mf_win_info), pointer            :: win
      type(grobj_elem),  pointer            :: grobj
      character(len=*),          intent(in) :: prompt
      !------ API end ------

      integer :: itmp
      real(kind=MF_DOUBLE) :: dx, dy
      integer :: hdle
      character(len=20) :: cmd

      double precision :: rbuf(1)
      integer :: ibuf(2), lchr
      character(len=1) :: chr

      logical :: legend_exists, legend_grobj
      logical :: clipped, clipping_disabled

      character(len=*), parameter :: ROUTINE_NAME = "msMoveGrObj"

   !------ end of declarations -- execution starts hereafter  ------

      if( len_trim(prompt) /= 0 ) then
         print "(A)", trim(prompt)
      end if

      call set_focus_mfplot_win( 1 )

      write(STDOUT,*)
      write(STDOUT,"(A,I0,A)") "  Entering interactive mode in Figure ", &
                               CURRENT_WIN_ID, " ... (ESC to quit)"
      write(STDOUT,*) " [click and drag according to your choice]"
      write(STDOUT,*)

      ! preparation of move

      hdle = grobj%struct%hdle

      ! By default, target drawable is the main pixmap

      ! redraw all things, except the specified grobj and its successors
      call mf_win_redraw( CURRENT_WIN_ID, stm_before_hdl=hdle )

      ibuf(1) = 1 ! Target drawable is the 1st auxiliary pixmap
      ibuf(2) = 0 ! Default size
      call grexec( grgtyp, SELECT_AUX_PIXMAP, rbuf, ibuf, chr, lchr )

!### TODO: why a double specification of "no clipping" ?
!          (once via grexec, then via the 'no_clipping' arg of 'mf_win_redraw')
!          (see the same remark in 'Pan.f90')
      ! For X11 : no clipping (drawing will be automatically clipped at
      ! the pixmap boundaries)
      clipping_disabled = .false.
      if( CLIPPING_IN_AXES ) then
         ibuf(1) = 0 ! no clipping at viewport
         call grexec( grgtyp, SET_CLIPPING, rbuf, ibuf, chr, lchr ) ! set clipping
         CLIPPING_IN_AXES = .false.
         clipping_disabled = .true.
      end if

      ! redraw only the grobj itself
      call mf_win_redraw( CURRENT_WIN_ID, stm_only_hdl=hdle,            &
                          no_clipping=.true. )

      if( clipping_disabled ) then
         ! Restore the clipping at the viewport
         ibuf(1) = 1 ! clipping
         call grexec( grgtyp, SET_CLIPPING, rbuf, ibuf, chr, lchr ) ! set clipping
         CLIPPING_IN_AXES = .true.
      end if

      ibuf(1) = 2 ! Target drawable is the 2nd auxiliary pixmap
      call grexec( grgtyp, SELECT_AUX_PIXMAP, rbuf, ibuf, chr, lchr )

      ! redraw the successors of the specified grobj
      call mf_win_redraw( CURRENT_WIN_ID, stm_after_hdl=hdle )

      ! Only one legend can be accounted for (if others exist, they will
      ! be drawn, anyway, during the full redrawing).
      legend_exists = .false.
      legend_grobj = .false.
      if( associated(win%legend) ) then
         legend_exists = .true.
      else
         grobj => win%grobj_head
         do
            if( .not. associated(grobj) ) exit
            if( .not. grobj%struct%visible ) then
               grobj => grobj%next
               cycle
            end if
            cmd = grobj%struct%cmd
            select case( cmd )
               case( "legend" )
                  legend_exists = .true.
                  legend_grobj = .true.
                  exit
            end select
            grobj => grobj%next
         end do
      end if
      if( legend_exists ) then
         ! Redraw legend only
         gr_text_in_legend = .true. ! (see mf_win_redraw)
         if( legend_grobj ) then
            call redraw_legend_X11( CURRENT_WIN_ID, grobj%struct )
         else
            call redraw_legend_X11( CURRENT_WIN_ID )
         end if
         gr_text_in_legend = .false.
      end if

      ibuf(1) = 0 ! Target drawable is the main pixmap
      call grexec( grgtyp, SELECT_AUX_PIXMAP, rbuf, ibuf, chr, lchr )

      ! Move auxiliary pixmap (interactive mode).
      ! Taking care of clipping.
      select case( grobj%struct%cmd )
         case( "polygon" )
            clipped = grobj%struct%bool1
         case( "text" )
            clipped = grobj%struct%bool1
      end select
      if( clipped ) then
         ibuf(1) = 1 ! grobj is clipped at viewport
      else
         ibuf(1) = 0 ! grobj is not clipped at viewport
      end if
      call grexec( grgtyp, MOVE_GROBJ_PIXMAP, rbuf, ibuf, chr, lchr )

      ! change grobj position only if there is a shift of at leat one pixel
      if( abs(ibuf(1)) > 0 .or. abs(ibuf(2)) > 0 ) then

         ! pixels converted in world coords
         dx = ibuf(1)/PGXSCL(PGID)
         dy = ibuf(2)/PGYSCL(PGID)

         select case( grobj%struct%cmd )
            case( "polygon" )
               grobj%struct%abs_tab = grobj%struct%abs_tab + dx
               grobj%struct%ord_tab = grobj%struct%ord_tab + dy
            case( "text" )
               grobj%struct%x_text = grobj%struct%x_text + dx
               grobj%struct%y_text = grobj%struct%y_text + dy
         end select

      end if

      ! needed to eliminate the dashed contour around the moving grobj
      ! (indeed, the dashed line may remain over other grobjs)
      call mf_win_redraw( CURRENT_WIN_ID )

      itmp = gr_set_cursor_shape( MF_LEFT_ARROW_CURSOR )

      call set_focus_mfplot_win( 0 )

   end subroutine msMoveGrObj_no_rot
!_______________________________________________________________________
!
   subroutine msMoveGrObj_arrow( win, grobj, prompt )

      type(mf_win_info), pointer            :: win
      type(grobj_elem),  pointer            :: grobj
      character(len=*),          intent(in) :: prompt
      !------ API end ------

      real(kind=MF_DOUBLE) :: x_start, y_start, x_end, y_end
      integer :: itmp
      real(kind=MF_DOUBLE) :: dx, dy
      integer :: hdle
      character(len=20) :: cmd
      double precision :: ch, dh, xs1, xs2, ys1, ys2

      double precision :: rbuf(2)
      integer :: ibuf(5), lchr
      character(len=1) :: chr

      logical :: legend_exists, legend_grobj
      logical :: clipped, clipping_disabled

      character(len=*), parameter :: ROUTINE_NAME = "msMoveGrObj"

   !------ end of declarations -- execution starts hereafter  ------

      if( len_trim(prompt) /= 0 ) then
         print "(A)", trim(prompt)
      end if

      call set_focus_mfplot_win( 1 )

      write(STDOUT,*)
      write(STDOUT,"(A,I0,A)") "  Entering interactive mode in Figure ", &
                               CURRENT_WIN_ID, " ... (ESC to quit)"
      write(STDOUT,*) " [click and drag according to your choice]"
      write(STDOUT,*)

      ! Preparation of move

      hdle = grobj%struct%hdle

      ! Send arrow geometry and attributes to the X11 driver.
      ! Convert to device coords.
      call gr_wld_to_dev( grobj%struct%x_text, grobj%struct%y_text,     &
                          x_start, y_start )
      call gr_wld_to_dev( grobj%struct%ang_text, grobj%struct%just_text, &
                          x_end, y_end )
      ibuf(1) = nint(x_start)
      ibuf(2) = nint(y_start)
      ibuf(3) = nint(x_end)
      ibuf(4) = nint(y_end)
      ibuf(5) = grobj%struct%color       ! color index
      rbuf(1) = grobj%struct%linewidth   ! line width
      ch = grobj%struct%height_symb
      call pgqvsz( 3, xs1, xs2, ys1, ys2 )
      dh = ch*min(xs2,ys2)/40.0d0
      rbuf(2) = dh ! length of arrowhead (see pgarro)
      call grexec( grgtyp, PREP_ARROW_MOVE, rbuf, ibuf, chr, lchr )

      ! By default, target drawable is the main pixmap

      ! Redraw all things, except the specified grobj and its successors
      call mf_win_redraw( CURRENT_WIN_ID, stm_before_hdl=hdle )

      ibuf(1) = 2 ! Target drawable is the 2nd auxiliary pixmap
      call grexec( grgtyp, SELECT_AUX_PIXMAP, rbuf, ibuf, chr, lchr )

      ! redraw the successors of the specified grobj
      call mf_win_redraw( CURRENT_WIN_ID, stm_after_hdl=hdle )

      ! Only one legend can be accounted for (if others exist, they will
      ! be drawn, anyway, during the full redrawing).
      legend_exists = .false.
      legend_grobj = .false.
      if( associated(win%legend) ) then
         legend_exists = .true.
      else
         grobj => win%grobj_head
         do
            if( .not. associated(grobj) ) exit
            if( .not. grobj%struct%visible ) then
               grobj => grobj%next
               cycle
            end if
            cmd = grobj%struct%cmd
            select case( cmd )
               case( "legend" )
                  legend_exists = .true.
                  legend_grobj = .true.
                  exit
            end select
            grobj => grobj%next
         end do
      end if
      if( legend_exists ) then
         ! Redraw legend only
         gr_text_in_legend = .true. ! (see mf_win_redraw)
         if( legend_grobj ) then
            call redraw_legend_X11( CURRENT_WIN_ID, grobj%struct )
         else
            call redraw_legend_X11( CURRENT_WIN_ID )
         end if
         gr_text_in_legend = .false.
      end if

      ibuf(1) = 0 ! Target drawable is the main pixmap
      call grexec( grgtyp, SELECT_AUX_PIXMAP, rbuf, ibuf, chr, lchr )

      ! Move arrow, taking care of clipping
      clipped = grobj%struct%bool1
      if( clipped ) then
         ibuf(1) = 1 ! grobj is clipped at viewport
      else
         ibuf(1) = 0 ! grobj is not clipped at viewport
      end if
      call grexec( grgtyp, MOVE_ARROW, rbuf, ibuf, chr, lchr )

      ! Update new position of the arrow
      x_start = ibuf(1)
      y_start = ibuf(2)
      x_end   = ibuf(3)
      y_end   = ibuf(4)
      ! Convert to world coords.
      call gr_dev_to_wld( x_start, y_start,                             &
                          grobj%struct%x_text, grobj%struct%y_text )
      call gr_dev_to_wld( x_end, y_end,                                 &
                          grobj%struct%ang_text, grobj%struct%just_text )

      ! needed to eliminate the dashed contour around the moving grobj
      ! (indeed, the dashed line may remain over other grobjs)
      call mf_win_redraw( CURRENT_WIN_ID )

      itmp = gr_set_cursor_shape( MF_LEFT_ARROW_CURSOR )

      call set_focus_mfplot_win( 0 )

   end subroutine msMoveGrObj_arrow

