!_______________________________________________________________________
!
   subroutine msMoveGrObj( handle, prompt )

      integer,          intent(in)           :: handle
      character(len=*), intent(in), optional :: prompt
      !------ API end ------

      integer :: hdle, win_id0

      type(mf_win_info), pointer :: win
      type(grobj_elem), pointer :: grobj
      integer :: axis_manual_save_x, axis_manual_save_y
      character(len=256) :: prompt0

      character(len=*), parameter :: ROUTINE_NAME = "msMoveGrObj"

   !------ end of declarations -- execution starts hereafter  ------

      if( .not. X11_DEVICE ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "X11 device is ""off"".",                   &
                            "('" // trim(ROUTINE_NAME) // "' is an interactive routine which requires X11)" )
         return
      end if

      if( CURRENT_WIN_ID == 0 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "no X11 device selected." )
         return
      end if

      win => mf_win_db(CURRENT_WIN_ID)
      if( all( win%current_axes(:) == 0.0d0 ) ) then
         ! set the whole graphic env, keeping the 'manual' status
         axis_manual_save_x = win%axis_manual_x
         axis_manual_save_y = win%axis_manual_y
         call msAxis( [ 0.0d0, 1.0d0, 0.0d0, 1.0d0 ] )
         win%axis_manual_x = axis_manual_save_x
         win%axis_manual_y = axis_manual_save_y
      end if

      call decode_handle( handle, win_id0, hdle )
      if( win_id0 /= CURRENT_WIN_ID ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "bad grobj handle!" )
         return
      end if

      ! do handle exist?
      if( hdle < 1 .or. size(win%handles) < hdle ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "handle out of range!" )
         return
      end if

      grobj => win%handles(hdle)%ptr

      ! do grobj exist?
      if( .not. associated( grobj ) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "bad handle!" )
         return
      end if

      select case( grobj%struct%cmd )

         case( "polygon" )
            if( present(prompt) ) then
               prompt0 = prompt
            else
               prompt0 = "  -> Grab and move the polygon surrounded by a dashed line..."
            end if
            call msMoveGrObj_no_rot( win, grobj, prompt0 )

         case( "text" )
            if( present(prompt) ) then
               prompt0 = prompt
            else
               prompt0 = "  -> Grab and move the text string surrounded by a dashed line..."
            end if
            call msMoveGrObj_no_rot( win, grobj, prompt0 )

         case( "arrow" )
            if( present(prompt) ) then
               prompt0 = prompt
            else
               prompt0 = "  -> Grab and move the arrow wearing three hotspots..."
            end if
            call msMoveGrObj_arrow( win, grobj, prompt0 )

         case default
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "bad graphic object type!",              &
                               "(MoveGrObj supports only Text and Arrow objects)" )
            return

      end select

   end subroutine msMoveGrObj
