!_______________________________________________________________________
!
   subroutine redraw_legend_X11( win_id, grobj_struct_ptr )

      integer, intent(in) :: win_id
      type(grobj_struct), optional :: grobj_struct_ptr
      !------ API end ------

      type(mf_win_info), pointer :: win
      type(grobj_elem), pointer :: grobj
      integer :: i, nb_leg
      real(kind=MF_DOUBLE) :: xbox(5), ybox(5), x0, y0, DL_x, DL_y, xcur, ycur
      real(kind=MF_DOUBLE) :: dx_axes, dy_axes
      real(kind=MF_DOUBLE) :: current_axes(4)
      real(kind=MF_DOUBLE) :: proto_width

      logical :: bar_plot, clipping_disabled
      integer :: icol

      type(legend_struct), pointer :: legend_ptr => null()
      integer :: hdle

      double precision :: rbuf(1)
      integer :: ibuf(1), lchr
      character(len=1) :: chr

   !------ end of declarations -- execution starts hereafter  ------

      win => mf_win_db(win_id)

      if( present(grobj_struct_ptr) ) then
         ! legend is inside a grobj (it has a handle)
         legend_ptr => grobj_struct_ptr%legend
      else
         ! legend has no handle (it is unique in the figure)
         legend_ptr => win%legend
      end if

!### TODO: des cas où il faudrait modifier la légende ?
      ! no redraw if outside (small window)
      if( legend_ptr%outside ) return

      current_axes(:) = win%current_axes(:)
      if( win%axis_scale_x == 2 ) then ! log scale
         current_axes(1:2) = log10( current_axes(1:2) )
      end if
      if( win%axis_scale_y == 2 ) then ! log scale
         current_axes(3:4) = log10( current_axes(3:4) )
      end if

      dx_axes = current_axes(2) - current_axes(1)
      dy_axes = current_axes(4) - current_axes(3)

      x0 = legend_ptr%x0 * dx_axes + current_axes(1)
      y0 = legend_ptr%y0 * dy_axes + current_axes(3)
      DL_x = legend_ptr%DL_x * dx_axes
      DL_y = legend_ptr%DL_y * dy_axes
      proto_width = legend_ptr%proto_width * dx_axes

!### TODO ?:
! setting default value (not adapted if enlarging window),
! moreover, doesn't match the current symbol size ...
      call pgsch(1.0d0)

      call grslw(1.0d0)
      call grsls(1)

      ! Legend is the only exception for which the clipping inside axes is
      ! disabled.
      clipping_disabled = .false.
      if( CLIPPING_IN_AXES ) then
         ibuf(1) = 0 ! no clipping
         call grexec( grgtyp, SET_CLIPPING, rbuf, ibuf, chr, lchr ) ! set clipping
         CLIPPING_IN_AXES = .false.
         clipping_disabled = .true.
      end if

      ! erasing the current part of the plot located inside
      ! the legend box...
      call grsci(MFPLOT_QUASI_BACKGROUND) ! quasi background color, because we
                                          ! don't want a transparency when
                                          ! moving the legend.
      xbox(1) = legend_ptr%xmin * dx_axes + current_axes(1)
      xbox(3) = legend_ptr%xmax * dx_axes + current_axes(1)
      ybox(3) = legend_ptr%ymin * dy_axes + current_axes(3)
      ybox(1) = legend_ptr%ymax * dy_axes + current_axes(3)
      call grrect( xbox(1), ybox(1), xbox(3), ybox(3), filled=.true. )

      call grsci(1) ! foreground color
      call grrect( xbox(1), ybox(1), xbox(3), ybox(3), filled=.false. )

      ! check if a "groups of bars" or a "stacked bars" plot is the first grobj
      bar_plot = .false.
      grobj => win%grobj_head
      if( associated(grobj) ) then
         if( grobj%struct%cmd == "bar_groups_stacks" ) then
            bar_plot = .true.
         end if
      end if

      xcur = x0
      ycur = y0
      nb_leg = size( legend_ptr%legends )

      ! drawing lines and associated legends
      if( associated(legend_ptr%hdle) ) then

         ! legends by handle
         do i = 1, nb_leg
            hdle = legend_ptr%hdle(i)
            grobj => win%handles(hdle)%ptr

            if( grobj%struct%cmd == "line" .or.                         &
                grobj%struct%cmd == "cubic_bezier" .or.                 &
                grobj%struct%cmd == "quadr_bezier" ) then
               call grsci(grobj%struct%color)
               call grslw(grobj%struct%linewidth)
               call grsls(grobj%struct%linestyle)
               call pgline( 2, [ xcur, xcur+proto_width ], [ ycur+DL_y/2, ycur+DL_y/2 ] )
               xcur = xcur + proto_width + DL_x
               call grsci(1)
               call pgptxt(xcur,ycur,0.d0,0.d0,0.d0,trim(legend_ptr%legends(i)))
               xcur = x0
               ycur = ycur - 2*DL_y
            else if( grobj%struct%cmd == "point"  ) then
               call grsci(grobj%struct%color)
               call grsms(grobj%struct%markersize)
               call pgpt( 1, [ xcur+proto_width/2 ], [ ycur+DL_y/2 ],   &
                          grobj%struct%marker )
               xcur = xcur + proto_width + DL_x
               call grsci(1)
               call pgptxt(xcur,ycur,0.d0,0.d0,0.d0,trim(legend_ptr%legends(i)))
               xcur = x0
               ycur = ycur - 2*DL_y
            else if( grobj%struct%cmd == "line+point"  ) then
               call grsci(grobj%struct%color)
               call grslw(grobj%struct%linewidth)
               call grsls(grobj%struct%linestyle)
               call pgline( 2, [ xcur, xcur+proto_width ], [ ycur+DL_y/2, ycur+DL_y/2 ] )
               call grsms(grobj%struct%markersize)
               call pgpt( 1, [ xcur+proto_width/2 ], [ ycur+DL_y/2 ],   &
                          grobj%struct%marker )
               xcur = xcur + proto_width + DL_x
               call grsci(1)
               call pgptxt(xcur,ycur,0.d0,0.d0,0.d0,trim(legend_ptr%legends(i)))
               xcur = x0
               ycur = ycur - 2*DL_y
            else
               ! do nothing
            end if

         end do

      else

         ! legends by curve
         i = 0
         grobj => win%grobj_head
         if( bar_plot ) then
            icol = 1
            do i = 1, nb_leg
               if( associated(grobj%struct%col_tab) ) then
                  icol = grobj%struct%col_tab(i)
               else
                  ! cycling colors (between 2 and 15)
                  icol = icol + 1
                  if( icol > 15 ) icol = 2
               end if
               call grsci(icol)
               call grslw(6.6d0)
               call pgline( 2, [ xcur, xcur+2*DL_x ], [ ycur+DL_y/2, ycur+DL_y/2 ] )
               xcur = xcur + 3*DL_x
               call grsci(1)
               call grslw(1.d0)
               call pgptxt(xcur,ycur,0.d0,0.d0,0.d0,trim(legend_ptr%legends(i)))
               xcur = x0
               ycur = ycur - 2*DL_y
            end do
         else
            do ! scanning the 'grobj' linked list
               if( i+1 > nb_leg ) exit

               if( .not. associated(grobj) ) exit

               if( grobj%struct%cmd == "line" .or.                      &
                   grobj%struct%cmd == "cubic_bezier" .or.              &
                   grobj%struct%cmd == "quadr_bezier" ) then
                  call grsci(grobj%struct%color)
                  call grslw(grobj%struct%linewidth)
                  call grsls(grobj%struct%linestyle)
                  call pgline( 2, [ xcur, xcur+proto_width ], [ ycur+DL_y/2, ycur+DL_y/2 ] )
                  xcur = xcur + proto_width + DL_x
                  call grsci(1)
                  i = i + 1
                  call pgptxt(xcur,ycur,0.d0,0.d0,0.d0,trim(legend_ptr%legends(i)))
                  xcur = x0
                  ycur = ycur - 2*DL_y
               else if( grobj%struct%cmd == "point"  ) then
                  call grsci(grobj%struct%color)
                  call grsms(grobj%struct%markersize)
                  call pgpt( 1, [ xcur+proto_width/2 ], [ ycur+DL_y/2 ], &
                             grobj%struct%marker )
                  xcur = xcur + proto_width + DL_x
                  call grsci(1)
                  i = i + 1
                  call pgptxt(xcur,ycur,0.d0,0.d0,0.d0,trim(legend_ptr%legends(i)))
                  xcur = x0
                  ycur = ycur - 2*DL_y
               else if( grobj%struct%cmd == "line+point"  ) then
                  call grsci(grobj%struct%color)
                  call grslw(grobj%struct%linewidth)
                  call grsls(grobj%struct%linestyle)
                  call pgline( 2, [ xcur, xcur+proto_width ], [ ycur+DL_y/2, ycur+DL_y/2 ] )
                  call grsms(grobj%struct%markersize)
                  call pgpt( 1, [ xcur+proto_width/2 ], [ ycur+DL_y/2 ], &
                             grobj%struct%marker )
                  xcur = xcur + proto_width + DL_x
                  call grsci(1)
                  i = i + 1
                  call pgptxt(xcur,ycur,0.d0,0.d0,0.d0,trim(legend_ptr%legends(i)))
                  xcur = x0
                  ycur = ycur - 2*DL_y
               end if

               grobj => grobj%next

            end do
         end if

      end if

      if( clipping_disabled ) then
         ibuf(1) = 1 ! clipping at viewport
         call grexec( grgtyp, SET_CLIPPING, rbuf, ibuf, chr, lchr ) ! set clipping
         CLIPPING_IN_AXES = .true.
      end if

   end subroutine redraw_legend_X11
!_______________________________________________________________________
!
   subroutine redraw_legend_EPS_PDF( win_id, grobj_struct_ptr )

      integer, intent(in) :: win_id
      type(grobj_struct), optional :: grobj_struct_ptr
      !------ API end ------

      type(mf_win_info), pointer :: win
      type(grobj_elem), pointer :: grobj
      integer :: i, nb_leg
      real(kind=MF_DOUBLE) :: xbox(5), ybox(5), x0, y0, DL_x, DL_y,     &
                              xcur, ycur,                               &
                              xmin_dev, ymin_dev, xmax_dev, ymax_dev,   &
                              EPS_PDF_xmargin, EPS_PDF_ymargin
      real(kind=MF_DOUBLE) :: dx_axes, dy_axes
      real(kind=MF_DOUBLE) :: current_axes(4)
      real(kind=MF_DOUBLE) :: proto_width, length_wc
      integer :: istyle, dash_pattern_period

      logical :: bar_plot, clipping_disabled
      integer :: icol
      logical :: bbox_changed

      real(kind=MF_DOUBLE) :: dx, dy, X1, X2, Y1, Y2,                   &
                              pix_per_x_unit, pix_per_y_unit

      type(legend_struct), pointer :: legend_ptr => null()
      integer :: hdle

      ! adding comments in the EPS or PDF file
      integer :: ibuf(4), lchr
      character :: chr
      real(kind=MF_DOUBLE) :: rbuf(4)

   !------ end of declarations -- execution starts hereafter  ------

      if( PRINTING_EPS ) then
         if( COMMENTS_IN_EPS ) then
            ibuf(1) = 0
            call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- begin of Legend", 0 )
         end if
      end if
      if( PRINTING_PDF ) then
         if( COMMENTS_IN_PDF ) then
            call pdf_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- begin of Legend", 0 )
         end if
      end if

      win => mf_win_db(win_id)

      if( present(grobj_struct_ptr) ) then
         ! legend is inside a grobj (it has a handle)
         legend_ptr => grobj_struct_ptr%legend
      else
         ! legend has no handle (it is unique in the figure)
         legend_ptr => win%legend
      end if

!### TODO ?:
! setting default value (not adapted if enlarging window),
! moreover, doesn't match the current symbol size ...
      call pgsch(1.0d0)

      current_axes(:) = win%current_axes(:)
      if( win%axis_scale_x == 2 ) then ! log scale
         current_axes(1:2) = log10( current_axes(1:2) )
      end if
      if( win%axis_scale_y == 2 ) then ! log scale
         current_axes(3:4) = log10( current_axes(3:4) )
      end if

      dx_axes = current_axes(2) - current_axes(1)
      dy_axes = current_axes(4) - current_axes(3)

      ! keep old position (x0,y0)...
      x0 = legend_ptr%x0 * dx_axes + current_axes(1)
      y0 = legend_ptr%y0 * dy_axes + current_axes(3)

      ! ... but recompute the length of the string
      ! inquiring text size (for the longer legend)
      call pgqtxt( 0.0d0, 0.0d0, 0.0d0, 0.0d0,                          &
                   legend_ptr%legends(legend_ptr%legend_i_max),         &
                   xbox, ybox )
      dx = xbox(3)
      dy = ybox(3) ! this is the characteristic length...
      DL_y = dy    ! in terms of the y-axis scale
      ! Set a smaller DL_y, in order to get a good layout in the EPS files
      DL_y = 0.6667d0*DL_y
      call PGQVP(3, X1, X2, Y1, Y2)
      pix_per_x_unit = X2 - X1
      pix_per_y_unit = Y2 - Y1
      call PGQWIN(X1, X2, Y1, Y2)
      pix_per_x_unit = pix_per_x_unit/(X2-X1)
      pix_per_y_unit = pix_per_y_unit/(Y2-Y1)
      DL_x = dy*pix_per_y_unit/pix_per_x_unit ! in terms of the x-axis scale

      !### Check if legend was outside... in such a case we have to modify (x0,y0)
      if( legend_ptr%outside ) then
         x0 = x0 + current_axes(2) + 3.*DL_x/2.
      end if

      ! check if a "groups of bars" or a "stacked bars" plot is the first grobj
      bar_plot = .false.
      grobj => win%grobj_head
      if( associated(grobj) ) then
         if( grobj%struct%cmd == "bar_groups_stacks" ) then
            bar_plot = .true.
         end if
      end if

      nb_leg = size( legend_ptr%legends )

      ! proto_width is the width of the curve prototype: it has not a constant
      ! value because it depends on the dash pattern (if any).
      if( bar_plot ) then
         proto_width = 2*DL_x
      else
         proto_width = 2*DL_x ! minimum value
         i = 0
         grobj => win%grobj_head
         do ! scanning the 'grobj' linked list
            if( i+1 > nb_leg ) exit

            if( .not. associated(grobj) ) exit

            if( grobj%struct%cmd == "line" .or.                         &
                grobj%struct%cmd == "cubic_bezier" .or.                 &
                grobj%struct%cmd == "quadr_bezier" .or.                 &
                grobj%struct%cmd == "line+point" ) then

               call grslw(grobj%struct%linewidth)
               call grsls(grobj%struct%linestyle)
               call grqls( istyle, dash_pattern_period )
               ! convert to world coords (x-axis)
               length_wc = 1.5d0*dash_pattern_period/grxscl(grcide)
               if( length_wc > proto_width ) proto_width = length_wc
            end if

            grobj => grobj%next

         end do

      end if

      call grslw(1.0d0)
      call grsls(1)

      ! Legend is the only exception for which the clipping inside axes is
      ! disabled.
      clipping_disabled = .false.
      if( CLIPPING_IN_AXES ) then
         ibuf(1) = 0 ! no clipping
         call grexec( grgtyp, SET_CLIPPING, rbuf, ibuf, chr, lchr ) ! set clipping
         CLIPPING_IN_AXES = .false.
         clipping_disabled = .true.
      end if

      gr_pdf_color_intent = 2 ! Fill
      ! erasing the current part of the plot located inside
      ! the legend box...
      call grsci(0) ! background color
      xbox(1) = x0 - DL_x/2.
      ybox(1) = y0 + DL_y + DL_y
      xbox(3) = x0 + DL_x/2. + proto_width + DL_x/2. + dx + DL_x/2.
      ybox(3) = y0 - 2.*DL_y*(nb_leg-1) - DL_y

      ! If the legend frame is drawn outside the window, we must update
      ! the BBox.
      ! Convert in device coordinates
      call gr_wld_to_dev( xbox(1), ybox(1), xmin_dev, ymax_dev )
      call gr_wld_to_dev( xbox(3), ybox(3), xmax_dev, ymin_dev )
      ! Convert pixels in EPS or PDF device
      EPS_PDF_xmargin = X11_XMARGIN / 0.072d0
      EPS_PDF_ymargin = X11_YMARGIN / 0.072d0
      bbox_changed = .false.
      if( xmin_dev < -EPS_PDF_xmargin ) then
         ibuf(1) = nint( min( xmin_dev, -EPS_PDF_xmargin ) )
         ! enlarge slightly the corresponding direction
         ibuf(1) = ibuf(1) - 0.015d0*(grxmxa(grcide)+EPS_PDF_xmargin-ibuf(1))
         bbox_changed = .true.
      else
         ibuf(1) = nint( -EPS_PDF_xmargin )
      end if
      if( ymin_dev < -EPS_PDF_ymargin ) then
         ibuf(2) = nint( min( ymin_dev, -EPS_PDF_ymargin ) )
         ! enlarge slightly the corresponding direction
         ibuf(2) = ibuf(2) - 0.015d0*(grymxa(grcide)+EPS_PDF_ymargin-ibuf(2))
         bbox_changed = .true.
      else
         ibuf(2) = nint( -EPS_PDF_ymargin )
      end if
      if( xmax_dev > grxmxa(grcide)+EPS_PDF_xmargin ) then
         ibuf(3) = nint( max( xmax_dev, grxmxa(grcide)+EPS_PDF_xmargin ) )
         ! enlarge slightly the corresponding direction
         ibuf(3) = ibuf(3) + 0.015d0*(ibuf(3)+EPS_PDF_xmargin)
         bbox_changed = .true.
      else
         ibuf(3) = nint( grxmxa(grcide)+EPS_PDF_xmargin )
      end if
      if( ymax_dev > grymxa(grcide)+EPS_PDF_ymargin ) then
         ibuf(4) = nint( max( ymax_dev, grymxa(grcide)+EPS_PDF_ymargin ) )
         ! enlarge slightly the corresponding direction
         ibuf(4) = ibuf(4) + 0.015d0*(ibuf(4)+EPS_PDF_ymargin)
         bbox_changed = .true.
      else
         ibuf(4) = nint( grymxa(grcide)+EPS_PDF_ymargin )
      end if
      if( bbox_changed ) then
         call grexec( grgtyp, UPDATE_BBOX, rbuf, ibuf, chr, lchr )
      end if

      call grrect( xbox(1), ybox(1), xbox(3), ybox(3), filled=.true. )

      gr_pdf_color_intent = 1 ! Stroke
      call grsci(1) ! foreground color
      call grrect( xbox(1), ybox(1), xbox(3), ybox(3), filled=.false. )

      xcur = x0
      ycur = y0
      nb_leg = size( legend_ptr%legends )

      ! drawing lines and associated legends
      if( associated(legend_ptr%hdle) ) then

         ! legends by handle
         do i = 1, nb_leg
            hdle = legend_ptr%hdle(i)
            grobj => win%handles(hdle)%ptr

            if( grobj%struct%cmd == "line" .or.                         &
                grobj%struct%cmd == "cubic_bezier" .or.                 &
                grobj%struct%cmd == "quadr_bezier" ) then
               gr_pdf_color_intent = 1 ! Stroke
               call grsci(grobj%struct%color)
               call grslw(grobj%struct%linewidth)
               call grsls(grobj%struct%linestyle)
               call pgline( 2, [ xcur, xcur+proto_width ], [ ycur+DL_y/2, ycur+DL_y/2 ] )
               xcur = xcur + proto_width + DL_x
               gr_pdf_color_intent = 2 ! Fill
               call grsci(1)
               call pgptxt(xcur,ycur,0.d0,0.d0,0.d0,trim(legend_ptr%legends(i)))
               xcur = x0
               ycur = ycur - 2*DL_y
            else if( grobj%struct%cmd == "point"  ) then
               gr_pdf_color_intent = 3 ! Stroke and Fill
               call grsci(grobj%struct%color)
               call grsms(grobj%struct%markersize)
               call pgpt( 1, [ xcur+proto_width/2 ], [ ycur+DL_y/2 ],   &
                          grobj%struct%marker )
               xcur = xcur + proto_width + DL_x
               gr_pdf_color_intent = 2 ! Fill
               call grsci(1)
               call pgptxt(xcur,ycur,0.d0,0.d0,0.d0,trim(legend_ptr%legends(i)))
               xcur = x0
               ycur = ycur - 2*DL_y
            else if( grobj%struct%cmd == "line+point"  ) then
               gr_pdf_color_intent = 3 ! Stroke and Fill
               call grsci(grobj%struct%color)
               call grslw(grobj%struct%linewidth)
               call grsls(grobj%struct%linestyle)
               call pgline( 2, [ xcur, xcur+proto_width ], [ ycur+DL_y/2, ycur+DL_y/2 ] )
               call grsms(grobj%struct%markersize)
               call pgpt( 1, [ xcur+proto_width/2 ], [ ycur+DL_y/2 ],   &
                          grobj%struct%marker )
               xcur = xcur + proto_width + DL_x
               gr_pdf_color_intent = 2 ! Fill
               call grsci(1)
               call pgptxt(xcur,ycur,0.d0,0.d0,0.d0,trim(legend_ptr%legends(i)))
               xcur = x0
               ycur = ycur - 2*DL_y
            else
               ! do nothing
            end if

         end do

      else

         i = 0
         ! drawing lines and associated legends
         grobj => win%grobj_head
         if( bar_plot ) then
            icol = 1
            do i = 1, nb_leg
               if( associated(grobj%struct%col_tab) ) then
                  icol = grobj%struct%col_tab(i)
               else
                  ! cycling colors (between 2 and 15)
                  icol = icol + 1
                  if( icol > 15 ) icol = 2
               end if
               gr_pdf_color_intent = 1 ! Stroke
               call grsci(icol)
!### TODO: modification empirique pour avoir le même aspect dans les EPS et PDF
               if( PRINTING_EPS ) then
                  call grslw(6.0d0)
               else ! PRINTING_PDF
                  call grslw(7.0d0)
               end if

               ! Set appropriate cap and join style for the lines.
               ibuf(1) = 0 ! Cap butt
               ibuf(2) = 0 ! Join miter
               call grexec( grgtyp, SET_LINE_CAP_JOIN_STYLE, rbuf, ibuf, chr, lchr )

               call pgline( 2, [ xcur, xcur+2*DL_x ], [ ycur+DL_y/2, ycur+DL_y/2 ] )

               ! Set appropriate cap and join style for the lines.
               ibuf(1) = 1 ! Cap round
               ibuf(2) = 1 ! Join round
               call grexec( grgtyp, SET_LINE_CAP_JOIN_STYLE, rbuf, ibuf, chr, lchr )

               xcur = xcur + 3*DL_x
               gr_pdf_color_intent = 2 ! Fill
               call grsci(1)
               call grslw(1.0d0)
               call pgptxt(xcur,ycur,0.d0,0.d0,0.d0,trim(legend_ptr%legends(i)))
               xcur = x0
               ycur = ycur - 2*DL_y
            end do
         else
            do ! scanning the 'grobj' linked list
               if( i+1 > nb_leg ) exit

               if( .not. associated(grobj) ) exit

               if( grobj%struct%cmd == "line" .or.                      &
                   grobj%struct%cmd == "cubic_bezier" .or.              &
                   grobj%struct%cmd == "quadr_bezier" ) then
                  gr_pdf_color_intent = 1 ! Stroke
                  call grsci(grobj%struct%color)
                  call grslw(grobj%struct%linewidth)
                  call grsls(grobj%struct%linestyle)
                  call pgline( 2, [ xcur, xcur+proto_width ], [ ycur+DL_y/2, ycur+DL_y/2 ] )
                  xcur = xcur + proto_width + DL_x
                  gr_pdf_color_intent = 2 ! Fill
                  call grsci(1)
                  i = i + 1
                  call pgptxt(xcur,ycur,0.d0,0.d0,0.d0,trim(legend_ptr%legends(i)))
                  xcur = x0
                  ycur = ycur - 2*DL_y
               else if( grobj%struct%cmd == "point"  ) then
                  gr_pdf_color_intent = 3 ! Stroke and Fill
                  call grsci(grobj%struct%color)
                  call grsms(grobj%struct%markersize)
                  call pgpt( 1, [ xcur+proto_width/2 ], [ ycur+DL_y/2 ], &
                             grobj%struct%marker )
                  xcur = xcur + proto_width + DL_x
                  gr_pdf_color_intent = 2 ! Fill
                  call grsci(1)
                  i = i + 1
                  call pgptxt(xcur,ycur,0.d0,0.d0,0.d0,trim(legend_ptr%legends(i)))
                  xcur = x0
                  ycur = ycur - 2*DL_y
               else if( grobj%struct%cmd == "line+point"  ) then
                  gr_pdf_color_intent = 3 ! Stroke and Fill
                  call grsci(grobj%struct%color)
                  call grslw(grobj%struct%linewidth)
                  call grsls(grobj%struct%linestyle)
                  call pgline( 2, [ xcur, xcur+proto_width ], [ ycur+DL_y/2, ycur+DL_y/2 ] )
                  call grsms(grobj%struct%markersize)
                  call pgpt( 1, [ xcur+proto_width/2 ], [ ycur+DL_y/2 ], &
                             grobj%struct%marker )
                  xcur = xcur + proto_width + DL_x
                  gr_pdf_color_intent = 2 ! Fill
                  call grsci(1)
                  i = i + 1
                  call pgptxt(xcur,ycur,0.d0,0.d0,0.d0,trim(legend_ptr%legends(i)))
                  xcur = x0
                  ycur = ycur - 2*DL_y
               end if

               grobj => grobj%next

            end do
         end if

      end if

      if( clipping_disabled ) then
         ibuf(1) = 1 ! clipping at viewport
         call grexec( grgtyp, SET_CLIPPING, rbuf, ibuf, chr, lchr ) ! set clipping
         CLIPPING_IN_AXES = .true.
      end if

      if( PRINTING_EPS ) then
         if( COMMENTS_IN_EPS ) then
            ibuf(1) = 0
            call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- end of Legend", 0 )
         end if
      end if
      if( PRINTING_PDF ) then
         if( COMMENTS_IN_PDF ) then
            call pdf_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- end of Legend", 0 )
         end if
      end if

   end subroutine redraw_legend_EPS_PDF
