!_______________________________________________________________________
!
#ifdef _MF_FUNC
   function mfLegend_array( legend_array,                               &
                            location, position )                        &
   result( handle )

      character(len=*), intent(in)           :: legend_array(:)
      character(len=*), intent(in), optional :: location
      type(mfArray),                optional :: position

      integer :: handle
      !------ API end ------

      integer :: n
      character(len=7) :: location0

      character(len=*), parameter :: ROUTINE_NAME = "mfLegend"

   !------ end of declarations -- execution starts hereafter  ------

      if( present(location) .and. present(position) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'location' and 'position' optional arguments", &
                            "cannot be both present!" )
         handle = 0
         return
      end if

      if( present(location) ) then
         location0 = location
      else
         location0 = "TL"
      end if

      n = size(legend_array)

      select case( n )
         case( 0 )
            ! nothing to do
            return
         case( 1 )
            if( present(position) ) then
               handle = mfLegend_args( legend_array(1),                 &
                                       position=position )
            else
               handle = mfLegend_args( legend_array(1),                 &
                                       location=location0 )
            end if
         case( 2 )
            if( present(position) ) then
               handle = mfLegend_args( legend_array(1), legend_array(2), &
                                       position=position )
            else
               handle = mfLegend_args( legend_array(1), legend_array(2), &
                                       location=location0 )
            end if
         case( 3 )
            if( present(position) ) then
               handle = mfLegend_args( legend_array(1), legend_array(2), &
                                       legend_array(3),                 &
                                       position=position )
            else
               handle = mfLegend_args( legend_array(1), legend_array(2), &
                                       legend_array(3),                 &
                                       location=location0 )
            end if
         case( 4 )
            if( present(position) ) then
               handle = mfLegend_args( legend_array(1), legend_array(2), &
                                       legend_array(3), legend_array(4), &
                                       position=position )
            else
               handle = mfLegend_args( legend_array(1), legend_array(2), &
                                       legend_array(3), legend_array(4), &
                                       location=location0 )
            end if
         case( 5 )
            if( present(position) ) then
               handle = mfLegend_args( legend_array(1), legend_array(2), &
                                       legend_array(3), legend_array(4), &
                                       legend_array(5),                 &
                                       position=position )
            else
               handle = mfLegend_args( legend_array(1), legend_array(2), &
                                       legend_array(3), legend_array(4), &
                                       legend_array(5),                 &
                                       location=location0 )
            end if
         case( 6 )
            if( present(position) ) then
               handle = mfLegend_args( legend_array(1), legend_array(2), &
                                       legend_array(3), legend_array(4), &
                                       legend_array(5), legend_array(6), &
                                       position=position )
            else
               handle = mfLegend_args( legend_array(1), legend_array(2), &
                                       legend_array(3), legend_array(4), &
                                       legend_array(5), legend_array(6), &
                                       location=location0 )
            end if
         case( 7 )
            if( present(position) ) then
               handle = mfLegend_args( legend_array(1), legend_array(2), &
                                       legend_array(3), legend_array(4), &
                                       legend_array(5), legend_array(6), &
                                       legend_array(7),                 &
                                       position=position )
            else
               handle = mfLegend_args( legend_array(1), legend_array(2), &
                                       legend_array(3), legend_array(4), &
                                       legend_array(5), legend_array(6), &
                                       legend_array(7),                 &
                                       location=location0 )
            end if
         case( 8 )
            if( present(position) ) then
               handle = mfLegend_args( legend_array(1), legend_array(2), &
                                       legend_array(3), legend_array(4), &
                                       legend_array(5), legend_array(6), &
                                       legend_array(7), legend_array(8), &
                                       position=position )
            else
               handle = mfLegend_args( legend_array(1), legend_array(2), &
                                       legend_array(3), legend_array(4), &
                                       legend_array(5), legend_array(6), &
                                       legend_array(7), legend_array(8), &
                                       location=location0 )
            end if
         case( 9 )
            if( present(position) ) then
               handle = mfLegend_args( legend_array(1), legend_array(2), &
                                       legend_array(3), legend_array(4), &
                                       legend_array(5), legend_array(6), &
                                       legend_array(7), legend_array(8), &
                                       legend_array(9),                 &
                                       position=position )
            else
               handle = mfLegend_args( legend_array(1), legend_array(2), &
                                       legend_array(3), legend_array(4), &
                                       legend_array(5), legend_array(6), &
                                       legend_array(7), legend_array(8), &
                                       legend_array(9),                 &
                                       location=location0 )
            end if
         case( 10 )
            if( present(position) ) then
               handle = mfLegend_args( legend_array(1), legend_array(2), &
                                       legend_array(3), legend_array(4), &
                                       legend_array(5), legend_array(6), &
                                       legend_array(7), legend_array(8), &
                                       legend_array(9), legend_array(10), &
                                       position=position )
            else
               handle = mfLegend_args( legend_array(1), legend_array(2), &
                                       legend_array(3), legend_array(4), &
                                       legend_array(5), legend_array(6), &
                                       legend_array(7), legend_array(8), &
                                       legend_array(9), legend_array(10), &
                                       location=location0 )
            end if
         case( 11 )
            if( present(position) ) then
               handle = mfLegend_args( legend_array(1), legend_array(2), &
                                       legend_array(3), legend_array(4), &
                                       legend_array(5), legend_array(6), &
                                       legend_array(7), legend_array(8), &
                                       legend_array(9), legend_array(10), &
                                       legend_array(11),                &
                                       position=position )
            else
               handle = mfLegend_args( legend_array(1), legend_array(2), &
                                       legend_array(3), legend_array(4), &
                                       legend_array(5), legend_array(6), &
                                       legend_array(7), legend_array(8), &
                                       legend_array(9), legend_array(10), &
                                       legend_array(11),                &
                                       location=location0 )
            end if
         case( 12 )
            if( present(position) ) then
               handle = mfLegend_args( legend_array(1), legend_array(2), &
                                       legend_array(3), legend_array(4), &
                                       legend_array(5), legend_array(6), &
                                       legend_array(7), legend_array(8), &
                                       legend_array(9), legend_array(10), &
                                       legend_array(11), legend_array(12), &
                                       position=position )
            else
               handle = mfLegend_args( legend_array(1), legend_array(2), &
                                       legend_array(3), legend_array(4), &
                                       legend_array(5), legend_array(6), &
                                       legend_array(7), legend_array(8), &
                                       legend_array(9), legend_array(10), &
                                       legend_array(11), legend_array(12), &
                                       location=location0 )
            end if
         case( 13 )
            if( present(position) ) then
               handle = mfLegend_args( legend_array(1), legend_array(2), &
                                       legend_array(3), legend_array(4), &
                                       legend_array(5), legend_array(6), &
                                       legend_array(7), legend_array(8), &
                                       legend_array(9), legend_array(10), &
                                       legend_array(11), legend_array(12), &
                                       legend_array(13), position=position )
            else
               handle = mfLegend_args( legend_array(1), legend_array(2), &
                                       legend_array(3), legend_array(4), &
                                       legend_array(5), legend_array(6), &
                                       legend_array(7), legend_array(8), &
                                       legend_array(9), legend_array(10), &
                                       legend_array(11), legend_array(12), &
                                       legend_array(13), location=location0 )
            end if
         case default
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "Max 13 legends are supported." )
      end select

   end function mfLegend_array
#endif
!_______________________________________________________________________
!
#ifdef _MF_FUNC
   function mfLegend_array_subset( legend_array, handle_array,          &
                                   location, position )                 &
   result( handle )

      character(len=*), intent(in)           :: legend_array(:)
      integer,          intent(in)           :: handle_array(:)
      character(len=*), intent(in), optional :: location
      type(mfArray),                optional :: position

      integer :: handle
      !------ API end ------

      integer :: n
      character(len=7) :: location0

      character(len=*), parameter :: ROUTINE_NAME = "mfLegend"

   !------ end of declarations -- execution starts hereafter  ------

      if( present(location) .and. present(position) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'location' and 'position' optional arguments", &
                            "cannot be both present!" )
         handle = 0
         return
      end if

      if( present(location) ) then
         location0 = location
      else
         location0 = "TL"
      end if

      n = size(legend_array)

      if( size(handle_array) /= n ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'legend_array' and 'handle_array' must have", &
                            "the same size!" )
         return
      end if

      select case( n )
         case( 0 )
            ! nothing to do
            return
         case( 1 )
            if( present(position) ) then
               handle = mfLegend_args_subset( legend_array(1), handle_array(1), &
                                              position=position )
            else
               handle = mfLegend_args_subset( legend_array(1), handle_array(1), &
                                              location=location0 )
            end if
         case( 2 )
            if( present(position) ) then
               handle = mfLegend_args_subset( legend_array(1), handle_array(1), &
                                              legend_array(2), handle_array(2), &
                                              position=position )
            else
               handle = mfLegend_args_subset( legend_array(1), handle_array(1), &
                                              legend_array(2), handle_array(2), &
                                              location=location0 )
            end if
         case( 3 )
            if( present(position) ) then
               handle = mfLegend_args_subset( legend_array(1), handle_array(1), &
                                              legend_array(2), handle_array(2), &
                                              legend_array(3), handle_array(3), &
                                              position=position )
            else
               handle = mfLegend_args_subset( legend_array(1), handle_array(1), &
                                              legend_array(2), handle_array(2), &
                                              legend_array(3), handle_array(3), &
                                              location=location0 )
            end if
         case( 4 )
            if( present(position) ) then
               handle = mfLegend_args_subset( legend_array(1), handle_array(1), &
                                              legend_array(2), handle_array(2), &
                                              legend_array(3), handle_array(3), &
                                              legend_array(4), handle_array(4), &
                                              position=position )
            else
               handle = mfLegend_args_subset( legend_array(1), handle_array(1), &
                                              legend_array(2), handle_array(2), &
                                              legend_array(3), handle_array(3), &
                                              legend_array(4), handle_array(4), &
                                              location=location0 )
            end if
         case( 5 )
            if( present(position) ) then
               handle = mfLegend_args_subset( legend_array(1), handle_array(1), &
                                              legend_array(2), handle_array(2), &
                                              legend_array(3), handle_array(3), &
                                              legend_array(4), handle_array(4), &
                                              legend_array(5), handle_array(5), &
                                              position=position )
            else
               handle = mfLegend_args_subset( legend_array(1), handle_array(1), &
                                              legend_array(2), handle_array(2), &
                                              legend_array(3), handle_array(3), &
                                              legend_array(4), handle_array(4), &
                                              legend_array(5), handle_array(5), &
                                              location=location0 )
            end if
         case( 6 )
            if( present(position) ) then
               handle = mfLegend_args_subset( legend_array(1), handle_array(1), &
                                              legend_array(2), handle_array(2), &
                                              legend_array(3), handle_array(3), &
                                              legend_array(4), handle_array(4), &
                                              legend_array(5), handle_array(5), &
                                              legend_array(6), handle_array(6), &
                                              position=position )
            else
               handle = mfLegend_args_subset( legend_array(1), handle_array(1), &
                                              legend_array(2), handle_array(2), &
                                              legend_array(3), handle_array(3), &
                                              legend_array(4), handle_array(4), &
                                              legend_array(5), handle_array(5), &
                                              legend_array(6), handle_array(6), &
                                              location=location0 )
            end if
         case( 7 )
            if( present(position) ) then
               handle = mfLegend_args_subset( legend_array(1), handle_array(1), &
                                              legend_array(2), handle_array(2), &
                                              legend_array(3), handle_array(3), &
                                              legend_array(4), handle_array(4), &
                                              legend_array(5), handle_array(5), &
                                              legend_array(6), handle_array(6), &
                                              legend_array(7), handle_array(7), &
                                              position=position )
            else
               handle = mfLegend_args_subset( legend_array(1), handle_array(1), &
                                              legend_array(2), handle_array(2), &
                                              legend_array(3), handle_array(3), &
                                              legend_array(4), handle_array(4), &
                                              legend_array(5), handle_array(5), &
                                              legend_array(6), handle_array(6), &
                                              legend_array(7), handle_array(7), &
                                              location=location0 )
            end if
         case( 8 )
            if( present(position) ) then
               handle = mfLegend_args_subset( legend_array(1), handle_array(1), &
                                              legend_array(2), handle_array(2), &
                                              legend_array(3), handle_array(3), &
                                              legend_array(4), handle_array(4), &
                                              legend_array(5), handle_array(5), &
                                              legend_array(6), handle_array(6), &
                                              legend_array(7), handle_array(7), &
                                              legend_array(8), handle_array(8), &
                                              position=position )
            else
               handle = mfLegend_args_subset( legend_array(1), handle_array(1), &
                                              legend_array(2), handle_array(2), &
                                              legend_array(3), handle_array(3), &
                                              legend_array(4), handle_array(4), &
                                              legend_array(5), handle_array(5), &
                                              legend_array(6), handle_array(6), &
                                              legend_array(7), handle_array(7), &
                                              legend_array(8), handle_array(8), &
                                              location=location0 )
            end if
         case( 9 )
            if( present(position) ) then
               handle = mfLegend_args_subset( legend_array(1), handle_array(1), &
                                              legend_array(2), handle_array(2), &
                                              legend_array(3), handle_array(3), &
                                              legend_array(4), handle_array(4), &
                                              legend_array(5), handle_array(5), &
                                              legend_array(6), handle_array(6), &
                                              legend_array(7), handle_array(7), &
                                              legend_array(8), handle_array(8), &
                                              legend_array(9), handle_array(9), &
                                              position=position )
            else
               handle = mfLegend_args_subset( legend_array(1), handle_array(1), &
                                              legend_array(2), handle_array(2), &
                                              legend_array(3), handle_array(3), &
                                              legend_array(4), handle_array(4), &
                                              legend_array(5), handle_array(5), &
                                              legend_array(6), handle_array(6), &
                                              legend_array(7), handle_array(7), &
                                              legend_array(8), handle_array(8), &
                                              legend_array(9), handle_array(9), &
                                              location=location0 )
            end if
         case( 10 )
            if( present(position) ) then
               handle = mfLegend_args_subset( legend_array(1), handle_array(1), &
                                              legend_array(2), handle_array(2), &
                                              legend_array(3), handle_array(3), &
                                              legend_array(4), handle_array(4), &
                                              legend_array(5), handle_array(5), &
                                              legend_array(6), handle_array(6), &
                                              legend_array(7), handle_array(7), &
                                              legend_array(8), handle_array(8), &
                                              legend_array(9), handle_array(9), &
                                              legend_array(10), handle_array(10), &
                                              position=position )
            else
               handle = mfLegend_args_subset( legend_array(1), handle_array(1), &
                                              legend_array(2), handle_array(2), &
                                              legend_array(3), handle_array(3), &
                                              legend_array(4), handle_array(4), &
                                              legend_array(5), handle_array(5), &
                                              legend_array(6), handle_array(6), &
                                              legend_array(7), handle_array(7), &
                                              legend_array(8), handle_array(8), &
                                              legend_array(9), handle_array(9), &
                                              legend_array(10), handle_array(10), &
                                              location=location0 )
            end if
         case( 11 )
            if( present(position) ) then
               handle = mfLegend_args_subset( legend_array(1), handle_array(1), &
                                              legend_array(2), handle_array(2), &
                                              legend_array(3), handle_array(3), &
                                              legend_array(4), handle_array(4), &
                                              legend_array(5), handle_array(5), &
                                              legend_array(6), handle_array(6), &
                                              legend_array(7), handle_array(7), &
                                              legend_array(8), handle_array(8), &
                                              legend_array(9), handle_array(9), &
                                              legend_array(10), handle_array(10), &
                                              legend_array(11), handle_array(11), &
                                              position=position )
            else
               handle = mfLegend_args_subset( legend_array(1), handle_array(1), &
                                              legend_array(2), handle_array(2), &
                                              legend_array(3), handle_array(3), &
                                              legend_array(4), handle_array(4), &
                                              legend_array(5), handle_array(5), &
                                              legend_array(6), handle_array(6), &
                                              legend_array(7), handle_array(7), &
                                              legend_array(8), handle_array(8), &
                                              legend_array(9), handle_array(9), &
                                              legend_array(10), handle_array(10), &
                                              legend_array(11), handle_array(11), &
                                              location=location0 )
            end if
         case( 12 )
            if( present(position) ) then
               handle = mfLegend_args_subset( legend_array(1), handle_array(1), &
                                              legend_array(2), handle_array(2), &
                                              legend_array(3), handle_array(3), &
                                              legend_array(4), handle_array(4), &
                                              legend_array(5), handle_array(5), &
                                              legend_array(6), handle_array(6), &
                                              legend_array(7), handle_array(7), &
                                              legend_array(8), handle_array(8), &
                                              legend_array(9), handle_array(9), &
                                              legend_array(10), handle_array(10), &
                                              legend_array(11), handle_array(11), &
                                              legend_array(12), handle_array(12), &
                                              position=position )
            else
               handle = mfLegend_args_subset( legend_array(1), handle_array(1), &
                                              legend_array(2), handle_array(2), &
                                              legend_array(3), handle_array(3), &
                                              legend_array(4), handle_array(4), &
                                              legend_array(5), handle_array(5), &
                                              legend_array(6), handle_array(6), &
                                              legend_array(7), handle_array(7), &
                                              legend_array(8), handle_array(8), &
                                              legend_array(9), handle_array(9), &
                                              legend_array(10), handle_array(10), &
                                              legend_array(11), handle_array(11), &
                                              legend_array(12), handle_array(12), &
                                              location=location0 )
            end if
         case( 13 )
            if( present(position) ) then
               handle = mfLegend_args_subset( legend_array(1), handle_array(1), &
                                              legend_array(2), handle_array(2), &
                                              legend_array(3), handle_array(3), &
                                              legend_array(4), handle_array(4), &
                                              legend_array(5), handle_array(5), &
                                              legend_array(6), handle_array(6), &
                                              legend_array(7), handle_array(7), &
                                              legend_array(8), handle_array(8), &
                                              legend_array(9), handle_array(9), &
                                              legend_array(10), handle_array(10), &
                                              legend_array(11), handle_array(11), &
                                              legend_array(12), handle_array(12), &
                                              legend_array(13), handle_array(13), &
                                              position=position )
            else
               handle = mfLegend_args_subset( legend_array(1), handle_array(1), &
                                              legend_array(2), handle_array(2), &
                                              legend_array(3), handle_array(3), &
                                              legend_array(4), handle_array(4), &
                                              legend_array(5), handle_array(5), &
                                              legend_array(6), handle_array(6), &
                                              legend_array(7), handle_array(7), &
                                              legend_array(8), handle_array(8), &
                                              legend_array(9), handle_array(9), &
                                              legend_array(10), handle_array(10), &
                                              legend_array(11), handle_array(11), &
                                              legend_array(12), handle_array(12), &
                                              legend_array(13), handle_array(13), &
                                              location=location0 )
            end if
         case default
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "Max 13 legends are supported." )
      end select

   end function mfLegend_array_subset
#endif
!_______________________________________________________________________
!
#ifdef _MF_SUBR
   subroutine msLegend_array( legend_array,                             &
                              location, position )

      character(len=*), intent(in)           :: legend_array(:)
      character(len=*), intent(in), optional :: location
      type(mfArray),                optional :: position

      integer :: handle
      !------ API end ------

      integer :: n
      character(len=7) :: location0

      character(len=*), parameter :: ROUTINE_NAME = "msLegend"

   !------ end of declarations -- execution starts hereafter  ------

      if( present(location) .and. present(position) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'location' and 'position' optional arguments", &
                            "cannot be both present!" )
         return
      end if

      if( present(location) ) then
         location0 = location
      else
         location0 = "TL"
      end if

      n = size(legend_array)

      select case( n )
         case( 0 )
            ! nothing to do
            return
         case( 1 )
            if( present(position) ) then
               call msLegend_args( legend_array(1),                     &
                                   position=position )
            else
               call msLegend_args( legend_array(1),                     &
                                   location=location0 )
            end if
         case( 2 )
            if( present(position) ) then
               call msLegend_args( legend_array(1), legend_array(2),    &
                                   position=position )
            else
               call msLegend_args( legend_array(1), legend_array(2),    &
                                   location=location0 )
            end if
         case( 3 )
            if( present(position) ) then
               call msLegend_args( legend_array(1), legend_array(2),    &
                                   legend_array(3),                     &
                                   position=position )
            else
               call msLegend_args( legend_array(1), legend_array(2),    &
                                   legend_array(3),                     &
                                   location=location0 )
            end if
         case( 4 )
            if( present(position) ) then
               call msLegend_args( legend_array(1), legend_array(2),    &
                                   legend_array(3), legend_array(4),    &
                                   position=position )
            else
               call msLegend_args( legend_array(1), legend_array(2),    &
                                   legend_array(3), legend_array(4),    &
                                   location=location0 )
            end if
         case( 5 )
            if( present(position) ) then
               call msLegend_args( legend_array(1), legend_array(2),    &
                                   legend_array(3), legend_array(4),    &
                                   legend_array(5),                     &
                                   position=position )
            else
               call msLegend_args( legend_array(1), legend_array(2),    &
                                   legend_array(3), legend_array(4),    &
                                   legend_array(5),                     &
                                   location=location0 )
            end if
         case( 6 )
            if( present(position) ) then
               call msLegend_args( legend_array(1), legend_array(2),    &
                                   legend_array(3), legend_array(4),    &
                                   legend_array(5), legend_array(6),    &
                                   position=position )
            else
               call msLegend_args( legend_array(1), legend_array(2),    &
                                   legend_array(3), legend_array(4),    &
                                   legend_array(5), legend_array(6),    &
                                   location=location0 )
            end if
         case( 7 )
            if( present(position) ) then
               call msLegend_args( legend_array(1), legend_array(2),    &
                                   legend_array(3), legend_array(4),    &
                                   legend_array(5), legend_array(6),    &
                                   legend_array(7),                     &
                                   position=position )
            else
               call msLegend_args( legend_array(1), legend_array(2),    &
                                   legend_array(3), legend_array(4),    &
                                   legend_array(5), legend_array(6),    &
                                   legend_array(7),                     &
                                   location=location0 )
            end if
         case( 8 )
            if( present(position) ) then
               call msLegend_args( legend_array(1), legend_array(2),    &
                                   legend_array(3), legend_array(4),    &
                                   legend_array(5), legend_array(6),    &
                                   legend_array(7), legend_array(8),    &
                                   position=position )
            else
               call msLegend_args( legend_array(1), legend_array(2),    &
                                   legend_array(3), legend_array(4),    &
                                   legend_array(5), legend_array(6),    &
                                   legend_array(7), legend_array(8),    &
                                   location=location0 )
            end if
         case( 9 )
            if( present(position) ) then
               call msLegend_args( legend_array(1), legend_array(2),    &
                                   legend_array(3), legend_array(4),    &
                                   legend_array(5), legend_array(6),    &
                                   legend_array(7), legend_array(8),    &
                                   legend_array(9),                     &
                                   position=position )
            else
               call msLegend_args( legend_array(1), legend_array(2),    &
                                   legend_array(3), legend_array(4),    &
                                   legend_array(5), legend_array(6),    &
                                   legend_array(7), legend_array(8),    &
                                   legend_array(9),                     &
                                   location=location0 )
            end if
         case( 10 )
            if( present(position) ) then
               call msLegend_args( legend_array(1), legend_array(2),    &
                                   legend_array(3), legend_array(4),    &
                                   legend_array(5), legend_array(6),    &
                                   legend_array(7), legend_array(8),    &
                                   legend_array(9), legend_array(10),   &
                                   position=position )
            else
               call msLegend_args( legend_array(1), legend_array(2),    &
                                   legend_array(3), legend_array(4),    &
                                   legend_array(5), legend_array(6),    &
                                   legend_array(7), legend_array(8),    &
                                   legend_array(9), legend_array(10),   &
                                   location=location0 )
            end if
         case( 11 )
            if( present(position) ) then
               call msLegend_args( legend_array(1), legend_array(2),    &
                                   legend_array(3), legend_array(4),    &
                                   legend_array(5), legend_array(6),    &
                                   legend_array(7), legend_array(8),    &
                                   legend_array(9), legend_array(10),   &
                                   legend_array(11),                    &
                                   position=position )
            else
               call msLegend_args( legend_array(1), legend_array(2),    &
                                   legend_array(3), legend_array(4),    &
                                   legend_array(5), legend_array(6),    &
                                   legend_array(7), legend_array(8),    &
                                   legend_array(9), legend_array(10),   &
                                   legend_array(11),                    &
                                   location=location0 )
            end if
         case( 12 )
            if( present(position) ) then
               call msLegend_args( legend_array(1), legend_array(2),    &
                                   legend_array(3), legend_array(4),    &
                                   legend_array(5), legend_array(6),    &
                                   legend_array(7), legend_array(8),    &
                                   legend_array(9), legend_array(10),   &
                                   legend_array(11), legend_array(12),  &
                                   position=position )
            else
               call msLegend_args( legend_array(1), legend_array(2),    &
                                   legend_array(3), legend_array(4),    &
                                   legend_array(5), legend_array(6),    &
                                   legend_array(7), legend_array(8),    &
                                   legend_array(9), legend_array(10),   &
                                   legend_array(11), legend_array(12),  &
                                   location=location0 )
            end if
         case( 13 )
            if( present(position) ) then
               call msLegend_args( legend_array(1), legend_array(2),    &
                                   legend_array(3), legend_array(4),    &
                                   legend_array(5), legend_array(6),    &
                                   legend_array(7), legend_array(8),    &
                                   legend_array(9), legend_array(10),   &
                                   legend_array(11), legend_array(12),  &
                                   legend_array(13), position=position )
            else
               call msLegend_args( legend_array(1), legend_array(2),    &
                                   legend_array(3), legend_array(4),    &
                                   legend_array(5), legend_array(6),    &
                                   legend_array(7), legend_array(8),    &
                                   legend_array(9), legend_array(10),   &
                                   legend_array(11), legend_array(12),  &
                                   legend_array(13), location=location0 )
            end if
         case default
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "Max 13 legends are supported." )
      end select

   end subroutine msLegend_array
#endif
!_______________________________________________________________________
!
#ifdef _MF_SUBR
   subroutine msLegend_array_subset( legend_array, handle_array,        &
                                     location, position )

      character(len=*), intent(in)           :: legend_array(:)
      integer,          intent(in)           :: handle_array(:)
      character(len=*), intent(in), optional :: location
      type(mfArray),                optional :: position

      integer :: handle
      !------ API end ------

      integer :: n
      character(len=7) :: location0

      character(len=*), parameter :: ROUTINE_NAME = "msLegend"

   !------ end of declarations -- execution starts hereafter  ------

      if( present(location) .and. present(position) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'location' and 'position' optional arguments", &
                            "cannot be both present!" )
         return
      end if

      if( present(location) ) then
         location0 = location
      else
         location0 = "TL"
      end if

      n = size(legend_array)

      if( size(handle_array) /= n ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'legend_array' and 'handle_array' must have", &
                            "the same size!" )
         return
      end if

      select case( n )
         case( 0 )
            ! nothing to do
            return
         case( 1 )
            if( present(position) ) then
               call msLegend_args_subset( legend_array(1), handle_array(1), &
                                          position=position )
            else
               call msLegend_args_subset( legend_array(1), handle_array(1), &
                                          location=location0 )
            end if
         case( 2 )
            if( present(position) ) then
               call msLegend_args_subset( legend_array(1), handle_array(1), &
                                          legend_array(2), handle_array(2), &
                                          position=position )
            else
               call msLegend_args_subset( legend_array(1), handle_array(1), &
                                          legend_array(2), handle_array(2), &
                                          location=location0 )
            end if
         case( 3 )
            if( present(position) ) then
               call msLegend_args_subset( legend_array(1), handle_array(1), &
                                          legend_array(2), handle_array(2), &
                                          legend_array(3), handle_array(3), &
                                          position=position )
            else
               call msLegend_args_subset( legend_array(1), handle_array(1), &
                                          legend_array(2), handle_array(2), &
                                          legend_array(3), handle_array(3), &
                                          location=location0 )
            end if
         case( 4 )
            if( present(position) ) then
               call msLegend_args_subset( legend_array(1), handle_array(1), &
                                          legend_array(2), handle_array(2), &
                                          legend_array(3), handle_array(3), &
                                          legend_array(4), handle_array(4), &
                                          position=position )
            else
               call msLegend_args_subset( legend_array(1), handle_array(1), &
                                          legend_array(2), handle_array(2), &
                                          legend_array(3), handle_array(3), &
                                          legend_array(4), handle_array(4), &
                                          location=location0 )
            end if
         case( 5 )
            if( present(position) ) then
               call msLegend_args_subset( legend_array(1), handle_array(1), &
                                          legend_array(2), handle_array(2), &
                                          legend_array(3), handle_array(3), &
                                          legend_array(4), handle_array(4), &
                                          legend_array(5), handle_array(5), &
                                          position=position )
            else
               call msLegend_args_subset( legend_array(1), handle_array(1), &
                                          legend_array(2), handle_array(2), &
                                          legend_array(3), handle_array(3), &
                                          legend_array(4), handle_array(4), &
                                          legend_array(5), handle_array(5), &
                                          location=location0 )
            end if
         case( 6 )
            if( present(position) ) then
               call msLegend_args_subset( legend_array(1), handle_array(1), &
                                          legend_array(2), handle_array(2), &
                                          legend_array(3), handle_array(3), &
                                          legend_array(4), handle_array(4), &
                                          legend_array(5), handle_array(5), &
                                          legend_array(6), handle_array(6), &
                                          position=position )
            else
               call msLegend_args_subset( legend_array(1), handle_array(1), &
                                          legend_array(2), handle_array(2), &
                                          legend_array(3), handle_array(3), &
                                          legend_array(4), handle_array(4), &
                                          legend_array(5), handle_array(5), &
                                          legend_array(6), handle_array(6), &
                                          location=location0 )
            end if
         case( 7 )
            if( present(position) ) then
               call msLegend_args_subset( legend_array(1), handle_array(1), &
                                          legend_array(2), handle_array(2), &
                                          legend_array(3), handle_array(3), &
                                          legend_array(4), handle_array(4), &
                                          legend_array(5), handle_array(5), &
                                          legend_array(6), handle_array(6), &
                                          legend_array(7), handle_array(7), &
                                          position=position )
            else
               call msLegend_args_subset( legend_array(1), handle_array(1), &
                                          legend_array(2), handle_array(2), &
                                          legend_array(3), handle_array(3), &
                                          legend_array(4), handle_array(4), &
                                          legend_array(5), handle_array(5), &
                                          legend_array(6), handle_array(6), &
                                          legend_array(7), handle_array(7), &
                                          location=location0 )
            end if
         case( 8 )
            if( present(position) ) then
               call msLegend_args_subset( legend_array(1), handle_array(1), &
                                          legend_array(2), handle_array(2), &
                                          legend_array(3), handle_array(3), &
                                          legend_array(4), handle_array(4), &
                                          legend_array(5), handle_array(5), &
                                          legend_array(6), handle_array(6), &
                                          legend_array(7), handle_array(7), &
                                          legend_array(8), handle_array(8), &
                                          position=position )
            else
               call msLegend_args_subset( legend_array(1), handle_array(1), &
                                          legend_array(2), handle_array(2), &
                                          legend_array(3), handle_array(3), &
                                          legend_array(4), handle_array(4), &
                                          legend_array(5), handle_array(5), &
                                          legend_array(6), handle_array(6), &
                                          legend_array(7), handle_array(7), &
                                          legend_array(8), handle_array(8), &
                                          location=location0 )
            end if
         case( 9 )
            if( present(position) ) then
               call msLegend_args_subset( legend_array(1), handle_array(1), &
                                          legend_array(2), handle_array(2), &
                                          legend_array(3), handle_array(3), &
                                          legend_array(4), handle_array(4), &
                                          legend_array(5), handle_array(5), &
                                          legend_array(6), handle_array(6), &
                                          legend_array(7), handle_array(7), &
                                          legend_array(8), handle_array(8), &
                                          legend_array(9), handle_array(9), &
                                          position=position )
            else
               call msLegend_args_subset( legend_array(1), handle_array(1), &
                                          legend_array(2), handle_array(2), &
                                          legend_array(3), handle_array(3), &
                                          legend_array(4), handle_array(4), &
                                          legend_array(5), handle_array(5), &
                                          legend_array(6), handle_array(6), &
                                          legend_array(7), handle_array(7), &
                                          legend_array(8), handle_array(8), &
                                          legend_array(9), handle_array(9), &
                                          location=location0 )
            end if
         case( 10 )
            if( present(position) ) then
               call msLegend_args_subset( legend_array(1), handle_array(1), &
                                          legend_array(2), handle_array(2), &
                                          legend_array(3), handle_array(3), &
                                          legend_array(4), handle_array(4), &
                                          legend_array(5), handle_array(5), &
                                          legend_array(6), handle_array(6), &
                                          legend_array(7), handle_array(7), &
                                          legend_array(8), handle_array(8), &
                                          legend_array(9), handle_array(9), &
                                          legend_array(10), handle_array(10), &
                                          position=position )
            else
               call msLegend_args_subset( legend_array(1), handle_array(1), &
                                          legend_array(2), handle_array(2), &
                                          legend_array(3), handle_array(3), &
                                          legend_array(4), handle_array(4), &
                                          legend_array(5), handle_array(5), &
                                          legend_array(6), handle_array(6), &
                                          legend_array(7), handle_array(7), &
                                          legend_array(8), handle_array(8), &
                                          legend_array(9), handle_array(9), &
                                          legend_array(10), handle_array(10), &
                                          location=location0 )
            end if
         case( 11 )
            if( present(position) ) then
               call msLegend_args_subset( legend_array(1), handle_array(1), &
                                          legend_array(2), handle_array(2), &
                                          legend_array(3), handle_array(3), &
                                          legend_array(4), handle_array(4), &
                                          legend_array(5), handle_array(5), &
                                          legend_array(6), handle_array(6), &
                                          legend_array(7), handle_array(7), &
                                          legend_array(8), handle_array(8), &
                                          legend_array(9), handle_array(9), &
                                          legend_array(10), handle_array(10), &
                                          legend_array(11), handle_array(11), &
                                          position=position )
            else
               call msLegend_args_subset( legend_array(1), handle_array(1), &
                                          legend_array(2), handle_array(2), &
                                          legend_array(3), handle_array(3), &
                                          legend_array(4), handle_array(4), &
                                          legend_array(5), handle_array(5), &
                                          legend_array(6), handle_array(6), &
                                          legend_array(7), handle_array(7), &
                                          legend_array(8), handle_array(8), &
                                          legend_array(9), handle_array(9), &
                                          legend_array(10), handle_array(10), &
                                          legend_array(11), handle_array(11), &
                                          location=location0 )
            end if
         case( 12 )
            if( present(position) ) then
               call msLegend_args_subset( legend_array(1), handle_array(1), &
                                          legend_array(2), handle_array(2), &
                                          legend_array(3), handle_array(3), &
                                          legend_array(4), handle_array(4), &
                                          legend_array(5), handle_array(5), &
                                          legend_array(6), handle_array(6), &
                                          legend_array(7), handle_array(7), &
                                          legend_array(8), handle_array(8), &
                                          legend_array(9), handle_array(9), &
                                          legend_array(10), handle_array(10), &
                                          legend_array(11), handle_array(11), &
                                          legend_array(12), handle_array(12), &
                                          position=position )
            else
               call msLegend_args_subset( legend_array(1), handle_array(1), &
                                          legend_array(2), handle_array(2), &
                                          legend_array(3), handle_array(3), &
                                          legend_array(4), handle_array(4), &
                                          legend_array(5), handle_array(5), &
                                          legend_array(6), handle_array(6), &
                                          legend_array(7), handle_array(7), &
                                          legend_array(8), handle_array(8), &
                                          legend_array(9), handle_array(9), &
                                          legend_array(10), handle_array(10), &
                                          legend_array(11), handle_array(11), &
                                          legend_array(12), handle_array(12), &
                                          location=location0 )
            end if
         case( 13 )
            if( present(position) ) then
               call msLegend_args_subset( legend_array(1), handle_array(1), &
                                          legend_array(2), handle_array(2), &
                                          legend_array(3), handle_array(3), &
                                          legend_array(4), handle_array(4), &
                                          legend_array(5), handle_array(5), &
                                          legend_array(6), handle_array(6), &
                                          legend_array(7), handle_array(7), &
                                          legend_array(8), handle_array(8), &
                                          legend_array(9), handle_array(9), &
                                          legend_array(10), handle_array(10), &
                                          legend_array(11), handle_array(11), &
                                          legend_array(12), handle_array(12), &
                                          legend_array(13), handle_array(13), &
                                          position=position )
            else
               call msLegend_args_subset( legend_array(1), handle_array(1), &
                                          legend_array(2), handle_array(2), &
                                          legend_array(3), handle_array(3), &
                                          legend_array(4), handle_array(4), &
                                          legend_array(5), handle_array(5), &
                                          legend_array(6), handle_array(6), &
                                          legend_array(7), handle_array(7), &
                                          legend_array(8), handle_array(8), &
                                          legend_array(9), handle_array(9), &
                                          legend_array(10), handle_array(10), &
                                          legend_array(11), handle_array(11), &
                                          legend_array(12), handle_array(12), &
                                          legend_array(13), handle_array(13), &
                                          location=location0 )
            end if
         case default
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "Max 13 legends are supported." )
      end select

   end subroutine msLegend_array_subset
#endif
!_______________________________________________________________________
!
#ifdef _MF_FUNC
   function mfLegend_args( legend_1, legend_2, legend_3, legend_4,      &
                           legend_5, legend_6, legend_7, legend_8,      &
                           legend_9, legend_10, legend_11, legend_12,   &
                           legend_13, location, position )              &
   result( handle )
#endif
#ifdef _MF_SUBR
   subroutine msLegend_args( legend_1, legend_2, legend_3, legend_4,    &
                             legend_5, legend_6, legend_7, legend_8,    &
                             legend_9, legend_10, legend_11, legend_12, &
                             legend_13, location, position )
#endif

      character(len=*), intent(in)           :: legend_1
      character(len=*), intent(in), optional ::                         &
                           legend_2,  legend_3,  legend_4,  legend_5,   &
                           legend_6,  legend_7,  legend_8,  legend_9,   &
                           legend_10, legend_11, legend_12, legend_13
      character(len=*), intent(in), optional :: location
      type(mfArray),                optional :: position

      integer :: handle
      !------ API end ------

      type(mf_win_info), pointer :: win
      type(grobj_elem), pointer :: grobj
      integer :: nb_curves, nb_leg, len_max, i, i_max, len_0, len_1
      real(kind=MF_DOUBLE) :: xbox(5), ybox(5), dx, dy, x0, y0,         &
                              xcur, ycur, DL_x, DL_y, X1, X2, Y1, Y2,   &
                              pix_per_x_unit, pix_per_y_unit,           &
                              x_shift, y_shift
      real(kind=MF_DOUBLE) :: frame_position_x, frame_position_y
      real(kind=MF_DOUBLE) :: dx_axes, dy_axes
      character(len=5) :: string_1, string_2
      logical :: shift_x, shift_y
      logical :: bar_plot, legend_exist, clipping_disabled, new_window
      integer :: icol, hdle, pixmap_width, pixmap_height
      integer :: x_TLC, y_TLC, width, height

      real(kind=MF_DOUBLE) :: current_axes(4)
      real(kind=MF_DOUBLE) :: proto_width, length_wc
      integer :: istyle, dash_pattern_period
      integer :: xmin, ymin, xmax, ymax
      integer :: win_id_loc, j, geometry(4), WM_title_height

      integer :: MAIN_WIN_ID, WIN_SHARED_ID

      type(legend_struct), pointer :: legend_ptr => null()

      double precision :: rbuf(1)
      integer :: ibuf(5), lchr
      character(len=1) :: chr

#ifdef _MF_FUNC
      character(len=*), parameter :: ROUTINE_NAME = "mfLegend"
#endif
#ifdef _MF_SUBR
      character(len=*), parameter :: ROUTINE_NAME = "msLegend"
#endif

   !------ end of declarations -- execution starts hereafter  ------

#ifdef _MF_FUNC
      handle = 0
#endif

      if( CURRENT_WIN_ID == 0 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "no X11 device selected." )
         return
      end if

      win => mf_win_db(CURRENT_WIN_ID)

      if( associated(win%legend) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "A legend already exists!",                 &
                            "(use only 'mfLegend' if you want to create many legends", &
                            "in different languages)" )
         return
      end if

#ifdef _MF_SUBR
      ! let's examine if there is another legend inside a grobj
      ! (created by mfLegend)
      legend_exist = .false.
      grobj => win%grobj_head
      do ! scanning the 'grobj' linked list
         if( .not. associated(grobj) ) exit
         if( grobj%struct%cmd == "legend" ) then
            legend_exist = .true.
         end if
         grobj => grobj%next
      end do
      if( legend_exist ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "A legend already exists!",                 &
                            "(use only 'mfLegend' if you want to create many legends", &
                            "in different languages)" )
         return
      end if
#endif

      ! count nb of legends
      if( present(legend_2) ) then
         if( present(legend_3) ) then
            if( present(legend_4) ) then
               if( present(legend_5) ) then
                  if( present(legend_6) ) then
                     if( present(legend_7) ) then
                        if( present(legend_8) ) then
                           if( present(legend_9) ) then
                              if( present(legend_10) ) then
                                 if( present(legend_11) ) then
                                    if( present(legend_12) ) then
                                       if( present(legend_13) ) then
                                          nb_leg = 13
                                       else
                                          nb_leg = 12
                                       end if
                                    else
                                       nb_leg = 11
                                    end if
                                 else
                                    nb_leg = 10
                                 end if
                              else
                                 nb_leg = 9
                              end if
                           else
                              nb_leg = 8
                           end if
                        else
                           nb_leg = 7
                        end if
                     else
                        nb_leg = 6
                     end if
                  else
                     nb_leg = 5
                  end if
               else
                  nb_leg = 4
               end if
            else
               nb_leg = 3
            end if
         else
            nb_leg = 2
         end if
      else
         nb_leg = 1
      end if

      if( present(location) .and. present(position) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'location' and 'position' optional arguments",                       &
                            "cannot be both present!" )
         return
      end if

      shift_x = .false.
      shift_y = .false.
      new_window = .false.
      if( present(location) ) then
         if( location == "TL" ) then
            ! default
         else if( location == "TR" ) then
            shift_x = .true.
         else if( location == "BL" ) then
            shift_y = .true.
         else if( location == "BR" ) then
            shift_x = .true.
            shift_y = .true.
         else if( location == "outside" ) then
#ifdef _MF_FUNC
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "Only 'msLegend' is able to draw a legend outside (in a new window).", &
                               "(here you have used 'mfLegend')" )
#else /* MF_SUBR */
            new_window = .true.
#endif
         else
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "bad value for argument 'location'!",    &
                               "(must be equal to: 'TL', 'TR', 'BL', 'BR' or 'outside')" )
         end if
      end if

      if( present(position) ) then
         call msInitArgs( position )
         frame_position_x = mfGet(position,1)
         if( win%axis_scale_x == 2 ) then ! log scale
            frame_position_x = log10( frame_position_x )
         end if
         frame_position_y = mfGet(position,2)
         if( win%axis_scale_y == 2 ) then ! log scale
            frame_position_y = log10( frame_position_y )
         end if
      end if

      ! check if a "groups of bars" or a "stacked bars" plot is the first grobj
      bar_plot = .false.
      grobj => win%grobj_head
      if( associated(grobj) ) then
         if( grobj%struct%cmd == "bar_groups_stacks" ) then
            bar_plot = .true.
         end if
      end if

      nb_curves = 0
      ! getting number of curves in the current figure
      grobj => win%grobj_head
      do ! scanning the 'grobj' linked list
         if( .not. associated(grobj) ) then
            exit
         end if

         if( grobj%struct%cmd == "line"         .or.                    &
             grobj%struct%cmd == "point"        .or.                    &
             grobj%struct%cmd == "line+point"   .or.                    &
             grobj%struct%cmd == "cubic_bezier" .or.                    &
             grobj%struct%cmd == "quadr_bezier"      ) then
            nb_curves = nb_curves + 1
         end if
         grobj => grobj%next

      end do

      if( bar_plot .and. nb_curves >= 1 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "hybrid multiple plots in the figure: legends not available!" )
         return
      end if

      ! nb of data series in a bar plot
      if( bar_plot ) then
         grobj => win%grobj_head
         nb_curves = size( grobj%struct%ord_mat, 2 )
      end if

      if( nb_leg /= nb_curves ) then
         write(string_1,"(I0)") nb_leg
         write(string_2,"(I0)") nb_curves
         if( nb_leg > nb_curves ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "too many legends!",                     &
                               "(got " // trim(string_1) // " legends but found " // trim(string_2) // " curve(s))", &
                               "→ additional legends will be ignored!" )
            nb_leg = nb_curves
         else
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "too few legends!",                      &
                               "(got " // trim(string_1) // " legends but found " // trim(string_2) // " curve(s))", &
                               "→ only the first curves will be legended!" )
         end if
      end if

      if( nb_leg == 0 ) then ! due to 0 curves in the figure
         return
      end if

      ! hereafter, the nb of legends is fixed.

      allocate( legend_ptr )
#ifdef _MF_FUNC
      ! create a new grobj
      call create_grobj( win, grobj )

      grobj%struct%cmd = "legend"
      grobj%struct%legend => legend_ptr

      hdle = mf_win_get_free_handle(CURRENT_WIN_ID)
      win%handles(hdle)%ptr => grobj
      grobj%struct%hdle = hdle
      handle = encode_handle( CURRENT_WIN_ID, hdle )
#else /* MF_SUBR */
      win%legend => legend_ptr
#endif

      ! find which legend has the longer length

      allocate( legend_ptr%legends(nb_leg) )

      if( UTF8_ENCODING ) then
         legend_ptr%legends(1) = utf8_to_latin_1( trim(legend_1) )
      else
         legend_ptr%legends(1) = trim(legend_1)
      end if
      len_max = len_trim(legend_ptr%legends(1))
      i_max = 1

      if( present(legend_2) ) then
! quick return if there are too many legends...
if( nb_leg < 2 ) go to 100
         if( UTF8_ENCODING ) then
            legend_ptr%legends(2) = utf8_to_latin_1( trim(legend_2) )
         else
            legend_ptr%legends(2) = trim(legend_2)
         end if
         len_1 = len_trim(legend_ptr%legends(2))
         if( len_1 > len_max ) then
            len_max = len_1
            i_max = 2
         end if
         if( present(legend_3) ) then
! quick return if there are too many legends...
if( nb_leg < 3 ) go to 100
            if( UTF8_ENCODING ) then
               legend_ptr%legends(3) = utf8_to_latin_1( trim(legend_3) )
            else
               legend_ptr%legends(3) = trim(legend_3)
            end if
            len_1 = len_trim(legend_ptr%legends(3))
            if( len_1 > len_max ) then
               len_max = len_1
               i_max = 3
            end if
            if( present(legend_4) ) then
! quick return if there are too many legends...
if( nb_leg < 4 ) go to 100
               if( UTF8_ENCODING ) then
                  legend_ptr%legends(4) = utf8_to_latin_1( trim(legend_4) )
               else
                  legend_ptr%legends(4) = trim(legend_4)
               end if
               len_1 = len_trim(legend_ptr%legends(4))
               if( len_1 > len_max ) then
                  len_max = len_1
                  i_max = 4
               end if
               if( present(legend_5) ) then
! quick return if there are too many legends...
if( nb_leg < 5 ) go to 100
                  if( UTF8_ENCODING ) then
                     legend_ptr%legends(5) = utf8_to_latin_1( trim(legend_5) )
                  else
                     legend_ptr%legends(5) = trim(legend_5)
                  end if
                  len_1 = len_trim(legend_ptr%legends(5))
                  if( len_1 > len_max ) then
                     len_max = len_1
                     i_max = 5
                  end if
                  if( present(legend_6) ) then
! quick return if there are too many legends...
if( nb_leg < 6 ) go to 100
                     if( UTF8_ENCODING ) then
                        legend_ptr%legends(6) = utf8_to_latin_1( trim(legend_6) )
                     else
                        legend_ptr%legends(6) = trim(legend_6)
                     end if
                     len_1 = len_trim(legend_ptr%legends(6))
                     if( len_1 > len_max ) then
                        len_max = len_1
                        i_max = 6
                     end if
                     if( present(legend_7) ) then
! quick return if there are too many legends...
if( nb_leg < 7 ) go to 100
                        if( UTF8_ENCODING ) then
                           legend_ptr%legends(7) = utf8_to_latin_1( trim(legend_7) )
                        else
                           legend_ptr%legends(7) = trim(legend_7)
                        end if
                        len_1 = len_trim(legend_ptr%legends(7))
                        if( len_1 > len_max ) then
                           len_max = len_1
                           i_max = 7
                        end if
                        if( present(legend_8) ) then
! quick return if there are too many legends...
if( nb_leg < 8 ) go to 100
                           if( UTF8_ENCODING ) then
                              legend_ptr%legends(8) = utf8_to_latin_1( trim(legend_8) )
                           else
                              legend_ptr%legends(8) = trim(legend_8)
                           end if
                           len_1 = len_trim(legend_ptr%legends(8))
                           if( len_1 > len_max ) then
                              len_max = len_1
                              i_max = 8
                           end if
                           if( present(legend_9) ) then
! quick return if there are too many legends...
if( nb_leg < 9 ) go to 100
                              if( UTF8_ENCODING ) then
                                 legend_ptr%legends(9) = utf8_to_latin_1( trim(legend_9) )
                              else
                                 legend_ptr%legends(9) = trim(legend_9)
                              end if
                              len_1 = len_trim(legend_ptr%legends(9))
                              if( len_1 > len_max ) then
                                 len_max = len_1
                                 i_max = 9
                              end if
                              if( present(legend_10) ) then
! quick return if there are too many legends...
if( nb_leg < 10 ) go to 100
                                 if( UTF8_ENCODING ) then
                                    legend_ptr%legends(10) = utf8_to_latin_1( trim(legend_10) )
                                 else
                                    legend_ptr%legends(10) = trim(legend_10)
                                 end if
                                 len_1 = len_trim(legend_ptr%legends(10))
                                 if( len_1 > len_max ) then
                                    len_max = len_1
                                    i_max = 10
                                 end if
                                 if( present(legend_11) ) then
! quick return if there are too many legends...
if( nb_leg < 11 ) go to 100
                                    if( UTF8_ENCODING ) then
                                       legend_ptr%legends(11) = utf8_to_latin_1( trim(legend_11) )
                                    else
                                       legend_ptr%legends(11) = trim(legend_11)
                                    len_1 = len_trim(legend_ptr%legends(11))
                                    end if
                                    if( len_1 > len_max ) then
                                       len_max = len_1
                                       i_max = 11
                                    end if
                                    if( present(legend_12) ) then
! quick return if there are too many legends...
if( nb_leg < 12 ) go to 100
                                       if( UTF8_ENCODING ) then
                                          legend_ptr%legends(12) = utf8_to_latin_1( trim(legend_12) )
                                       else
                                          legend_ptr%legends(12) = trim(legend_12)
                                       end if
                                       len_1 = len_trim(legend_ptr%legends(12))
                                       if( len_1 > len_max ) then
                                          len_max = len_1
                                          i_max = 12
                                       end if
                                       if( present(legend_13) ) then
! quick return if there are too many legends...
if( nb_leg < 13 ) go to 100
                                          if( UTF8_ENCODING ) then
                                             legend_ptr%legends(13) = utf8_to_latin_1( trim(legend_13) )
                                          else
                                             legend_ptr%legends(13) = trim(legend_13)
                                          end if
                                          len_1 = len_trim(legend_ptr%legends(13))
                                          if( len_1 > len_max ) then
                                             len_max = len_1
                                             i_max = 13
                                          end if
                                       end if
                                    end if
                                 end if
                              end if
                           end if
                        end if
                     end if
                  end if
               end if
            end if
         end if
      end if

 100  continue ! from the quick returns above

      if( len_max > 80 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "too long legends!",                        &
                            "(each string must be shorter than 80 char.)" )
         return
      end if

!### TODO ?:
! setting default value (not adapted if enlarging window),
! moreover, doesn't match the current symbol size ...
      call pgsch(1.0d0)

      ! Legend is the only exception for which the clipping inside axes is
      ! disabled.
      clipping_disabled = .false.
      if( CLIPPING_IN_AXES ) then
         ibuf(1) = 0 ! no clipping
         call grexec( grgtyp, SET_CLIPPING, rbuf, ibuf, chr, lchr ) ! set clipping
         CLIPPING_IN_AXES = .false.
         clipping_disabled = .true.
      end if

      current_axes(:) = win%current_axes(:)
      if( win%axis_scale_x == 2 ) then ! log scale
         current_axes(1:2) = log10( current_axes(1:2) )
      end if
      if( win%axis_scale_y == 2 ) then ! log scale
         current_axes(3:4) = log10( current_axes(3:4) )
      end if

      !-----------------------------------------------------------------
      ! Be aware that, below, many variables storing lengths may have
      ! a negative value when axis are inverted. Keep this way, it has
      ! been verified.
      ! Ex. of these variables:
      !        dx, dy, DL_x, DL_y, proto_width, length_wc, ...
      ! Only few tests about length may be done in absolute value.
      !-----------------------------------------------------------------

      ! inquiring text size (for the longer legend)
      call pgqtxt(0.d0,0.d0,0.d0,0.d0,legend_ptr%legends(i_max),xbox,ybox)
      dx = xbox(3)
      dy = ybox(3) ! this is the characteristic length...
      DL_y = dy    ! in terms of the y-axis scale, but always linear
      ! Set a smaller DL_y, in order to get a good layout in the EPS files
      DL_y = 0.6667*DL_y
      ! now, we want DL_x = DL_y (in pixels), to obtain a good layout
      call PGQVP(3, X1, X2, Y1, Y2) ! 3: returns pixels
      pix_per_x_unit = X2 - X1
      pix_per_y_unit = Y2 - Y1
      call PGQWIN(X1, X2, Y1, Y2)
      pix_per_x_unit = pix_per_x_unit/(X2-X1)
      pix_per_y_unit = pix_per_y_unit/(Y2-Y1)
      DL_x = dy * pix_per_y_unit/pix_per_x_unit ! in terms of the x-axis scale
      ! beginning of the first legend line (default: top-left corner)
      x0 = current_axes(1) + DL_x
      y0 = current_axes(4) - 2*DL_y - DL_y/2.

      ! proto_width is the width of the curve prototype: it has not a constant
      ! value because it depends on the dash pattern (if any).
      if( bar_plot ) then
         proto_width = 2*DL_x
      else
         proto_width = 2*DL_x ! minimum value
         i = 0
         grobj => win%grobj_head
         do ! scanning the 'grobj' linked list
            if( i+1 > nb_leg ) exit

            if( .not. associated(grobj) ) exit

            if( grobj%struct%cmd == "line" .or.                         &
                grobj%struct%cmd == "cubic_bezier" .or.                 &
                grobj%struct%cmd == "quadr_bezier" .or.                 &
                grobj%struct%cmd == "line+point" ) then

               call grslw(grobj%struct%linewidth)
               call grsls(grobj%struct%linestyle)
               call grqls( istyle, dash_pattern_period )
               ! convert to world unit (x-axis)
               length_wc = 1.5d0*dash_pattern_period/grxscl(grcide)
               if( abs(length_wc) > abs(proto_width) ) proto_width = length_wc
            end if

            grobj => grobj%next

         end do

      end if

      call grslw(1.0d0)
      call grsls(1)

      ! erasing the current part of the plot located inside
      ! the legend box...
      call grsci(MFPLOT_QUASI_BACKGROUND) ! quasi background color, because we
                                          ! don't want a transparency when
                                          ! moving the legend.
      ! the layout below must be exactly the same as in 'redraw_legend_X11'
      ! and 'redraw_legend_EPS_PDF'
      xbox(1) = x0 - DL_x/2.
      ybox(1) = y0 + DL_y + DL_y
      xbox(3) = x0 + DL_x/2. + proto_width + DL_x/2. + dx + DL_x/2.
      ybox(3) = y0 - 2.*DL_y*(nb_leg-1) - DL_y

      ! computing an x-shift to put the frame in the right corner
      if( shift_x ) then
         x_shift = current_axes(2) - xbox(3) - DL_x/2.
      else if( present(position) ) then
         x_shift = frame_position_x - xbox(1)
      else
         x_shift = 0.
      end if
      x0 = x0 + x_shift
      xbox(1) = xbox(1) + x_shift
      xbox(3) = xbox(3) + x_shift

      ! computing an y-shift to put the frame in the bottom corner
      if( shift_y ) then
         y_shift = ybox(3) - current_axes(3) - DL_y/2.
      else if( present(position) ) then
         y_shift = -(frame_position_y - ybox(1))
      else
         y_shift = 0.
      end if
      y0 = y0 - y_shift
      ybox(1) = ybox(1) - y_shift
      ybox(3) = ybox(3) - y_shift

      ! Drawing begins hereafter...

      if( new_window ) then

         ! Select the auxiliary pixmap (normal size: hope that the legend
         ! frame is not too large)
         ibuf(1) = 1 ! Target is the auxiliary pixmap
         ibuf(2) = 0
         call grexec( grgtyp, SELECT_AUX_PIXMAP, rbuf, ibuf, chr, lchr )

      end if

      call grrect( xbox(1), ybox(1), xbox(3), ybox(3), filled=.true. )

      call grsci(1) ! foreground color
      ! drawing a frame
      call grrect( xbox(1), ybox(1), xbox(3), ybox(3), filled=.false. )

      ! saving data (in relative axes coord.) for interaction
      dx_axes = current_axes(2) - current_axes(1)
      dy_axes = current_axes(4) - current_axes(3)
      legend_ptr%x0 = (x0-current_axes(1)) / dx_axes
      legend_ptr%y0 = (y0-current_axes(3)) / dy_axes
      legend_ptr%DL_x = DL_x / dx_axes
      legend_ptr%DL_y = DL_y / dy_axes
      legend_ptr%proto_width = proto_width / dx_axes
      legend_ptr%xmin = (xbox(1)-current_axes(1)) / dx_axes
      legend_ptr%xmax = (xbox(3)-current_axes(1)) / dx_axes
      legend_ptr%ymin = (ybox(3)-current_axes(3)) / dy_axes
      legend_ptr%ymax = (ybox(1)-current_axes(3)) / dy_axes
      legend_ptr%legend_i_max = i_max
      if( new_window ) then
         legend_ptr%outside = .true.
      else
         legend_ptr%outside = .false.
      end if

      xcur = x0
      ycur = y0
      i = 0
      ! drawing lines and associated legends
      grobj => win%grobj_head
      if( bar_plot ) then
         icol = 1
         do i = 1, nb_leg
            if( associated(grobj%struct%col_tab) ) then
               icol = grobj%struct%col_tab(i)
            else
               ! cycling colors (between 2 and 15)
               icol = icol + 1
               if( icol > 15 ) icol = 2
            end if
            call grsci(icol)
            call grslw(6.6d0)

            ! Set appropriate cap and join style for the lines.
            ibuf(1) = 0 ! Cap butt
            ibuf(2) = 0 ! Join miter
            call grexec( grgtyp, SET_LINE_CAP_JOIN_STYLE, rbuf, ibuf, chr, lchr )

            call pgline( 2, [ xcur, xcur+2*DL_x ], [ ycur+DL_y/2, ycur+DL_y/2 ] )

            ! Set appropriate cap and join style for the lines.
            ibuf(1) = 1 ! Cap round
            ibuf(2) = 1 ! Join round
            call grexec( grgtyp, SET_LINE_CAP_JOIN_STYLE, rbuf, ibuf, chr, lchr )

            xcur = xcur + 3*DL_x
            call grsci(1)
            call grslw(1.0d0)
            call pgptxt(xcur,ycur,0.d0,0.d0,0.d0,trim(legend_ptr%legends(i)))
            xcur = x0
            ycur = ycur - 2*DL_y
         end do
      else
         do ! scanning the 'grobj' linked list
            if( i+1 > nb_leg ) exit

            if( .not. associated(grobj) ) exit

            if( grobj%struct%cmd == "line" .or.                         &
                grobj%struct%cmd == "cubic_bezier" .or.                 &
                grobj%struct%cmd == "quadr_bezier" ) then
               call grsci(grobj%struct%color)
               call grslw(grobj%struct%linewidth)
               call grsls(grobj%struct%linestyle)
               call pgline( 2, [ xcur, xcur+proto_width ], [ ycur+DL_y/2, ycur+DL_y/2 ] )
               xcur = xcur + proto_width + DL_x
               call grsci(1)
               i = i + 1
               call pgptxt(xcur,ycur,0.d0,0.d0,0.d0,trim(legend_ptr%legends(i)))
               xcur = x0
               ycur = ycur - 2*DL_y
            else if( grobj%struct%cmd == "point"  ) then
               call grsci(grobj%struct%color)
               call grsms(grobj%struct%markersize)
               call pgpt( 1, [ xcur+proto_width/2 ], [ ycur+DL_y/2 ],   &
                          grobj%struct%marker )
               xcur = xcur + proto_width + DL_x
               call grsci(1)
               i = i + 1
               call pgptxt(xcur,ycur,0.d0,0.d0,0.d0,trim(legend_ptr%legends(i)))
               xcur = x0
               ycur = ycur - 2*DL_y
            else if( grobj%struct%cmd == "line+point"  ) then
               call grsci(grobj%struct%color)
               call grslw(grobj%struct%linewidth)
               call grsls(grobj%struct%linestyle)
               call pgline( 2, [ xcur, xcur+proto_width ], [ ycur+DL_y/2, ycur+DL_y/2 ] )
               call grsms(grobj%struct%markersize)
               call pgpt( 1, [ xcur+proto_width/2 ], [ ycur+DL_y/2 ],   &
                          grobj%struct%marker )
               xcur = xcur + proto_width + DL_x
               call grsci(1)
               i = i + 1
               call pgptxt(xcur,ycur,0.d0,0.d0,0.d0,trim(legend_ptr%legends(i)))
               xcur = x0
               ycur = ycur - 2*DL_y
            else
               ! do nothing
            end if

            grobj => grobj%next

         end do
      end if

      if( new_window ) then

         ! Get position and size of the current window...
         call grexec( grgtyp, GET_CURRENT_WIN_GEOM, rbuf, ibuf, chr, lchr )
         x_TLC = ibuf(1)
         y_TLC = ibuf(2)
         width  = ibuf(3)
         height = ibuf(4)
         WM_title_height = ibuf(5)

         ! Drawing is finished: get the BBox of the auxiliary pixmap and
         ! save its ID internally
         call grexec( grgtyp, SAVE_PIXMAP_ID, rbuf, ibuf, chr, lchr )
         xmin = ibuf(1)
         ymin = ibuf(2)
         xmax = ibuf(3)
         ymax = ibuf(4)
         pixmap_width  = (xmax - xmin + 1) + 2
         pixmap_height = (ymax - ymin + 1) + 2

         MAIN_WIN_ID = CURRENT_WIN_ID

!### à investiguer: pourquoi faut-il cela pour que la figure suivante
!                   soit "dessinable" ?
         ibuf(1) = 0 ! Target is the main pixmap
         call grexec( grgtyp, SELECT_AUX_PIXMAP, rbuf, ibuf, chr, lchr )

         ! replacement of msFigure...
         win_id_loc = 0
         do j = 1, MF_WIN_NB_MAX
            if( mf_win_db(j)%mfplot_id == 0 ) then
               win_id_loc = j
               exit
            end if
         end do

         geometry = [ x_TLC+width, y_TLC,                               &
                      max(200,pixmap_width), max(20,pixmap_height) ]

         ibuf(1) = 0 ! No figure number in the title
         call grexec( grgtyp, REM_FIG_NUM_IN_WIN_TITLE, rbuf, ibuf, chr, lchr )

         j = gropen_ec( 0, "/XWIN", pgid, geometry, MUESLI_EXE_NAME,    &
                        win_id_loc, "Shared legend" )

         ibuf(1) = 1 ! Figure number in the title (default) for future windows
         call grexec( grgtyp, REM_FIG_NUM_IN_WIN_TITLE, rbuf, ibuf, chr, lchr )

!### je suis obligé de mettre ça pour voir la légende s'afficher dans la
!    nouvelle fenêtre... pourquoi ?
         call grbpic

         ! Copy the auxiliary pixmap in this new window
         ibuf(1) = xmin
         ibuf(2) = ymin
         ibuf(3) = xmax
         ibuf(4) = ymax
         call grexec( grgtyp, COPY_PIXMAP_FROM_ID, rbuf, ibuf, chr, lchr )

         call msFigure( MAIN_WIN_ID )

!### changer la fenêtre avec 'msFigure'  ne suffit pas pour que le dessin
!    se refasse dans la 1ère fenêtre...
         ibuf(1) = 0 ! Target is the main pixmap
         call grexec( grgtyp, SELECT_AUX_PIXMAP, rbuf, ibuf, chr, lchr )

      end if

      if( clipping_disabled ) then
         ibuf(1) = 1 ! clipping at viewport
         call grexec( grgtyp, SET_CLIPPING, rbuf, ibuf, chr, lchr ) ! set clipping
         CLIPPING_IN_AXES = .true.
      end if

      if( present(position) ) then
         call msFreeArgs(position)
         call msAutoRelease(position)
      end if

#ifdef _MF_FUNC
   end function mfLegend_args
#endif
#ifdef _MF_SUBR
   end subroutine msLegend_args
#endif
!_______________________________________________________________________
!
#ifdef _MF_FUNC
   function mfLegend_args_subset( legend_1,  handle_1,                  &
                                  legend_2,  handle_2,                  &
                                  legend_3,  handle_3,                  &
                                  legend_4,  handle_4,                  &
                                  legend_5,  handle_5,                  &
                                  legend_6,  handle_6,                  &
                                  legend_7,  handle_7,                  &
                                  legend_8,  handle_8,                  &
                                  legend_9,  handle_9,                  &
                                  legend_10, handle_10,                 &
                                  legend_11, handle_11,                 &
                                  legend_12, handle_12,                 &
                                  legend_13, handle_13,                 &
                                  location, position )                  &
   result( handle )
#endif
#ifdef _MF_SUBR
   subroutine msLegend_args_subset( legend_1,  handle_1,                &
                                    legend_2,  handle_2,                &
                                    legend_3,  handle_3,                &
                                    legend_4,  handle_4,                &
                                    legend_5,  handle_5,                &
                                    legend_6,  handle_6,                &
                                    legend_7,  handle_7,                &
                                    legend_8,  handle_8,                &
                                    legend_9,  handle_9,                &
                                    legend_10, handle_10,               &
                                    legend_11, handle_11,               &
                                    legend_12, handle_12,               &
                                    legend_13, handle_13,               &
                                    location, position )
#endif

      character(len=*), intent(in)           :: legend_1
      integer,          intent(in)           :: handle_1
      character(len=*), intent(in), optional ::                         &
                           legend_2,  legend_3,  legend_4,  legend_5,   &
                           legend_6,  legend_7,  legend_8,  legend_9,   &
                           legend_10, legend_11, legend_12, legend_13
      integer,          intent(in), optional ::                         &
                           handle_2,  handle_3,  handle_4,  handle_5,   &
                           handle_6,  handle_7,  handle_8,  handle_9,   &
                           handle_10, handle_11, handle_12, handle_13
      character(len=*), intent(in), optional :: location
      type(mfArray),                optional :: position

      integer :: handle
      !------ API end ------

      type(mf_win_info), pointer :: win
      type(grobj_elem), pointer :: grobj
      integer :: nb_curves, len_max, i, i_max, len_0, len_1
      integer :: nb_leg, nb_hdle, win_id0
      integer, allocatable :: hdle_vec(:)
      real(kind=MF_DOUBLE) :: xbox(5), ybox(5), dx, dy, x0, y0,         &
                              xcur, ycur, DL_x, DL_y, X1, X2, Y1, Y2,   &
                              pix_per_x_unit, pix_per_y_unit,           &
                              x_shift, y_shift
      real(kind=MF_DOUBLE) :: frame_position_x, frame_position_y
      real(kind=MF_DOUBLE) :: dx_axes, dy_axes
      character(len=5) :: string_1, string_2
      logical :: shift_x, shift_y
      logical :: legend_exist, clipping_disabled, new_window
      integer :: icol, hdle, pixmap_width, pixmap_height
      integer :: x_TLC, y_TLC, width, height

      real(kind=MF_DOUBLE) :: current_axes(4)
      real(kind=MF_DOUBLE) :: proto_width, length_wc
      integer :: istyle, dash_pattern_period
      integer :: xmin, ymin, xmax, ymax
      integer :: win_id_loc, j, geometry(4), WM_title_height

      integer :: MAIN_WIN_ID, WIN_SHARED_ID

      type(legend_struct), pointer :: legend_ptr => null()

      double precision :: rbuf(1)
      integer :: ibuf(5), lchr
      character(len=1) :: chr

#ifdef _MF_FUNC
      character(len=*), parameter :: ROUTINE_NAME = "mfLegend"
#endif
#ifdef _MF_SUBR
      character(len=*), parameter :: ROUTINE_NAME = "msLegend"
#endif

   !------ end of declarations -- execution starts hereafter  ------

#ifdef _MF_FUNC
      handle = 0
#endif

      if( CURRENT_WIN_ID == 0 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "no X11 device selected." )
         return
      end if

      win => mf_win_db(CURRENT_WIN_ID)

      if( associated(win%legend) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "A legend already exists!",                 &
                            "(use only 'mfLegend' if you want to create many legends", &
                            "in different languages)" )
         return
      end if

#ifdef _MF_SUBR
      ! let's examine if there is another legend inside a grobj
      ! (created by mfLegend)
      legend_exist = .false.
      grobj => win%grobj_head
      do ! scanning the 'grobj' linked list
         if( .not. associated(grobj) ) exit
         if( grobj%struct%cmd == "legend" ) then
            legend_exist = .true.
         end if
         grobj => grobj%next
      end do
      if( legend_exist ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "A legend already exists!",                 &
                            "(use only 'mfLegend' if you want to create many legends", &
                            "in different languages)" )
         return
      end if
#endif

      ! count nb of legends
      if( present(legend_2) ) then
         if( present(legend_3) ) then
            if( present(legend_4) ) then
               if( present(legend_5) ) then
                  if( present(legend_6) ) then
                     if( present(legend_7) ) then
                        if( present(legend_8) ) then
                           if( present(legend_9) ) then
                              if( present(legend_10) ) then
                                 if( present(legend_11) ) then
                                    if( present(legend_12) ) then
                                       if( present(legend_13) ) then
                                          nb_leg = 13
                                       else
                                          nb_leg = 12
                                       end if
                                    else
                                       nb_leg = 11
                                    end if
                                 else
                                    nb_leg = 10
                                 end if
                              else
                                 nb_leg = 9
                              end if
                           else
                              nb_leg = 8
                           end if
                        else
                           nb_leg = 7
                        end if
                     else
                        nb_leg = 6
                     end if
                  else
                     nb_leg = 5
                  end if
               else
                  nb_leg = 4
               end if
            else
               nb_leg = 3
            end if
         else
            nb_leg = 2
         end if
      else
         nb_leg = 1
      end if

      ! count nb of handles
      if( present(handle_2) ) then
         if( present(handle_3) ) then
            if( present(handle_4) ) then
               if( present(handle_5) ) then
                  if( present(handle_6) ) then
                     if( present(handle_7) ) then
                        if( present(handle_8) ) then
                           if( present(handle_9) ) then
                              if( present(handle_10) ) then
                                 if( present(handle_11) ) then
                                    if( present(handle_12) ) then
                                       if( present(handle_13) ) then
                                          nb_hdle = 13
                                       else
                                          nb_hdle = 12
                                       end if
                                    else
                                       nb_hdle = 11
                                    end if
                                 else
                                    nb_hdle = 10
                                 end if
                              else
                                 nb_hdle = 9
                              end if
                           else
                              nb_hdle = 8
                           end if
                        else
                           nb_hdle = 7
                        end if
                     else
                        nb_hdle = 6
                     end if
                  else
                     nb_hdle = 5
                  end if
               else
                  nb_hdle = 4
               end if
            else
               nb_hdle = 3
            end if
         else
            nb_hdle = 2
         end if
      else
         nb_hdle = 1
      end if

      if( nb_leg /= nb_hdle ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "The current routine must have the same number", &
                            "of legends and handles!" )
         return
      end if

      allocate( hdle_vec(nb_hdle) )

      ! store and check that handles provided by the user are all valid
      call decode_handle( handle_1, win_id0, hdle_vec(1) )
      if( win_id0 /= CURRENT_WIN_ID ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "bad grobj handle! (#1)" )
         return
      end if
      if( present(handle_2) ) then
         call decode_handle( handle_2, win_id0, hdle_vec(2) )
         if( win_id0 /= CURRENT_WIN_ID ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "bad grobj handle! (#2)" )
            return
         end if
         if( present(handle_3) ) then
            call decode_handle( handle_3, win_id0, hdle_vec(3) )
            if( win_id0 /= CURRENT_WIN_ID ) then
               call PrintMessage( trim(ROUTINE_NAME), "E",              &
                                  "bad grobj handle! (#3)" )
               return
            end if
            if( present(handle_4) ) then
               call decode_handle( handle_4, win_id0, hdle_vec(4) )
               if( win_id0 /= CURRENT_WIN_ID ) then
                  call PrintMessage( trim(ROUTINE_NAME), "E",           &
                                     "bad grobj handle! (#4)" )
                  return
               end if
               if( present(handle_5) ) then
                  call decode_handle( handle_5, win_id0, hdle_vec(5) )
                  if( win_id0 /= CURRENT_WIN_ID ) then
                     call PrintMessage( trim(ROUTINE_NAME), "E",        &
                                        "bad grobj handle! (#5)" )
                     return
                  end if
                  if( present(handle_6) ) then
                     call decode_handle( handle_6, win_id0, hdle_vec(6) )
                     if( win_id0 /= CURRENT_WIN_ID ) then
                        call PrintMessage( trim(ROUTINE_NAME), "E",     &
                                           "bad grobj handle! (#6)" )
                        return
                     end if
                     if( present(handle_7) ) then
                        call decode_handle( handle_7, win_id0, hdle_vec(7) )
                        if( win_id0 /= CURRENT_WIN_ID ) then
                           call PrintMessage( trim(ROUTINE_NAME), "E",  &
                                              "bad grobj handle! (#7)" )
                           return
                        end if
                        if( present(handle_8) ) then
                           call decode_handle( handle_8, win_id0, hdle_vec(8) )
                           if( win_id0 /= CURRENT_WIN_ID ) then
                              call PrintMessage( trim(ROUTINE_NAME), "E", &
                                                 "bad grobj handle! (#8)" )
                              return
                           end if
                           if( present(handle_9) ) then
                              call decode_handle( handle_9, win_id0, hdle_vec(9) )
                              if( win_id0 /= CURRENT_WIN_ID ) then
                                 call PrintMessage( trim(ROUTINE_NAME), "E", &
                                                    "bad grobj handle! (#9)" )
                                 return
                              end if
                              if( present(handle_10) ) then
                                 call decode_handle( handle_10, win_id0, hdle_vec(10) )
                                 if( win_id0 /= CURRENT_WIN_ID ) then
                                    call PrintMessage( trim(ROUTINE_NAME), "E", &
                                                       "bad grobj handle! (#10)" )
                                    return
                                 end if
                                 if( present(handle_11) ) then
                                    call decode_handle( handle_11, win_id0, hdle_vec(11) )
                                    if( win_id0 /= CURRENT_WIN_ID ) then
                                       call PrintMessage( trim(ROUTINE_NAME), "E", &
                                                          "bad grobj handle! (#11)" )
                                       return
                                    end if
                                    if( present(handle_12) ) then
                                       call decode_handle( handle_12, win_id0, hdle_vec(12) )
                                       if( win_id0 /= CURRENT_WIN_ID ) then
                                          call PrintMessage( trim(ROUTINE_NAME), "E", &
                                                             "bad grobj handle! (#12)" )
                                          return
                                       end if
                                       if( present(handle_13) ) then
                                          call decode_handle( handle_13, win_id0, hdle_vec(13) )
                                          if( win_id0 /= CURRENT_WIN_ID ) then
                                             call PrintMessage( trim(ROUTINE_NAME), "E", &
                                                                "bad grobj handle! (#13)" )
                                             return
                                          end if
                                       end if
                                    end if
                                 end if
                              end if
                           end if
                        end if
                     end if
                  end if
               end if
            end if
         end if
      end if

      if( present(location) .and. present(position) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'location' and 'position' optional arguments",                       &
                            "cannot be both present!" )
         return
      end if

      shift_x = .false.
      shift_y = .false.
      new_window = .false.
      if( present(location) ) then
         if( location == "TL" ) then
            ! default
         else if( location == "TR" ) then
            shift_x = .true.
         else if( location == "BL" ) then
            shift_y = .true.
         else if( location == "BR" ) then
            shift_x = .true.
            shift_y = .true.
         else if( location == "outside" ) then
#ifdef _MF_FUNC
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "Only 'msLegend' is able to draw a legend outside (in a new window).", &
                               "(here you have used 'mfLegend')" )
#else /* MF_SUBR */
            new_window = .true.
#endif
         else
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "bad value for argument 'location'!",    &
                               "(must be equal to: 'TL', 'TR', 'BL', 'BR' or 'outside')" )
         end if
      end if

      if( present(position) ) then
         call msInitArgs( position )
         frame_position_x = mfGet(position,1)
         if( win%axis_scale_x == 2 ) then ! log scale
            frame_position_x = log10( frame_position_x )
         end if
         frame_position_y = mfGet(position,2)
         if( win%axis_scale_y == 2 ) then ! log scale
            frame_position_y = log10( frame_position_y )
         end if
      end if

      allocate( legend_ptr )
#ifdef _MF_FUNC
      ! create a new grobj
      call create_grobj( win, grobj )

      grobj%struct%cmd = "legend"
      grobj%struct%legend => legend_ptr

      hdle = mf_win_get_free_handle(CURRENT_WIN_ID)
      win%handles(hdle)%ptr => grobj
      grobj%struct%hdle = hdle
      handle = encode_handle( CURRENT_WIN_ID, hdle )
#else /* MF_SUBR */
      win%legend => legend_ptr
#endif

      ! store legends, and find also which legend has the longer length
      allocate( legend_ptr%legends(nb_leg) )

      if( UTF8_ENCODING ) then
         legend_ptr%legends(1) = utf8_to_latin_1( trim(legend_1) )
      else
         legend_ptr%legends(1) = trim(legend_1)
      end if
      len_max = len_trim(legend_ptr%legends(1))
      i_max = 1

      if( present(legend_2) ) then
         if( UTF8_ENCODING ) then
            legend_ptr%legends(2) = utf8_to_latin_1( trim(legend_2) )
         else
            legend_ptr%legends(2) = trim(legend_2)
         end if
         len_1 = len_trim(legend_ptr%legends(2))
         if( len_1 > len_max ) then
            len_max = len_1
            i_max = 2
         end if
         if( present(legend_3) ) then
            if( UTF8_ENCODING ) then
               legend_ptr%legends(3) = utf8_to_latin_1( trim(legend_3) )
            else
               legend_ptr%legends(3) = trim(legend_3)
            end if
            len_1 = len_trim(legend_ptr%legends(3))
            if( len_1 > len_max ) then
               len_max = len_1
               i_max = 3
            end if
            if( present(legend_4) ) then
               if( UTF8_ENCODING ) then
                  legend_ptr%legends(4) = utf8_to_latin_1( trim(legend_4) )
               else
                  legend_ptr%legends(4) = trim(legend_4)
               end if
               len_1 = len_trim(legend_ptr%legends(4))
               if( len_1 > len_max ) then
                  len_max = len_1
                  i_max = 4
               end if
               if( present(legend_5) ) then
                  if( UTF8_ENCODING ) then
                     legend_ptr%legends(5) = utf8_to_latin_1( trim(legend_5) )
                  else
                     legend_ptr%legends(5) = trim(legend_5)
                  end if
                  len_1 = len_trim(legend_ptr%legends(5))
                  if( len_1 > len_max ) then
                     len_max = len_1
                     i_max = 5
                  end if
                  if( present(legend_6) ) then
                     if( UTF8_ENCODING ) then
                        legend_ptr%legends(6) = utf8_to_latin_1( trim(legend_6) )
                     else
                        legend_ptr%legends(6) = trim(legend_6)
                     end if
                     len_1 = len_trim(legend_ptr%legends(6))
                     if( len_1 > len_max ) then
                        len_max = len_1
                        i_max = 6
                     end if
                     if( present(legend_7) ) then
                        if( UTF8_ENCODING ) then
                           legend_ptr%legends(7) = utf8_to_latin_1( trim(legend_7) )
                        else
                           legend_ptr%legends(7) = trim(legend_7)
                        end if
                        len_1 = len_trim(legend_ptr%legends(7))
                        if( len_1 > len_max ) then
                           len_max = len_1
                           i_max = 7
                        end if
                        if( present(legend_8) ) then
                           if( UTF8_ENCODING ) then
                              legend_ptr%legends(8) = utf8_to_latin_1( trim(legend_8) )
                           else
                              legend_ptr%legends(8) = trim(legend_8)
                           end if
                           len_1 = len_trim(legend_ptr%legends(8))
                           if( len_1 > len_max ) then
                              len_max = len_1
                              i_max = 8
                           end if
                           if( present(legend_9) ) then
                              if( UTF8_ENCODING ) then
                                 legend_ptr%legends(9) = utf8_to_latin_1( trim(legend_9) )
                              else
                                 legend_ptr%legends(9) = trim(legend_9)
                              end if
                              len_1 = len_trim(legend_ptr%legends(9))
                              if( len_1 > len_max ) then
                                 len_max = len_1
                                 i_max = 9
                              end if
                              if( present(legend_10) ) then
                                 if( UTF8_ENCODING ) then
                                    legend_ptr%legends(10) = utf8_to_latin_1( trim(legend_10) )
                                 else
                                    legend_ptr%legends(10) = trim(legend_10)
                                 end if
                                 len_1 = len_trim(legend_ptr%legends(10))
                                 if( len_1 > len_max ) then
                                    len_max = len_1
                                    i_max = 10
                                 end if
                                 if( present(legend_11) ) then
                                    if( UTF8_ENCODING ) then
                                       legend_ptr%legends(11) = utf8_to_latin_1( trim(legend_11) )
                                    else
                                       legend_ptr%legends(11) = trim(legend_11)
                                    len_1 = len_trim(legend_ptr%legends(11))
                                    end if
                                    if( len_1 > len_max ) then
                                       len_max = len_1
                                       i_max = 11
                                    end if
                                    if( present(legend_12) ) then
                                       if( UTF8_ENCODING ) then
                                          legend_ptr%legends(12) = utf8_to_latin_1( trim(legend_12) )
                                       else
                                          legend_ptr%legends(12) = trim(legend_12)
                                       end if
                                       len_1 = len_trim(legend_ptr%legends(12))
                                       if( len_1 > len_max ) then
                                          len_max = len_1
                                          i_max = 12
                                       end if
                                       if( present(legend_13) ) then
                                          if( UTF8_ENCODING ) then
                                             legend_ptr%legends(13) = utf8_to_latin_1( trim(legend_13) )
                                          else
                                             legend_ptr%legends(13) = trim(legend_13)
                                          end if
                                          len_1 = len_trim(legend_ptr%legends(13))
                                          if( len_1 > len_max ) then
                                             len_max = len_1
                                             i_max = 13
                                          end if
                                       end if
                                    end if
                                 end if
                              end if
                           end if
                        end if
                     end if
                  end if
               end if
            end if
         end if
      end if

      if( len_max > 80 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "too long legends!",                        &
                            "(each string must be shorter than 80 char.)" )
         return
      end if

      ! store handles, and check that selected grobjs are all valid...
      allocate( legend_ptr%hdle(nb_hdle) )

      do i = 1, nb_leg
         hdle = hdle_vec(i)
         if( hdle < 1 .or. size(win%handles) < hdle ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "handle out of range!" )
            return
         end if
         grobj => win%handles(hdle)%ptr
         if( .not. associated( grobj ) ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "bad handle!" )
            return
         end if
         legend_ptr%hdle(i) = hdle
      end do
      deallocate( hdle_vec )

!### TODO ?:
! setting default value (not adapted if enlarging window),
! moreover, doesn't match the current symbol size ...
      call pgsch(1.0d0)

      ! Legend is the only exception for which the clipping inside axes is
      ! disabled.
      clipping_disabled = .false.
      if( CLIPPING_IN_AXES ) then
         ibuf(1) = 0 ! no clipping
         call grexec( grgtyp, SET_CLIPPING, rbuf, ibuf, chr, lchr ) ! set clipping
         CLIPPING_IN_AXES = .false.
         clipping_disabled = .true.
      end if

      current_axes(:) = win%current_axes(:)
      if( win%axis_scale_x == 2 ) then ! log scale
         current_axes(1:2) = log10( current_axes(1:2) )
      end if
      if( win%axis_scale_y == 2 ) then ! log scale
         current_axes(3:4) = log10( current_axes(3:4) )
      end if

      !-----------------------------------------------------------------
      ! Be aware that, below, many variables storing lengths may have
      ! a negative value when axis are inverted. Keep this way, it has
      ! been verified.
      ! Ex. of these variables:
      !        dx, dy, DL_x, DL_y, proto_width, length_wc, ...
      ! Only few tests about length may be done in absolute value.
      !-----------------------------------------------------------------

      ! inquiring text size (for the longer legend)
      call pgqtxt(0.d0,0.d0,0.d0,0.d0,legend_ptr%legends(i_max),xbox,ybox)
      dx = xbox(3)
      dy = ybox(3) ! this is the characteristic length...
      DL_y = dy    ! in terms of the y-axis scale, but always linear
      ! Set a smaller DL_y, in order to get a good layout in the EPS files
      DL_y = 0.6667*DL_y
      ! now, we want DL_x = DL_y (in pixels), to obtain a good layout
      call PGQVP(3, X1, X2, Y1, Y2) ! 3: returns pixels
      pix_per_x_unit = X2 - X1
      pix_per_y_unit = Y2 - Y1
      call PGQWIN(X1, X2, Y1, Y2)
      pix_per_x_unit = pix_per_x_unit/(X2-X1)
      pix_per_y_unit = pix_per_y_unit/(Y2-Y1)
      DL_x = dy * pix_per_y_unit/pix_per_x_unit ! in terms of the x-axis scale
      ! beginning of the first legend line (default: top-left corner)
      x0 = current_axes(1) + DL_x
      y0 = current_axes(4) - 2*DL_y - DL_y/2.

      ! proto_width is the width of the curve prototype: it has not a constant
      ! value because it depends on the dash pattern (if any).
      proto_width = 2*DL_x ! minimum value
      i = 0
      grobj => win%grobj_head
      do ! scanning the 'grobj' linked list
         if( i+1 > nb_leg ) exit

         if( .not. associated(grobj) ) exit

         if( grobj%struct%cmd == "line" .or.                            &
             grobj%struct%cmd == "cubic_bezier" .or.                    &
             grobj%struct%cmd == "quadr_bezier" .or.                    &
             grobj%struct%cmd == "line+point" ) then

            call grslw(grobj%struct%linewidth)
            call grsls(grobj%struct%linestyle)
            call grqls( istyle, dash_pattern_period )
            ! convert to world unit (x-axis)
            length_wc = 1.5d0*dash_pattern_period/grxscl(grcide)
            if( abs(length_wc) > abs(proto_width) ) proto_width = length_wc
         end if

         grobj => grobj%next

      end do

      call grslw(1.0d0)
      call grsls(1)

      ! erasing the current part of the plot located inside
      ! the legend box...
      call grsci(MFPLOT_QUASI_BACKGROUND) ! quasi background color, because we
                                          ! don't want a transparency when
                                          ! moving the legend.
      ! the layout below must be exactly the same as in 'redraw_legend_X11'
      ! and 'redraw_legend_EPS_PDF'
      xbox(1) = x0 - DL_x/2.
      ybox(1) = y0 + DL_y + DL_y
      xbox(3) = x0 + DL_x/2. + proto_width + DL_x/2. + dx + DL_x/2.
      ybox(3) = y0 - 2.*DL_y*(nb_leg-1) - DL_y

      ! computing an x-shift to put the frame in the right corner
      if( shift_x ) then
         x_shift = current_axes(2) - xbox(3) - DL_x/2.
      else if( present(position) ) then
         x_shift = frame_position_x - xbox(1)
      else
         x_shift = 0.
      end if
      x0 = x0 + x_shift
      xbox(1) = xbox(1) + x_shift
      xbox(3) = xbox(3) + x_shift

      ! computing an y-shift to put the frame in the bottom corner
      if( shift_y ) then
         y_shift = ybox(3) - current_axes(3) - DL_y/2.
      else if( present(position) ) then
         y_shift = -(frame_position_y - ybox(1))
      else
         y_shift = 0.
      end if
      y0 = y0 - y_shift
      ybox(1) = ybox(1) - y_shift
      ybox(3) = ybox(3) - y_shift

      ! Drawing begins hereafter...

      if( new_window ) then

         ! Select the auxiliary pixmap (normal size: hope that the legend
         ! frame is not too large)
         ibuf(1) = 1 ! Target is the auxiliary pixmap
         ibuf(2) = 0
         call grexec( grgtyp, SELECT_AUX_PIXMAP, rbuf, ibuf, chr, lchr )

      end if

      call grrect( xbox(1), ybox(1), xbox(3), ybox(3), filled=.true. )

      call grsci(1) ! foreground color
      ! drawing a frame
      call grrect( xbox(1), ybox(1), xbox(3), ybox(3), filled=.false. )

      ! saving data (in relative axes coord.) for interaction
      dx_axes = current_axes(2) - current_axes(1)
      dy_axes = current_axes(4) - current_axes(3)
      legend_ptr%x0 = (x0-current_axes(1)) / dx_axes
      legend_ptr%y0 = (y0-current_axes(3)) / dy_axes
      legend_ptr%DL_x = DL_x / dx_axes
      legend_ptr%DL_y = DL_y / dy_axes
      legend_ptr%proto_width = proto_width / dx_axes
      legend_ptr%xmin = (xbox(1)-current_axes(1)) / dx_axes
      legend_ptr%xmax = (xbox(3)-current_axes(1)) / dx_axes
      legend_ptr%ymin = (ybox(3)-current_axes(3)) / dy_axes
      legend_ptr%ymax = (ybox(1)-current_axes(3)) / dy_axes
      legend_ptr%legend_i_max = i_max

      xcur = x0
      ycur = y0
      ! drawing lines and associated legends
      do i = 1, nb_leg
         hdle = legend_ptr%hdle(i)
         grobj => win%handles(hdle)%ptr

         if( grobj%struct%cmd == "line" .or.                            &
             grobj%struct%cmd == "cubic_bezier" .or.                    &
             grobj%struct%cmd == "quadr_bezier" ) then
            call grsci(grobj%struct%color)
            call grslw(grobj%struct%linewidth)
            call grsls(grobj%struct%linestyle)
            call pgline( 2, [ xcur, xcur+proto_width ], [ ycur+DL_y/2, ycur+DL_y/2 ] )
            xcur = xcur + proto_width + DL_x
            call grsci(1)
            call pgptxt(xcur,ycur,0.d0,0.d0,0.d0,trim(legend_ptr%legends(i)))
            xcur = x0
            ycur = ycur - 2*DL_y
         else if( grobj%struct%cmd == "point"  ) then
            call grsci(grobj%struct%color)
            call grsms(grobj%struct%markersize)
            call pgpt( 1, [ xcur+proto_width/2 ], [ ycur+DL_y/2 ],      &
                       grobj%struct%marker )
               xcur = xcur + proto_width + DL_x
            call grsci(1)
            call pgptxt(xcur,ycur,0.d0,0.d0,0.d0,trim(legend_ptr%legends(i)))
            xcur = x0
            ycur = ycur - 2*DL_y
         else if( grobj%struct%cmd == "line+point"  ) then
            call grsci(grobj%struct%color)
            call grslw(grobj%struct%linewidth)
            call grsls(grobj%struct%linestyle)
            call pgline( 2, [ xcur, xcur+proto_width ], [ ycur+DL_y/2, ycur+DL_y/2 ] )
            call grsms(grobj%struct%markersize)
            call pgpt( 1, [ xcur+proto_width/2 ], [ ycur+DL_y/2 ],      &
                       grobj%struct%marker )
            xcur = xcur + proto_width + DL_x
            call grsci(1)
            call pgptxt(xcur,ycur,0.d0,0.d0,0.d0,trim(legend_ptr%legends(i)))
            xcur = x0
            ycur = ycur - 2*DL_y
         else
            ! do nothing
         end if

      end do

      if( new_window ) then

         ! Get position and size of the current window...
         call grexec( grgtyp, GET_CURRENT_WIN_GEOM, rbuf, ibuf, chr, lchr )
         x_TLC = ibuf(1)
         y_TLC = ibuf(2)
         width  = ibuf(3)
         height = ibuf(4)
         WM_title_height = ibuf(5)

         ! Drawing is finished: get the BBox of the auxiliary pixmap and
         ! save its ID internally
         call grexec( grgtyp, SAVE_PIXMAP_ID, rbuf, ibuf, chr, lchr )
         xmin = ibuf(1)
         ymin = ibuf(2)
         xmax = ibuf(3)
         ymax = ibuf(4)
         pixmap_width  = (xmax - xmin + 1) + 2
         pixmap_height = (ymax - ymin + 1) + 2

         MAIN_WIN_ID = CURRENT_WIN_ID

!### à investiguer: pourquoi faut-il cela pour que la figure suivante
!                   soit "dessinable" ?
         ibuf(1) = 0 ! Target is the main pixmap
         call grexec( grgtyp, SELECT_AUX_PIXMAP, rbuf, ibuf, chr, lchr )

         ! replacement of msFigure...
         win_id_loc = 0
         do j = 1, MF_WIN_NB_MAX
            if( mf_win_db(j)%mfplot_id == 0 ) then
               win_id_loc = j
               exit
            end if
         end do

         geometry = [ x_TLC+width, y_TLC,                               &
                      max(200,pixmap_width), max(20,pixmap_height) ]

         ibuf(1) = 0 ! No figure number in the title
         call grexec( grgtyp, REM_FIG_NUM_IN_WIN_TITLE, rbuf, ibuf, chr, lchr )

         j = gropen_ec( 0, "/XWIN", pgid, geometry, MUESLI_EXE_NAME,    &
                        win_id_loc, "Shared legend" )

         ibuf(1) = 1 ! Figure number in the title (default) for future windows
         call grexec( grgtyp, REM_FIG_NUM_IN_WIN_TITLE, rbuf, ibuf, chr, lchr )

!### je suis obligé de mettre ça pour voir la légende s'afficher dans la
!    nouvelle fenêtre... pourquoi ?
         call grbpic

         ! Copy the auxiliary pixmap in this new window
         ibuf(1) = xmin
         ibuf(2) = ymin
         ibuf(3) = xmax
         ibuf(4) = ymax
         call grexec( grgtyp, COPY_PIXMAP_FROM_ID, rbuf, ibuf, chr, lchr )

         call msFigure( MAIN_WIN_ID )

!### changer la fenêtre avec 'msFigure'  ne suffit pas pour que le dessin
!    se refasse dans la 1ère fenêtre...
         ibuf(1) = 0 ! Target is the main pixmap
         call grexec( grgtyp, SELECT_AUX_PIXMAP, rbuf, ibuf, chr, lchr )

      end if

      if( clipping_disabled ) then
         ibuf(1) = 1 ! clipping at viewport
         call grexec( grgtyp, SET_CLIPPING, rbuf, ibuf, chr, lchr ) ! set clipping
         CLIPPING_IN_AXES = .true.
      end if

      if( present(position) ) then
         call msFreeArgs(position)
         call msAutoRelease(position)
      end if

#ifdef _MF_FUNC
   end function mfLegend_args_subset
#endif
#ifdef _MF_SUBR
   end subroutine msLegend_args_subset
#endif
