!_______________________________________________________________________
!
   subroutine msLabelFontSize( size_factor )

      real(kind=MF_DOUBLE), intent(in) :: size_factor
      !------ API end ------

      ! Default size factor is unity.
      !
      ! Actual font size depends on the 'char_height_pixel' property
      ! (see subroutine msCharInPixels)

      type(mf_win_info), pointer :: win

      character(len=*), parameter :: ROUTINE_NAME = "msLabelFontSize"

   !------ end of declarations -- execution starts hereafter  ------

      if( CURRENT_WIN_ID == 0 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "no X11 device selected." )
         return
      end if

      win => mf_win_db(CURRENT_WIN_ID)

      if( isnan(size_factor) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'size_factor' must be a numeric value, not NaN." )
         return
      end if

      if( size_factor < 0.4d0 .or. 2.5d0 < size_factor ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'size_factor' must be ranged in [0.4,2.5]." )
         return
      end if

      win%label_font_size = size_factor
      pg_lab_fnt_siz_fct(pgid) = size_factor

      ! le redessinement complet est inutile si 'msAxis' n'a pas été
      ! appelée auparavant :
      if( win%axis_scale_x==0 .or. win%axis_scale_y==0 ) then
         return
      end if

      call mf_win_redraw( CURRENT_WIN_ID )

   end subroutine msLabelFontSize
