!_______________________________________________________________________
!
   subroutine msInitFgl( )
   !------ API end ------

      ! Get many environment variables.
      !
      ! This routine should be called by the main program; but it is not
      ! strictly necessary (the first window created will execute it).

      character(len=10) :: defstr
      integer :: i, iostat, L
      logical :: warning

      integer, external :: get_terminal_x11_ID

      character(len=*), parameter :: ROUTINE_NAME = "msInitFgl"

   !------ end of declarations -- execution starts hereafter  ------

      ! Making sure that all tasks are done only one time.
      if( MF_INIT_FGL == 0 ) then

         warning = .false.
         ! Check whether an environment variable called MFPLOT_X11_DEVICE
         ! is present, and get its value (0 or 1).
         call grgenv( "X11_DEVICE", defstr, L )
         if( L > 0 ) then
            ! value must be an integer
            read( defstr(1:1), "(I1)", iostat=iostat ) i
            if( iostat == 0 ) then
               if( i == 0 ) then
                  X11_DEVICE = .false.
                  NULL_DEVICE = .true.
               else if( i /= 1 ) then
                  warning = .true.
               end if
            else
               warning = .true.
            end if
            if( warning ) then
               call PrintMessage( trim(ROUTINE_NAME), "W",              &
                                 "Bad value in the environment variable MFPLOT_X11_DEVICE:", &
                                 "it must be an integer value equal to 0 or 1" )
            end if
         end if

         if( X11_DEVICE ) then
            ! try to get the X11 ID of the terminal
            MF_TERMINAL_X11_ID = get_terminal_x11_ID()
         else
            MF_TERMINAL_X11_ID = 0
         end if

         warning = .false.
         ! Check whether an environment variable called MFPLOT_DEBUG is
         ! present, and get its value (positive integer).
         call grgenv( "DEBUG", defstr, L )
         if( L > 0 ) then
            ! value must be a positive integer
            read( defstr, *, iostat=iostat ) i
            if( iostat == 0 ) then
               if( i >= 0 ) then
                  MFPLOT_DEBUG = i
               else ! i < 0
                  warning = .true.
               end if
            else
               warning = .true.
            end if
            if( warning ) then
               call PrintMessage( trim(ROUTINE_NAME), "W",              &
                                 "Bad value in the environment variable MFPLOT_DEBUG:", &
                                 "it must have a positive integer value" )
            end if
         end if

!### si MFPLOT_DEBUG vaut 1 (DEBUG activé => suppression du graphic buffer de
!    MFPLOT) et qu'on est en mode OPTIM, il faut mettre un warning !

         ! Get the executable name to put it in the figure title.
         ! (call getarg(0,MUESLI_EXE_NAME) works for all compilers, but
         !  we prefer this modern approach)
         call get_command( MUESLI_EXE_NAME )

         ! Cleaning the executable name (removing the path before it)
         i = index( MUESLI_EXE_NAME, "/", back=.true. )
         if( i /= 0 ) then
            MUESLI_EXE_NAME = MUESLI_EXE_NAME(i+1:)
         end if

         ! Keep track of initialization
         MF_INIT_FGL = 1

      end if

   end subroutine msInitFgl
