!_______________________________________________________________________
!
   subroutine mf_image_draw( grobj )

      type(grobj_elem), intent(in) :: grobj
      !------ API end ------

      ! grobj type = "image"

      type(mf_win_info), pointer :: win

      integer :: idim, jdim
      real(kind=MF_DOUBLE) :: tr(6)

      real(kind=MF_DOUBLE) :: rbuf(1)
      integer :: ibuf(1)

   !------ end of declarations -- execution starts hereafter  ------

      if( PRINTING_EPS ) then
         if( COMMENTS_IN_EPS ) then
            ibuf(1) = 0
            call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- begin of Image", 0 )
         end if
      end if
      if( PRINTING_PDF ) then
         if( COMMENTS_IN_PDF ) then
            call pdf_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- begin of Image", 0 )
         end if
      end if

      win => mf_win_db(CURRENT_WIN_ID)

      if( win%axis_scale_x == 2 .or. win%axis_scale_y == 2 ) then
         call PrintMessage( "Image", "W",                               &
               "we are going to use a different scaling of axis from a previous", &
               "plot on the same figure; else, you could obtain some unexpected", &
               "results!" )
      end if

      ! Axes must be defined AND linear
      win%axis_scale_x = 1
      win%axis_scale_y = 1

      idim = size(grobj%struct%val_mat,1)
      jdim = size(grobj%struct%val_mat,2)
      tr(:) = grobj%struct%abs_tab(:)
      call pgimag( grobj%struct%val_mat, idim, jdim,        &
                   1, idim, 1, jdim, 0.d0, 1.0d0, tr  )

      if( PRINTING_EPS ) then
         if( COMMENTS_IN_EPS ) then
            ibuf(1) = 0
            call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- end of Image", 0 )
         end if
      end if
      if( PRINTING_PDF ) then
         if( COMMENTS_IN_PDF ) then
            call pdf_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- end of Image", 0 )
         end if
      end if

   end subroutine mf_image_draw
