!_______________________________________________________________________
!
   function ImageCore( mat, angle ) result( handle )

      real(kind=MF_DOUBLE), pointer :: mat(:,:)
      real(kind=MF_DOUBLE), intent(in) :: angle ! degree
      integer :: handle
      !------ API end ------

      ! dans cette version, on utilise : pgimag
      ! (pour bénéficier des opérations : flip, rotate, ou
      !  toute sorte de transformation linéaire : shear, ...)

      type(mf_win_info), pointer :: win
      type(grobj_elem), pointer :: grobj

      real(kind=MF_DOUBLE) :: range(4)
      integer :: i, idim, jdim, hdle
      real(kind=MF_DOUBLE) :: tr(6)
      real(kind=MF_DOUBLE) :: angle_rad, co, si, x_mil, y_mil

   !------ end of declarations -- execution starts hereafter  ------

      handle = 0

      angle_rad = (90.0d0-angle)*deg_to_rad
      co = cos(angle_rad)
      si = sin(angle_rad)

      idim = size(mat,1)
      jdim = size(mat,2)

      ! le barycentre de l'image est fixe et indépendant de l'angle
      x_mil = ( 1.0d0-0.5 + jdim+0.5d0 ) / 2.0d0
      y_mil = ( 1.0d0-0.5 + idim+0.5d0 ) / 2.0d0

      tr(1) = (2.0d0*x_mil - co*(idim+1) - si*(jdim+1) )/2.0d0
      tr(2) = co
      tr(3) = si
      tr(4) = (2.0d0*y_mil + si*(idim+1) - co*(jdim+1) )/2.0d0
      tr(5) = -si
      tr(6) = co

      win => mf_win_db(CURRENT_WIN_ID)

      ! 'ij' axis mode is selected
      win%axis_mode_xy = .false.

      ! les [nouveaux] axes doivent être prêts
      range(1) = 1
      range(2) = jdim
      ! 'y' axis is inverted to be coherent with PColor and Contour
      range(3) = idim
      range(4) = 1
      call mf_prepare_axes( CURRENT_WIN_ID, range )

      ! plotting something is always clipped at viewport
      if( X11_DEVICE ) then
         ! caution: axes must have been defined before
         call X11_clip_on_viewport()
      end if

!++++++++++++++++++ Storage in DB ++++++++++++++++++

      ! new grobj
      if( win%mf_win_db_active ) then
         ! create a new grobj and insert it in the linked list
         call create_grobj( win, grobj )
      else
         ! just allocate the grobj
         allocate( grobj )
      end if

      grobj%struct%cmd = "image"
      grobj%struct%val_mat => mat

      allocate( grobj%struct%abs_tab(6) )

      grobj%struct%abs_tab(:) = tr(:)

      if( win%mf_win_db_active ) then
         hdle = mf_win_get_free_handle(CURRENT_WIN_ID)
         win%handles(hdle)%ptr => grobj
         grobj%struct%hdle = hdle
         handle = encode_handle( CURRENT_WIN_ID, hdle )
      end if

!+++++++++++++++++++++++++++++++++++++++++++++++++++

      win%blank = .false.
      win%empty = .false.

!------------------ Drawing GrObj ------------------

      call mf_image_draw( grobj )

!---------------------------------------------------

      if( .not. win%mf_win_db_active ) then
         call delete_grobj_inside( grobj )
         deallocate( grobj )
      end if

   end function ImageCore
