!_______________________________________________________________________
!
#ifdef _MF_FUNC
   function mfImage( image, angle, flip, indexed ) result( handle )
#endif
#ifdef _MF_SUBR
   subroutine msImage( image, angle, flip, indexed )
#endif

      type(mfArray),        intent(in)           :: image
      real(kind=MF_DOUBLE), intent(in), optional :: angle ! degree
      character(len=*),     intent(in), optional :: flip ! none | horiz | vert
      logical,              intent(in), optional :: indexed
      integer :: handle
      !------ API end ------

      real(kind=MF_DOUBLE) :: angle_s

      ! pointers for manipulating mfArray out of fml module
      real(kind=MF_DOUBLE), pointer :: image_ptr(:,:)

      real(kind=MF_DOUBLE), pointer :: mat_sto_pg(:,:)

      integer :: i, j, nx, ny, num_colors, offset
      integer :: mf_message_level_save
      logical :: indexed_image
      type(mf_win_info), pointer :: win

#ifdef _MF_FUNC
      character(len=*), parameter :: ROUTINE_NAME = "mfImage"
#endif
#ifdef _MF_SUBR
      character(len=*), parameter :: ROUTINE_NAME = "msImage"
#endif

   !------ end of declarations -- execution starts hereafter  ------

#ifdef _MF_FUNC
      handle = 0
#endif

      if( CURRENT_WIN_ID == 0 ) then
         call msFigure()
         if( CURRENT_WIN_ID == 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "cannot plot: no window created!" )
            go to 99
         end if
      end if

      win => mf_win_db(CURRENT_WIN_ID)

      if( .not. win%colormap_init ) then
         call PrintMessage( trim(ROUTINE_NAME), "W",                    &
                            "colormap is not yet initialized!" )
         return
      end if

      if( present(angle) ) then
         angle_s = angle
      else
         angle_s = 0.
      end if

      if( present(indexed) ) then
         indexed_image = indexed
      else
         indexed_image = .false.
      end if

      call msInitArgs( image )

      ! checking that 'image' is allocated
      if( mfIsEqual(image,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'image' not allocated!" )
         go to 99
      end if

      ! 'image' must be Real
      if( .not. mfIsReal(image) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'image' must be real!" )
         go to 99
      end if

      ! 'image' cannot be sparse
      if( mfIsSparse(image) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'image' cannot be sparse!" )
         go to 99
      end if

      call msPointer( image, image_ptr, no_crc=.true. )

      nx = size(image_ptr,1)
      ny = size(image_ptr,2)
      allocate( mat_sto_pg(nx,ny) )

      if( present(flip) ) then
      select case( to_lower(flip) )
            case( "vert" )
               ! upside <-> downside (sur 'i')
               do i = 1, nx
                  do j = 1, ny
                     mat_sto_pg(i,j) = image_ptr(nx+1-i,j)
                  end do
               end do
            case( "horiz" )
               ! left <-> right (sur 'j')
               do i = 1, nx
                  do j = 1, ny
                     mat_sto_pg(i,j) = image_ptr(i,ny+1-j)
                  end do
               end do
            case default
               mat_sto_pg(:,:) = image_ptr(:,:)
         end select
      else
         mat_sto_pg(:,:) = image_ptr(:,:)
      end if

      call msFreePointer( image, image_ptr )

      if( indexed_image ) then
         ! getting the number of colors from the current colormap
         offset = win%colormap_ci_low - 1
         num_colors = win%colormap_ci_high - offset
         ! mapping the image array values to [0.0d0,1.0d0]
         if( win%colormap_none_removed ) then
            mat_sto_pg(:,:) = mat_sto_pg(:,:) - 1.0d0
            where( mat_sto_pg == 0.0d0 )
               mat_sto_pg(:,:) = MF_NAN
            elsewhere
               mat_sto_pg(:,:) = (mat_sto_pg(:,:)-1.0d0)/(num_colors-1)
            end where
         else
            mat_sto_pg(:,:) = (mat_sto_pg(:,:)-1.0d0)/(num_colors-1)
         end if
      end if

      handle = ImageCore( mat_sto_pg, angle_s )
      ! for images, the framebox should be redrawn as soon as possible...
      call mf_win_draw_box( CURRENT_WIN_ID, draw_labels=.false. )

 99   continue

      call msFreeArgs( image )
      call msAutoRelease( image )

#ifdef _MF_FUNC
   end function mfImage
#endif
#ifdef _MF_SUBR
   end subroutine msImage
#endif
