!_______________________________________________________________________
!
   subroutine write_any( mf_array, mf_color_table, filename, indexed_image )

      type(mfArray) :: mf_array, mf_color_table
      character(len=*), intent(in) :: filename
      logical,          intent(in) :: indexed_image
      !------ API end ------

      integer :: status, unit, mypid
      character(len=16) :: str_mypid
      logical :: exist
      character(len=80) :: line
      character(len=132) :: cmd

   !------ end of declarations -- execution starts hereafter  ------

      mypid = getpid()
      write( str_mypid, "(I0)" ) mypid

      ! verifying that 'convert' of ImageMagick is available...
      cmd = "convert -version > /tmp/IM_convert_check_"//trim(str_mypid)//" 2> /dev/null"
#if defined _INTEL_IFC | defined _GNU_GFC
      status = system(trim(cmd))
#else
- '(MUESLI write_any:) compiler not defined!'
#endif
      if( status /= 0 ) then
         call PrintMessage( "write_any", "E",                           &
                            "following 'system' command failed :",      &
                            trim(cmd) )
         return
      end if

      inquire(file="/tmp/IM_convert_check_"//trim(str_mypid),exist=exist)
      if( .not. exist ) then
         write(STDERR,*) "(MUESLI write_any:) internal error: tmp file doesn't exist!"
         call msMuesliTrace( pause="no" )
         stop
      end if
      call find_unit( unit )
      open(unit,file="/tmp/IM_convert_check_"//trim(str_mypid))
      read(unit,"(A)") line
      close(unit)
      status = system( "rm /tmp/IM_convert_check_"//trim(str_mypid) )
      if( line(1:20) /= "Version: ImageMagick" ) then
         call PrintMessage( "write_any", "E",                           &
                            "'convert' from ImageMagick not available!" )
         return
      end if

      ! processing new XPM image file
      call write_xpm( mf_array, mf_color_table, "/tmp/MUESLI_image_"//trim(str_mypid)//".xpm", indexed_image )

      ! converting the XPM image -> any image format
      cmd = "convert /tmp/MUESLI_image_"//trim(str_mypid)//".xpm " // trim(filename)
#if defined _INTEL_IFC | defined _GNU_GFC
      status = system(trim(cmd))
#else
- '(MUESLI write_any:) compiler not defined!'
#endif
      if( status /= 0 ) then
         call PrintMessage( "write_any", "E",                           &
                            "following 'system' command failed :",      &
                            trim(cmd) )
         return
      end if

      status = system( "rm /tmp/MUESLI_image_"//trim(str_mypid)//".xpm" )

   end subroutine write_any
