!_______________________________________________________________________
!
   subroutine write_xpm( mf_array, mf_color_table, filename, indexed_image )

      type(mfArray)                :: mf_array, mf_color_table
      character(len=*), intent(in) :: filename
      logical,          intent(in) :: indexed_image
      !------ API end ------

      ! pointers for manipulating mfArray out of fml module
      real(kind=MF_DOUBLE), pointer :: array(:,:) ! (imax,jmax)
      real(kind=MF_DOUBLE), pointer :: color_table(:,:) ! (ncol,3)

      integer :: i, j, k, ii, jj
      integer :: unit

      ! max image width : MF_ROW_WIDTH_MAX   pix. (1 char / pix.)
      !              or   MF_ROW_WIDTH_MAX/2 pix. (2 chrs / pix.)
      !                   etc.
      integer, parameter :: long_max = MF_ROW_WIDTH_MAX + 3

      integer :: imax, jmax, num_colors, chars_per_pixel
      integer :: num_colors_2
      real(kind=MF_DOUBLE) :: val

      integer, parameter :: num_colors_max = MF_ASCII_range**2 ! 8281
      character(len=2) :: cle(num_colors_max+1) ! (added NONE)
      integer :: red, green, blue

      character(len=6) :: num_colors_max_char

   !------ end of declarations -- execution starts hereafter  ------

      call find_unit( unit )
      open( unit=unit, file=trim(filename), recl=long_max )

      ! accès rapide aux mfArrays
      call msPointer( mf_array, array, no_crc=.true. )
      call msPointer( mf_color_table, color_table, no_crc=.true. )

      ! écriture de l'entête
      write(unit,"(A)") "/* XPM */"
      write(unit,"(A)") "static char *dummy[]={"

      jmax = size( array, 2 )
      imax = size( array, 1 )
      num_colors = size( color_table, 1 )
      if( num_colors <= MF_ASCII_range ) then
         chars_per_pixel = 1
      else if( num_colors <= num_colors_max ) then
         chars_per_pixel = 2
      else
         write(num_colors_max_char,*) num_colors_max
         call PrintMessage( "ImWrite", "E",                             &
                            "Too much colors. Max is currently " //     &
                            trim(num_colors_max_char) )
         return
      end if

      num_colors_2 = num_colors
      if( .not. indexed_image ) then
         ! check if the image 'array' contain at least on NaN value
         if( any(mfIsNaN(mf_array)) ) then
            num_colors_2 = num_colors_2 + 1
         end if
      end if

      write(unit,"(A,I0,3(1X,I0),A)")                                   &
            '"', jmax, imax, num_colors_2, chars_per_pixel, '",'

      if( jmax*chars_per_pixel+3 > long_max ) then
         write(STDERR,*) "(MUESLI ImWrite:) internal error: jmax*chars_per_pixel must be < ", long_max-3
         write(STDERR,*) "                  you must change the value of 'long_max'"
         call msMuesliTrace( pause="yes" )
         return
      end if

      ! writing the color table
      if( chars_per_pixel == 1 ) then
         ii = MF_ASCII_start
         do i = 1, num_colors
            cle(i) = char(ii)
            if( indexed_image .and. color_table(i,1) /= color_table(i,1) ) then
               ! the color is (NaN,NaN,Nan), so it is NONE
               write(unit,"(3(A))") '"', cle(i)(1:1), ' c None",'
            else
               ! 256 nuances par composante, car chacune est écriture avec
               ! deux chiffress hexadécimaux (00 à FF)
!### TODO 1: Touve-t-on des XPM avec 0-F ou 000-FFF ?
               red   = nint( color_table(i,1) * 255 )
               green = nint( color_table(i,2) * 255 )
               blue  = nint( color_table(i,3) * 255 )
               write(unit,"(3(A),3(Z2.2),A)")                           &
                     '"', cle(i)(1:1), ' c #', red, green, blue, '",'
            end if
            ii = ii + 1
         end do
         if( num_colors_2 == num_colors + 1 ) then
            ! adding the NONE color in the color table
            ! (the key character is a 'white space')
            write(unit,"(A)") '"  c None",'
         end if
      else ! chars_per_pixel == 2
         ii = MF_ASCII_start
         jj = ii
         do i = 1, num_colors
            cle(i) = char(jj)//char(ii)
            if( indexed_image .and. color_table(i,1) /= color_table(i,1) ) then
               ! the color is (NaN,NaN,Nan), so it is NONE
               write(unit,"(3(A))") '"', cle(i), ' c None",'
            else
               ! 256 nuances par composante, car chacune est écriture avec
               ! deux chiffress hexadécimaux (00 à FF)
!### TODO 1: Touve-t-on des XPM avec 0-F ou 000-FFF ?
               red   = nint( color_table(i,1) * 255 )
               green = nint( color_table(i,2) * 255 )
               blue  = nint( color_table(i,3) * 255 )
               write(unit,"(3(A),3(Z2.2),A)")                           &
                     '"', cle(i), ' c #', red, green, blue, '",'
            end if
            ii = ii + 1
            if( ii > MF_ASCII_end ) then
               ii = MF_ASCII_start
               jj = jj + 1
            end if
         end do
         if( num_colors_2 == num_colors + 1 ) then
            ! adding the NONE color in the color table
            ! (the key character is two 'white space')
            write(unit,"(A)") '"   c None",'
         end if
      end if

      ! writing image, row by row
      do i = 1, imax
         write(unit,fmt="(A)",advance="no") '"'
         do j = 1, jmax
            val = array(i,j)
            if( indexed_image ) then
               k = nint( val )
            else
               k = nint( val * (num_colors-1) + 1 )
            end if
            if( chars_per_pixel == 1 ) then
               if( val /= val ) then ! check for a NaN value
                  write(unit,fmt="(A)",advance="no") " "
               else
                  write(unit,fmt="(A)",advance="no") cle(k)(1:1)
               end if
            else
               if( val /= val ) then ! check for a NaN value
                  write(unit,fmt="(A)",advance="no") "  "
               else
                  write(unit,fmt="(A)",advance="no") cle(k)
               end if
            end if
         end do
         if( i == imax ) then
            write(unit,fmt="(A)") '"};'
         else
            write(unit,fmt="(A)") '",'
         end if
      end do

      close( unit )

      call msFreePointer( mf_array, array )
      call msFreePointer( mf_color_table, color_table )

   end subroutine write_xpm
