!_______________________________________________________________________
!
   subroutine read_any( filename, mf_array, mf_color_table, indexed_image )

      character(len=*), intent(in) :: filename
      type(mfArray)                :: mf_array, mf_color_table
      logical,          intent(in) :: indexed_image
      !------ API end ------

      integer :: status, unit, mypid
      character(len=16) :: str_mypid
      logical :: exist
      character(len=80) :: line
      character(len=256) :: cmd

   !------ end of declarations -- execution starts hereafter  ------

      ! ce n'est pas l'utilisateur qui appelle de lui-même cette routine :
      ! on est sûr, grâce au test 'args_mfout_ok', que les arguments de
      ! type mfArray ne sont pas tempo !
      ! => 'call msInitArgs( mf_array, mf_color_table )' inutile

      mypid = getpid()
      write( str_mypid, "(I0)" ) mypid

      ! verifying that 'convert' of ImageMagick is available...
      cmd = "convert -version > /tmp/IM_convert_check_"//trim(str_mypid)//" 2> /dev/null"
#if defined _INTEL_IFC | defined _GNU_GFC
      status = system(trim(cmd))
#else
- '(MUESLI read_any:) compiler not defined!'
#endif
      if( status /= 0 ) then
         call PrintMessage( "read_any", "E",                            &
                            "following 'system' command failed:",       &
                            trim(cmd) )
         return
      end if

      inquire(file="/tmp/IM_convert_check_"//trim(str_mypid),exist=exist)
      if( .not. exist ) then
         write(STDERR,*) "(MUESLI read_any:) internal error: tmp file doesn't exist!"
         call msMuesliTrace( pause="no" )
         stop
      end if
      call find_unit( unit )
      open(unit,file="/tmp/IM_convert_check_"//trim(str_mypid))
      read(unit,"(A)") line
      close(unit)
      status = system( "rm /tmp/IM_convert_check_"//trim(str_mypid) )
      if( line(1:20) /= "Version: ImageMagick" ) then
         call PrintMessage( "read_any", "E",                            &
                            "'convert' from ImageMagick not available!" )
         return
      end if

      ! converting any image format -> XPM

      ! from Muesli-2.15.0_2018-09-28, added the option '-colors 2048'
      ! to avoid dark images...
      ! (WARNING, by default, the XPM image has only 256 colors...
      !  but it is better to use the '-colors' option)

      ! add single quote to handles blanks in filenames
      cmd = "convert '" // trim(filename) // "' -colors 2048 /tmp/MUESLI_image_"//trim(str_mypid)//".xpm 2> /dev/null"
#if defined _INTEL_IFC | defined _GNU_GFC
      status = system(trim(cmd))
#else
- '(MUESLI read_any:) compiler not defined!'
#endif
      if( status /= 0 ) then
         call PrintMessage( "read_any", "E",                            &
                            "following 'system' command failed:",       &
                            trim(cmd) )
         return
      end if

      ! processing new XPM image file
      call read_xpm( "/tmp/MUESLI_image_"//trim(str_mypid)//".xpm",     &
                     mf_array, mf_color_table, indexed_image )

      status = system( "rm /tmp/MUESLI_image_"//trim(str_mypid)//".xpm" )

   end subroutine read_any
!_______________________________________________________________________
!
   subroutine get_image_infos( filename, infos )

      character(len=*), intent(in) :: filename
      type(mfArray) :: infos
      !------ API end ------

      integer :: status, unit, i, i1, i2, i_width, i_height, mypid
      character(len=16) :: str_mypid
      logical :: exist, further_debug_info
      character(len=256) :: line
      character(len=256) :: cmd

      ! get image size (width and height)

   !------ end of declarations -- execution starts hereafter  ------

      mypid = getpid()
      write( str_mypid, "(I0)" ) mypid

      ! verifying that 'identify' of ImageMagick is available...
      cmd = "identify -version > /tmp/IM_identify_check_"//trim(str_mypid)//" 2> /dev/null"
#if defined _INTEL_IFC | defined _GNU_GFC
      status = system(trim(cmd))
#else
- '(MUESLI get_image_infos:) compiler not defined!'
#endif
      if( status /= 0 ) then
         call PrintMessage( "get_image_infos", "E",                     &
                            "following 'system' command failed:",       &
                            trim(cmd) )
         return
      end if

      inquire(file="/tmp/IM_identify_check_"//trim(str_mypid),exist=exist)
      if( .not. exist ) then
         write(STDERR,*) "(MUESLI get_image_infos:) internal error: tmp file doesn't exist!"
         call msMuesliTrace( pause="no" )
         stop
      end if
      call find_unit( unit )
      open(unit,file="/tmp/IM_identify_check_"//trim(str_mypid))
      read(unit,"(A)") line
      close(unit)
      status = system( "rm /tmp/IM_identify_check_"//trim(str_mypid) )
      if( line(1:20) /= "Version: ImageMagick" ) then
         call PrintMessage( "get_image_infos", "E",                     &
                            "'identify' from ImageMagick not available!" )
         return
      end if

      ! extracting image information
      cmd = "identify '" // trim(filename) // "' > /tmp/IM_identify_size_" &
                         // trim(str_mypid) // " 2> /tmp/IM_identify_error_" &
                         // trim(str_mypid)
#if defined _INTEL_IFC | defined _GNU_GFC
      status = system(trim(cmd))
#else
- '(MUESLI get_image_infos:) compiler not defined!'
#endif
      if( status /= 0 ) then
         ! Try to go further in the error explaination (because 'identify'
         ! don't accept all RGB colornames)
         further_debug_info = .false.
         call find_unit( unit )
         open(unit,file="/tmp/IM_identify_error_"//trim(str_mypid))
         read(unit,"(A)") line
         close(unit)
         ! search for 'unrecognized color' in 'line'
         i = index(trim(line),"unrecognized color")
         if( i /= 0 ) then
            i1 = index(trim(line),"`")
            i2 = index(trim(line),"'")
            if( i1 /= 0 .and. i2 /= 0 ) then
               line = "-> unrecognized color: " // line(i1:i2)
               further_debug_info = .true.
            end if
         end if
         if( further_debug_info ) then
            call PrintMessage( "get_image_infos", "E",                  &
                               "following 'system' command failed:",    &
                               trim(cmd), trim(line) )
         else
            call PrintMessage( "get_image_infos", "E",                  &
                               "following 'system' command failed:",    &
                               trim(cmd) )
         end if
         status = system( "rm /tmp/IM_identify_size_"//trim(str_mypid) )
         status = system( "rm /tmp/IM_identify_error_"//trim(str_mypid) )
         return
      end if

      inquire(file="/tmp/IM_identify_size_"//trim(str_mypid),exist=exist)
      if( .not. exist ) then
         write(STDERR,*) "(MUESLI get_image_infos:) internal error: tmp file doesn't exist!"
         call msMuesliTrace( pause="no" )
         stop
      end if
      call find_unit( unit )
      open(unit,file="/tmp/IM_identify_size_"//trim(str_mypid))
      read(unit,"(A)") line
      close(unit)
      status = system( "rm /tmp/IM_identify_size_"//trim(str_mypid) )
      status = system( "rm /tmp/IM_identify_error_"//trim(str_mypid) )
      ! search for first blank in 'line'
      i = index(trim(line)," ")
      if( i == 0 ) then
         write(STDERR,*) "(MUESLI get_image_infos:) internal error: bad processing of output if 'identify'!"
         call msMuesliTrace( pause="no" )
         stop
      end if
      line = line(i+1:)
      ! search for second blank in 'line'
      i = index(trim(line)," ")
      if( i == 0 ) then
         write(STDERR,*) "(MUESLI get_image_infos:) internal error: bad processing of output if 'identify'!"
         call msMuesliTrace( pause="no" )
         stop
      end if
      line = line(i+1:)
      ! search for a "x"
      i = index(trim(line),"x")
      if( i == 0 ) then
         write(STDERR,*) "(MUESLI get_image_infos:) internal error: bad processing of output if 'identify'!"
         call msMuesliTrace( pause="no" )
         stop
      end if
      read(line(1:i-1),*) i_width
      line = line(i+1:)
      read(line,*) i_height

      infos = [ i_width, i_height ]

   end subroutine get_image_infos
