!_______________________________________________________________________
!
   subroutine read_xpm( filename, mf_array, mf_color_table, indexed_image )

      character(len=*), intent(in) :: filename
      type(mfArray)                :: mf_array, mf_color_table
      logical,          intent(in) :: indexed_image
      !------ API end ------

      ! Has been modified for new version of [ImageMagick]/convert
      ! (perhaps from version 6.7.7), which write explicitly the name
      ! of some colors in XPM files.
      ! Thanks to the '-colorspace RGB' option (see 'read_any' routine),
      ! only the following basic colornames are processed:
      ! 'white', black', 'red', 'green', 'blue', 'cyan', yellow', 'magenta'

      ! pointers for manipulating mfArray out of fml module
      real(kind=MF_DOUBLE), pointer :: array(:,:) ! (imax,jmax)
      real(kind=MF_DOUBLE), pointer :: color_table(:,:) ! (ncol,3)

      integer :: i, j, k, k2, ii
      integer :: unit

      ! max image width: MF_ROW_WIDTH_MAX   pix. (1 char / pix.)
      !             or   MF_ROW_WIDTH_MAX/2 pix. (2 chrs / pix.)
      !                  etc.
      integer, parameter :: long_max = MF_ROW_WIDTH_MAX + 3
      character(len=long_max) :: line

      integer :: length, imax, jmax, num_colors_xpm, num_colors,        &
                 chars_per_pixel, int_val, status

      integer, parameter :: num_colors_max = MF_ASCII_range**2 ! 8281
      character(len=2) :: cle(num_colors_max+1) ! (added NONE)
      character(len=2) :: c, c_NONE
      integer :: red, green, blue
      character(len=4) :: str1

      logical :: NONE_is_present, color_found, all_colors_found, failed

      ! The longest name in the RGB database is "light goldenrod yellow";
      ! it contains blanks.
      character(len=22) :: color_name

   !------ end of declarations -- execution starts hereafter  ------

      call find_unit( unit )
      open( unit=unit, file=trim(filename), recl=long_max )

      ! skipping blank or comment lines (arbitrary number of lines)
      call next_valid_line( unit, status )
      if( status /= 0 ) go to 99

      ! here, 'line' should contain "static char"
      if( line(1:11) /= "static char" ) then
         write(STDERR,*) "bad XPM image? Abort."
         go to 99
      end if

      ! skipping blank or comment lines (arbitrary number of lines)
      call next_valid_line( unit, status )
      if( status /= 0 ) go to 99

      ! image information is retrieved from the first line containing
      ! some information like "w h n c", where the integers w, h, n, c
      ! define the image characteristics
      line(1:1) = " "
      length = len_trim(line)
      line(length-1:length) = "  "
      read(line,*) jmax, imax, num_colors_xpm, chars_per_pixel
      num_colors = num_colors_xpm

      if( chars_per_pixel > 2 ) then
         call PrintMessage( "ImRead", "E",                              &
                            "chars_per_pixel must be equal to 1 or 2" )
         go to 99
      end if

      ! check the presence of NONE
      NONE_is_present = .false.
      i = 0
      do
         call next_valid_line( unit, status )
         if( status /= 0 ) go to 99
         i = i + 1
         if( chars_per_pixel == 1 ) then
            if( line(6:9) == "None" ) then
               NONE_is_present = .true.
               if( .not. indexed_image ) then
                  num_colors = num_colors_xpm - 1
               end if
               exit ! infinite do loop
            end if
         else if( chars_per_pixel == 2 ) then
            if( line(7:10) == "None" ) then
               NONE_is_present = .true.
               if( .not. indexed_image ) then
                  num_colors = num_colors_xpm - 1
               end if
               exit ! infinite do loop
            end if
         end if
         if( i == num_colors_xpm ) then
            exit ! infinite do loop
         end if
      enddo

      ! hereafter, num_colors contains the true number of colors

      if( num_colors > num_colors_max ) then
         write(str1,"(I0)") num_colors_max
         call PrintMessage( "ImRead", "E",                              &
                            "num_colors must be < " // trim(str1),      &
                            "(please reduce the number of colors)" )
         go to 99
      end if

      if( jmax*chars_per_pixel+3 > long_max ) then
         write(STDERR,*) "(MUESLI ImRead:) internal error: jmax*chars_per_pixel must be < ", long_max-3
         write(STDERR,*) "                 you must change the value of 'long_max'"
         call msMuesliTrace( pause="yes" )
         go to 99
      end if

      ! explicit call of mf_allocate
      ! (the following array is not a grobj, and doesn't contain the '%' character)
#ifndef _TRACE_MEM_ALLOC
      allocate( array(imax,jmax) )
#else
      call mf_allocate( array=array, m=imax, n=jmax,                    &
                        file="ImRead_aux.f90", line="???",              &
                        symb="array", unit="read_xpm" )
#endif
      call msEquiv( array, mf_array )
      call set_status_restr_to_false( mf_array )

#ifndef _TRACE_MEM_ALLOC
      allocate( color_table(num_colors,3) )
#else
      call mf_allocate( array=color_table, m=num_colors, n=3,           &
                        file="ImRead_aux.f90", line="???",              &
                        symb="color_table", unit="read_xpm" )
#endif
      call msEquiv( color_table, mf_color_table )
      call set_status_restr_to_false( mf_color_table )

      rewind( unit )

      ! read again the beginning of the image file (header)
      call next_valid_line( unit, status )
      if( status /= 0 ) go to 99

      ! here, 'line' should contain "static char"

      call next_valid_line( unit, status )
      if( status /= 0 ) go to 99

      ! here, 'line' should contain image information (w, h, c, n)
      ! so, ready to read colors.

      ! building: color_table(1:num_colors)
      !           cle(1:num_colors)
      i = 0
      ii = 0
      if( NONE_is_present .and. indexed_image ) then
         ii = 1
      end if
      c_NONE = ""
      do
         call next_valid_line( unit, status )
         if( status /= 0 ) go to 99
         i = i + 1
         if( chars_per_pixel == 1 ) then

            if( line(6:6) == "#" ) then
               read( line(7:8), "(Z2)") red
               read( line(9:10),"(Z2)") green
               read(line(11:12),"(Z2)") blue
               ii = ii + 1
               cle(ii) = line(2:2)
               ! 256 nuances par composante, car chacune est écrite avec
               ! deux chiffres hexadécimaux (00 à FF)
!### TODO 1: Trouve-t-on des XPM avec 0-F ou 000-FFF ?
               color_table(ii,1) = dble(red) / dble(255)
               color_table(ii,2) = dble(green) / dble(255)
               color_table(ii,3) = dble(blue) / dble(255)
            else
               ! color has a name
               k = index( line, '"', back=.true. )
               if( k <= 1 ) then
                  ! something is wrong
                  call PrintMessage( "ImRead", "E",                     &
                                     "got problem when reading the color table", &
                                     "(corrupted image?)" )
                  go to 99
               end if
               ! perhaps the line contains also some additional infos
               ! for monochrome devices. Searching for " m ".
               k2 = index( line, " m " )
               if( k2 == 0 ) then
                  color_name = line(6:k-1)
               else
                  color_name = line(6:k2-1)
               end if
               select case( color_name )
                  case( "None" )
                     if( NONE_is_present .and. indexed_image ) then
                        cle(1) = line(2:2)
                        color_table(1,:) = [ MF_NAN, MF_NAN, MF_NAN ]
                     else
                        c_NONE = line(2:2)
                     end if
                  case( "", "black", "gray0" ) ! some XPM file left empty
                                               ! the color field for black.
                     ii = ii + 1
                     cle(ii) = line(2:2)
                     color_table(ii,:) = [ 0.0d0, 0.0d0, 0.0d0 ]
                  case( "white", "gray100" )
                     ii = ii + 1
                     cle(ii) = line(2:2)
                     color_table(ii,:) = [ 1.0d0, 1.0d0, 1.0d0 ]
                  case( "red" )
                     ii = ii + 1
                     cle(ii) = line(2:2)
                     color_table(ii,:) = [ 1.0d0, 0.0d0, 0.0d0 ]
                  case( "green" )
                     ii = ii + 1
                     cle(ii) = line(2:2)
                     color_table(ii,:) = [ 0.0d0, 1.0d0, 0.0d0 ]
                  case( "blue" )
                     ii = ii + 1
                     cle(ii) = line(2:2)
                     color_table(ii,:) = [ 0.0d0, 0.0d0, 1.0d0 ]
                  case( "cyan" )
                     ii = ii + 1
                     cle(ii) = line(2:2)
                     color_table(ii,:) = [ 0.0d0, 1.0d0, 1.0d0 ]
                  case( "magenta" )
                     ii = ii + 1
                     cle(ii) = line(2:2)
                     color_table(ii,:) = [ 1.0d0, 0.0d0, 1.0d0 ]
                  case( "yellow" )
                     ii = ii + 1
                     cle(ii) = line(2:2)
                     color_table(ii,:) = [ 1.0d0, 1.0d0, 0.0d0 ]
                  case default
                     ! special case for 'gray0' to 'gray100'
                     failed = .false.
                     if( color_name(1:4) == "gray" ) then
                        length = len_trim(color_name)
                        if( length == 4 .or. length > 7 ) then
                           failed = .true.
                        else
                           read( color_name(5:length), *, iostat=status ) int_val
                           if( status == 0 ) then
                              ii = ii + 1
                              cle(ii) = line(2:2)
                              color_table(ii,:) = [ 1.0d0, 1.0d0, 1.0d0 ]*(int_val/100.0d0)
                           else
                              failed = .true.
                           end if
                        end if
                     else
                        ii = ii + 1
                        cle(ii) = line(2:2)
                        ! Sometimes the colorname comes from the RGB database
                        if( .not. RGB_database_ready ) then
                           ! Read the full RGB database
                           call read_RGB_database()
                        end if
                        call find_colorname_in_RGB_database( color_name, &
                                        color_table(ii,:), status )
                        if( status == 0 ) then
                           failed = .false.
                        else
                           failed = .true.
                        end if
                     end if
                     if( failed ) then
                        ! something is wrong
                        call PrintMessage( "ImRead", "E",               &
                                           "cannot understand the following color:", &
                                           trim(color_name),            &
                                           "(corrupted image?)" )
                        go to 99
                     end if
               end select
            end if

         else if( chars_per_pixel == 2 ) then

            if( line(7:7) == "#" ) then
               read( line(8:9), "(Z2)") red
               read(line(10:11),"(Z2)") green
               read(line(12:13),"(Z2)") blue
               ii = ii + 1
               cle(ii) = line(2:3)
               ! 256 nuances par composante, car chacune est écrite avec
               ! deux chiffres hexadécimaux (00 à FF)
!### TODO 1: Trouve-t-on des XPM avec 0-F ou 000-FFF ?
               color_table(ii,1) = dble(red) / 255.d0
               color_table(ii,2) = dble(green) / 255.d0
               color_table(ii,3) = dble(blue) / 255.d0
            else
               ! color has a name
               k = index( line, '"', back=.true. )
               if( k <= 1 ) then
                  ! something is wrong
                  call PrintMessage( "ImRead", "E",                     &
                                     "got problem when reading the color table", &
                                     "(corrupted image?)" )
                  go to 99
               end if
               ! perhaps the line contains also some additional infos
               ! for monochrome devices. Searching for " m ".
               k2 = index( line, " m " )
               if( k2 == 0 ) then
                  color_name = line(7:k-1)
               else
                  color_name = line(7:k2-1)
               end if
               select case( color_name )
                  case( "None" )
                     if( NONE_is_present .and. indexed_image ) then
                        cle(1) = line(2:3)
                        color_table(1,:) = [ MF_NAN, MF_NAN, MF_NAN ]
                     else
                        c_NONE = line(2:3)
                     end if
                  case( "", "black", "gray0" ) ! some XPM file left empty
                                               ! the color field for black.
                     ii = ii + 1
                     cle(ii) = line(2:3)
                     color_table(ii,:) = [ 0.0d0, 0.0d0, 0.0d0 ]
                  case( "white", "gray100" )
                     ii = ii + 1
                     cle(ii) = line(2:3)
                     color_table(ii,:) = [ 1.0d0, 1.0d0, 1.0d0 ]
                  case( "red" )
                     ii = ii + 1
                     cle(ii) = line(2:3)
                     color_table(ii,:) = [ 1.0d0, 0.0d0, 0.0d0 ]
                  case( "green" )
                     ii = ii + 1
                     cle(ii) = line(2:3)
                     color_table(ii,:) = [ 0.0d0, 1.0d0, 0.0d0 ]
                  case( "blue" )
                     ii = ii + 1
                     cle(ii) = line(2:3)
                     color_table(ii,:) = [ 0.0d0, 0.0d0, 1.0d0 ]
                  case( "cyan" )
                     ii = ii + 1
                     cle(ii) = line(2:3)
                     color_table(ii,:) = [ 0.0d0, 1.0d0, 1.0d0 ]
                  case( "magenta" )
                     ii = ii + 1
                     cle(ii) = line(2:3)
                     color_table(ii,:) = [ 1.0d0, 0.0d0, 1.0d0 ]
                  case( "yellow" )
                     ii = ii + 1
                     cle(ii) = line(2:3)
                     color_table(ii,:) = [ 1.0d0, 1.0d0, 0.0d0 ]
                  case default
                     ! special case for 'gray0' to 'gray100'
                     failed = .false.
                     if( color_name(1:4) == "gray" ) then
                        length = len_trim(color_name)
                        if( length == 4 .or. length > 7 ) then
                           failed = .true.
                        else
                           read( color_name(5:length), *, iostat=status ) int_val
                           if( status == 0 ) then
                              ii = ii + 1
                              cle(ii) = line(2:3)
                              color_table(ii,:) = [ 1.0d0, 1.0d0, 1.0d0 ]*(int_val/100.0d0)
                           else
                              failed = .true.
                           end if
                        end if
                     else
                        ii = ii + 1
                        cle(ii) = line(2:3)
                        ! Sometimes the colorname comes from the RGB database
                        if( .not. RGB_database_ready ) then
                           ! Read the full RGB database
                           call read_RGB_database()
                        end if
                        call find_colorname_in_RGB_database( color_name, &
                                        color_table(ii,:), status )
                        if( status == 0 ) then
                           failed = .false.
                        else
                           failed = .true.
                        end if
                     end if
                     if( failed ) then
                        ! something is wrong
                        call PrintMessage( "ImRead", "E",               &
                                           "cannot understand the following color:", &
                                           trim(color_name),            &
                                           "(corrupted image?)" )
                        go to 99
                     end if
               end select
            end if

         end if

         if( i == num_colors_xpm ) then
            exit ! infinite do loop
         end if

      enddo

      ! reading the image and storing pixel values in a matrix
      i = 0
      all_colors_found = .true.
      do

         call next_valid_line( unit, status )
         if( status /= 0 ) go to 99

         i = i + 1
         do j = 1, jmax
            if( chars_per_pixel == 1 ) then
               c = line(j+1:j+1)
            else if( chars_per_pixel == 2 ) then
               c = line(2*j:2*j+1)
            end if

            color_found = .false.
            do k = 1, num_colors
               if( cle(k) == c ) then
                  if( indexed_image ) then
                     ! storing the index of the color
                     array(i,j) = k
                  else
                     ! remapping :
                     !  k_min = 1           =>  array = 0.
                     !  k_max = num_colors  =>  array = 1.
                     array(i,j) = dble(k-1)/dble(num_colors-1)
                  end if
                  color_found = .true.
                  exit ! 'k' do loop
               end if
            enddo

            if( .not. color_found ) then
               if( .not.(NONE_is_present .and. indexed_image) ) then
                  ! special case for NONE
                  if( c_NONE  == c ) then
                     array(i,j) = MF_NAN
                     color_found = .true.
                  end if
               end if
            end if

            if( .not. color_found ) then
               all_colors_found = .false.
            end if

         enddo

         if( i == imax ) then
            exit ! infinite do loop
         end if

      enddo

      if( .not. color_found ) then
         call PrintMessage( "ImRead", "W",                              &
                            "Color not found in the embedded colormap!", &
                            "(corrupted image?)" )
      end if

 99   continue

      close( unit )

   contains
   !____________________________________________________________________
   !
      function begin_C_comment( line ) result( bool )

         character(len=*), intent(in) :: line
         logical                      :: bool
         !------ API end ------

         if( line(1:2) == "/*" .or. len_trim(line) == 0 ) then
            bool = .true.
         else
            bool = .false.
         end if

      end function begin_C_comment
   !____________________________________________________________________
   !
      function end_C_comment( line ) result( bool )

         character(len=*), intent(in) :: line
         logical                      :: bool
         !------ API end ------

         integer :: n

         n = len_trim(line)
         if( line(n-1:n) == "*/" .or. n == 0 ) then
            bool = .true.
         else
            bool = .false.
         end if

      end function end_C_comment
   !____________________________________________________________________
   !
      subroutine next_valid_line( unit, status )

         integer, intent(in) :: unit
         integer             :: status
         !------ API end ------

         logical :: in_C_comment

         read(unit,"(A)") line ; line = adjustl(line)
         in_C_comment = begin_C_comment(line)
         do
            if( in_C_comment ) then
               in_C_comment = .not. end_C_comment(line)
               do while( in_C_comment )
                  read(unit,"(A)") line ; line = adjustl(line)
                  if( begin_C_comment(line) ) then
                     write(STDERR,*) "badly-formed comment in XPM! Abort."
                     status = -1
                     return
                  end if
                  in_C_comment = .not. end_C_comment(line)
               end do
            else
               exit
            end if
            read(unit,"(A)") line ; line = adjustl(line)
            in_C_comment = begin_C_comment(line)
         end do

         status = 0

      end subroutine next_valid_line
   !____________________________________________________________________
   !
   end subroutine read_xpm
