!_______________________________________________________________________
!
   subroutine msImRead( out, filename, fmt, only_infos, indexed )

      type(mf_Out) :: out
      character(len=*), intent(in) :: filename
      character(len=*), intent(in), optional :: fmt
      logical,          intent(in), optional :: only_infos, indexed
      !------ API end ------

      ! Two image indexing schemes:
      !
      ! 1) real valued pixels
      !    (default one or if 'indexed_image'=.false.)
      !    => (fractional) real values are stored in 'array';
      !       these real values are ranged in [0.0,1.0].
      !       Transparent pixels correspond to a NaN value.
      !
      ! 2) indexed pixels
      !    => integer values are stored in 'array';
      !       these indexes are ranged in [1,N], where N is the number
      !       of colors in the colormap (including the NONE color for
      !       transparent pixels).
      !       NONE color is coded as the triplet (R,G,B) = (NaN,NaN,NaN),
      !       at the beginning of the colormap.

      ! supported image formats are :
      !
      ! XPM + any other format supported by 'convert' of ImageMagick

      type(mfArray), pointer :: out1, out2
      logical :: exist, has_extension, get_only_infos, indexed_image
      integer :: length, i
      character(len=80) :: imagename
      character(len=9) :: fmt_img

      character(len=*), parameter :: ROUTINE_NAME = "msImRead"

   !------ end of declarations -- execution starts hereafter  ------

      if( present(only_infos) ) then
         get_only_infos = only_infos
      else
         get_only_infos = .false.
      end if

      if( present(indexed) ) then
         indexed_image = indexed
      else
         indexed_image = .false.
      end if

      if( get_only_infos ) then

         if( out%n /= 1 ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "when 'only_infos' is TRUE, calling sequence is:", &
                               "call msImRead( mfOut(infos), filename [, fmt], only_infos)" )
            return
         end if

      else

         if( out%n /= 2 ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "calling sequence is:",                  &
                               "call msImRead( mfOut(A,cmap), filename [, fmt])" )
            return
         end if

      end if

      ! check args of mfOut
      if( .not. args_mfout_ok( out ) ) then
         call PrintMessage( "msImRead", "E",                            &
                            "output arguments cannot be tempo, or cannot share",&
                            "same memory as another input argument." )
         return
      end if

      length = len_trim(filename)
      if( length == 0 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "empty image name!" )
         return
      end if

      has_extension = .false.

      if( present(fmt) ) then
         fmt_img = to_lower(fmt)
      else
         ! image format is based on extension
         inquire( file=trim(filename), exist=exist )
         if( .not. exist ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "image file = " // trim(filename) // " doesn't exist!" )
            return
         end if
         i = index( trim(filename), "/", back=.true. )
         if( i /= 0 ) then
            imagename = filename(i+1:length)
         else
            imagename = filename
         end if
         i = index( trim(imagename), ".", back=.true. )
         if( i == 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "image format not detected!",            &
                               "You should supply the format." )
         end if
         has_extension = .true.
         fmt_img = to_lower( imagename(i+1:length) )
      end if

      inquire( file=trim(filename), exist=exist )
      if( .not. exist ) then
         if( has_extension ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "image file = " // trim(filename) // " doesn't exist!" )
            return
         end if
         ! essai en rajoutant l'extension ".fmt"
         imagename = trim(filename) // "." // trim(fmt_img)
         write(STDERR,*) "trying : " // trim(imagename)
         inquire( file=trim(imagename), exist=exist )
         if( .not. exist ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "image file = " // trim(imagename) // " doesn't exist!" )
            return
         end if
      end if

      if( get_only_infos ) then

         out1 => out%ptr1

         call get_image_infos( filename, out1 )

      else

         out1 => out%ptr1

         out2 => out%ptr2

         select case( to_lower(fmt_img) )
            case( "xpm" )
               call read_xpm( filename, out1, out2, indexed_image )
            case default
#ifdef _HAS_IM_CONVERT
               call read_any( filename, out1, out2, indexed_image )
#else
               call PrintMessage( trim(ROUTINE_NAME), "E",              &
                                  "image format not supported!",        &
                                  "You should install the ImageMagick package." )
#endif
         end select

      end if

   end subroutine msImRead
