!_______________________________________________________________________
!
   subroutine msGrid( mode, minor )

      character(len=*), intent(in)           :: mode
      logical,          intent(in), optional :: minor
      !------ API end ------

      ! grid is plotted inside the 'mf_win_draw_box' routine

      type(mf_win_info), pointer :: win

      character(len=*), parameter :: ROUTINE_NAME = "msGrid"

   !------ end of declarations -- execution starts hereafter  ------

      if( CURRENT_WIN_ID == 0 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "no X11 device selected." )
         return
      end if

      win => mf_win_db(CURRENT_WIN_ID)

      if( present(minor) ) then
         win%minor_grid = minor
      else
         win%minor_grid = .false.
      end if

      select case( to_lower(mode) )
         case("on")
            if( .not. win%grid_on ) then
               win%grid_on = .true.
               if( win%empty ) then
                  ! no grobj, therefore drawing the box only
                  call mf_win_draw_box( CURRENT_WIN_ID,                 &
                                        draw_labels=.false., draw_grid=.true. )
               else
                  call mf_win_redraw( CURRENT_WIN_ID )
               end if
            end if
         case("off")
            if( win%grid_on ) then
               win%grid_on = .false.
               ! must redraw all the plot (cannot erase the grid only)
               call mf_win_redraw( CURRENT_WIN_ID )
            end if
         case default
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "unknown keyword : '" // trim(mode) // "'" )
            return
      end select

   end subroutine msGrid
