!_______________________________________________________________________
!
   function mfGinputRect( ) result ( out )

      type(mfArray) :: out
      !------ API end ------

      real(kind=MF_DOUBLE) :: xref, yref, xc, yc
      real(kind=MF_DOUBLE) :: x_min, x_max, y_min, y_max
      real(kind=MF_DOUBLE) :: x_min_z, x_max_z, y_min_z, y_max_z
      character :: ch
      character(len=4) :: win_id_char
      integer :: itmp
      type(mf_win_info), pointer :: win
      integer :: axis_manual_save_x, axis_manual_save_y

      character(len=*), parameter :: ROUTINE_NAME = "mfGinputRect"

   !------ end of declarations -- execution starts hereafter  ------

      if( .not. X11_DEVICE ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "X11 device is ""off"".",                   &
                            "('" // trim(ROUTINE_NAME) // "' is an interactive routine which requires X11)" )
         return
      end if

      if( CURRENT_WIN_ID == 0 ) then
         call msFigure()
      end if

      win => mf_win_db(CURRENT_WIN_ID)
      if( all( win%current_axes(:) == 0.0d0 ) ) then
         ! set the whole graphic env, keeping the 'manual' status
         axis_manual_save_x = win%axis_manual_x
         axis_manual_save_y = win%axis_manual_y
         call msAxis( [ 0.0d0, 1.0d0, 0.0d0, 1.0d0 ] )
         win%axis_manual_x = axis_manual_save_x
         win%axis_manual_y = axis_manual_save_y
      end if

      win => mf_win_db(CURRENT_WIN_ID)

      call set_focus_mfplot_win( 1 )

      write(STDOUT,*)
      write(STDOUT,"(A,I0,A)") "  Entering interactive mode in Figure ", &
                               CURRENT_WIN_ID, " ... (ESC to quit)"
      write(STDOUT,*) " [click and drag to get a domain]"
      write(STDOUT,*)

      ! copies required for location test
      x_min = win%current_axes(1)
      x_max = win%current_axes(2)
      y_min = win%current_axes(3)
      y_max = win%current_axes(4)

      if( win%axis_scale_x == 1 ) then ! lin scale
         x_min_z = x_min
         x_max_z = x_max
      else ! log scale
         x_min_z = log10(x_min)
         x_max_z = log10(x_max)
      end if
      if( win%axis_scale_y == 1 ) then ! lin scale
         y_min_z = y_min
         y_max_z = y_max
      else ! log scale
         y_min_z = log10(y_min)
         y_max_z = log10(y_max)
      end if

      ! wait for a click (mouse down)
      if( pgband_dyn(MF_CROSSHAIR_CURSOR, x_min_z, x_max_z, y_min_z, y_max_z, &
          xc, yc, ch, win%axis_scale_x, win%axis_scale_y) == 0 ) then
         write(win_id_char,"(I0)") CURRENT_WIN_ID
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "no cursor device for win ID: " //          &
                            trim(adjustl(win_id_char)) )
         return
      end if

      if( ch == "L" ) then ! left button click
         xref = xc
         yref = yc
         ! wait for a click (mouse up)
         if( pgband(MF_CROSSHAIR_CURSOR,2,0,xref,yref,xc,yc,ch,         &
                    .false., win%axis_scale_x, win%axis_scale_y) == 0 ) then
            write(win_id_char,"(I0)") CURRENT_WIN_ID
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "no cursor device for win ID: " //       &
                               trim(adjustl(win_id_char)) )
            return
         end if
         out = [ xref, yref, xc, yc ]
         if( win%axis_scale_x == 2 ) then
            call msSet( 10.0d0**xref, out, 1 )
            call msSet( 10.0d0**xc,   out, 3 )
         else if( win%axis_scale_x == 0 ) then
            write(STDERR,*) "(MUESLI msGinput:) internal error: x-axis scale undefined!"
            call msMuesliTrace( pause="no" )
            stop
         end if
         if( win%axis_scale_y == 2 ) then
            call msSet( 10.0d0**yref, out, 2 )
            call msSet( 10.0d0**yc,   out, 4 )
         else if( win%axis_scale_y == 0 ) then
            write(STDERR,*) "(MUESLI msGinput:) internal error: y-axis scale undefined!"
            call msMuesliTrace( pause="no" )
            stop
         end if
      end if

      call msReturnArray( out ) ! set to tempo

      itmp = gr_set_cursor_shape( MF_LEFT_ARROW_CURSOR )

      call set_focus_mfplot_win( 0 )

   end function mfGinputRect
