!_______________________________________________________________________
!
   function mfGinputCustom_1( )                                         &
   result ( out )

      type(mfArray) :: out
      !------ API end ------

      ! Returns in the mfArray 'out' the coordinates (x,y) and the case
      ! used.
      !   First case:  without the Control key pressed, displaying
      !                the first custom cursor;
      !   Second case: with the Control key pressed, displaying the
      !                second custom cursor.
      !
      ! Before use, needs that two user-defined cursors (see
      ! msDefineCustomCursors).
      !
      !---------------------------------------------------------------------
      ! Implementation notes:
      ! If used with the keyboard only, two X11 events occur: indeed,
      ! there are two call to 'pgband' (the first one for MouseDown, the
      ! second one for MouseUp).

      real(kind=MF_DOUBLE) :: xref, yref, xc, yc
      character :: ch
      character(len=4) :: win_id_char
      integer :: itmp, inside, cursor, custom_cursor, control_key_down
      integer :: axis_manual_save_x, axis_manual_save_y

      character(len=*), parameter :: ROUTINE_NAME = "mfGinputCustom"

      type(mf_win_info), pointer :: win

      interface
         function get_mod_keys( key ) result( bool )
            integer :: key, bool
         end function
      end interface

   !------ end of declarations -- execution starts hereafter  ------

      if( .not. X11_DEVICE ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "X11 device is ""off"".",                   &
                            "('" // trim(ROUTINE_NAME) // "' is an interactive routine which requires X11)" )
         return
      end if

      if( CURRENT_WIN_ID == 0 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "no X11 device selected." )
         return
      end if

      call set_focus_mfplot_win( 1 )

      win => mf_win_db(CURRENT_WIN_ID)

      if( .not. win%user_cursors_defined ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "custom cursors USER1 and USER2 not defined!", &
                            "-> forgot to call msDefineCustomCursors()?" )
         return
      end if

      if( all( win%current_axes(:) == 0.0d0 ) ) then
         ! set the whole graphic env, keeping the 'manual' status
         axis_manual_save_x = win%axis_manual_x
         axis_manual_save_y = win%axis_manual_y
         call msAxis( [ 0.0d0, 1.0d0, 0.0d0, 1.0d0 ] )
         win%axis_manual_x = axis_manual_save_x
         win%axis_manual_y = axis_manual_save_y
      end if

      write(STDOUT,*)
      write(STDOUT,"(A,I0,A)") "  Entering interactive mode in Figure ", &
                               CURRENT_WIN_ID, " ..."
      write(STDOUT,"(A,I0,A)") '  (2 events expected; any key different to "L", "M" or "R" to quit)'
      write(STDOUT,*) " [click with the mouse to get a point]"
      write(STDOUT,*)

      call grsci(1) ! std foreground
      call grsls(1) ! continuous line

      ! avoid passing NaN values to MFPLOT
      xref = 0.
      yref = 0.
      xc = 0.
      yc = 0.

      ! check a control key pressed
      if( get_mod_keys(2) == 1 ) then
         ! control key is pressed
         cursor = MF_USER2_CURSOR
      else
         cursor = MF_USER1_CURSOR
      end if

      ! wait for a click (mouse down or equivalent key pressed)
      if( pgband( cursor, 100, 0, xref, yref, xc, yc, ch,               &
                  .false., win%axis_scale_x, win%axis_scale_y) == 0 ) then
         write(win_id_char,"(I0)") CURRENT_WIN_ID
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "no cursor device for win ID: " // win_id_char )
         return
      end if

      ch = to_upper(ch)
      ! Below, values "4", "5" and "6" have been added for testing ch;
      ! they correspond to "L", "M" and "R" respectively when the Ctrl key
      ! is pressed. See 'xw_read_cursor()'.
      if( ch=="L" .or. ch=="M" .or. ch=="R" .or.                        &
          ch=="4" .or. ch=="5" .or. ch=="6" ) then
         ! wait for a click (mouse up)
         if( pgband( cursor, 100, 0, xref, yref, xc, yc, ch,            &
                     .false., win%axis_scale_x, win%axis_scale_y,       &
                     control_key_down) == 0 ) then
            write(win_id_char,"(I0)") CURRENT_WIN_ID
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "no cursor device for win ID: " // win_id_char )
            return
         end if
         out = [ xc, yc ]
         if( win%axis_scale_x == 2 ) then
            call msSet( 10.0d0**xc, out, 1 )
         else if( win%axis_scale_x == 0 ) then
            write(STDERR,*) "(MUESLI mfGinput:) internal error: x-axis scale undefined!"
            call msMuesliTrace( pause="no" )
            stop
         end if
         if( win%axis_scale_y == 2 ) then
            call msSet( 10.0d0**yc, out, 2 )
         else if( win%axis_scale_y == 0 ) then
            write(STDERR,*) "(MUESLI mfGinput:) internal error: y-axis scale undefined!"
            call msMuesliTrace( pause="no" )
            stop
         end if
         custom_cursor = 1 + control_key_down
         out = out .hc. mf(custom_cursor)
      end if

      itmp = gr_set_cursor_shape( MF_LEFT_ARROW_CURSOR )

      call set_focus_mfplot_win( 0 )

      call msReturnArray( out ) ! set to tempo

   end function mfGinputCustom_1
!_______________________________________________________________________
!
   function mfGinputCustom_2( magnetic_grid_rule )                      &
   result ( out )

      interface
         subroutine magnetic_grid_rule( icase, x1, y1, x2, y2, valid )
            import :: MF_DOUBLE
            integer,              intent(in)  :: icase
            real(kind=MF_DOUBLE), intent(in)  :: x1, y1
            real(kind=MF_DOUBLE), intent(out) :: x2, y2
            logical,              intent(out) :: valid
         end subroutine
      end interface
      type(mfArray) :: out
      !------ API end ------

      ! Returns in the mfArray 'out' only the coordinates (x,y).
      !
      ! Before use, needs that two user-defined cursors (see
      ! msDefineCustomCursors).
      !
      !---------------------------------------------------------------------
      ! Implementation notes:
      ! If used with the keyboard only, two X11 events occur: indeed,
      ! there are two call to 'pgband' (the first one for MouseDown, the
      ! second one for MouseUp).

      real(kind=MF_DOUBLE) :: xref, yref, xc, yc
      character :: ch
      character(len=4) :: win_id_char
      integer :: itmp, inside, custom_cursor,                           &
                 control_key_down, read_cursor_valid
      integer :: axis_manual_save_x, axis_manual_save_y

      character(len=*), parameter :: ROUTINE_NAME = "mfGinputCustom"

      type(mf_win_info), pointer :: win

      interface
         function get_mod_keys( key ) result( bool )
            integer :: key, bool
         end function
      end interface

      double precision :: rbuf(2)
      integer :: ibuf(1), lchr
      character(len=16) :: chr

   !------ end of declarations -- execution starts hereafter  ------

      if( .not. X11_DEVICE ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "X11 device is ""off"".",                   &
                            "('" // trim(ROUTINE_NAME) // "' is an interactive routine which requires X11)" )
         return
      end if

      if( CURRENT_WIN_ID == 0 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "no X11 device selected." )
         return
      end if

      call set_focus_mfplot_win( 1 )

      win => mf_win_db(CURRENT_WIN_ID)

      if( .not. win%user_cursors_defined ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "custom cursors USER1 and USER2 not defined!", &
                            "-> forgot to call msDefineCustomCursors()?" )
         return
      end if

      if( all( win%current_axes(:) == 0.0d0 ) ) then
         ! set the whole graphic env, keeping the 'manual' status
         axis_manual_save_x = win%axis_manual_x
         axis_manual_save_y = win%axis_manual_y
         call msAxis( [ 0.0d0, 1.0d0, 0.0d0, 1.0d0 ] )
         win%axis_manual_x = axis_manual_save_x
         win%axis_manual_y = axis_manual_save_y
      end if

      write(STDOUT,*)
      write(STDOUT,"(A,I0,A)") "  Entering interactive mode in Figure ", &
                               CURRENT_WIN_ID, " ..."
      write(STDOUT,"(A,I0,A)") '  (2 events expected; any key different to "L", "M" or "R" to quit)'
      write(STDOUT,*) " [click with the mouse to get a point]"
      write(STDOUT,*)

      call grsci(1) ! std foreground
      call grsls(1) ! continuous line

      ! avoid passing NaN values to MFPLOT
      xref = 0.
      yref = 0.
      xc = 0.
      yc = 0.

      magnetic_grid_rule_ptr => magnetic_grid_rule

      ! wait for a click (mouse down or equivalent key pressed)
      if( pgband( MF_TRANSPARENT_CURSOR, 101, 0, xref, yref, xc, yc, ch, &
                  .false., win%axis_scale_x, win%axis_scale_y ) == 0 ) then
         write(win_id_char,"(I0)") CURRENT_WIN_ID
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "no cursor device for win ID: " // win_id_char )
         return
      end if

      ch = to_upper(ch)
      ! Below, values "4", "5" and "6" have been added for testing ch;
      ! they correspond to "L", "M" and "R" respectively when the Ctrl key
      ! is pressed. See 'xw_read_cursor()'.
      if( ch=="L" .or. ch=="M" .or. ch=="R" .or.                        &
          ch=="4" .or. ch=="5" .or. ch=="6" ) then
         ! wait for a click (mouse up)
         if( pgband( MF_TRANSPARENT_CURSOR, 101, 0, xref, yref, xc, yc, ch, &
                     .false., win%axis_scale_x, win%axis_scale_y,       &
                     control_key_down, read_cursor_valid ) == 0 ) then
            write(win_id_char,"(I0)") CURRENT_WIN_ID
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "no cursor device for win ID: " // win_id_char )
            return
         end if
         ! Warning: (xc,yc) is not the relevant position. Due to the
         ! magnetic grid, the expected position must be get from the
         ! X11 driver
         call grexec( grgtyp, GET_MODIFIED_CURS_POS, rbuf, ibuf, chr, lchr )
         out = rbuf(1:2)
         if( win%axis_scale_x == 2 ) then
            call msSet( 10.0d0**xc, out, 1 )
         else if( win%axis_scale_x == 0 ) then
            write(STDERR,*) "(MUESLI mfGinput:) internal error: x-axis scale undefined!"
            call msMuesliTrace( pause="no" )
            stop
         end if
         if( win%axis_scale_y == 2 ) then
            call msSet( 10.0d0**yc, out, 2 )
         else if( win%axis_scale_y == 0 ) then
            write(STDERR,*) "(MUESLI mfGinput:) internal error: y-axis scale undefined!"
            call msMuesliTrace( pause="no" )
            stop
         end if
         custom_cursor = 1 + control_key_down
         out = out .hc. mf(custom_cursor)
         out = out .hc. mf(read_cursor_valid)
      end if

      itmp = gr_set_cursor_shape( MF_LEFT_ARROW_CURSOR )

      call set_focus_mfplot_win( 0 )

      call msReturnArray( out ) ! set to tempo

   end function mfGinputCustom_2
