!_______________________________________________________________________
!
   function mfGetXAxisTicksNb( ticks ) result( nb )

      character(len=*), optional :: ticks
      integer                    :: nb
      !------ API end ------

      ! Get the number of ticks for the X-axis only (linear mode)

      type(mf_win_info), pointer :: win

      character(len=3) :: get_ticks

      character(len=*), parameter :: ROUTINE_NAME = "mfGetXAxisTicksNb"

   !------ end of declarations -- execution starts hereafter  ------

      nb = -1 ! i.e. not defined

      if( CURRENT_WIN_ID == 0 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "no X11 device selected." )
         return
      end if

      win => mf_win_db(CURRENT_WIN_ID)

      if( win%axis_scale_x == 2 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "X-axis scaling cannot be of logarithmic type!" )
         return
      end if

      if( present(ticks) ) then
         get_ticks = to_lower(ticks)
         if( get_ticks /= "all" .and. get_ticks /= "maj" ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               'bad argument: "ticks" must be equal to "major" or "all".' )
            return
         end if
      else
         get_ticks = "maj"
      end if

      USER_TICKS_ALL(pgid) = get_ticks == "all"

      if( USER_TICKS_ALL(pgid) ) then

         if( X_ALL_TICKS_IND_START(pgid) == -666 .or.                   &
             X_ALL_TICKS_IND_END(pgid)   == -666 ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "Cannot get the ticks number (misused function?)", &
                               "-> it works only for a linear X-axis, once a valid figure has been drawn." )
            return
         end if

         nb = X_ALL_TICKS_IND_END(pgid) - X_ALL_TICKS_IND_START(pgid) + 1

      else ! major ticks only

         if( X_MAJ_TICKS_IND_START(pgid) == -666 .or.                   &
             X_MAJ_TICKS_IND_END(pgid) == -666 ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "Cannot get the ticks number (misused function?)", &
                               "-> it works only for a linear X-axis, once a valid figure has been drawn." )
            return
         end if

         nb = X_MAJ_TICKS_IND_END(pgid) - X_MAJ_TICKS_IND_START(pgid) + 1

      end if

   end function mfGetXAxisTicksNb
