!_______________________________________________________________________
!
   subroutine msGetX11Pixmap( red, green, blue )

      type(mfArray), optional :: red, green, blue
      !------ API end ------

      ! in case where background color = black -> get R,G,B planes
      ! in case where background color = white -> get C,M,Y planes
      ! (in latter case, the user must modify 'red', 'green', 'blue'
      !  to get the true colors)

      ! args must not be tempo !

      type(mf_win_info), pointer :: win
      integer :: X11_id
      real(kind=MF_DOUBLE), pointer :: mat_red(:,:),                    &
                                       mat_green(:,:),                  &
                                       mat_blue(:,:)

      ! code : 0 -> color is not required
      !        1 -> color is required
      ! (on return, X11_rect_dump can change this value, by setting it to -1,
      !  to signal a size change)
      integer :: flag_red, flag_green, flag_blue

      character(len=*), parameter :: ROUTINE_NAME = "msGetX11Pixmap"

   !------ end of declarations -- execution starts hereafter  ------

      if( .not. X11_DEVICE ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "not an X11 device!" )
         return
      end if

      if( CURRENT_WIN_ID == 0 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "no window selected!" )
         return
      end if

      win => mf_win_db(CURRENT_WIN_ID)

      X11_id = win%mfplot_id

      if( present(red) ) then
         if( mfIsReal(red) ) then
            if( mfNbPointers(red) > 0 ) then
               call PrintMessage( trim(ROUTINE_NAME), "W",              &
                                  "'red' argument is still pointed by a f90", &
                                  " pointer! this can be confusing..." )
            end if
            call msPointer( red, mat_red, no_crc=.true. ) ! mat_red => red%double
         else
            mat_red => null()
         end if
         flag_red = 1
      else
         flag_red = 0
      end if

      if( present(green) ) then
         if( mfIsReal(green) ) then
            if( mfNbPointers(green) > 0 ) then
               call PrintMessage( trim(ROUTINE_NAME), "W",              &
                                  "'green' argument is still pointed by a f90", &
                                  " pointer! this can be confusing..." )
            end if
            call msPointer( green, mat_green, no_crc=.true. ) ! mat_green => green%double
         else
            mat_green => null()
         end if
         flag_green = 1
      else
         flag_green = 0
      end if

      if( present(blue) ) then
         if( mfIsReal(blue) ) then
            if( mfNbPointers(blue) > 0 ) then
               call PrintMessage( trim(ROUTINE_NAME), "W",              &
                                  "'blue' argument is still pointed by a f90", &
                                  " pointer! this can be confusing..." )
            end if
            call msPointer( blue, mat_blue, no_crc=.true. ) ! mat_blue => blue%double
         else
            mat_blue => null()
         end if
         flag_blue = 1
      else
         flag_blue = 0
      end if

      call X11_rect_dump( X11_id, win%current_axes,                     &
                          mat_red, flag_red,                            &
                          mat_green, flag_green,                        &
                          mat_blue, flag_blue )

      if( flag_red /= 0 ) then
         if( mfIsReal(red) ) then
            ! red%double should be ok, except if its size has been
            ! changed (dealloc/alloc => modify address)
            if( flag_red == -1 ) then
               ! it may appear weird to call msEquiv on a locked mfArray
               ! (locked by msPointer)... but it is desired!
               call msEquiv( mat_red, red, realloc=.true. ) ! just point to
               call set_status_restr_to_false( red )
            else
               call msFreePointer( red, mat_red ) ! mat_red => null()
            end if
         else
            call msEquiv( mat_red, red ) ! do: SilentRelease(red)
            call set_status_restr_to_false( red )
         end if
      end if

      if( flag_green /= 0 ) then
         if( mfIsReal(green) ) then
            ! green%double should be ok, except if its size has been
            ! changed (dealloc/alloc => modify address)
            if( flag_green == -1 ) then
               call msEquiv( mat_green, green, realloc=.true. ) ! just point to
               call set_status_restr_to_false( green )
            else
               call msFreePointer( green, mat_green ) ! mat_green => null()
            end if
         else
            call msEquiv( mat_green, green ) ! do: SilentRelease(green)
            call set_status_restr_to_false( green )
         end if
      end if

      if( flag_blue /= 0 ) then
         if( mfIsReal(blue) ) then
            ! blue%double should be ok, except if its size has been
            ! changed (dealloc/alloc => modify address)
            if( flag_blue == -1 ) then
               call msEquiv( mat_blue, blue, realloc=.true. ) ! just point to
               call set_status_restr_to_false( blue )
            else
               call msFreePointer( blue, mat_blue ) ! mat_blue => null()
            end if
         else
            call msEquiv( mat_blue, blue ) ! do: SilentRelease(blue)
            call set_status_restr_to_false( blue )
         end if
      end if

   end subroutine msGetX11Pixmap
