!_______________________________________________________________________
!
   function mfGetAllGrObj( ) result( grobj_hdle )

      integer, allocatable :: grobj_hdle(:)
      !------ API end ------

      ! returns the list of the handle of all graphic objects in the
      ! current window.

      type(mf_win_info), pointer :: win
      integer :: hdle, k, handle

      character(len=*), parameter :: ROUTINE_NAME = "mfGetAllGrObj"

   !------ end of declarations -- execution starts hereafter  ------

      if( CURRENT_WIN_ID == 0 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "no figure selected!" )
         return
      end if

      win => mf_win_db(CURRENT_WIN_ID)

      ! count all grobj handles
      k = 0
      if( associated( win%handles ) ) then
         do hdle = lbound(win%handles,1), ubound(win%handles,1)
            if( associated(win%handles(hdle)%ptr) ) then
               k = k + 1
            end if
         end do
      end if

      ! allocate the integer array
      allocate( grobj_hdle(k) )

      ! fill the mfArray with the handles
      if( associated( win%handles ) ) then
         do hdle = lbound(win%handles,1), ubound(win%handles,1)
            if( associated(win%handles(hdle)%ptr) ) then
               handle = encode_handle( CURRENT_WIN_ID, hdle )
               grobj_hdle(hdle) = handle
            end if
         end do
      end if

   end function mfGetAllGrObj
