!_______________________________________________________________________
!
   subroutine msFigure( win_id, position, size, title )

      integer,          intent(in), optional :: win_id
      integer,          intent(in), optional :: position(2), size(2)
      character(len=*), intent(in), optional :: title
      !------ API end ------

      integer :: pos(2), siz(2), win_geom_prev(4), win_x, win_y
      integer :: status
      integer :: win_width, win_height
      integer :: geometry(4)
      integer :: i, j, L, win_id_loc, iostat

      logical :: win_geom_tmp_known

      character(len=80) :: string
      character(len=6) :: win_id_char, win_nb_char
      character :: defstr
      character(len=5) :: DEVICE_TYPE
      character(len=256) :: title_latin_1

      type(mf_win_info), pointer :: win

      character(len=*), parameter :: ROUTINE_NAME = "msFigure"

   !------ end of declarations -- execution starts hereafter  ------

      if( MF_INIT_FGL == 0 ) then
         call msInitFgl()
      end if

      if( present(win_id) ) then

         if( win_id < 1 ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "window ID arg. must be >= 1!" )
            go to 99
         end if

         if( win_id > MF_WIN_NB_MAX ) then
            write(win_nb_char,"(I0)") MF_WIN_NB_MAX
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "max window ID is:" // trim(win_nb_char) // "!" )
            go to 99
         end if

         ! If window already exists: select it and quit the routine
         if( mf_win_db(win_id)%mfplot_id /= 0 ) then
            call pgslct( mf_win_db(win_id)%mfplot_id )
            call raise_mfplot_win()
            CURRENT_WIN_ID = win_id
            go to 99
         end if

         win_id_loc = win_id

      else

         ! win_id is not provided by the user: find the first one
         ! which is available...
         win_id_loc = 0
         do j = 1, MF_WIN_NB_MAX
            if( mf_win_db(j)%mfplot_id == 0 ) then
               win_id_loc = j
               exit
            end if
         end do
         if( win_id_loc == 0 ) then
            write(win_nb_char,"(I0)") MF_WIN_NB_MAX
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "cannot find a window ID!",              &
                               "(max. nb of windows: " // trim(win_nb_char) // " has been reached)" )
            go to 99
         end if

      end if

      win_geom_tmp_known = .false.

      if( present(position) ) then

         ! Check position: valid input
         if( any(position<0) ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "'position' must contain non-negative numbers" )
            go to 99
         end if

         pos = position

      else

         if( present(win_id) ) then

            ! try to read a previous registered window
            call read_mf_win_pos_db( win_id, win_geom_prev )
            pos = win_geom_prev(1:2)
            win_geom_tmp_known = .true.

         else

            ! defines position of a window
            ! -> it is preferable to not use a constant (X,Y) position of the
            ! window (hide windows is not a good idea). Here, each window is
            ! shifted from the previous one by a constant... this is
            ! CASCADE WINDOWS.
            win_x = LAST_MF_WIN_X + MF_WIN_X_OFFSET
            win_y = LAST_MF_WIN_Y + MF_WIN_Y_OFFSET
            pos = [ win_x, win_y  ]
            LAST_MF_WIN_X = win_x
            LAST_MF_WIN_Y = win_y

         end if

      end if

      if( present(size) ) then

         ! Check size: valid input
         if( any(size<0) ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "'size' must contain non-negative numbers" )
            go to 99
         end if

         ! Check size: minimum size is 200x150 or 150x200
         if( (size(1)<200 .or. size(2)<150) .and.                       &
             (size(1)<150 .or. size(2)<200)  ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "too small size" )
            go to 99
         end if

         siz = size

      else

         if( present(win_id) ) then

            if( .not. win_geom_tmp_known ) then
               ! try to read a previous registered window
               call read_mf_win_pos_db( win_id, win_geom_prev )
            end if
            siz = win_geom_prev(3:4)

         else

            call get_default_x11_size( win_width, win_height )

            siz = [ win_width, win_height ]

         end if

      end if

      ! Create a new MFPLOT X11 window...
      !
      ! /XSERV device should be possible, but with /XWIN, msClose() can
      ! really delete the window. On the other hand, when the program will
      ! finish, all windows will be deleted (as in MATLAB); a mechanism is
      ! therefore added (msExitFgl routine) to ask the user to explictly
      ! quit the graphic part of MUESLI.

      ! If required, set W/B instead of B/W ( 0=Black, 1=White )
      if( BLACK_ON_WHITE == 0 ) then
         call set_mfplot_background_color( "X11", 0 )
      end if

      if( X11_DEVICE ) then
         DEVICE_TYPE = "/XWIN"
      else
         DEVICE_TYPE = "/NULL"
      end if

      if( present(title) ) then
         if( UTF8_ENCODING ) then
            title_latin_1 = utf8_to_latin_1( trim(title) )
         else
            title_latin_1 = trim(title)
         end if
      else
         title_latin_1 = ""
      end if

      geometry = [ pos, siz ]

      i = pgopen_ec( DEVICE_TYPE, geometry, MUESLI_EXE_NAME,            &
                     win_id_loc, title_latin_1 )

      if( i <= 0 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "cannot open a new MFPLOT X11 window!" )
         go to 99
      end if

      pg_axe_fnt_siz_fct(pgid) = 1.0d0
      pg_axis_lin_width(pgid)  = 1.0d0
      pg_lab_fnt_siz_fct(pgid) = 1.0d0
      pg_tit_fnt_siz_fct(pgid) = 2.0d0

      if( BLACK_ON_WHITE == -1 ) then
         BLACK_ON_WHITE = 1
      end if

      mf_win_db(win_id_loc)%mfplot_id = i
      CURRENT_WIN_ID = win_id_loc
      ! Register that 'msFigure' has been called with an explicit win_id
      mf_win_db(win_id_loc)%save_geometry = .true.
      mf_win_db(win_id_loc)%win_title = title_latin_1

      ! Opened device becomes automatically the current selected one
      ! (see gropen_ec). No need to call pgslct.

      win => mf_win_db(CURRENT_WIN_ID)

      ! Default: see mod_win_db.F90
      call pgscir( win%colormap_ci_low, win%colormap_ci_high )

      call grgenv( "COLOR_SCHEME", defstr, L )
      if( L > 0 ) then
         ! Value must be an integer
         read( defstr(1:1), "(I1)", iostat=iostat ) i
         if( iostat == 0 ) then
            if( 1 <= i .and. i <= 4 ) then
               mf_win_db(win_id_loc)%color_scheme = i
            else
               call PrintMessage( trim(ROUTINE_NAME), "W",              &
                                  "Bad value in the environment variable MFPLOT_COLOR_SCHEME:", &
                                  "it must be an integer value ranged in 1-4", &
                                  "(keeping the default value of 3)" )
            end if
         else
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "Bad value in the environment variable MFPLOT_COLOR_SCHEME:", &
                               "it must be an integer value ranged in 1-4", &
                                  "(keeping the default value of 3)" )
         end if
      end if

      ! The field 'geometry' is only used for the NULL_DEVICE;
      ! it is a virtual window geometry...
      mf_win_db(win_id_loc)%geometry = geometry

 99   continue

   end subroutine msFigure
!_______________________________________________________________________
!
   function mfFigure( ) result ( win_id )

      integer :: win_id
      !------ API end ------

   !------ end of declarations -- execution starts hereafter  ------

      call msFigure( )

      win_id = CURRENT_WIN_ID

   end function mfFigure
