!_______________________________________________________________________
!
   subroutine msExitFgl( pause, indent )
      logical, optional :: pause
      integer, optional :: indent
   !------ API end ------

      character :: c
      integer :: win_id, indent_0
      logical :: any_opened, pause_0

      double precision :: rbuf(1)
      integer :: ibuf(1), lchr
      character :: chr
      character(len=32) :: format
      type(mf_win_info), pointer :: win

   !------ end of declarations -- execution starts hereafter  ------

      any_opened = .false.
      do win_id = 1, MF_WIN_NB_MAX
         if( mf_win_db(win_id)%mfplot_id /= 0 ) then
            any_opened = .true.
            exit
         end if
      end do

      if( present(pause) ) then
         pause_0 = pause
      else
         pause_0 = .true.
      end if

      if( present(indent) ) then
         if( indent < 0 ) then
            write(STDOUT,*) "***"
            write(STDOUT,*) "(MUESLI msExitFgl:) ERROR: 'indent' cannot have a negative value!"
            write(STDOUT,*) "***"
            indent_0 = 0
         else
            indent_0 = indent
         end if
      else
         indent_0 = 0
      end if

      if( indent_0 == 0 ) then
         format = "(A)"
      else
         write(format,"(I0)") indent_0
         format = "(" // trim(format) // "X,A)"
      end if

      write(STDOUT,format)
      write(STDOUT,format) "***"
      write(STDOUT,format) "End of MUESLI plotting:"
      if( X11_DEVICE .and. any_opened ) then
         write(STDOUT,format) "  - all figures are going to be closed."
      end if
      write(STDOUT,format) "  - graphic memory will be properly cleaned."

      if( MFPLOT_BUF_LEVEL > 0 ) then
         write(STDOUT,format) "***"
         write(STDOUT,format) "(MUESLI msExitFgl:) Warning: plotting buffer is not empty!"
         write(STDOUT,format) "***"
      end if

      if( pgid > 0 ) then
         if( pgblev(pgid) > 0 ) then
            write(STDOUT,format) "***"
            write(STDOUT,format) "(MUESLI msExitFgl:) Internal error: MFPLOT plotting buffer is not empty!"
            write(STDOUT,format) "***"
         end if
      end if

      if( any_opened ) then

         ! Skip this part when the /NULL device has been used
         ! for all windows
         if( X11_DEVICE ) then
            if( pause_0 ) then
               ! The chosen letter to quit the program is 'y'.
               ! So, we can automatize the production of figures by
               ! using the 'yes' unix command which send an infinite
               ! suite of 'y' to the terminal. Type for example:
               !   # yes | ./Plot
               do
!!#if defined _INTEL_IFC
!!                  ! As mentionned in msFlush, the workaround for the bug of
!!                  ! 'flush' doesn't work when writing on the same line.
!!                  call put_string_on_term_no_adv(" Do you really close graphics? [y|Y] ")
!!#else
                  write(STDOUT,format,advance="no") "Do you really close graphics? [y|Y] "
                  call msFlush(STDOUT)
!!#endif
                  read(STDIN,"(A)") c
                  if( to_lower(c) == "y" ) exit
               end do
            end if
         end if

         write(STDOUT,*)
         write(STDOUT,format) "***"
         if( X11_DEVICE ) then
            write(STDOUT,format) "Registering X11 windows..."
         end if
         ! Explicit close for:
         !   (i) registering position and size of each window
         !  (ii) cleaning graphic memory...
         do win_id = 1, MF_WIN_NB_MAX
            if( mf_win_db(win_id)%mfplot_id /= 0 ) then
               ! cleaning common graphics memory
               if( allocated(mf_win_db(win_id)%user_colormap) ) then
                  deallocate( mf_win_db(win_id)%user_colormap )
               end if
               call msClose( win_id )
            end if
         end do

      end if

      ! Additional clean of FontConfig
      if( X11_DEVICE ) then
         write(STDOUT,format) "FontConfig cleaning..."
         call grexec( grgtyp, CLEAN_FONTCONFIG, rbuf, ibuf, chr, lchr )
      end if

      ! reset to default for some global variables...
      BLACK_ON_WHITE = -1 ! -1 means not yet initialized
                          ! (see SetBackgroundColor)

      write(STDOUT,format) "Bye"
      write(STDOUT,*)

      ! reset, to allow the disabling of the X11 device
      MF_INIT_FGL = 0

   end subroutine msExitFgl
