!_______________________________________________________________________
!
   subroutine mf_errorbar_x_line_draw( grobj )

      type(grobj_elem), intent(in) :: grobj
      !------ API end ------

      ! grobj type = "errorbar_x_line"

      real(kind=MF_DOUBLE) :: rbuf(1)
      integer :: ibuf(1)

   !------ end of declarations -- execution starts hereafter  ------

      if( PRINTING_EPS ) then
         if( COMMENTS_IN_EPS ) then
            ibuf(1) = 0
            call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- begin of Line+ErrorBarX", 0 )
         end if
      end if
      if( PRINTING_PDF ) then
         if( COMMENTS_IN_PDF ) then
            call pdf_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- begin of Line+ErrorBarX", 0 )
         end if
         gr_pdf_color_intent = 1 ! Stroke
      end if

      call grsci(grobj%struct%color) ! set color index
      call grslw(grobj%struct%linewidth) ! set line width
      call grsls(grobj%struct%linestyle) ! set line style

      call pgline_errorbarx( grobj%struct%npt,                          &
                             grobj%struct%abs_tab, grobj%struct%ord_tab, &
                             grobj%struct%tm1_tab )

      if( PRINTING_EPS ) then
         if( COMMENTS_IN_EPS ) then
            ibuf(1) = 0
            call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- end of Line+ErrorBarX", 0 )
         end if
      end if
      if( PRINTING_PDF ) then
         if( COMMENTS_IN_PDF ) then
            call pdf_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- end of Line+ErrorBarX", 0 )
         end if
      end if

   end subroutine mf_errorbar_x_line_draw
!_______________________________________________________________________
!
   subroutine mf_errorbar_x_pt_draw( grobj )

      type(grobj_elem), intent(in) :: grobj
      !------ API end ------

      ! grobj type = "errorbar_x_pt"

      integer :: marker

      real(kind=MF_DOUBLE) :: rbuf(1)
      integer :: ibuf(1)

   !------ end of declarations -- execution starts hereafter  ------

      if( PRINTING_EPS ) then
         if( COMMENTS_IN_EPS ) then
            ibuf(1) = 0
            call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- begin of Point+ErrorBarX", 0 )
         end if
      end if
      if( PRINTING_PDF ) then
         if( COMMENTS_IN_PDF ) then
            call pdf_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- begin of Point+ErrorBarX", 0 )
         end if
         gr_pdf_color_intent = 3 ! Stroke & Fill
      end if

      call grsci(grobj%struct%color) ! set color index
      marker = grobj%struct%marker

      call grslw( grobj%struct%linewidth ) ! set linewidth
      call grsls(1)                       ! set line style
      call grsms(grobj%struct%markersize) ! set marker size

      call pgpt_errorbarx( grobj%struct%npt,                            &
                           grobj%struct%abs_tab, grobj%struct%ord_tab,  &
                           grobj%struct%tm1_tab,                        &
                           marker, grobj%struct%linewidth )

      if( PRINTING_EPS ) then
         if( COMMENTS_IN_EPS ) then
            ibuf(1) = 0
            call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- end of Point+ErrorBarX", 0 )
         end if
      end if
      if( PRINTING_PDF ) then
         if( COMMENTS_IN_PDF ) then
            call pdf_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- end of Point+ErrorBarX", 0 )
         end if
      end if

   end subroutine mf_errorbar_x_pt_draw
!_______________________________________________________________________
!
   subroutine mf_errorbar_x_line_pt_draw( grobj )

      type(grobj_elem), intent(in) :: grobj
      !------ API end ------

      ! grobj type = "errorbar_x_line+pt"

      integer :: marker
      real(kind=MF_DOUBLE) :: linewidth

      real(kind=MF_DOUBLE) :: rbuf(1)
      integer :: ibuf(1)

   !------ end of declarations -- execution starts hereafter  ------

      if( PRINTING_EPS ) then
         if( COMMENTS_IN_EPS ) then
            ibuf(1) = 0
            call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- begin of Line+Point+ErrorBarX", 0 )
         end if
      end if
      if( PRINTING_PDF ) then
         if( COMMENTS_IN_PDF ) then
            call pdf_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- begin of Line+Point+ErrorBarX", 0 )
         end if
         gr_pdf_color_intent = 3 ! Stroke & Fill
      end if

      call grsci(grobj%struct%color) ! set color index

      if( PRINTING_EPS .or. PRINTING_PDF ) then
         call gresc( "q" ) ! = gsave
      end if

      linewidth = grobj%struct%linewidth
      call grslw(linewidth) ! set line width
      call grsls(grobj%struct%linestyle) ! set line style

      call pgline( grobj%struct%npt,                                    &
                   grobj%struct%abs_tab, grobj%struct%ord_tab )

      if( PRINTING_EPS ) then
         call gresc( "Q" ) ! = grestore
         LAST_COLOR_IS_VALID = .false.
         LAST_LINEWIDTH_IS_VALID = .false.
         LAST_LINESTYLE_IS_VALID = .false.
         LAST_FONT_ATTRIB_IS_VALID = .false.
      end if
      if( PRINTING_PDF ) then
         call gresc( "Q" ) ! = grestore
         LAST_LINEWIDTH_IS_VALID = .false.
         LAST_LINESTYLE_IS_VALID = .false.
         LAST_FONT_ATTRIB_IS_VALID = .false.
      end if

      marker = grobj%struct%marker
      call grsls(1) ! set line style
      call grsms(grobj%struct%markersize) ! set marker size

      call pgpt_errorbarx( grobj%struct%npt,                            &
                           grobj%struct%abs_tab, grobj%struct%ord_tab,  &
                           grobj%struct%tm1_tab,                        &
                           marker, grobj%struct%linewidth )

      if( PRINTING_EPS ) then
         if( COMMENTS_IN_EPS ) then
            ibuf(1) = 0
            call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- end of Line+Point+ErrorBarX", 0 )
         end if
      end if
      if( PRINTING_PDF ) then
         if( COMMENTS_IN_PDF ) then
            call pdf_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- end of Line+Point+ErrorBarX", 0 )
         end if
      end if

   end subroutine mf_errorbar_x_line_pt_draw
!_______________________________________________________________________
!
   subroutine mf_errorbar_y_line_draw( grobj )

      type(grobj_elem), intent(in) :: grobj
      !------ API end ------

      ! grobj type = "errorbar_y_line"

      real(kind=MF_DOUBLE) :: rbuf(1)
      integer :: ibuf(1)

   !------ end of declarations -- execution starts hereafter  ------

      if( PRINTING_EPS ) then
         if( COMMENTS_IN_EPS ) then
            ibuf(1) = 0
            call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- begin of Line+ErrorBarY", 0 )
         end if
      end if
      if( PRINTING_PDF ) then
         if( COMMENTS_IN_PDF ) then
            call pdf_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- begin of Line+ErrorBarY", 0 )
         end if
         gr_pdf_color_intent = 1 ! Stroke
      end if

      call grsci(grobj%struct%color) ! set color index
      call grslw(grobj%struct%linewidth) ! set line width
      call grsls(grobj%struct%linestyle) ! set line style

      call pgline_errorbary( grobj%struct%npt,                          &
                             grobj%struct%abs_tab, grobj%struct%ord_tab, &
                             grobj%struct%tm2_tab )

      if( PRINTING_EPS ) then
         if( COMMENTS_IN_EPS ) then
            ibuf(1) = 0
            call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- end of Line+ErrorBarY", 0 )
         end if
      end if
      if( PRINTING_PDF ) then
         if( COMMENTS_IN_PDF ) then
            call pdf_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- end of Line+ErrorBarY", 0 )
         end if
      end if

   end subroutine mf_errorbar_y_line_draw
!_______________________________________________________________________
!
   subroutine mf_errorbar_y_pt_draw( grobj )

      type(grobj_elem), intent(in) :: grobj
      !------ API end ------

      ! grobj type = "errorbar_y_pt"

      integer :: marker

      real(kind=MF_DOUBLE) :: rbuf(1)
      integer :: ibuf(1)

   !------ end of declarations -- execution starts hereafter  ------

      if( PRINTING_EPS ) then
         if( COMMENTS_IN_EPS ) then
            ibuf(1) = 0
            call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- begin of Point+ErrorBarY", 0 )
         end if
      end if
      if( PRINTING_PDF ) then
         if( COMMENTS_IN_PDF ) then
            call pdf_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- begin of Point+ErrorBarY", 0 )
         end if
         gr_pdf_color_intent = 3 ! Stroke & Fill
      end if

      call grsci(grobj%struct%color) ! set color index
      marker = grobj%struct%marker

      call grslw( grobj%struct%linewidth ) ! set linewidth
      call grsls(1) ! set line style
      call grsms(grobj%struct%markersize) ! set marker size

      call pgpt_errorbary( grobj%struct%npt,                            &
                           grobj%struct%abs_tab, grobj%struct%ord_tab,  &
                           grobj%struct%tm2_tab,                        &
                           marker, grobj%struct%linewidth )

      if( PRINTING_EPS ) then
         if( COMMENTS_IN_EPS ) then
            ibuf(1) = 0
            call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- end of Point+ErrorBarY", 0 )
         end if
      end if
      if( PRINTING_PDF ) then
         if( COMMENTS_IN_PDF ) then
            call pdf_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- end of Point+ErrorBarY", 0 )
         end if
      end if

   end subroutine mf_errorbar_y_pt_draw
!_______________________________________________________________________
!
   subroutine mf_errorbar_y_line_pt_draw( grobj )

      type(grobj_elem), intent(in) :: grobj
      !------ API end ------

      ! grobj type = "errorbar_y_line+pt"

      integer :: marker
      real(kind=MF_DOUBLE) :: linewidth

      real(kind=MF_DOUBLE) :: rbuf(1)
      integer :: ibuf(1)

   !------ end of declarations -- execution starts hereafter  ------

      if( PRINTING_EPS ) then
         if( COMMENTS_IN_EPS ) then
            ibuf(1) = 0
            call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- begin of Line+Point+ErrorBarY", 0 )
         end if
      end if
      if( PRINTING_PDF ) then
         if( COMMENTS_IN_PDF ) then
            call pdf_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- begin of Line+Point+ErrorBarY", 0 )
         end if
         gr_pdf_color_intent = 3 ! Stroke & Fill
      end if

      call grsci(grobj%struct%color) ! set color index

      if( PRINTING_EPS .or. PRINTING_PDF ) then
         call gresc( "q" ) ! = gsave
      end if

      linewidth = grobj%struct%linewidth
      call grslw(linewidth) ! set line width
      call grsls(grobj%struct%linestyle) ! set line style

      call pgline( grobj%struct%npt,                                    &
                   grobj%struct%abs_tab, grobj%struct%ord_tab )

      if( PRINTING_EPS ) then
         call gresc( "Q" ) ! = grestore
         LAST_COLOR_IS_VALID = .false.
         LAST_LINEWIDTH_IS_VALID = .false.
         LAST_LINESTYLE_IS_VALID = .false.
         LAST_FONT_ATTRIB_IS_VALID = .false.
      end if
      if( PRINTING_PDF ) then
         call gresc( "Q" ) ! = grestore
         LAST_LINEWIDTH_IS_VALID = .false.
         LAST_LINESTYLE_IS_VALID = .false.
         LAST_FONT_ATTRIB_IS_VALID = .false.
      end if

      marker = grobj%struct%marker
      call grsls(1) ! set line style
      call grsms(grobj%struct%markersize) ! set marker size

      call pgpt_errorbary( grobj%struct%npt,                            &
                           grobj%struct%abs_tab, grobj%struct%ord_tab,  &
                           grobj%struct%tm2_tab,                        &
                           marker, grobj%struct%linewidth )

      if( PRINTING_EPS ) then
         if( COMMENTS_IN_EPS ) then
            ibuf(1) = 0
            call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- end of Line+Point+ErrorBarY", 0 )
         end if
      end if
      if( PRINTING_PDF ) then
         if( COMMENTS_IN_PDF ) then
            call pdf_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- end of Line+Point+ErrorBarY", 0 )
         end if
      end if

   end subroutine mf_errorbar_y_line_pt_draw
!_______________________________________________________________________
!
   subroutine mf_errorbar_xy_line_draw( grobj )

      type(grobj_elem), intent(in) :: grobj
      !------ API end ------

      ! grobj type = "errorbar_xy_line"

      real(kind=MF_DOUBLE) :: rbuf(1)
      integer :: ibuf(1)

   !------ end of declarations -- execution starts hereafter  ------

      if( PRINTING_EPS ) then
         if( COMMENTS_IN_EPS ) then
            ibuf(1) = 0
            call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- begin of Line+ErrorBarXY", 0 )
         end if
      end if
      if( PRINTING_PDF ) then
         if( COMMENTS_IN_PDF ) then
            call pdf_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- begin of Line+ErrorBarXY", 0 )
         end if
         gr_pdf_color_intent = 1 ! Stroke
      end if

      call grsci(grobj%struct%color) ! set color index
      call grslw(grobj%struct%linewidth) ! set line width
      call grsls(grobj%struct%linestyle) ! set line style

      call pgline_errorbarxy( grobj%struct%npt,                         &
                              grobj%struct%abs_tab, grobj%struct%ord_tab, &
                              grobj%struct%tm1_tab, grobj%struct%tm2_tab )

      if( PRINTING_EPS ) then
         if( COMMENTS_IN_EPS ) then
            ibuf(1) = 0
            call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- end of Line+ErrorBarXY", 0 )
         end if
      end if
      if( PRINTING_PDF ) then
         if( COMMENTS_IN_PDF ) then
            call pdf_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- end of Line+ErrorBarXY", 0 )
         end if
      end if

   end subroutine mf_errorbar_xy_line_draw
!_______________________________________________________________________
!
   subroutine mf_errorbar_xy_pt_draw( grobj )

      type(grobj_elem), intent(in) :: grobj
      !------ API end ------

      ! grobj type = "errorbar_xy_pt"

      integer :: marker

      real(kind=MF_DOUBLE) :: rbuf(1)
      integer :: ibuf(1)

   !------ end of declarations -- execution starts hereafter  ------

      if( PRINTING_EPS ) then
         if( COMMENTS_IN_EPS ) then
            ibuf(1) = 0
            call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- begin of Point+ErrorBarXY", 0 )
         end if
      end if
      if( PRINTING_PDF ) then
         if( COMMENTS_IN_PDF ) then
            call pdf_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- begin of Point+ErrorBarXY", 0 )
         end if
         gr_pdf_color_intent = 3 ! Stroke & Fill
      end if

      call grsci(grobj%struct%color) ! set color index
      marker = grobj%struct%marker

      call grslw( grobj%struct%linewidth ) ! set linewidth
      call grsls(1) ! set line style
      call grsms(grobj%struct%markersize) ! set marker size

      call pgpt_errorbarxy( grobj%struct%npt,                           &
                            grobj%struct%abs_tab, grobj%struct%ord_tab, &
                            grobj%struct%tm1_tab, grobj%struct%tm2_tab, &
                            marker, grobj%struct%linewidth )

      if( PRINTING_EPS ) then
         if( COMMENTS_IN_EPS ) then
            ibuf(1) = 0
            call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- end of Point+ErrorBarXY", 0 )
         end if
      end if
      if( PRINTING_PDF ) then
         if( COMMENTS_IN_PDF ) then
            call pdf_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- end of Point+ErrorBarXY", 0 )
         end if
      end if

   end subroutine mf_errorbar_xy_pt_draw
!_______________________________________________________________________
!
   subroutine mf_errorbar_xy_line_pt_draw( grobj )

      type(grobj_elem), intent(in) :: grobj
      !------ API end ------

      ! grobj type = "errorbar_xy_line+pt"

      integer :: marker
      real(kind=MF_DOUBLE) :: linewidth

      real(kind=MF_DOUBLE) :: rbuf(1)
      integer :: ibuf(1)

   !------ end of declarations -- execution starts hereafter  ------

      if( PRINTING_EPS ) then
         if( COMMENTS_IN_EPS ) then
            ibuf(1) = 0
            call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- begin of Line+Point+ErrorBarXY", 0 )
         end if
      end if
      if( PRINTING_PDF ) then
         if( COMMENTS_IN_PDF ) then
            call pdf_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- begin of Line+Point+ErrorBarXY", 0 )
         end if
         gr_pdf_color_intent = 3 ! Stroke & Fill
      end if

      call grsci(grobj%struct%color) ! set color index

      if( PRINTING_EPS .or. PRINTING_PDF ) then
         call gresc( "q" ) ! = gsave
      end if

      linewidth = grobj%struct%linewidth
      call grslw(linewidth) ! set line width
      call grsls(grobj%struct%linestyle) ! set line style

      call pgline( grobj%struct%npt,                                    &
                   grobj%struct%abs_tab, grobj%struct%ord_tab )

      if( PRINTING_EPS ) then
         call gresc( "Q" ) ! = grestore
         LAST_COLOR_IS_VALID = .false.
         LAST_LINEWIDTH_IS_VALID = .false.
         LAST_LINESTYLE_IS_VALID = .false.
         LAST_FONT_ATTRIB_IS_VALID = .false.
      end if
      if( PRINTING_PDF ) then
         call gresc( "Q" ) ! = grestore
         LAST_LINEWIDTH_IS_VALID = .false.
         LAST_LINESTYLE_IS_VALID = .false.
         LAST_FONT_ATTRIB_IS_VALID = .false.
      end if

      marker = grobj%struct%marker
      linewidth = grobj%struct%linewidth
      call grsls(1) ! set line style
      call grsms(grobj%struct%markersize) ! set marker size

      call pgpt_errorbarxy( grobj%struct%npt,                           &
                            grobj%struct%abs_tab, grobj%struct%ord_tab, &
                            grobj%struct%tm1_tab, grobj%struct%tm2_tab, &
                            marker, grobj%struct%linewidth )

      if( PRINTING_EPS ) then
         if( COMMENTS_IN_EPS ) then
            ibuf(1) = 0
            call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- end of Line+Point+ErrorBarXY", 0 )
         end if
      end if
      if( PRINTING_PDF ) then
         if( COMMENTS_IN_PDF ) then
            call pdf_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- end of Line+Point+ErrorBarXY", 0 )
         end if
      end if

   end subroutine mf_errorbar_xy_line_pt_draw
