!_______________________________________________________________________
!
   function ErrorBarX( x_pg, y_pg, x_err_pg,                            &
                       linecolor, linestyle, linewidth, marker,         &
                       markersize )                                     &
   result( handle )

      real(kind=MF_DOUBLE), pointer    :: x_pg(:), y_pg(:), x_err_pg(:)
      integer                          :: linecolor
      integer,              intent(in) :: linestyle, marker
      real(kind=MF_DOUBLE), intent(in) :: linewidth, markersize

      integer :: handle
      !------ API end ------

      ! only scales "lin", "lin" (currently)

      type(mf_win_info), pointer :: win
      type(grobj_elem), pointer :: grobj

      integer :: i, n_pg, hdle
      real(kind=MF_DOUBLE) :: range(4)

   !------ end of declarations -- execution starts hereafter  ------

      n_pg = size(x_pg)

      win => mf_win_db(CURRENT_WIN_ID)

      win%axis_scale_x = 1
      win%axis_scale_y = 1

      call mf_save_and_disable_fpe( )

      range(1) = minval( x_pg )
      range(2) = maxval( x_pg )
      range(3) = minval( y_pg )
      range(4) = maxval( y_pg )
      call mf_prepare_axes( CURRENT_WIN_ID, range )

      ! cycling color table
      if( linecolor == -127 ) then
         select case( win%color_scheme )
            case( 1 )
               linecolor = COL_CYCLE_TAB_1(win%ind_next_color)
               if( win%ind_next_color == 6 ) then
                  win%ind_next_color = 1
               else
                  win%ind_next_color = win%ind_next_color + 1
               end if
            case( 2 )
               linecolor = COL_CYCLE_TAB_2(win%ind_next_color)
               if( win%ind_next_color == 7 ) then
                  win%ind_next_color = 1
               else
                  win%ind_next_color = win%ind_next_color + 1
               end if
            case( 3 )
               linecolor = COL_CYCLE_TAB_3(win%ind_next_color)
               if( win%ind_next_color == 7 ) then
                  win%ind_next_color = 1
               else
                  win%ind_next_color = win%ind_next_color + 1
               end if
            case( 4 )
               linecolor = COL_CYCLE_TAB_4(win%ind_next_color)
               if( win%ind_next_color == 12 ) then
                  win%ind_next_color = 1
               else
                  win%ind_next_color = win%ind_next_color + 1
               end if
            case default
               write(STDERR,*) "(FGL ErrorBarX:) Internal error."
               write(STDERR,*) "     Bad value for color_scheme."
               pause "only for debugging purpose"
               stop
         end select
      end if

      ! plotting something is always clipped at viewport
      if( X11_DEVICE ) then
         ! caution: axes must have been defined before
         call X11_clip_on_viewport()
      end if

!++++++++++++++++++ Storage in DB ++++++++++++++++++

      ! new grobj
      if( win%mf_win_db_active ) then
         ! create a new grobj and insert it in the linked list
         call create_grobj( win, grobj )
      else
         ! just allocate the grobj
         allocate( grobj )
      end if

      grobj%struct%color = linecolor
      grobj%struct%linewidth = linewidth
      grobj%struct%marker = marker
      grobj%struct%npt = n_pg

      grobj%struct%abs_tab => x_pg
      grobj%struct%ord_tab => y_pg
      grobj%struct%tm1_tab => x_err_pg

      if( linestyle /= -127 .and. marker == -127 ) then
         ! draw only line
         grobj%struct%linestyle = linestyle
         grobj%struct%cmd = "errorbar_x_line"
      else if( linestyle == -127 .and. marker /= -127 ) then
         ! draw only markers
         grobj%struct%linestyle = 1
         grobj%struct%markersize = markersize
         grobj%struct%cmd = "errorbar_x_pt"
      else
         ! draw both
         grobj%struct%linestyle = linestyle
         grobj%struct%markersize = markersize
         grobj%struct%cmd = "errorbar_x_line+pt"
      end if

      if( win%mf_win_db_active ) then
         hdle = mf_win_get_free_handle(CURRENT_WIN_ID)
         win%handles(hdle)%ptr => grobj
         grobj%struct%hdle = hdle
         handle = encode_handle( CURRENT_WIN_ID, hdle )
      end if

!+++++++++++++++++++++++++++++++++++++++++++++++++++

      win%blank = .false.
      win%empty = .false.

!------------------ Drawing GrObj ------------------

      if( grobj%struct%cmd == "errorbar_x_line" ) then
         call mf_errorbar_x_line_draw( grobj )
      else  if( grobj%struct%cmd == "errorbar_x_pt" ) then
         call mf_errorbar_x_pt_draw( grobj )
      else ! grobj%struct%cmd = "errorbar_x_line+pt"
         call mf_errorbar_x_line_pt_draw( grobj )
      end if

!---------------------------------------------------

      if( .not. win%mf_win_db_active ) then
         call delete_grobj_inside( grobj )
         deallocate( grobj )
      end if

      call mf_restore_fpe( )

   end function ErrorBarX
!_______________________________________________________________________
!
   function ErrorBarY( x_pg, y_pg, y_err_pg,                            &
                       linecolor, linestyle, linewidth, marker,         &
                       markersize )                                     &
   result( handle )

      real(kind=MF_DOUBLE), pointer    :: x_pg(:), y_pg(:), y_err_pg(:)
      integer                          :: linecolor
      integer,              intent(in) :: linestyle, marker
      real(kind=MF_DOUBLE), intent(in) :: linewidth, markersize

      integer :: handle
      !------ API end ------

      ! only scales "lin", "lin" (currently)

      type(mf_win_info), pointer :: win
      type(grobj_elem), pointer :: grobj

      integer :: i, n_pg, hdle
      real(kind=MF_DOUBLE) :: range(4)

   !------ end of declarations -- execution starts hereafter  ------

      n_pg = size(x_pg)

      win => mf_win_db(CURRENT_WIN_ID)

      win%axis_scale_x = 1
      win%axis_scale_y = 1

      call mf_save_and_disable_fpe( )

      range(1) = minval( x_pg )
      range(2) = maxval( x_pg )
      range(3) = minval( y_pg )
      range(4) = maxval( y_pg )
      call mf_prepare_axes( CURRENT_WIN_ID, range )

      ! cycling color table
      if( linecolor == -127 ) then
         select case( win%color_scheme )
            case( 1 )
               linecolor = COL_CYCLE_TAB_1(win%ind_next_color)
               if( win%ind_next_color == 6 ) then
                  win%ind_next_color = 1
               else
                  win%ind_next_color = win%ind_next_color + 1
               end if
            case( 2 )
               linecolor = COL_CYCLE_TAB_2(win%ind_next_color)
               if( win%ind_next_color == 7 ) then
                  win%ind_next_color = 1
               else
                  win%ind_next_color = win%ind_next_color + 1
               end if
            case( 3 )
               linecolor = COL_CYCLE_TAB_3(win%ind_next_color)
               if( win%ind_next_color == 7 ) then
                  win%ind_next_color = 1
               else
                  win%ind_next_color = win%ind_next_color + 1
               end if
            case( 4 )
               linecolor = COL_CYCLE_TAB_4(win%ind_next_color)
               if( win%ind_next_color == 12 ) then
                  win%ind_next_color = 1
               else
                  win%ind_next_color = win%ind_next_color + 1
               end if
            case default
               write(STDERR,*) "(FGL ErrorBarY:) Internal error."
               write(STDERR,*) "     Bad value for color_scheme."
               pause "only for debugging purpose"
               stop
         end select
      end if

      ! plotting something is always clipped at viewport
      if( X11_DEVICE ) then
         ! caution: axes must have been defined before
         call X11_clip_on_viewport()
      end if

!++++++++++++++++++ Storage in DB ++++++++++++++++++

      ! new grobj
      if( win%mf_win_db_active ) then
         ! create a new grobj and insert it in the linked list
         call create_grobj( win, grobj )
      else
         ! just allocate the grobj
         allocate( grobj )
      end if

      grobj%struct%color = linecolor
      grobj%struct%linewidth = linewidth
      grobj%struct%marker = marker
      grobj%struct%npt = n_pg

      grobj%struct%abs_tab => x_pg
      grobj%struct%ord_tab => y_pg
      grobj%struct%tm2_tab => y_err_pg

      if( linestyle /= -127 .and. marker == -127 ) then
         ! draw only line
         grobj%struct%linestyle = linestyle
         grobj%struct%cmd = "errorbar_y_line"
      else if( linestyle == -127 .and. marker /= -127 ) then
         ! draw only markers
         grobj%struct%linestyle = 1
         grobj%struct%markersize = markersize
         grobj%struct%cmd = "errorbar_y_pt"
      else
         ! draw both
         grobj%struct%linestyle = linestyle
         grobj%struct%markersize = markersize
         grobj%struct%cmd = "errorbar_y_line+pt"
      end if

      if( win%mf_win_db_active ) then
         hdle = mf_win_get_free_handle(CURRENT_WIN_ID)
         win%handles(hdle)%ptr => grobj
         grobj%struct%hdle = hdle
         handle = encode_handle( CURRENT_WIN_ID, hdle )
      end if

!+++++++++++++++++++++++++++++++++++++++++++++++++++

      win%blank = .false.
      win%empty = .false.

!------------------ Drawing GrObj ------------------

      if( grobj%struct%cmd == "errorbar_y_line" ) then
         call mf_errorbar_y_line_draw( grobj )
      else  if( grobj%struct%cmd == "errorbar_y_pt" ) then
         call mf_errorbar_y_pt_draw( grobj )
      else ! grobj%struct%cmd = "errorbar_y_line+pt"
         call mf_errorbar_y_line_pt_draw( grobj )
      end if

!---------------------------------------------------

      if( .not. win%mf_win_db_active ) then
         call delete_grobj_inside( grobj )
         deallocate( grobj )
      end if

      call mf_restore_fpe( )

   end function ErrorBarY
!_______________________________________________________________________
!
   function ErrorBarXY( x_pg, y_pg, x_err_pg, y_err_pg,                 &
                        linecolor, linestyle, linewidth, marker,        &
                        markersize )                                    &
   result( handle )

      real(kind=MF_DOUBLE), pointer    :: x_pg(:), y_pg(:), x_err_pg(:), y_err_pg(:)
      integer                          :: linecolor
      integer,              intent(in) :: linestyle, marker
      real(kind=MF_DOUBLE), intent(in) :: linewidth, markersize

      integer :: handle
      !------ API end ------

      ! only scales "lin", "lin" (currently)

      type(mf_win_info), pointer :: win
      type(grobj_elem), pointer :: grobj

      integer :: i, n_pg, hdle
      real(kind=MF_DOUBLE) :: range(4)

   !------ end of declarations -- execution starts hereafter  ------

      n_pg = size(x_pg)

      win => mf_win_db(CURRENT_WIN_ID)

      win%axis_scale_x = 1
      win%axis_scale_y = 1

      call mf_save_and_disable_fpe( )

      range(1) = minval( x_pg )
      range(2) = maxval( x_pg )
      range(3) = minval( y_pg )
      range(4) = maxval( y_pg )
      call mf_prepare_axes( CURRENT_WIN_ID, range )

      ! cycling color table
      if( linecolor == -127 ) then
         select case( win%color_scheme )
            case( 1 )
               linecolor = COL_CYCLE_TAB_1(win%ind_next_color)
               if( win%ind_next_color == 6 ) then
                  win%ind_next_color = 1
               else
                  win%ind_next_color = win%ind_next_color + 1
               end if
            case( 2 )
               linecolor = COL_CYCLE_TAB_2(win%ind_next_color)
               if( win%ind_next_color == 7 ) then
                  win%ind_next_color = 1
               else
                  win%ind_next_color = win%ind_next_color + 1
               end if
            case( 3 )
               linecolor = COL_CYCLE_TAB_3(win%ind_next_color)
               if( win%ind_next_color == 7 ) then
                  win%ind_next_color = 1
               else
                  win%ind_next_color = win%ind_next_color + 1
               end if
            case( 4 )
               linecolor = COL_CYCLE_TAB_4(win%ind_next_color)
               if( win%ind_next_color == 12 ) then
                  win%ind_next_color = 1
               else
                  win%ind_next_color = win%ind_next_color + 1
               end if
            case default
               write(STDERR,*) "(FGL ErrorBarXY:) Internal error."
               write(STDERR,*) "     Bad value for color_scheme."
               pause "only for debugging purpose"
               stop
         end select
      end if

      ! plotting something is always clipped at viewport
      if( X11_DEVICE ) then
         ! caution: axes must have been defined before
         call X11_clip_on_viewport()
      end if

!++++++++++++++++++ Storage in DB ++++++++++++++++++

      ! new grobj
      if( win%mf_win_db_active ) then
         ! create a new grobj and insert it in the linked list
         call create_grobj( win, grobj )
      else
         ! just allocate the grobj
         allocate( grobj )
      end if

      grobj%struct%color = linecolor
      grobj%struct%linewidth = linewidth
      grobj%struct%marker = marker
      grobj%struct%npt = n_pg

      grobj%struct%abs_tab => x_pg
      grobj%struct%ord_tab => y_pg
      grobj%struct%tm1_tab => x_err_pg
      grobj%struct%tm2_tab => y_err_pg

      if( linestyle /= -127 .and. marker == -127 ) then
         ! draw only line
         grobj%struct%linestyle = linestyle
         grobj%struct%cmd = "errorbar_xy_line"
      else if( linestyle == -127 .and. marker /= -127 ) then
         ! draw only markers
         grobj%struct%linestyle = 1
         grobj%struct%markersize = markersize
         grobj%struct%cmd = "errorbar_xy_pt"
      else
         ! draw both
         grobj%struct%linestyle = linestyle
         grobj%struct%markersize = markersize
         grobj%struct%cmd = "errorbar_xy_line+pt"
      end if

      if( win%mf_win_db_active ) then
         hdle = mf_win_get_free_handle(CURRENT_WIN_ID)
         win%handles(hdle)%ptr => grobj
         grobj%struct%hdle = hdle
         handle = encode_handle( CURRENT_WIN_ID, hdle )
      end if

!+++++++++++++++++++++++++++++++++++++++++++++++++++

      win%blank = .false.
      win%empty = .false.

!------------------ Drawing GrObj ------------------

      if( grobj%struct%cmd == "errorbar_xy_line" ) then
         call mf_errorbar_xy_line_draw( grobj )
      else  if( grobj%struct%cmd == "errorbar_xy_pt" ) then
         call mf_errorbar_xy_pt_draw( grobj )
      else ! grobj%struct%cmd = "errorbar_xy_line+pt"
         call mf_errorbar_xy_line_pt_draw( grobj )
      end if

!---------------------------------------------------

      if( .not. win%mf_win_db_active ) then
         call delete_grobj_inside( grobj )
         deallocate( grobj )
      end if

      call mf_restore_fpe( )

   end function ErrorBarXY
