!_______________________________________________________________________
!
#ifdef _MF_FUNC
   function mfErrorBar_color_str( x, y, x_err, y_err, linespec,         &
                                  color, linewidth, markersize )        &
   result( handle )
#endif
#ifdef _MF_SUBR
   subroutine msErrorBar_color_str( x, y, x_err, y_err, linespec,       &
                                    color, linewidth, markersize )
#endif

      type(mfArray),                    optional :: x
      type(mfArray)                              :: y
      type(mfArray),                    optional :: x_err
      type(mfArray),                    optional :: y_err
      character(len=*),     intent(in), optional :: linespec
      character(len=*),     intent(in)           :: color
      real(kind=MF_DOUBLE), intent(in), optional :: linewidth, markersize

      integer :: handle
      !------ API end ------

      ! Optional arguments optionnels make implementation easier.
      ! Only 4 cases are possible:
      !
      !    call ErrorBar(      y=., y_err=., ... )        Error bars along y
      !    call ErrorBar( x=., y=., y_err=., ... )          "    "     "
      !
      !    call ErrorBar( x=., y=., x_err=., ... )        Error bars along x
      !
      !    call ErrorBar( x=., y=., x_err=., y_err=. )    Error bars
      !                                                   along x and y

      logical :: draw_x_err, draw_y_err

      type(mf_win_info), pointer :: win
      real(kind=MF_DOUBLE) :: linewidth_d, markersize_d
      integer :: linecolor, linestyle, marker, ier

      ! pointers for manipulating mfArray out of fml module
      real(kind=MF_DOUBLE), pointer :: x_ptr(:,:), y_ptr(:,:),          &
                                       x_err_ptr(:,:), y_err_ptr(:,:)

      real(kind=MF_DOUBLE), pointer :: x_sto_pg(:), y_sto_pg(:),                        &
                       x_err_sto_pg(:), y_err_sto_pg(:)
      integer :: p_dim, i, n_pg
      integer :: status, status_alloc_x, status_alloc_y,                &
                 status_alloc_x_err, status_alloc_y_err

#ifdef _MF_FUNC
      character(len=*), parameter :: ROUTINE_NAME = "mfErrorBar"
#endif
#ifdef _MF_SUBR
      character(len=*), parameter :: ROUTINE_NAME = "msErrorBar"
#endif

   !------ end of declarations -- execution starts hereafter  ------

#ifdef _MF_FUNC
      handle = 0
#endif

      ! detection des cas possibles/impossibles
      if( present(x) ) then
         if( present(x_err) ) then
            if( present(y_err) ) then
               draw_x_err = .true.
               draw_y_err = .true.
            else ! y_err not present
               draw_x_err = .true.
               draw_y_err = .false.
            end if
         else ! x_err not present
            if( present(y_err) ) then
               draw_x_err = .false.
               draw_y_err = .true.
            else ! y_err not present
               call PrintMessage( trim(ROUTINE_NAME), "E",              &
                                  "bad optional arg combinaison (see doc)!" )
               return
            end if
         end if
      else ! x not present
         if( present(x_err) ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "bad optional arg combinaison (see doc)!" )
            return
         else ! x_err not present
            if( present(y_err) ) then
               draw_x_err = .false.
               draw_y_err = .true.
            else ! y_err not present
               call PrintMessage( trim(ROUTINE_NAME), "E",              &
                                  "bad optional arg combinaison (see doc)!" )
               return
            end if
         end if
      end if

      if( present(x) ) then

         call msInitArgs( x )

         ! checking that 'x' is allocated
         if( mfIsEqual(x,MF_EMPTY) ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "'x' not allocated!" )
            go to 99
         end if

         ! 'x' must be Numeric (real or complex)
         if( .not. mfIsNumeric(x) ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "'x' must be numeric!" )
            go to 99
         end if

         ! 'x' cannot be sparse
         if( mfIsSparse(x) ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "'x' cannot be sparse!" )
            go to 99
         end if

         if( mfIsComplex(x) ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "Imaginary parts of complex argument 'x' ignored." )
         end if

         call msPointer_real_only( x, x_ptr, status_alloc_x )

         ! checking that 'x' is a 1-D array
         if( size(x_ptr,1) /= 1 .and. size(x_ptr,2) /= 1 ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "'x' must be a 1-D array" )
            go to 99
         end if

      end if

      call msInitArgs( y )

      ! checking that 'y' is allocated
      if( mfIsEqual(y,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' not allocated!" )
         go to 99
      end if

      ! 'y' must be Numeric (real or complex)
      if( .not. mfIsNumeric(y) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' must be numeric!" )
         go to 99
      end if

      ! 'y' cannot be sparse
      if( mfIsSparse(y) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' cannot be sparse!" )
         go to 99
      end if

      if( mfIsComplex(y) ) then
         call PrintMessage( trim(ROUTINE_NAME), "W",                    &
                            "Imaginary parts of complex argument 'y' ignored." )
      end if

      call msPointer_real_only( y, y_ptr, status_alloc_y )

      ! checking that 'y' is a 1-D array
      if( size(y_ptr,1) == 1 ) then
         p_dim = 2
         n_pg = size(y_ptr,2)
      else if( size(y_ptr,2) == 1 ) then
         p_dim = 1
         n_pg = size(y_ptr,1)
      else
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' must be a 1-D array" )
         go to 99
      end if

      if( present(x) ) then

         ! checking that 'y' have the same shape than 'x'
         if( any(shape(y_ptr)/=shape(x_ptr)) ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "'x' and 'y' array must have the same shape" )
            go to 99
         end if

      else

         allocate( x_ptr(size(y_ptr,1),size(y_ptr,2)) )
         if( p_dim == 1 ) then
            x_ptr(:,1) = [ (i, i=1,n_pg) ]
         else ! p_dim = 2
            x_ptr(1,:) = [ (i, i=1,n_pg) ]
         end if

      end if

      allocate( x_sto_pg(n_pg) )
      if( p_dim == 1 ) then
         x_sto_pg(:) = x_ptr(:,1)
      else
         x_sto_pg(:) = x_ptr(1,:)
      end if

      if( draw_x_err ) then

         call msInitArgs( x_err )

         ! 'x_err' must be Numeric (real only)
         if( .not. mfIsReal(x_err) ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "'x_err' must be numeric!" )
            go to 99
         end if
         ! 'x_err' cannot be sparse
         if( mfIsSparse(x_err) ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "'x_err' cannot be sparse!" )
            go to 99
         end if
         call msPointer_real_only( x_err, x_err_ptr, status_alloc_x_err )
         ! checking that 'x_err' have the same shape than 'x'
         if( any(shape(x_err_ptr)/=shape(x_ptr)) ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "'x_err' and 'x' array must have the same shape" )
            go to 99
         end if

         allocate( x_err_sto_pg(n_pg) )
         if( p_dim == 1 ) then
            x_err_sto_pg(:) = x_err_ptr(:,1)
         else
            x_err_sto_pg(:) = x_err_ptr(1,:)
         end if

      end if

      allocate( y_sto_pg(n_pg) )
      if( p_dim == 1 ) then
         y_sto_pg(:) = y_ptr(:,1)
      else
         y_sto_pg(:) = y_ptr(1,:)
      end if

      if( draw_y_err ) then

         call msInitArgs( y_err )

         ! 'y_err' must be Numeric (real only)
         if( .not. mfIsReal(y_err) ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "'y_err' must be numeric!" )
            go to 99
         end if
         ! 'y_err' cannot be sparse
         if( mfIsSparse(y_err) ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "'y_err' cannot be sparse!" )
            go to 99
         end if
         call msPointer_real_only( y_err, y_err_ptr, status_alloc_y_err )
         ! checking that 'y_err' have the same shape than 'y'
         if( any(shape(y_err_ptr)/=shape(y_ptr)) ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "'y_err' and 'y' array must have the same shape" )
            go to 99
         end if

         allocate( y_err_sto_pg(n_pg) )
         if( p_dim == 1 ) then
            y_err_sto_pg(:) = y_err_ptr(:,1)
         else
            y_err_sto_pg(:) = y_err_ptr(1,:)
         end if

      end if

      if( present(linespec) ) then
         call decode_linespec( linespec, linecolor, linestyle, marker )
         ! only linestyle must have a valid value
         if( linestyle == -127 .and. marker == -127 ) then
            linestyle = 1
         end if
      else
         linecolor = -127 ! means: not found
         linestyle = 1
         marker    = -127 ! means: not found
      end if

      if( len_trim(color) == 1 .or. color(1:1) == "\" ) then
         call decode_linespec( color, linecolor, ier=ier )
         if( ier /= 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                              "bad 'color' argument!",                  &
                              "(line color will be set to foreground color)" )
            linecolor = 1
         end if
      else
         call decode_col_name( color, linecolor )
      end if

      if( present(linewidth) ) then
         linewidth_d = linewidth
      else
         linewidth_d = 1.0
      end if

      if( present(markersize) ) then
         markersize_d = markersize
      else
         if( present(linewidth) ) then
            markersize_d = sqrt(linewidth)
         else
            markersize_d = 1.0
         end if
      end if

      if( CURRENT_WIN_ID == 0 ) then
         call msFigure()
         if( CURRENT_WIN_ID == 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "cannot plot: no window created!" )
            go to 99
         end if
      end if

      win => mf_win_db(CURRENT_WIN_ID)

      if( win%axis_scale_x == 2 .or. win%axis_scale_y == 2 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "you are going to use a different scaling of axis", &
                            "from a previous plot on the same figure: however", &
                            "currently, ErrorBar is restricted to linear axis!" )
         go to 99
      end if

      if( draw_x_err ) then
         if( draw_y_err ) then
            handle = ErrorBarXY( x_sto_pg, y_sto_pg, x_err_sto_pg, y_err_sto_pg, &
                                 linecolor, linestyle, linewidth_d,     &
                                 marker, markersize_d )
         else ! not draw_y_err
            handle = ErrorBarX( x_sto_pg, y_sto_pg, x_err_sto_pg,       &
                                linecolor, linestyle, linewidth_d,      &
                                marker, markersize_d )
         end if
      else ! not draw_x_err
         handle = ErrorBarY( x_sto_pg, y_sto_pg, y_err_sto_pg,          &
                             linecolor, linestyle, linewidth_d,         &
                             marker, markersize_d )
      end if

 99   continue

      if( present(x) ) then
         if( status_alloc_x == 1 ) then
            deallocate( x_ptr )
         else
            ! unlock the internal mfArray properties
            call msFreePointer( x, x_ptr )
         end if
         call msFreeArgs( x )
         call msAutoRelease( x )
      else
         deallocate( x_ptr )
      end if

      if( status_alloc_y == 1 ) then
         deallocate( y_ptr )
      else
         ! unlock the internal mfArray properties
         call msFreePointer( y, y_ptr )
      end if
      call msFreeArgs( y )
      call msAutoRelease( y )

      if( present(x_err) ) then
         if( status_alloc_x_err == 1 ) then
            deallocate( x_err_ptr )
         else
            ! unlock the internal mfArray properties
            call msFreePointer( x_err, x_err_ptr )
         end if
         call msFreeArgs( x_err )
         call msAutoRelease( x_err )
      end if

      if( present(y_err) ) then
         if( status_alloc_y_err == 1 ) then
            deallocate( y_err_ptr )
         else
            ! unlock the internal mfArray properties
            call msFreePointer( y_err, y_err_ptr )
         end if
         call msFreeArgs( y_err )
         call msAutoRelease( y_err )
      end if

#ifdef _MF_FUNC
   end function mfErrorBar_color_str
#endif
#ifdef _MF_SUBR
   end subroutine msErrorBar_color_str
#endif
!_______________________________________________________________________
!
#ifdef _MF_FUNC
   function mfErrorBar_color_rgb( x, y, x_err, y_err, linespec,         &
                                  color, linewidth, markersize )        &
   result( handle )
#endif
#ifdef _MF_SUBR
   subroutine msErrorBar_color_rgb( x, y, x_err, y_err, linespec,       &
                                    color, linewidth, markersize )
#endif

      type(mfArray),                    optional :: x
      type(mfArray)                              :: y
      type(mfArray),                    optional :: x_err
      type(mfArray),                    optional :: y_err
      character(len=*),     intent(in), optional :: linespec
      real(kind=MF_DOUBLE), intent(in), optional :: color(3)
      real(kind=MF_DOUBLE), intent(in), optional :: linewidth, markersize

      integer :: handle
      !------ API end ------

      ! Optional arguments optionnels make implementation easier.
      ! Only 4 cases are possible:
      !
      !    call ErrorBar(      y=., y_err=., ... )        Error bars along y
      !    call ErrorBar( x=., y=., y_err=., ... )          "    "     "
      !
      !    call ErrorBar( x=., y=., x_err=., ... )        Error bars along x
      !
      !    call ErrorBar( x=., y=., x_err=., y_err=. )    Error bars
      !                                                   along x and y

      logical :: draw_x_err, draw_y_err

      type(mf_win_info), pointer :: win
      real(kind=MF_DOUBLE) :: linewidth_d, markersize_d
      integer :: linecolor, linestyle, marker, ier

      ! pointers for manipulating mfArray out of fml module
      real(kind=MF_DOUBLE), pointer :: x_ptr(:,:), y_ptr(:,:),          &
                                       x_err_ptr(:,:), y_err_ptr(:,:)

      real(kind=MF_DOUBLE), pointer :: x_sto_pg(:), y_sto_pg(:),                        &
                       x_err_sto_pg(:), y_err_sto_pg(:)
      integer :: p_dim, i, n_pg
      integer :: status, status_alloc_x, status_alloc_y,                &
                 status_alloc_x_err, status_alloc_y_err

#ifdef _MF_FUNC
      character(len=*), parameter :: ROUTINE_NAME = "mfErrorBar"
#endif
#ifdef _MF_SUBR
      character(len=*), parameter :: ROUTINE_NAME = "msErrorBar"
#endif

   !------ end of declarations -- execution starts hereafter  ------

#ifdef _MF_FUNC
      handle = 0
#endif

      ! detection des cas possibles/impossibles
      if( present(x) ) then
         if( present(x_err) ) then
            if( present(y_err) ) then
               draw_x_err = .true.
               draw_y_err = .true.
            else ! y_err not present
               draw_x_err = .true.
               draw_y_err = .false.
            end if
         else ! x_err not present
            if( present(y_err) ) then
               draw_x_err = .false.
               draw_y_err = .true.
            else ! y_err not present
               call PrintMessage( trim(ROUTINE_NAME), "E",              &
                                  "bad optional arg combinaison (see doc)!" )
               return
            end if
         end if
      else ! x not present
         if( present(x_err) ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "bad optional arg combinaison (see doc)!" )
            return
         else ! x_err not present
            if( present(y_err) ) then
               draw_x_err = .false.
               draw_y_err = .true.
            else ! y_err not present
               call PrintMessage( trim(ROUTINE_NAME), "E",              &
                                  "bad optional arg combinaison (see doc)!" )
               return
            end if
         end if
      end if

      if( present(x) ) then

         call msInitArgs( x )

         ! checking that 'x' is allocated
         if( mfIsEqual(x,MF_EMPTY) ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "'x' not allocated!" )
            go to 99
         end if

         ! 'x' must be Numeric (real or complex)
         if( .not. mfIsNumeric(x) ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "'x' must be numeric!" )
            go to 99
         end if

         ! 'x' cannot be sparse
         if( mfIsSparse(x) ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "'x' cannot be sparse!" )
            go to 99
         end if

         if( mfIsComplex(x) ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "Imaginary parts of complex argument 'x' ignored." )
         end if

         call msPointer_real_only( x, x_ptr, status_alloc_x )

         ! checking that 'x' is a 1-D array
         if( size(x_ptr,1) /= 1 .and. size(x_ptr,2) /= 1 ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "'x' must be a 1-D array" )
            go to 99
         end if

      end if

      call msInitArgs( y )

      ! checking that 'y' is allocated
      if( mfIsEqual(y,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' not allocated!" )
         go to 99
      end if

      ! 'y' must be Numeric (real or complex)
      if( .not. mfIsNumeric(y) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' must be numeric!" )
         go to 99
      end if

      ! 'y' cannot be sparse
      if( mfIsSparse(y) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' cannot be sparse!" )
         go to 99
      end if

      if( mfIsComplex(y) ) then
         call PrintMessage( trim(ROUTINE_NAME), "W",                    &
                            "Imaginary parts of complex argument 'y' ignored." )
      end if

      call msPointer_real_only( y, y_ptr, status_alloc_y )

      ! checking that 'y' is a 1-D array
      if( size(y_ptr,1) == 1 ) then
         p_dim = 2
         n_pg = size(y_ptr,2)
      else if( size(y_ptr,2) == 1 ) then
         p_dim = 1
         n_pg = size(y_ptr,1)
      else
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' must be a 1-D array" )
         go to 99
      end if

      if( present(x) ) then

         ! checking that 'y' have the same shape than 'x'
         if( any(shape(y_ptr)/=shape(x_ptr)) ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "'x' and 'y' array must have the same shape" )
            go to 99
         end if

      else

         allocate( x_ptr(size(y_ptr,1),size(y_ptr,2)) )
         if( p_dim == 1 ) then
            x_ptr(:,1) = [ (i, i=1,n_pg) ]
         else ! p_dim = 2
            x_ptr(1,:) = [ (i, i=1,n_pg) ]
         end if

      end if

      allocate( x_sto_pg(n_pg) )
      if( p_dim == 1 ) then
         x_sto_pg(:) = x_ptr(:,1)
      else
         x_sto_pg(:) = x_ptr(1,:)
      end if

      if( draw_x_err ) then

         call msInitArgs( x_err )

         ! 'x_err' must be Numeric (real only)
         if( .not. mfIsReal(x_err) ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "'x_err' must be numeric!" )
            go to 99
         end if
         ! 'x_err' cannot be sparse
         if( mfIsSparse(x_err) ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "'x_err' cannot be sparse!" )
            go to 99
         end if
         call msPointer_real_only( x_err, x_err_ptr, status_alloc_x_err )
         ! checking that 'x_err' have the same shape than 'x'
         if( any(shape(x_err_ptr)/=shape(x_ptr)) ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "'x_err' and 'x' array must have the same shape" )
            go to 99
         end if

         allocate( x_err_sto_pg(n_pg) )
         if( p_dim == 1 ) then
            x_err_sto_pg(:) = x_err_ptr(:,1)
         else
            x_err_sto_pg(:) = x_err_ptr(1,:)
         end if

      end if

      allocate( y_sto_pg(n_pg) )
      if( p_dim == 1 ) then
         y_sto_pg(:) = y_ptr(:,1)
      else
         y_sto_pg(:) = y_ptr(1,:)
      end if

      if( draw_y_err ) then

         call msInitArgs( y_err )

         ! 'y_err' must be Numeric (real only)
         if( .not. mfIsReal(y_err) ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "'y_err' must be numeric!" )
            go to 99
         end if
         ! 'y_err' cannot be sparse
         if( mfIsSparse(y_err) ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "'y_err' cannot be sparse!" )
            go to 99
         end if
         call msPointer_real_only( y_err, y_err_ptr, status_alloc_y_err )
         ! checking that 'y_err' have the same shape than 'y'
         if( any(shape(y_err_ptr)/=shape(y_ptr)) ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "'y_err' and 'y' array must have the same shape" )
            go to 99
         end if

         allocate( y_err_sto_pg(n_pg) )
         if( p_dim == 1 ) then
            y_err_sto_pg(:) = y_err_ptr(:,1)
         else
            y_err_sto_pg(:) = y_err_ptr(1,:)
         end if

      end if

      if( present(linespec) ) then
         call decode_linespec( linespec, linecolor, linestyle, marker )
         ! only linestyle must have a valid value
         if( linestyle == -127 .and. marker == -127 ) then
            linestyle = 1
         end if
      else
         linecolor = -127 ! means: not found
         linestyle = 1
         marker    = -127 ! means: not found
      end if

      if( present(color) ) then
         call decode_col_rgb( color, linecolor )
      end if

      if( present(linewidth) ) then
         linewidth_d = linewidth
      else
         linewidth_d = 1.0
      end if

      if( present(markersize) ) then
         markersize_d = markersize
      else
         if( present(linewidth) ) then
            markersize_d = sqrt(linewidth)
         else
            markersize_d = 1.0
         end if
      end if

      if( CURRENT_WIN_ID == 0 ) then
         call msFigure()
         if( CURRENT_WIN_ID == 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "cannot plot: no window created!" )
            go to 99
         end if
      end if

      win => mf_win_db(CURRENT_WIN_ID)

      if( win%axis_scale_x == 2 .or. win%axis_scale_y == 2 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "you are going to use a different scaling of axis", &
                            "from a previous plot on the same figure: however", &
                            "currently, ErrorBar is restricted to linear axis!" )
         go to 99
      end if

      if( draw_x_err ) then
         if( draw_y_err ) then
            handle = ErrorBarXY( x_sto_pg, y_sto_pg, x_err_sto_pg, y_err_sto_pg, &
                                 linecolor, linestyle, linewidth_d,     &
                                 marker, markersize_d )
         else ! not draw_y_err
            handle = ErrorBarX( x_sto_pg, y_sto_pg, x_err_sto_pg,       &
                                linecolor, linestyle, linewidth_d,      &
                                marker, markersize_d )
         end if
      else ! not draw_x_err
         handle = ErrorBarY( x_sto_pg, y_sto_pg, y_err_sto_pg,          &
                             linecolor, linestyle, linewidth_d,         &
                             marker, markersize_d )
      end if

 99   continue

      if( present(x) ) then
         if( status_alloc_x == 1 ) then
            deallocate( x_ptr )
         else
            ! unlock the internal mfArray properties
            call msFreePointer( x, x_ptr )
         end if
         call msFreeArgs( x )
         call msAutoRelease( x )
      else
         deallocate( x_ptr )
      end if

      if( status_alloc_y == 1 ) then
         deallocate( y_ptr )
      else
         ! unlock the internal mfArray properties
         call msFreePointer( y, y_ptr )
      end if
      call msFreeArgs( y )
      call msAutoRelease( y )

      if( present(x_err) ) then
         if( status_alloc_x_err == 1 ) then
            deallocate( x_err_ptr )
         else
            ! unlock the internal mfArray properties
            call msFreePointer( x_err, x_err_ptr )
         end if
         call msFreeArgs( x_err )
         call msAutoRelease( x_err )
      end if

      if( present(y_err) ) then
         if( status_alloc_y_err == 1 ) then
            deallocate( y_err_ptr )
         else
            ! unlock the internal mfArray properties
            call msFreePointer( y_err, y_err_ptr )
         end if
         call msFreeArgs( y_err )
         call msAutoRelease( y_err )
      end if

#ifdef _MF_FUNC
   end function mfErrorBar_color_rgb
#endif
#ifdef _MF_SUBR
   end subroutine msErrorBar_color_rgb
#endif
