!_______________________________________________________________________
!
   subroutine msDefineCustomCursors( cursor_1, cursor_1_mask, color_1,  &
                                     cursor_2, cursor_2_mask, color_2 )

   character(len=*), intent(in) :: cursor_1, cursor_1_mask, color_1,    &
                                   cursor_2, cursor_2_mask, color_2
   !------ API end ------

      ! Register two customized cursors, referenced by:
      !    xw->user1_cursor
      !    xw->user2_cursor
      ! for the current window.
      !
      ! The user must provide bitmaps file, containing XBM images.
      ! For each cursors, two bitmaps are needed: one for the cursor
      !   itself, the other for the mask.
      ! A size of 16x16 pixels is recommended.
      ! The cursor files must contain the image size under the form:
      !   #define _width 16
      !   #define _height 16
      ! Moreover the cursor main image must define the Hot Spot position:
      !   #define _x_hot 8
      !   #define _y_hot 8
      !
      ! The colors color_1 and color_2 are colorname from the RGB database.

      character(len=*), parameter :: ROUTINE_NAME = "msDefineCustomCursors"

      type(mf_win_info), pointer :: win

      logical :: exist

      double precision :: rbuf(1)
      integer :: ibuf(1), lchr
      character(len=255) :: chr

   !------ end of declarations -- execution starts hereafter  ------

      if( .not. X11_DEVICE ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "X11 device is ""off"".",                   &
                            "('" // trim(ROUTINE_NAME) // "' is an interactive routine which requires X11)" )
         return
      end if

      if( CURRENT_WIN_ID == 0 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "no X11 device selected." )
         return
      end if

      win => mf_win_db(CURRENT_WIN_ID)

      ! check that all files exist
      inquire( file=trim(cursor_1), exist=exist )
      if( .not. exist ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "file defined by 'cursor_1': "// trim(cursor_1), &
                            "doesn't exist!" )
         return
      end if
      inquire( file=trim(cursor_1_mask), exist=exist )
      if( .not. exist ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "file defined by 'cursor_1_mask': "// trim(cursor_1_mask), &
                            "doesn't exist!" )
         return
      end if
      inquire( file=trim(cursor_2), exist=exist )
      if( .not. exist ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "file defined by 'cursor_2': "// trim(cursor_2), &
                            "doesn't exist!" )
         return
      end if
      inquire( file=trim(cursor_2_mask), exist=exist )
      if( .not. exist ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "file defined by 'cursor_2_mask': "// trim(cursor_2_mask), &
                            "doesn't exist!" )
         return
      end if

      ! registering the 1st cursor
      ibuf(1) = 1
      chr = trim(cursor_1) // char(0)
      call grexec( grgtyp, DEF_CUSTOM_CURSOR_SHAPE, rbuf, ibuf, chr, lchr )
      ibuf(1) = 2
      chr = trim(color_1) // char(0)
      call grexec( grgtyp, DEF_CUSTOM_CURSOR_SHAPE, rbuf, ibuf, chr, lchr )
      ibuf(1) = 3
      chr = trim(cursor_1_mask) // char(0)
      call grexec( grgtyp, DEF_CUSTOM_CURSOR_SHAPE, rbuf, ibuf, chr, lchr )

      ! registering the 2nd cursor
      ibuf(1) = 4
      chr = trim(cursor_2) // char(0)
      call grexec( grgtyp, DEF_CUSTOM_CURSOR_SHAPE, rbuf, ibuf, chr, lchr )
      ibuf(1) = 5
      chr = trim(color_2) // char(0)
      call grexec( grgtyp, DEF_CUSTOM_CURSOR_SHAPE, rbuf, ibuf, chr, lchr )
      ibuf(1) = 6
      chr = trim(cursor_2_mask) // char(0)
      call grexec( grgtyp, DEF_CUSTOM_CURSOR_SHAPE, rbuf, ibuf, chr, lchr )

      win%user_cursors_defined = .true.

   end subroutine msDefineCustomCursors
